/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Arrays;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.IndexedGeometryArrayRetained;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.J3dStructure;
import org.jogamp.java3d.MorphRetained;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.ObjectUpdate;
import org.jogamp.java3d.TextureAttributesRetained;
import org.jogamp.java3d.VirtualUniverse;

class RenderingAttributesStructure
extends J3dStructure
implements ObjectUpdate {
    ArrayList<J3dMessage> objList = new ArrayList();

    RenderingAttributesStructure() {
        super(null, 1024);
    }

    @Override
    void processMessages(long referenceTime) {
        boolean addMirrorObj = false;
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg <= 0) {
            return;
        }
        block9: for (int i2 = 0; i2 < nMsg; ++i2) {
            J3dMessage m2 = messages[i2];
            switch (m2.type) {
                case 18: 
                case 47: 
                case 65: {
                    int component = (Integer)m2.args[1];
                    NodeComponentRetained nc = (NodeComponentRetained)m2.args[0];
                    nc.mirror.changedFrequent = (Integer)m2.args[3];
                    this.updateNodeComponent(m2.args);
                    if (nc.mirror.changedFrequent != 0) {
                        this.objList.add(m2);
                        addMirrorObj = true;
                        nc.mirror.compChanged |= component;
                        continue block9;
                    }
                    m2.decRefcount();
                    continue block9;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 63: 
                case 64: {
                    NodeComponentRetained nc = (NodeComponentRetained)m2.args[0];
                    nc.mirror.changedFrequent = (Integer)m2.args[3];
                    if (nc.mirror.changedFrequent != 0) {
                        this.objList.add(m2);
                        addMirrorObj = true;
                        nc.mirror.compChanged = 1;
                        continue block9;
                    }
                    this.updateNodeComponent(m2.args);
                    m2.decRefcount();
                    continue block9;
                }
                case 54: {
                    NodeComponentRetained nc = (NodeComponentRetained)m2.args[0];
                    int changes = (Integer)m2.args[3];
                    if (nc.mirror != null) {
                        nc.mirror.changedFrequent = changes;
                    }
                    if (changes != 0) {
                        this.objList.add(m2);
                        addMirrorObj = true;
                        continue block9;
                    }
                    this.updateNodeComponent(m2.args);
                    m2.decRefcount();
                    continue block9;
                }
                case 11: {
                    NodeComponentRetained nc = (NodeComponentRetained)m2.args[0];
                    nc.mirror.changedFrequent = (Integer)m2.args[4];
                    if (nc.mirror.changedFrequent != 0) {
                        this.objList.add(m2);
                        addMirrorObj = true;
                        nc.mirror.compChanged = 1;
                        continue block9;
                    }
                    this.updateTextureAttributes(m2.args);
                    m2.decRefcount();
                    continue block9;
                }
                case 15: {
                    NodeComponentRetained nc = (NodeComponentRetained)m2.args[0];
                    nc.mirror.changedFrequent = (Integer)m2.args[3];
                    this.objList.add(m2);
                    nc.mirror.compChanged = 1;
                    addMirrorObj = true;
                    continue block9;
                }
                case 17: {
                    int val;
                    GeometryRetained geo = (GeometryRetained)m2.args[1];
                    if (geo instanceof IndexedGeometryArrayRetained) {
                        int val2;
                        this.objList.add(m2);
                        addMirrorObj = true;
                        if (m2.args[2] != null) continue block9;
                        geo.cachedChangedFrequent = val2 = ((Integer)m2.args[3]).intValue();
                        continue block9;
                    }
                    geo.cachedChangedFrequent = val = ((Integer)m2.args[3]).intValue();
                    m2.decRefcount();
                    continue block9;
                }
                case 16: {
                    this.objList.add(m2);
                    addMirrorObj = true;
                    continue block9;
                }
                default: {
                    m2.decRefcount();
                }
            }
        }
        if (addMirrorObj) {
            VirtualUniverse.mc.addMirrorObject(this);
        }
        Arrays.fill(messages, 0, nMsg, null);
    }

    @Override
    public void updateObject() {
        int size = this.objList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            NodeComponentRetained nc;
            J3dMessage m2 = this.objList.get(i2);
            if (m2.type == 17) {
                GeometryArrayRetained geo = (GeometryArrayRetained)m2.args[1];
                if (m2.args[2] == null) {
                    geo.updateMirrorGeometry();
                } else {
                    geo.initMirrorGeometry();
                }
            } else if (m2.type == 16) {
                MorphRetained morph = (MorphRetained)m2.args[0];
                GeometryArrayRetained geo = (GeometryArrayRetained)morph.morphedGeometryArray.retained;
                geo.updateMirrorGeometry();
            } else if (m2.type == 11) {
                nc = (NodeComponentRetained)m2.args[0];
                nc.mirror.compChanged = 0;
                this.updateTextureAttributes(m2.args);
            } else if (m2.type == 18 || m2.type == 65 || m2.type == 47) {
                nc = (NodeComponentRetained)m2.args[0];
                nc.mirror.compChanged = 0;
            } else {
                nc = (NodeComponentRetained)m2.args[0];
                if (nc.mirror != null) {
                    nc.mirror.compChanged = 0;
                }
                this.updateNodeComponent(m2.args);
            }
            m2.decRefcount();
        }
        this.objList.clear();
    }

    private void updateNodeComponent(Object[] args) {
        NodeComponentRetained n2 = (NodeComponentRetained)args[0];
        n2.updateMirrorObject((Integer)args[1], args[2]);
    }

    private void updateTextureAttributes(Object[] args) {
        TextureAttributesRetained n2 = (TextureAttributesRetained)args[0];
        n2.updateMirrorObject((Integer)args[1], args[2], args[3]);
    }

    @Override
    void removeNodes(J3dMessage m2) {
    }

    @Override
    void cleanup() {
    }
}

