/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransformInterpolator;

public abstract class PathInterpolator
extends TransformInterpolator {
    private float[] knots;
    protected float currentInterpolationValue;
    protected int currentKnotIndex;

    PathInterpolator() {
    }

    public PathInterpolator(Alpha alpha, float[] knots) {
        this(alpha, null, knots);
    }

    public PathInterpolator(Alpha alpha, TransformGroup target, float[] knots) {
        super(alpha, target);
        this.setKnots(knots);
    }

    public PathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, float[] knots) {
        super(alpha, target, axisOfTransform);
        this.setKnots(knots);
    }

    public int getArrayLengths() {
        return this.knots.length;
    }

    public void setKnot(int index, float knot) {
        this.knots[index] = knot;
    }

    public float getKnot(int index) {
        return this.knots[index];
    }

    protected void setKnots(float[] knots) {
        if ((double)knots[0] < -1.0E-4 || (double)knots[0] > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("PathInterpolator0"));
        }
        if ((double)(knots[knots.length - 1] - 1.0f) < -1.0E-4 || (double)(knots[knots.length - 1] - 1.0f) > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("PathInterpolator1"));
        }
        this.knots = new float[knots.length];
        for (int i2 = 0; i2 < knots.length; ++i2) {
            if (i2 > 0 && knots[i2] < knots[i2 - 1]) {
                throw new IllegalArgumentException(J3dI18N.getString("PathInterpolator2"));
            }
            this.knots[i2] = knots[i2];
        }
    }

    public void getKnots(float[] knots) {
        for (int i2 = 0; i2 < this.knots.length; ++i2) {
            knots[i2] = this.knots[i2];
        }
    }

    protected void computePathInterpolation(float alphaValue) {
        for (int i2 = 0; i2 < this.knots.length; ++i2) {
            if (!(i2 == 0 && alphaValue <= this.knots[i2]) && (i2 <= 0 || !(alphaValue >= this.knots[i2 - 1]) || !(alphaValue <= this.knots[i2]))) continue;
            if (i2 == 0) {
                this.currentInterpolationValue = 0.0f;
                this.currentKnotIndex = 0;
                break;
            }
            this.currentInterpolationValue = (alphaValue - this.knots[i2 - 1]) / (this.knots[i2] - this.knots[i2 - 1]);
            this.currentKnotIndex = i2 - 1;
            break;
        }
    }

    protected void computePathInterpolation() {
        float value = this.alpha.value();
        this.computePathInterpolation(value);
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        PathInterpolator pi = (PathInterpolator)originalNode;
        int len = pi.getArrayLengths();
        this.knots = new float[len];
        for (int i2 = 0; i2 < len; ++i2) {
            this.setKnot(i2, pi.getKnot(i2));
        }
    }
}

