/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.J3dNotification;
import org.jogamp.java3d.RenderingError;
import org.jogamp.java3d.ShaderError;
import org.jogamp.java3d.VirtualUniverse;

class NotificationThread
extends Thread {
    private static final int WAIT = 0;
    private static final int NOTIFY = 1;
    private static final int STOP = 2;
    private volatile boolean running = true;
    private boolean waiting = false;
    private boolean ready = false;
    private ArrayList<J3dNotification> notificationQueue = new ArrayList();

    NotificationThread(ThreadGroup t) {
        super(t, "J3D-NotificationThread");
    }

    synchronized void addNotification(J3dNotification n2) {
        this.notificationQueue.add(n2);
        this.runMonitor(1);
    }

    private synchronized J3dNotification[] getNotifications() {
        J3dNotification[] n2 = new J3dNotification[this.notificationQueue.size()];
        n2 = this.notificationQueue.toArray(n2);
        this.notificationQueue.clear();
        return n2;
    }

    private void processNotifications() {
        J3dNotification[] notifications = this.getNotifications();
        block4: for (int i2 = 0; i2 < notifications.length; ++i2) {
            J3dNotification n2 = notifications[i2];
            switch (n2.type) {
                case 0: {
                    n2.universe.notifyShaderErrorListeners((ShaderError)n2.args[0]);
                    continue block4;
                }
                case 1: {
                    VirtualUniverse.notifyRenderingErrorListeners((RenderingError)n2.args[0]);
                    continue block4;
                }
                default: {
                    System.err.println("J3dNotification.processNotifications: unrecognized type = " + n2.type);
                }
            }
        }
    }

    void finish() {
        this.runMonitor(2);
    }

    @Override
    public void run() {
        while (this.running) {
            this.runMonitor(0);
            this.processNotifications();
        }
    }

    private synchronized void runMonitor(int action) {
        switch (action) {
            case 0: {
                while (this.running && !this.ready) {
                    this.waiting = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.waiting = false;
                }
                this.ready = false;
                break;
            }
            case 1: {
                this.ready = true;
                if (!this.waiting) break;
                this.notify();
                break;
            }
            case 2: {
                this.running = false;
                this.notify();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

