/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.MaterialRetained;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.vecmath.Color3f;

public class Material
extends NodeComponent {
    public static final int ALLOW_COMPONENT_READ = 0;
    public static final int ALLOW_COMPONENT_WRITE = 1;
    public static final int AMBIENT = 0;
    public static final int EMISSIVE = 1;
    public static final int DIFFUSE = 2;
    public static final int SPECULAR = 3;
    public static final int AMBIENT_AND_DIFFUSE = 4;
    private static final int[] readCapabilities = new int[]{0};

    public Material() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Material(Color3f ambientColor, Color3f emissiveColor, Color3f diffuseColor, Color3f specularColor, float shininess) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((MaterialRetained)this.retained).createMaterial(ambientColor, emissiveColor, diffuseColor, specularColor, shininess);
    }

    @Override
    void createRetained() {
        this.retained = new MaterialRetained();
        this.retained.setSource(this);
    }

    public void setAmbientColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setAmbientColor(color);
        } else {
            ((MaterialRetained)this.retained).initAmbientColor(color);
        }
    }

    public void setAmbientColor(float r, float g2, float b2) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setAmbientColor(r, g2, b2);
        } else {
            ((MaterialRetained)this.retained).initAmbientColor(r, g2, b2);
        }
    }

    public void getAmbientColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material2"));
        }
        ((MaterialRetained)this.retained).getAmbientColor(color);
    }

    public void setEmissiveColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setEmissiveColor(color);
        } else {
            ((MaterialRetained)this.retained).initEmissiveColor(color);
        }
    }

    public void setEmissiveColor(float r, float g2, float b2) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setEmissiveColor(r, g2, b2);
        } else {
            ((MaterialRetained)this.retained).initEmissiveColor(r, g2, b2);
        }
    }

    public void getEmissiveColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material2"));
        }
        ((MaterialRetained)this.retained).getEmissiveColor(color);
    }

    public void setDiffuseColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setDiffuseColor(color);
        } else {
            ((MaterialRetained)this.retained).initDiffuseColor(color);
        }
    }

    public void setDiffuseColor(float r, float g2, float b2) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setDiffuseColor(r, g2, b2);
        } else {
            ((MaterialRetained)this.retained).initDiffuseColor(r, g2, b2);
        }
    }

    public void setDiffuseColor(float r, float g2, float b2, float a2) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setDiffuseColor(r, g2, b2, a2);
        } else {
            ((MaterialRetained)this.retained).initDiffuseColor(r, g2, b2, a2);
        }
    }

    public void getDiffuseColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material2"));
        }
        ((MaterialRetained)this.retained).getDiffuseColor(color);
    }

    public void setSpecularColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setSpecularColor(color);
        } else {
            ((MaterialRetained)this.retained).initSpecularColor(color);
        }
    }

    public void setSpecularColor(float r, float g2, float b2) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setSpecularColor(r, g2, b2);
        } else {
            ((MaterialRetained)this.retained).initSpecularColor(r, g2, b2);
        }
    }

    public void getSpecularColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material2"));
        }
        ((MaterialRetained)this.retained).getSpecularColor(color);
    }

    public void setShininess(float shininess) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setShininess(shininess);
        } else {
            ((MaterialRetained)this.retained).initShininess(shininess);
        }
    }

    public float getShininess() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material2"));
        }
        return ((MaterialRetained)this.retained).getShininess();
    }

    public void setLightingEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material15"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setLightingEnable(state);
        } else {
            ((MaterialRetained)this.retained).initLightingEnable(state);
        }
    }

    public boolean getLightingEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material16"));
        }
        return ((MaterialRetained)this.retained).getLightingEnable();
    }

    public void setColorTarget(int colorTarget) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material3"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setColorTarget(colorTarget);
        } else {
            ((MaterialRetained)this.retained).initColorTarget(colorTarget);
        }
    }

    public int getColorTarget() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material4"));
        }
        return ((MaterialRetained)this.retained).getColorTarget();
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer(this.getNamePrefix());
        str.append("org.jogamp.java3d.Material: ");
        Color3f color = new Color3f();
        try {
            this.getAmbientColor(color);
            str.append("AmbientColor=" + color);
        }
        catch (CapabilityNotSetException e2) {
            str.append("AmbientColor=N/A");
        }
        try {
            this.getEmissiveColor(color);
            str.append(" EmissiveColor=" + color);
        }
        catch (CapabilityNotSetException ex) {
            str.append(" EmissiveColor=N/A");
        }
        try {
            this.getDiffuseColor(color);
            str.append(" DiffuseColor=" + color);
        }
        catch (CapabilityNotSetException exc) {
            str.append(" DiffuseColor=N/A");
        }
        try {
            this.getSpecularColor(color);
            str.append(" SpecularColor=" + color);
        }
        catch (CapabilityNotSetException exce) {
            str.append(" SpecularColor=N/A");
        }
        try {
            float f2 = this.getShininess();
            str.append(" Shininess=" + f2);
        }
        catch (CapabilityNotSetException excep) {
            str.append(" Shininess=N/A");
        }
        try {
            boolean b2 = this.getLightingEnable();
            str.append(" LightingEnable=" + b2);
        }
        catch (CapabilityNotSetException except) {
            str.append(" LightingEnable=N/A");
        }
        try {
            int i2 = this.getColorTarget();
            str.append(" ColorTarget=" + i2);
        }
        catch (CapabilityNotSetException except) {
            str.append(" ColorTarget=N/A");
        }
        return new String(str);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        Material m2 = new Material();
        m2.duplicateNodeComponent(this);
        return m2;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        MaterialRetained mat = (MaterialRetained)originalNodeComponent.retained;
        MaterialRetained rt = (MaterialRetained)this.retained;
        Color3f c2 = new Color3f();
        mat.getAmbientColor(c2);
        rt.initAmbientColor(c2);
        mat.getEmissiveColor(c2);
        rt.initEmissiveColor(c2);
        mat.getDiffuseColor(c2);
        rt.initDiffuseColor(c2);
        mat.getSpecularColor(c2);
        rt.initSpecularColor(c2);
        rt.initShininess(mat.getShininess());
        rt.initLightingEnable(mat.getLightingEnable());
        rt.initColorTarget(mat.getColorTarget());
    }
}

