/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jogamp.java3d.BehaviorScheduler;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.CompressedGeometryRenderMethod;
import org.jogamp.java3d.DefaultRenderMethod;
import org.jogamp.java3d.DisplayListRenderMethod;
import org.jogamp.java3d.FreeListManager;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.InputDevice;
import org.jogamp.java3d.InputDeviceBlockingThread;
import org.jogamp.java3d.InputDeviceScheduler;
import org.jogamp.java3d.J3dClock;
import org.jogamp.java3d.J3dDebug;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.J3dNotification;
import org.jogamp.java3d.J3dStructure;
import org.jogamp.java3d.J3dThread;
import org.jogamp.java3d.J3dThreadData;
import org.jogamp.java3d.MasterControlThread;
import org.jogamp.java3d.NotificationThread;
import org.jogamp.java3d.ObjectUpdate;
import org.jogamp.java3d.OrientedShape3DRenderMethod;
import org.jogamp.java3d.PhysicalEnvironment;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.RenderMethod;
import org.jogamp.java3d.Renderer;
import org.jogamp.java3d.RenderingAttributesStructure;
import org.jogamp.java3d.Screen3D;
import org.jogamp.java3d.StructureUpdateThread;
import org.jogamp.java3d.Text3DRenderMethod;
import org.jogamp.java3d.TimerThread;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.VertexArrayRenderMethod;
import org.jogamp.java3d.View;
import org.jogamp.java3d.VirtualUniverse;

class MasterControl {
    static final int CHECK_FOR_WORK = 0;
    static final int SET_WORK = 1;
    static final int RUN_THREADS = 2;
    static final int THREAD_DONE = 3;
    static final int SET_WORK_FOR_REQUEST_RENDERER = 5;
    static final int RUN_RENDERER_CLEANUP = 6;
    static final int SLEEPING = 0;
    static final int RUNNING = 1;
    static final int WAITING_FOR_THREADS = 3;
    static final int WAITING_FOR_CPU = 4;
    static final int WAITING_FOR_RENDERER_CLEANUP = 5;
    static final Integer REQUESTRENDER = new Integer(2);
    static final Integer RENDER = new Integer(0);
    static final Integer SWAP = new Integer(1);
    static final Integer ACTIVATE_VIEW = new Integer(1);
    static final Integer DEACTIVATE_VIEW = new Integer(2);
    static final Integer START_VIEW = new Integer(3);
    static final Integer STOP_VIEW = new Integer(4);
    static final Integer REEVALUATE_CANVAS = new Integer(5);
    static final Integer UNREGISTER_VIEW = new Integer(6);
    static final Integer PHYSICAL_ENV_CHANGE = new Integer(7);
    static final Integer INPUTDEVICE_CHANGE = new Integer(8);
    static final Integer EMPTY_UNIVERSE = new Integer(9);
    static final Integer START_RENDERER = new Integer(10);
    static final Integer STOP_RENDERER = new Integer(11);
    static final Integer RENDER_ONCE = new Integer(12);
    static final Integer FREE_CONTEXT = new Integer(13);
    static final Integer FREE_DRAWING_SURFACE = new Integer(14);
    static final Integer FREE_MESSAGE = new Integer(15);
    static final Integer RESET_CANVAS = new Integer(16);
    static final Integer GETBESTCONFIG = new Integer(17);
    static final Integer ISCONFIGSUPPORT = new Integer(18);
    static final Integer SET_GRAPHICSCONFIG_FEATURES = new Integer(19);
    static final Integer SET_QUERYPROPERTIES = new Integer(20);
    static final Integer SET_VIEW = new Integer(21);
    private static boolean devLoggerEnabled = false;
    private static Logger devLogger;
    private static boolean statsLoggerEnabled;
    private static Logger statsLogger;
    private static boolean coreLoggerEnabled;
    private static Logger coreLogger;
    private static boolean librariesLoaded;
    private MasterControlThread mcThread = null;
    private UnorderList views = new UnorderList(1, View.class);
    boolean transparentOffScreen = false;
    boolean usePbuffer = true;
    boolean viewFrustumCulling = true;
    private boolean lockGeometry = false;
    private int numActiveViews = 0;
    private UnorderList activeUniverseList = new UnorderList(VirtualUniverse.class);
    private UnorderList regUniverseList = new UnorderList(VirtualUniverse.class);
    private Object timeLock = new Object();
    private long time = 0L;
    private long waitTimestamp = 0L;
    private UnorderList stateWorkThreads = new UnorderList(J3dThreadData.class);
    private UnorderList renderWorkThreads = new UnorderList(J3dThreadData.class);
    private UnorderList requestRenderWorkThreads = new UnorderList(J3dThreadData.class);
    private UnorderList renderThreadData = new UnorderList(J3dThreadData.class);
    private UnorderList inputDeviceThreads = new UnorderList(1, InputDeviceScheduler.class);
    private boolean threadListsChanged;
    private int lastTransformStructureThread = 0;
    private int lastStructureUpdateThread = 0;
    private long currentTime;
    TimerThread timerThread;
    private NotificationThread notificationThread;
    volatile boolean running = true;
    private boolean workToDo = false;
    private boolean requestRenderWorkToDo = false;
    private int threadPending = 0;
    private int renderPending = 0;
    private int statePending = 0;
    private boolean renderWaiting = false;
    private boolean stateWaiting = false;
    private int state = 0;
    private long sleepTime = 0L;
    private int cpuLimit;
    private UnorderList mirrorObjects = new UnorderList(ObjectUpdate.class);
    private RenderingAttributesStructure renderingAttributesStructure = new RenderingAttributesStructure();
    private DefaultRenderMethod defaultRenderMethod = null;
    private Text3DRenderMethod text3DRenderMethod = null;
    private VertexArrayRenderMethod vertexArrayRenderMethod = null;
    private DisplayListRenderMethod displayListRenderMethod = null;
    private CompressedGeometryRenderMethod compressedGeometryRenderMethod = null;
    private OrientedShape3DRenderMethod orientedShape3DRenderMethod = null;
    static long systemStartTime;
    private long contextTimeStamp = 0L;
    private boolean[] canvasIds = null;
    private int canvasFreeIndex = 0;
    private Object canvasIdLock = new Object();
    private int rendererCount = 0;
    boolean isSharedCtx = false;
    boolean useCombiners = false;
    boolean disableCompile = false;
    boolean doCompaction = true;
    boolean disableSeparateSpecularColor = false;
    boolean isDisplayList = true;
    boolean buildDisplayListIfPossible = false;
    boolean vertexAttrsInDisplayList = false;
    boolean allowSoleUser = false;
    boolean allowNullGraphicsConfig = false;
    boolean stencilClear = false;
    static Integer REMOVEALLCTXS_CLEANUP;
    static Integer REMOVECTX_CLEANUP;
    static Integer REMOVENOTIFY_CLEANUP;
    static Integer RESETCANVAS_CLEANUP;
    static Integer FREECONTEXT_CLEANUP;
    Object[] rendererCleanupArgs = new Object[]{new Integer(3), null, null};
    Object contextCreationLock = new Object();
    boolean doDsiRenderLock = false;
    boolean enforcePowerOfTwo = false;
    boolean sharedStereoZBuffer = true;
    boolean implicitAntialiasing = false;
    boolean defaultReadCapability = true;
    boolean defaultNodePickable = true;
    boolean defaultNodeCollidable = true;
    boolean isCompiledVertexArray = true;
    int glslVertexAttrOffset = 6;
    Hashtable<GraphicsDevice, Screen3D> deviceScreenMap = new Hashtable();
    UnorderList requestObjList = new UnorderList();
    private UnorderList requestTypeList = new UnorderList(Integer.class);
    private UnorderList tempViewList = new UnorderList();
    private UnorderList renderOnceList = new UnorderList();
    private boolean pendingRequest = false;
    private static ThreadGroup rootThreadGroup;
    private static int threadPriority;
    private static Object mcThreadLock;
    private ArrayList<View> timestampUpdateList = new ArrayList(3);
    private UnorderList freeMessageList = new UnorderList(8);
    int maxLights;
    boolean sortShape3DBounds = false;
    boolean forceReleaseView = false;
    boolean cacheAutoComputedBounds = false;
    boolean useBoxForGroupBounds = false;
    static String[] mtype;
    int frameCount = 0;
    private int frameCountCutoff = 100;
    private long[] statTimes = new long[TimeType.values().length];
    private int[] statCounts = new int[TimeType.values().length];
    private boolean[] statSeen = new boolean[TimeType.values().length];
    private int frameCycleTick = 0;
    private long frameCycleNumber = 0L;

    MasterControl() {
        int i2;
        Integer samplingTime;
        assert (librariesLoaded);
        if (systemStartTime == 0L) {
            systemStartTime = J3dClock.currentTimeMillis();
        }
        this.isSharedCtx = MasterControl.getBooleanProperty("j3d.sharedctx", this.isSharedCtx, "shared contexts");
        this.doCompaction = MasterControl.getBooleanProperty("j3d.docompaction", this.doCompaction, "compaction");
        this.transparentOffScreen = MasterControl.getBooleanProperty("j3d.transparentOffScreen", this.transparentOffScreen, "transparent OffScreen");
        this.usePbuffer = MasterControl.getBooleanProperty("j3d.usePbuffer", this.usePbuffer, "Off-screen Pbuffer");
        this.viewFrustumCulling = MasterControl.getBooleanProperty("j3d.viewFrustumCulling", this.viewFrustumCulling, "View frustum culling in the renderer is");
        this.sortShape3DBounds = MasterControl.getBooleanProperty("j3d.sortShape3DBounds", this.sortShape3DBounds, "Shape3D bounds enabled for transparency sorting", "Shape3D bounds *ignored* for transparency sorting");
        this.forceReleaseView = MasterControl.getBooleanProperty("j3d.forceReleaseView", this.forceReleaseView, "forceReleaseView  after Canvas3D dispose enabled", "forceReleaseView  after Canvas3D dispose disabled");
        if (MasterControl.getProperty("j3d.disablecompile") != null) {
            this.disableCompile = true;
            System.err.println("Java 3D: BranchGroup.compile disabled");
        }
        if (MasterControl.getProperty("j3d.disableSeparateSpecular") != null) {
            this.disableSeparateSpecularColor = true;
            System.err.println("Java 3D: separate specular color disabled if possible");
        }
        this.isDisplayList = MasterControl.getBooleanProperty("j3d.displaylist", this.isDisplayList, "display list");
        this.implicitAntialiasing = MasterControl.getBooleanProperty("j3d.implicitAntialiasing", this.implicitAntialiasing, "implicit antialiasing");
        this.defaultReadCapability = MasterControl.getBooleanProperty("j3d.defaultReadCapability", this.defaultReadCapability, "default read capability");
        this.defaultNodePickable = MasterControl.getBooleanProperty("j3d.defaultNodePickable", this.defaultNodePickable, "default node pickable");
        this.defaultNodeCollidable = MasterControl.getBooleanProperty("j3d.defaultNodeCollidable", this.defaultNodeCollidable, "default node collidable");
        this.isCompiledVertexArray = MasterControl.getBooleanProperty("j3d.compiledVertexArray", this.isCompiledVertexArray, "compiled vertex array");
        boolean j3dOptimizeSpace = MasterControl.getBooleanProperty("j3d.optimizeForSpace", true, "optimize for space");
        if (this.isDisplayList) {
            if (!j3dOptimizeSpace) {
                this.buildDisplayListIfPossible = true;
            }
            this.vertexAttrsInDisplayList = true;
        }
        this.doDsiRenderLock = MasterControl.getBooleanProperty("j3d.renderLock", this.doDsiRenderLock, "render lock");
        this.enforcePowerOfTwo = MasterControl.getBooleanProperty("j3d.textureEnforcePowerOfTwo", this.enforcePowerOfTwo, "checking power-of-two textures");
        this.allowSoleUser = MasterControl.getBooleanProperty("j3d.allowSoleUser", this.allowSoleUser, "sole-user mode");
        this.allowNullGraphicsConfig = MasterControl.getBooleanProperty("j3d.allowNullGraphicsConfig", this.allowNullGraphicsConfig, "null graphics configs");
        this.stencilClear = MasterControl.getBooleanProperty("j3d.stencilClear", this.stencilClear, "per-frame stencil clear");
        this.sharedStereoZBuffer = MasterControl.getBooleanProperty("j3d.sharedstereozbuffer", this.sharedStereoZBuffer, "shared stereo Z buffer");
        final int defaultThreadLimit = this.getNumberOfProcessors() + 1;
        Integer threadLimit = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger("j3d.threadLimit", defaultThreadLimit);
            }
        });
        this.cpuLimit = threadLimit;
        if (this.cpuLimit < 1) {
            this.cpuLimit = 1;
        }
        if (J3dDebug.debug || this.cpuLimit != defaultThreadLimit) {
            System.err.println("Java 3D: concurrent threadLimit = " + this.cpuLimit);
        }
        if ((samplingTime = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger("j3d.deviceSampleTime", 0);
            }
        })) > 0) {
            InputDeviceScheduler.samplingTime = samplingTime;
            System.err.println("Java 3D: Input device sampling time = " + samplingTime + " ms");
        }
        final int defaultGLSLVertexAttrOffset = this.glslVertexAttrOffset;
        Integer vattrOffset = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger("j3d.glslVertexAttrOffset", defaultGLSLVertexAttrOffset);
            }
        });
        this.glslVertexAttrOffset = vattrOffset;
        if (this.glslVertexAttrOffset < 1) {
            this.glslVertexAttrOffset = 1;
        }
        if (J3dDebug.debug || this.glslVertexAttrOffset != defaultGLSLVertexAttrOffset) {
            System.err.println("Java 3D: glslVertexAttrOffset = " + this.glslVertexAttrOffset);
        }
        this.cacheAutoComputedBounds = MasterControl.getBooleanProperty("j3d.cacheAutoComputeBounds", this.cacheAutoComputedBounds, "Cache AutoCompute Bounds, accelerates getBounds()");
        this.useBoxForGroupBounds = MasterControl.getBooleanProperty("j3d.useBoxForGroupBounds", this.useBoxForGroupBounds, "Use of BoundingBox for group geometric bounds");
        String[] obsoleteProps = new String[]{"j3d.backgroundtexture", "j3d.forceNormalized", "j3d.g2ddrawpixel", "j3d.simulatedMultiTexture", "j3d.useFreeLists"};
        for (i2 = 0; i2 < obsoleteProps.length; ++i2) {
            if (MasterControl.getProperty(obsoleteProps[i2]) == null) continue;
            System.err.println("Java 3D: " + obsoleteProps[i2] + " property ignored");
        }
        this.maxLights = Pipeline.getPipeline().getMaximumLights();
        FreeListManager.createFreeLists();
        this.canvasIds = new boolean[32];
        for (i2 = 0; i2 < this.canvasIds.length; ++i2) {
            this.canvasIds[i2] = false;
        }
        this.canvasFreeIndex = 0;
    }

    private static boolean initLogger(Logger logger, Level defaultLevel) {
        if (logger == null) {
            return false;
        }
        if (defaultLevel != null && logger.getLevel() == null && Logger.getLogger("j3d").getLevel() == null) {
            try {
                logger.setLevel(defaultLevel);
            }
            catch (SecurityException ex) {
                System.err.println(ex);
                return false;
            }
        }
        return logger.isLoggable(Level.SEVERE);
    }

    private static void initLoggers() {
        coreLogger = Logger.getLogger("j3d.core");
        devLogger = Logger.getLogger("j3d.developer");
        statsLogger = Logger.getLogger("j3d.stats");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                coreLoggerEnabled = MasterControl.initLogger(coreLogger, null);
                devLoggerEnabled = MasterControl.initLogger(devLogger, Level.OFF);
                statsLoggerEnabled = MasterControl.initLogger(statsLogger, Level.OFF);
                return null;
            }
        });
    }

    static Logger getDevLogger() {
        return devLogger;
    }

    static boolean isDevLoggable(Level level) {
        return devLoggerEnabled && devLogger.isLoggable(level);
    }

    static Logger getStatsLogger() {
        return statsLogger;
    }

    static boolean isStatsLoggable(Level level) {
        return statsLoggerEnabled && statsLogger.isLoggable(level);
    }

    static Logger getCoreLogger() {
        return coreLogger;
    }

    static boolean isCoreLoggable(Level level) {
        return coreLoggerEnabled && coreLogger.isLoggable(level);
    }

    private static String getProperty(final String prop) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(prop);
            }
        });
    }

    static int getIntegerProperty(String prop, int defaultValue) {
        int value = defaultValue;
        String propValue = MasterControl.getProperty(prop);
        if (propValue != null) {
            try {
                value = Integer.parseInt(propValue);
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        if (J3dDebug.debug) {
            System.err.println("Java 3D: " + prop + "=" + value);
        }
        return value;
    }

    static boolean getBooleanProperty(String prop, boolean defaultValue, String trueMsg, String falseMsg) {
        boolean value = defaultValue;
        String propValue = MasterControl.getProperty(prop);
        if (propValue != null) {
            value = Boolean.valueOf(propValue);
            if (J3dDebug.debug) {
                System.err.println("Java 3D: " + (value ? trueMsg : falseMsg));
            }
        }
        return value;
    }

    static boolean getBooleanProperty(String prop, boolean defaultValue, String msg) {
        return MasterControl.getBooleanProperty(prop, defaultValue, msg + " enabled", msg + " disabled");
    }

    static void loadLibraries() {
        assert (!librariesLoaded);
        Pipeline.Type pipelineType = Pipeline.Type.JOGL;
        String rendStr = MasterControl.getProperty("j3d.rend");
        if (rendStr != null) {
            if (rendStr.equals("jogl")) {
                pipelineType = Pipeline.Type.JOGL;
            } else if (rendStr.equals("jogl2es2")) {
                pipelineType = Pipeline.Type.JOGL2ES2;
            } else if (rendStr.equals("noop")) {
                pipelineType = Pipeline.Type.NOOP;
            } else {
                System.err.println("Java 3D: Unrecognized renderer: " + rendStr);
            }
        }
        if (GraphicsEnvironment.isHeadless() && pipelineType != Pipeline.Type.NOOP) {
            throw new HeadlessException();
        }
        Pipeline.createPipeline(pipelineType);
        librariesLoaded = true;
    }

    InputDeviceBlockingThread getInputDeviceBlockingThread(final InputDevice device) {
        return AccessController.doPrivileged(new PrivilegedAction<InputDeviceBlockingThread>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputDeviceBlockingThread run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    InputDeviceBlockingThread thread2 = new InputDeviceBlockingThread(rootThreadGroup, device);
                    thread2.setPriority(threadPriority);
                    return thread2;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setThreadPriority(final int pri) {
        ThreadGroup threadGroup = rootThreadGroup;
        synchronized (threadGroup) {
            threadPriority = pri;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread[] list = new Thread[rootThreadGroup.activeCount()];
                    int count = rootThreadGroup.enumerate(list);
                    for (int i2 = count - 1; i2 >= 0; --i2) {
                        list[i2].setPriority(pri);
                    }
                    return null;
                }
            });
        }
    }

    int getThreadPriority() {
        return threadPriority;
    }

    int getRendererBit() {
        return 1 << this.rendererCount++;
    }

    int getRendererId() {
        return this.rendererCount++;
    }

    long getContextTimeStamp() {
        return ++this.contextTimeStamp;
    }

    Integer getDisplayListId() {
        return (Integer)FreeListManager.getObject(0);
    }

    void freeDisplayListId(Integer id) {
        FreeListManager.freeObject(0, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCanvasId() {
        int i2;
        Object object = this.canvasIdLock;
        synchronized (object) {
            for (i2 = this.canvasFreeIndex; i2 < this.canvasIds.length && this.canvasIds[i2]; ++i2) {
            }
            if (i2 >= this.canvasIds.length) {
                throw new RuntimeException("Cannot render to more than 32 Canvas3Ds");
            }
            this.canvasIds[i2] = true;
            this.canvasFreeIndex = i2 + 1;
        }
        return i2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeCanvasId(int canvasId) {
        Object object = this.canvasIdLock;
        synchronized (object) {
            this.canvasIds[canvasId] = false;
            if (this.canvasFreeIndex > canvasId) {
                this.canvasFreeIndex = canvasId;
            }
        }
    }

    private Renderer createRenderer(GraphicsConfiguration gc2) {
        final GraphicsDevice gd = gc2.getDevice();
        Renderer rdr = Screen3D.deviceRendererMap.get(gd);
        if (rdr != null) {
            return rdr;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    Renderer r = new Renderer(rootThreadGroup);
                    r.initialize();
                    r.setPriority(threadPriority);
                    Screen3D.deviceRendererMap.put(gd, r);
                }
                return null;
            }
        });
        this.threadListsChanged = true;
        return Screen3D.deviceRendererMap.get(gd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRequest(Integer type, Object obj) {
        Object object = mcThreadLock;
        synchronized (object) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (this.mcThread == null) {
                    if (type == ACTIVATE_VIEW || type == GETBESTCONFIG || type == SET_VIEW || type == ISCONFIGSUPPORT || type == SET_QUERYPROPERTIES || type == SET_GRAPHICSCONFIG_FEATURES) {
                        this.createMasterControlThread();
                        this.requestObjList.add(obj);
                        this.requestTypeList.add(type);
                        this.pendingRequest = true;
                    } else if (type == EMPTY_UNIVERSE) {
                        this.destroyUniverseThreads((VirtualUniverse)obj);
                    } else if (type == STOP_VIEW) {
                        View v = (View)obj;
                        v.stopViewCount = -1;
                        v.isRunning = false;
                    } else if (type == STOP_RENDERER) {
                        if (obj instanceof Canvas3D) {
                            ((Canvas3D)obj).isRunningStatus = false;
                        } else {
                            ((Renderer)obj).userStop = true;
                        }
                    } else if (type == UNREGISTER_VIEW) {
                        ((View)obj).doneUnregister = true;
                    } else {
                        this.requestObjList.add(obj);
                        this.requestTypeList.add(type);
                        this.pendingRequest = true;
                    }
                } else {
                    this.requestObjList.add(obj);
                    this.requestTypeList.add(type);
                    this.pendingRequest = true;
                }
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mcThreadDone() {
        Object object = mcThreadLock;
        synchronized (object) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (!this.pendingRequest) {
                    this.mcThread = null;
                    if (this.renderingAttributesStructure.updateThread != null) {
                        this.renderingAttributesStructure.updateThread.finish();
                        this.renderingAttributesStructure.updateThread = null;
                    }
                    this.renderingAttributesStructure = new RenderingAttributesStructure();
                    if (this.timerThread != null) {
                        this.timerThread.finish();
                        this.timerThread = null;
                    }
                    if (this.notificationThread != null) {
                        this.notificationThread.finish();
                        this.notificationThread = null;
                    }
                    this.requestObjList.clear();
                    this.requestTypeList.clear();
                    return true;
                }
                this.running = true;
                this.createMCThreads();
                return false;
            }
        }
    }

    final long getTime() {
        return this.time++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(J3dMessage message) {
        Object object = this.timeLock;
        synchronized (object) {
            message.time = this.getTime();
            this.sendMessage(message);
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(J3dMessage[] messages) {
        Object object = this.timeLock;
        synchronized (object) {
            long time = this.getTime();
            for (int i2 = 0; i2 < messages.length; ++i2) {
                messages[i2].time = time;
                this.sendMessage(messages[i2]);
            }
        }
        this.setWork();
    }

    void sendNotification(J3dNotification notification) {
        this.notificationThread.addNotification(notification);
    }

    void createMasterControlThread() {
        if (this.mcThread != null) {
            return;
        }
        this.running = true;
        this.workToDo = true;
        this.state = 1;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.mcThread = new MasterControlThread(rootThreadGroup);
                    MasterControl.this.mcThread.setPriority(threadPriority);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(J3dMessage message) {
        J3dMessage j3dMessage = message;
        synchronized (j3dMessage) {
            int i2;
            View[] v;
            UnorderList unorderList;
            VirtualUniverse u = message.universe;
            int targetThreads = message.threads;
            if (MasterControl.isCoreLoggable(Level.FINEST)) {
                this.dumpMessage("sendMessage", message);
            }
            if ((targetThreads & 0x400) != 0) {
                this.renderingAttributesStructure.addMessage(message);
            }
            if (u != null) {
                if ((targetThreads & 0x40) != 0) {
                    u.geometryStructure.addMessage(message);
                }
                if ((targetThreads & 0x2000) != 0) {
                    u.transformStructure.addMessage(message);
                }
                if ((targetThreads & 0x100) != 0) {
                    u.behaviorStructure.addMessage(message);
                }
                if ((targetThreads & 0x200) != 0) {
                    u.soundStructure.addMessage(message);
                }
                if ((targetThreads & 0x1000) != 0) {
                    u.renderingEnvironmentStructure.addMessage(message);
                }
            }
            if ((targetThreads & 2) != 0) {
                if (message.view != null && message.view.soundScheduler != null) {
                    message.view.soundScheduler.addMessage(message);
                } else {
                    unorderList = this.views;
                    synchronized (unorderList) {
                        v = (View[])this.views.toArray(false);
                        if (u == null) {
                            while (i2 >= 0) {
                                v[i2--].soundScheduler.addMessage(message);
                            }
                        } else {
                            for (i2 = this.views.arraySize() - 1; i2 >= 0; --i2) {
                                if (v[i2].universe != u) continue;
                                v[i2].soundScheduler.addMessage(message);
                            }
                        }
                    }
                }
            }
            if ((targetThreads & 0x80) != 0) {
                if (message.view != null && message.view.renderBin != null) {
                    message.view.renderBin.addMessage(message);
                } else {
                    unorderList = this.views;
                    synchronized (unorderList) {
                        v = (View[])this.views.toArray(false);
                        if (u == null) {
                            while (i2 >= 0) {
                                v[i2--].renderBin.addMessage(message);
                            }
                        } else {
                            for (i2 = this.views.arraySize() - 1; i2 >= 0; --i2) {
                                if (v[i2].universe != u) continue;
                                v[i2].renderBin.addMessage(message);
                            }
                        }
                    }
                }
            }
            if (message.getRefcount() == 0) {
                message.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(int targetThreads) {
        Object object = this.timeLock;
        synchronized (object) {
            int i2;
            UnorderList unorderList;
            long time = this.getTime();
            if ((targetThreads & 4) != 0) {
                unorderList = this.inputDeviceThreads;
                synchronized (unorderList) {
                    InputDeviceScheduler[] ds = (InputDeviceScheduler[])this.inputDeviceThreads.toArray(false);
                    for (i2 = this.inputDeviceThreads.size() - 1; i2 >= 0; --i2) {
                        if (ds[i2].physicalEnv.activeViewRef <= 0) continue;
                        ds[i2].getThreadData().lastUpdateTime = time;
                    }
                    if (this.timerThread != null) {
                        this.timerThread.addInputDeviceSchedCond();
                    }
                }
            }
            if ((targetThreads & 0x10) != 0) {
                unorderList = this.renderThreadData;
                synchronized (unorderList) {
                    J3dThreadData[] threads = (J3dThreadData[])this.renderThreadData.toArray(false);
                    i2 = this.renderThreadData.arraySize() - 1;
                    while (i2 >= 0) {
                        J3dThreadData thr = threads[i2--];
                        if (!thr.view.renderBinReady) continue;
                        thr.lastUpdateTime = time;
                    }
                }
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(long waitTime, View view, int targetThreads) {
        Object object = this.timeLock;
        synchronized (object) {
            long time = this.getTime();
            if ((targetThreads & 2) != 0) {
                if (view.soundScheduler != null) {
                    view.soundScheduler.threadData.lastUpdateTime = time;
                }
                this.timerThread.addSoundSchedCond(time + waitTime);
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(View v, int targetThreads) {
        Object object = this.timeLock;
        synchronized (object) {
            long time = this.getTime();
            if ((targetThreads & 0x10) != 0) {
                UnorderList unorderList = this.renderThreadData;
                synchronized (unorderList) {
                    J3dThreadData[] threads = (J3dThreadData[])this.renderThreadData.toArray(false);
                    int i2 = this.renderThreadData.arraySize() - 1;
                    while (i2 >= 0) {
                        J3dThreadData thr = threads[i2--];
                        if (thr.view != v || !v.renderBinReady) continue;
                        thr.lastUpdateTime = time;
                    }
                }
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(VirtualUniverse u, int targetThreads) {
        Object object = this.timeLock;
        synchronized (object) {
            int i2;
            UnorderList unorderList;
            long time = this.getTime();
            if ((targetThreads & 1) != 0 && u.behaviorScheduler != null) {
                u.behaviorScheduler.getThreadData(null, null).lastUpdateTime = time;
            }
            if ((targetThreads & 0x100) != 0) {
                u.behaviorStructure.threadData.lastUpdateTime = time;
            }
            if ((targetThreads & 0x40) != 0) {
                u.geometryStructure.threadData.lastUpdateTime = time;
            }
            if ((targetThreads & 0x200) != 0) {
                u.soundStructure.threadData.lastUpdateTime = time;
            }
            if ((targetThreads & 2) != 0) {
                unorderList = this.views;
                synchronized (unorderList) {
                    View[] v = (View[])this.views.toArray(false);
                    for (i2 = this.views.arraySize() - 1; i2 >= 0; --i2) {
                        if (v[i2].soundScheduler == null || v[i2].universe != u) continue;
                        v[i2].soundScheduler.threadData.lastUpdateTime = time;
                    }
                }
            }
            if ((targetThreads & 0x10) != 0) {
                unorderList = this.renderThreadData;
                synchronized (unorderList) {
                    J3dThreadData[] threads = (J3dThreadData[])this.renderThreadData.toArray(false);
                    i2 = this.renderThreadData.arraySize() - 1;
                    while (i2 >= 0) {
                        J3dThreadData thr = threads[i2--];
                        if (thr.view.universe != u || !thr.view.renderBinReady) continue;
                        thr.lastUpdateTime = time;
                    }
                }
            }
        }
        this.setWork();
    }

    UnorderList cloneView() {
        return (UnorderList)this.views.clone();
    }

    boolean isRegistered(View view) {
        return this.views.contains(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimeValues() {
        Object object = this.timeLock;
        synchronized (object) {
            int i2 = 0;
            J3dThreadData lastThread = null;
            J3dThreadData thread2 = null;
            long lastTime = this.currentTime;
            this.currentTime = this.getTime();
            J3dThreadData[] threads = (J3dThreadData[])this.stateWorkThreads.toArray(false);
            int size = this.stateWorkThreads.arraySize();
            while (i2 < this.lastTransformStructureThread) {
                thread2 = threads[i2++];
                if (thread2.lastUpdateTime > thread2.lastRunTime && !thread2.thread.userStop) {
                    lastThread = thread2;
                    thread2.needsRun = true;
                    thread2.threadOpts = 2;
                    thread2.lastRunTime = this.currentTime;
                    continue;
                }
                thread2.needsRun = false;
            }
            if (lastThread != null) {
                lastThread.threadOpts = 1;
                lastThread = null;
            }
            while (i2 < this.lastStructureUpdateThread) {
                thread2 = threads[i2++];
                if (thread2.lastUpdateTime > thread2.lastRunTime && !thread2.thread.userStop) {
                    lastThread = thread2;
                    thread2.needsRun = true;
                    thread2.threadOpts = 2;
                    thread2.lastRunTime = this.currentTime;
                    continue;
                }
                thread2.needsRun = false;
            }
            if (lastThread != null) {
                lastThread.threadOpts = 1;
                lastThread = null;
            }
            while (i2 < size) {
                thread2 = threads[i2++];
                if (thread2.lastUpdateTime > thread2.lastRunTime && !thread2.thread.userStop) {
                    lastThread = thread2;
                    thread2.needsRun = true;
                    thread2.threadOpts = 2;
                    thread2.lastRunTime = this.currentTime;
                    continue;
                }
                thread2.needsRun = false;
            }
            if (lastThread != null) {
                lastThread.threadOpts = 1;
                lastThread = null;
            }
            threads = (J3dThreadData[])this.renderWorkThreads.toArray(false);
            size = this.renderWorkThreads.arraySize();
            J3dThreadData lastRunThread = null;
            ++this.waitTimestamp;
            this.sleepTime = 0L;
            boolean threadToRun = false;
            View v = null;
            for (i2 = 0; i2 < size; ++i2) {
                thread2 = threads[i2];
                if (thread2.view != v) {
                    thread2.view.computeCycleTime();
                    if (thread2.view.sleepTime > this.sleepTime) {
                        this.sleepTime = thread2.view.sleepTime;
                    }
                }
                v = thread2.view;
            }
            v = null;
            for (i2 = 0; i2 < size; ++i2) {
                thread2 = threads[i2];
                if (thread2.canvas == null) {
                    ((Object[])thread2.threadArgs)[3] = null;
                }
                if (thread2.lastUpdateTime > thread2.lastRunTime && !thread2.thread.userStop) {
                    if (thread2.thread.lastWaitTimestamp == this.waitTimestamp) {
                        ++this.waitTimestamp;
                        if (thread2.view != v) {
                            v = thread2.view;
                            threadToRun = true;
                            lastRunThread.threadOpts = 17;
                            ((Object[])lastRunThread.threadArgs)[3] = lastRunThread.view;
                            thread2.threadOpts = 10;
                        } else {
                            lastRunThread.threadOpts = (lastRunThread.threadOpts & 8) != 0 ? 9 : 1;
                            thread2.threadOpts = 2;
                        }
                    } else if (thread2.view != v) {
                        v = thread2.view;
                        threadToRun = true;
                        if (lastRunThread != null) {
                            lastRunThread.threadOpts = 17;
                            ((Object[])lastRunThread.threadArgs)[3] = lastRunThread.view;
                        }
                        thread2.threadOpts = 10;
                    } else {
                        thread2.threadOpts = 2;
                    }
                    thread2.thread.lastWaitTimestamp = this.waitTimestamp;
                    thread2.needsRun = true;
                    thread2.lastRunTime = this.currentTime;
                    lastRunThread = thread2;
                    continue;
                }
                thread2.needsRun = false;
            }
            if (lastRunThread != null) {
                lastRunThread.threadOpts = 49;
                this.lockGeometry = true;
                ((Object[])lastRunThread.threadArgs)[3] = lastRunThread.view;
            } else {
                this.lockGeometry = false;
            }
        }
        if (this.sleepTime > 0L) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e2) {
                System.err.println(e2);
            }
        }
    }

    private void createUpdateThread(J3dStructure structure) {
        final J3dStructure s = structure;
        if (s.updateThread == null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        s.updateThread = new StructureUpdateThread(rootThreadGroup, s, s.threadType);
                        s.updateThread.setDaemon(true);
                        s.updateThread.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            s.updateThread.initialize();
            s.threadData.thread = s.updateThread;
            s.threadData.lastUpdateTime = Math.max(this.currentTime, s.threadData.lastUpdateTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyMessageList(J3dStructure structure, View v) {
        if (structure != null) {
            UnorderList mlist;
            if (v == null) {
                if (structure.threadData != null) {
                    structure.threadData.thread = null;
                }
                if (structure.updateThread != null) {
                    structure.updateThread.structure = null;
                }
                structure.updateThread = null;
            }
            boolean otherViewExist = false;
            if (v != null && v.universe != null) {
                for (int i2 = this.views.size() - 1; i2 >= 0; --i2) {
                    if (((View)this.views.get((int)i2)).universe != v.universe) continue;
                    otherViewExist = true;
                    break;
                }
            }
            UnorderList unorderList = mlist = structure.messageList;
            synchronized (unorderList) {
                int size = mlist.size();
                if (size > 0) {
                    J3dMessage[] mess = (J3dMessage[])mlist.toArray(false);
                    int i3 = 0;
                    while (i3 < size) {
                        J3dMessage m2 = mess[i3];
                        if (v == null || m2.view == v || m2.view == null && !otherViewExist) {
                            if (m2.type == 0) break;
                            m2.decRefcount();
                            mlist.removeOrdered(i3);
                            --size;
                            continue;
                        }
                        ++i3;
                    }
                }
            }
        }
    }

    private void destroyUpdateThread(J3dStructure structure) {
        if (structure.updateThread != null) {
            structure.updateThread.finish();
            structure.updateThread.structure = null;
            structure.updateThread = null;
        }
        structure.threadData.thread = null;
        structure.clearMessages();
    }

    private void registerView(View v) {
        final VirtualUniverse univ = v.universe;
        if (this.views.contains(v) && this.regUniverseList.contains(univ)) {
            return;
        }
        if (this.timerThread == null) {
            this.running = true;
            this.createMCThreads();
        }
        v.assignViewId();
        this.createUpdateThread(univ.behaviorStructure);
        this.createUpdateThread(univ.geometryStructure);
        this.createUpdateThread(univ.soundStructure);
        this.createUpdateThread(univ.renderingEnvironmentStructure);
        this.createUpdateThread(univ.transformStructure);
        J3dThreadData threadData = null;
        if (univ.behaviorScheduler == null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        univ.behaviorScheduler = new BehaviorScheduler(rootThreadGroup, univ);
                        univ.behaviorScheduler.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            univ.behaviorScheduler.initialize();
            univ.behaviorScheduler.userStop = v.stopBehavior;
            threadData = univ.behaviorScheduler.getThreadData(null, null);
            threadData.thread = univ.behaviorScheduler;
            threadData.threadType = 1;
            threadData.lastUpdateTime = Math.max(this.currentTime, threadData.lastUpdateTime);
        }
        this.createUpdateThread(v.renderBin);
        this.createUpdateThread(v.soundScheduler);
        if (v.physicalEnvironment != null) {
            v.physicalEnvironment.addUser(v);
        }
        this.evaluatePhysicalEnv(v);
        this.regUniverseList.addUnique(univ);
        this.views.addUnique(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterView(View v) {
        if (!this.views.remove(v)) {
            v.active = false;
            v.doneUnregister = true;
            return;
        }
        if (v.active) {
            this.viewDeactivate(v);
        }
        v.soundScheduler.updateThread.finish();
        v.renderBin.updateThread.finish();
        v.soundScheduler.updateThread = null;
        v.renderBin.updateThread = null;
        VirtualUniverse univ = v.universe;
        Object object = this.timeLock;
        synchronized (object) {
            this.emptyMessageList(v.soundScheduler, v);
            this.emptyMessageList(v.renderBin, v);
            if (univ.isEmpty()) {
                this.destroyUniverseThreads(univ);
            } else {
                this.emptyMessageList(univ.behaviorStructure, v);
                this.emptyMessageList(univ.geometryStructure, v);
                this.emptyMessageList(univ.soundStructure, v);
                this.emptyMessageList(univ.renderingEnvironmentStructure, v);
                this.emptyMessageList(univ.transformStructure, v);
            }
        }
        if (v.physicalEnvironment != null) {
            v.physicalEnvironment.removeUser(v);
        }
        ArrayList<PhysicalEnvironment> list = new ArrayList<PhysicalEnvironment>();
        for (PhysicalEnvironment phyEnv : PhysicalEnvironment.physicalEnvMap.keySet()) {
            InputDeviceScheduler sched = PhysicalEnvironment.physicalEnvMap.get(phyEnv);
            boolean phyEnvHasUser = false;
            for (int i2 = 0; i2 < phyEnv.users.size(); ++i2) {
                if (!this.views.contains(phyEnv.users.get(i2))) continue;
                phyEnvHasUser = true;
                break;
            }
            if (phyEnvHasUser) continue;
            sched.finish();
            phyEnv.inputsched = null;
            list.add(phyEnv);
        }
        for (int i3 = 0; i3 < list.size(); ++i3) {
            PhysicalEnvironment.physicalEnvMap.remove(list.get(i3));
        }
        this.freeContext(v);
        if (this.views.isEmpty()) {
            for (Renderer rdr : Screen3D.deviceRendererMap.values()) {
                this.rendererCleanupArgs[2] = REMOVEALLCTXS_CLEANUP;
                this.runMonitor(6, null, null, null, rdr);
                Screen3D scr = rdr.onScreen;
                if (scr != null && scr.renderer != null) {
                    this.rendererCleanupArgs[2] = REMOVEALLCTXS_CLEANUP;
                    this.runMonitor(6, null, null, null, scr.renderer);
                    scr.renderer = null;
                }
                if ((scr = rdr.offScreen) != null && scr.renderer != null) {
                    this.rendererCleanupArgs[2] = REMOVEALLCTXS_CLEANUP;
                    this.runMonitor(6, null, null, null, scr.renderer);
                    scr.renderer = null;
                }
                rdr.onScreen = null;
                rdr.offScreen = null;
            }
            Iterator<Renderer> e2 = Screen3D.deviceRendererMap.values().iterator();
            while (e2.hasNext()) {
                e2.next().cleanup();
            }
        } else {
            Iterator<Renderer> e3 = Screen3D.deviceRendererMap.values().iterator();
            while (e3.hasNext()) {
                e3.next().cleanupView();
            }
        }
        this.freeMessageList.add(univ);
        this.freeMessageList.add(v);
        this.evaluateAllCanvases();
        this.stateWorkThreads.clear();
        this.renderWorkThreads.clear();
        this.requestRenderWorkThreads.clear();
        this.threadListsChanged = true;
        v.doneUnregister = true;
    }

    void createMCThreads() {
        this.createUpdateThread(this.renderingAttributesStructure);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.timerThread = new TimerThread(rootThreadGroup);
                    MasterControl.this.timerThread.setDaemon(true);
                    MasterControl.this.timerThread.setPriority(threadPriority);
                }
                return null;
            }
        });
        this.timerThread.start();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.notificationThread = new NotificationThread(rootThreadGroup);
                    MasterControl.this.notificationThread.setDaemon(true);
                    MasterControl.this.notificationThread.setPriority(threadPriority);
                }
                return null;
            }
        });
        this.notificationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyUniverseThreads(VirtualUniverse univ) {
        if (this.regUniverseList.contains(univ)) {
            this.destroyUpdateThread(univ.behaviorStructure);
            this.destroyUpdateThread(univ.geometryStructure);
            this.destroyUpdateThread(univ.soundStructure);
            this.destroyUpdateThread(univ.renderingEnvironmentStructure);
            this.destroyUpdateThread(univ.transformStructure);
            univ.behaviorScheduler.finish();
            univ.behaviorScheduler.free();
            univ.behaviorScheduler = null;
            univ.initMCStructure();
            this.activeUniverseList.remove(univ);
            this.regUniverseList.remove(univ);
        } else {
            this.emptyMessageList(univ.behaviorStructure, null);
            this.emptyMessageList(univ.geometryStructure, null);
            this.emptyMessageList(univ.soundStructure, null);
            this.emptyMessageList(univ.renderingEnvironmentStructure, null);
            this.emptyMessageList(univ.transformStructure, null);
        }
        if (this.regUniverseList.isEmpty() && this.views.isEmpty()) {
            if (this.renderingAttributesStructure.updateThread != null) {
                this.renderingAttributesStructure.updateThread.finish();
                this.renderingAttributesStructure.updateThread = null;
            }
            this.renderingAttributesStructure.messageList.clear();
            this.renderingAttributesStructure.objList = new ArrayList();
            this.renderingAttributesStructure = new RenderingAttributesStructure();
            if (this.timerThread != null) {
                this.timerThread.finish();
                this.timerThread = null;
            }
            if (this.notificationThread != null) {
                this.notificationThread.finish();
                this.notificationThread = null;
            }
            Hashtable<GraphicsDevice, Screen3D> hashtable = VirtualUniverse.mc.deviceScreenMap;
            synchronized (hashtable) {
                this.deviceScreenMap.clear();
            }
            this.mirrorObjects.clear();
            for (int i2 = 0; i2 < this.canvasIds.length; ++i2) {
                this.canvasIds[i2] = false;
            }
            this.canvasFreeIndex = 0;
            this.renderOnceList.clear();
            this.timestampUpdateList.clear();
            this.defaultRenderMethod = null;
            this.text3DRenderMethod = null;
            this.vertexArrayRenderMethod = null;
            this.displayListRenderMethod = null;
            this.compressedGeometryRenderMethod = null;
            this.orientedShape3DRenderMethod = null;
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateAllCanvases() {
        UnorderList unorderList = this.renderThreadData;
        synchronized (unorderList) {
            int i2;
            this.renderThreadData.clear();
            View[] viewArr = (View[])this.views.toArray(false);
            for (i2 = this.views.size() - 1; i2 >= 0; --i2) {
                viewArr[i2].getCanvasList(true);
                Screen3D[] screens = viewArr[i2].getScreens();
                for (int j2 = screens.length - 1; j2 >= 0; --j2) {
                    screens[j2].canvasCount = 0;
                }
            }
            for (i2 = this.views.size() - 1; i2 >= 0; --i2) {
                View v = viewArr[i2];
                Canvas3D[][] canvasList = v.getCanvasList(false);
                if (!v.active) continue;
                for (int j3 = canvasList.length - 1; j3 >= 0; --j3) {
                    boolean added = false;
                    for (int k2 = canvasList[j3].length - 1; k2 >= 0; --k2) {
                        J3dThreadData renderData;
                        Canvas3D cv = canvasList[j3][k2];
                        final Screen3D screen = cv.screen;
                        if (!cv.active) continue;
                        if (screen.canvasCount++ == 0 && screen.renderer == null) {
                            Renderer rdr = Screen3D.deviceRendererMap.get(cv.screen.graphicsDevice);
                            if (rdr == null) {
                                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public Object run() {
                                        ThreadGroup threadGroup = rootThreadGroup;
                                        synchronized (threadGroup) {
                                            screen.renderer = new Renderer(rootThreadGroup);
                                            screen.renderer.setPriority(threadPriority);
                                        }
                                        return null;
                                    }
                                });
                                screen.renderer.initialize();
                                Screen3D.deviceRendererMap.put(screen.graphicsDevice, screen.renderer);
                            } else {
                                screen.renderer = rdr;
                            }
                        }
                        if (cv.manualRendering) {
                            screen.renderer.offScreen = screen;
                            continue;
                        }
                        screen.renderer.onScreen = screen;
                        if (!added) {
                            renderData = screen.renderer.getThreadData(v, null);
                            this.renderThreadData.add(renderData);
                            if (v.renderBinReady) {
                                renderData.lastUpdateTime = Math.max(this.currentTime, renderData.lastUpdateTime);
                            }
                            added = true;
                        }
                        renderData = screen.renderer.getThreadData(v, cv);
                        this.renderThreadData.add(renderData);
                        if (!v.renderBinReady) continue;
                        renderData.lastUpdateTime = Math.max(this.currentTime, renderData.lastUpdateTime);
                    }
                }
            }
        }
        this.threadListsChanged = true;
    }

    private void evaluatePhysicalEnv(View v) {
        final PhysicalEnvironment env = v.physicalEnvironment;
        if (env.inputsched == null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        env.inputsched = new InputDeviceScheduler(rootThreadGroup, env);
                        env.inputsched.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            env.inputsched.start();
            PhysicalEnvironment.physicalEnvMap.put(env, env.inputsched);
        }
        this.threadListsChanged = true;
    }

    private final void addToStateThreads(J3dThreadData threadData) {
        if (threadData.thread.active) {
            this.stateWorkThreads.add(threadData);
        }
    }

    private void assignNewPrimaryView(VirtualUniverse univ) {
        View currentPrimary = univ.getCurrentView();
        if (currentPrimary != null) {
            currentPrimary.primaryView = false;
        }
        View[] v = (View[])this.views.toArray(false);
        int nviews = this.views.size();
        for (int i2 = 0; i2 < nviews; ++i2) {
            View view = v[i2];
            if (!view.active || !view.isRunning || univ != view.universe) continue;
            view.primaryView = true;
            univ.setCurrentView(view);
            return;
        }
        univ.setCurrentView(null);
    }

    RenderMethod getDefaultRenderMethod() {
        if (this.defaultRenderMethod == null) {
            this.defaultRenderMethod = new DefaultRenderMethod();
        }
        return this.defaultRenderMethod;
    }

    RenderMethod getText3DRenderMethod() {
        if (this.text3DRenderMethod == null) {
            this.text3DRenderMethod = new Text3DRenderMethod();
        }
        return this.text3DRenderMethod;
    }

    RenderMethod getVertexArrayRenderMethod() {
        if (this.vertexArrayRenderMethod == null) {
            this.vertexArrayRenderMethod = new VertexArrayRenderMethod();
        }
        return this.vertexArrayRenderMethod;
    }

    RenderMethod getDisplayListRenderMethod() {
        if (this.displayListRenderMethod == null) {
            this.displayListRenderMethod = new DisplayListRenderMethod();
        }
        return this.displayListRenderMethod;
    }

    RenderMethod getCompressedGeometryRenderMethod() {
        if (this.compressedGeometryRenderMethod == null) {
            this.compressedGeometryRenderMethod = new CompressedGeometryRenderMethod();
        }
        return this.compressedGeometryRenderMethod;
    }

    RenderMethod getOrientedShape3DRenderMethod() {
        if (this.orientedShape3DRenderMethod == null) {
            this.orientedShape3DRenderMethod = new OrientedShape3DRenderMethod();
        }
        return this.orientedShape3DRenderMethod;
    }

    private void viewActivate(View v) {
        VirtualUniverse univ = v.universe;
        if (univ == null) {
            return;
        }
        if (!this.views.contains(v) || !this.regUniverseList.contains(univ)) {
            this.registerView(v);
        } else if (v.active) {
            this.evaluateAllCanvases();
            return;
        }
        if (univ.activeViewCount == 0) {
            univ.geometryStructure.resetConditionMet();
            univ.behaviorStructure.resetConditionMet();
        }
        if (v.isRunning) {
            ++this.numActiveViews;
            ++univ.activeViewCount;
            this.renderingAttributesStructure.updateThread.active = true;
            univ.transformStructure.updateThread.active = true;
            univ.geometryStructure.updateThread.active = true;
            univ.soundStructure.updateThread.active = true;
            univ.renderingEnvironmentStructure.updateThread.active = true;
        }
        univ.behaviorScheduler.active = true;
        univ.behaviorStructure.updateThread.active = true;
        this.activeUniverseList.addUnique(univ);
        if (v.isRunning) {
            v.soundScheduler.activate();
            v.renderBin.updateThread.active = true;
        }
        v.active = true;
        if (v.physicalEnvironment.activeViewRef++ == 0) {
            v.physicalEnvironment.inputsched.activate();
        }
        if (univ.getCurrentView() == null) {
            this.assignNewPrimaryView(univ);
        }
        this.evaluateAllCanvases();
        v.inRenderThreadData = true;
        this.threadListsChanged = true;
        v.renderBin.reactivateView = true;
    }

    private void freeContext(View v) {
        Canvas3D[][] canvasList = v.getCanvasList(false);
        for (int j2 = canvasList.length - 1; j2 >= 0; --j2) {
            for (int k2 = canvasList[j2].length - 1; k2 >= 0; --k2) {
                Canvas3D cv = canvasList[j2][k2];
                if (cv.validCanvas || cv.screen == null || cv.screen.renderer == null) continue;
                this.rendererCleanupArgs[1] = cv;
                this.rendererCleanupArgs[2] = FREECONTEXT_CLEANUP;
                this.runMonitor(6, null, null, null, cv.screen.renderer);
                this.rendererCleanupArgs[1] = null;
            }
        }
    }

    private void viewDeactivate(View v) {
        if (!this.views.contains(v) || !v.active) {
            v.active = false;
            this.evaluateAllCanvases();
            return;
        }
        VirtualUniverse univ = v.universe;
        if (v.isRunning) {
            --this.numActiveViews;
            --univ.activeViewCount;
        }
        if (this.numActiveViews == 0) {
            this.renderingAttributesStructure.updateThread.active = false;
        }
        if (univ.activeViewCount == 0 && univ.behaviorScheduler != null) {
            univ.behaviorScheduler.deactivate();
            univ.transformStructure.updateThread.active = false;
            univ.geometryStructure.updateThread.active = false;
            univ.behaviorStructure.updateThread.active = false;
            univ.soundStructure.updateThread.active = false;
            univ.renderingEnvironmentStructure.updateThread.active = false;
            this.activeUniverseList.remove(univ);
        }
        v.soundScheduler.deactivate();
        v.renderBin.updateThread.active = false;
        v.active = false;
        if (--v.physicalEnvironment.activeViewRef == 0) {
            v.physicalEnvironment.inputsched.deactivate();
        }
        this.assignNewPrimaryView(univ);
        this.evaluateAllCanvases();
        this.freeContext(v);
        v.inRenderThreadData = false;
        this.threadListsChanged = true;
    }

    private void startView(View v) {
        if (!this.views.contains(v) || v.isRunning || !v.active) {
            v.isRunning = true;
            return;
        }
        ++this.numActiveViews;
        this.renderingAttributesStructure.updateThread.active = true;
        VirtualUniverse univ = v.universe;
        ++univ.activeViewCount;
        univ.transformStructure.updateThread.active = true;
        univ.geometryStructure.updateThread.active = true;
        univ.soundStructure.updateThread.active = true;
        univ.renderingEnvironmentStructure.updateThread.active = true;
        v.renderBin.updateThread.active = true;
        v.soundScheduler.activate();
        v.isRunning = true;
        if (univ.getCurrentView() == null) {
            this.assignNewPrimaryView(univ);
        }
        this.threadListsChanged = true;
    }

    private void stopView(View v) {
        if (!(this.views.contains(v) && v.isRunning && v.active)) {
            v.isRunning = false;
            return;
        }
        if (--this.numActiveViews == 0) {
            this.renderingAttributesStructure.updateThread.active = false;
        }
        VirtualUniverse univ = v.universe;
        if (--univ.activeViewCount == 0) {
            univ.transformStructure.updateThread.active = false;
            univ.geometryStructure.updateThread.active = false;
            univ.renderingEnvironmentStructure.updateThread.active = false;
            univ.soundStructure.updateThread.active = false;
        }
        v.renderBin.updateThread.active = false;
        v.soundScheduler.deactivate();
        v.isRunning = false;
        this.assignNewPrimaryView(univ);
        this.threadListsChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInputDeviceScheduler(InputDeviceScheduler ds) {
        UnorderList unorderList = this.inputDeviceThreads;
        synchronized (unorderList) {
            this.inputDeviceThreads.add(ds);
            if (this.inputDeviceThreads.size() == 1) {
                this.timerThread.addInputDeviceSchedCond();
            }
        }
        this.postRequest(INPUTDEVICE_CHANGE, null);
    }

    void removeInputDeviceScheduler(InputDeviceScheduler ds) {
        this.inputDeviceThreads.remove(ds);
        this.postRequest(INPUTDEVICE_CHANGE, null);
    }

    void addMirrorObject(ObjectUpdate o2) {
        this.mirrorObjects.add(o2);
    }

    void updateMirrorObjects() {
        ObjectUpdate[] objs = (ObjectUpdate[])this.mirrorObjects.toArray(false);
        int sz = this.mirrorObjects.arraySize();
        for (int i2 = 0; i2 < sz; ++i2) {
            objs[i2].updateObject();
        }
        this.mirrorObjects.clear();
    }

    private void updateWorkThreads() {
        J3dThreadData thread2;
        int i2;
        this.stateWorkThreads.clear();
        this.renderWorkThreads.clear();
        this.requestRenderWorkThreads.clear();
        if (this.numActiveViews > 0) {
            this.addToStateThreads(this.renderingAttributesStructure.getUpdateThreadData());
        }
        VirtualUniverse[] universes = (VirtualUniverse[])this.activeUniverseList.toArray(false);
        int size = this.activeUniverseList.arraySize();
        for (i2 = size - 1; i2 >= 0; --i2) {
            this.addToStateThreads(universes[i2].transformStructure.getUpdateThreadData());
        }
        this.lastTransformStructureThread = this.stateWorkThreads.size();
        for (i2 = size - 1; i2 >= 0; --i2) {
            VirtualUniverse univ = universes[i2];
            this.addToStateThreads(univ.geometryStructure.getUpdateThreadData());
            this.addToStateThreads(univ.behaviorStructure.getUpdateThreadData());
            this.addToStateThreads(univ.renderingEnvironmentStructure.getUpdateThreadData());
            this.addToStateThreads(univ.soundStructure.getUpdateThreadData());
        }
        this.lastStructureUpdateThread = this.stateWorkThreads.size();
        for (i2 = size - 1; i2 >= 0; --i2) {
            this.addToStateThreads(universes[i2].behaviorScheduler.getThreadData(null, null));
        }
        InputDeviceScheduler[] ds = (InputDeviceScheduler[])this.inputDeviceThreads.toArray(true);
        for (i2 = this.inputDeviceThreads.size() - 1; i2 >= 0; --i2) {
            J3dThreadData threadData = ds[i2].getThreadData();
            threadData.thread.active = true;
            this.addToStateThreads(threadData);
        }
        View[] viewArr = (View[])this.views.toArray(false);
        for (i2 = this.views.size() - 1; i2 >= 0; --i2) {
            Canvas3D cv;
            int k2;
            int j2;
            View v = viewArr[i2];
            if (!v.active || !v.isRunning) continue;
            this.addToStateThreads(v.renderBin.getUpdateThreadData());
            this.addToStateThreads(v.soundScheduler.getUpdateThreadData());
            Canvas3D[][] canvasList = v.getCanvasList(false);
            int longestScreenList = v.getLongestScreenList();
            Object[] args = null;
            for (j2 = 0; j2 < longestScreenList; ++j2) {
                for (k2 = 0; k2 < canvasList.length; ++k2) {
                    if (j2 >= canvasList[k2].length) continue;
                    cv = canvasList[k2][j2];
                    if (!cv.active || !cv.isRunningStatus || cv.manualRendering || cv.screen.renderer == null) continue;
                    thread2 = cv.screen.renderer.getThreadData(v, cv);
                    this.renderWorkThreads.add(thread2);
                    args = (Object[])thread2.threadArgs;
                    args[0] = RENDER;
                    args[1] = cv;
                    args[2] = v;
                }
            }
            block7: for (j2 = 0; j2 < canvasList.length; ++j2) {
                for (k2 = 0; k2 < canvasList[j2].length; ++k2) {
                    cv = canvasList[j2][k2];
                    if (!cv.active || !cv.isRunningStatus || cv.manualRendering || cv.screen.renderer == null) continue;
                    thread2 = cv.screen.renderer.getThreadData(v, null);
                    this.renderWorkThreads.add(thread2);
                    args = (Object[])thread2.threadArgs;
                    args[0] = SWAP;
                    args[1] = v;
                    args[2] = canvasList[j2];
                    continue block7;
                }
            }
        }
        thread2 = null;
        for (Renderer rdr : Screen3D.deviceRendererMap.values()) {
            thread2 = rdr.getThreadData(null, null);
            this.requestRenderWorkThreads.add(thread2);
            thread2.threadOpts = 2;
            ((Object[])thread2.threadArgs)[0] = REQUESTRENDER;
        }
        if (thread2 != null) {
            thread2.threadOpts |= 1;
        }
        this.threadListsChanged = false;
    }

    void dumpWorkThreads() {
        System.err.println("-----------------------------");
        System.err.println("MasterControl/dumpWorkThreads");
        int size = 0;
        for (int k2 = 0; k2 < 3; ++k2) {
            J3dThreadData[] threads;
            switch (k2) {
                case 0: {
                    threads = (J3dThreadData[])this.stateWorkThreads.toArray(false);
                    size = this.stateWorkThreads.arraySize();
                    break;
                }
                case 1: {
                    threads = (J3dThreadData[])this.renderWorkThreads.toArray(false);
                    size = this.renderWorkThreads.arraySize();
                    break;
                }
                default: {
                    threads = (J3dThreadData[])this.requestRenderWorkThreads.toArray(false);
                    size = this.requestRenderWorkThreads.arraySize();
                }
            }
            for (int i2 = 0; i2 < size; ++i2) {
                J3dThreadData thread2 = threads[i2];
                System.err.println("Thread " + i2 + ": " + thread2.thread);
                System.err.println("\tOps: " + thread2.threadOpts);
                if (thread2.threadArgs != null) {
                    Object[] args = (Object[])thread2.threadArgs;
                    System.err.print("\tArgs: ");
                    for (int j2 = 0; j2 < args.length; ++j2) {
                        System.err.print(args[j2] + " ");
                    }
                }
                System.err.println("");
            }
        }
        System.err.println("-----------------------------");
    }

    final void setWork() {
        this.runMonitor(1, null, null, null, null);
    }

    final void setWorkForRequestRenderer() {
        this.runMonitor(5, null, null, null, null);
    }

    void sendRenderMessage(GraphicsConfiguration gc2, Object arg, Integer mtype) {
        Renderer rdr = this.createRenderer(gc2);
        J3dMessage renderMessage = new J3dMessage();
        renderMessage.threads = 16;
        renderMessage.type = 44;
        renderMessage.universe = null;
        renderMessage.view = null;
        renderMessage.args[0] = null;
        renderMessage.args[1] = arg;
        renderMessage.args[2] = mtype;
        rdr.rendererStructure.addMessage(renderMessage);
        this.setWorkForRequestRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDestroyCtxAndOffScreenBuffer(Canvas3D c2) {
        GraphicsDevice gd = c2.graphicsConfiguration.getDevice();
        assert (Screen3D.deviceRendererMap.get(gd) != null);
        Object object = mcThreadLock;
        synchronized (object) {
            this.createMasterControlThread();
            assert (this.mcThread != null);
            Renderer rdr = this.createRenderer(c2.graphicsConfiguration);
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 16;
            createMessage.type = 62;
            createMessage.universe = null;
            createMessage.view = null;
            createMessage.args[0] = c2;
            createMessage.args[1] = 0L;
            createMessage.args[2] = c2.drawable;
            createMessage.args[3] = c2.ctx;
            rdr.rendererStructure.addMessage(createMessage);
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                this.setWorkForRequestRenderer();
                this.pendingRequest = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCreateOffScreenBuffer(Canvas3D c2) {
        GraphicsDevice gd = c2.graphicsConfiguration.getDevice();
        J3dDebug.doAssert(Screen3D.deviceRendererMap.get(gd) != null, "Screen3D.deviceRendererMap.get(gd) != null");
        Object object = mcThreadLock;
        synchronized (object) {
            this.createMasterControlThread();
            assert (this.mcThread != null);
            Renderer rdr = this.createRenderer(c2.graphicsConfiguration);
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 16;
            createMessage.type = 61;
            createMessage.universe = null;
            createMessage.view = null;
            createMessage.args[0] = c2;
            rdr.rendererStructure.addMessage(createMessage);
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                this.setWorkForRequestRenderer();
                this.pendingRequest = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAllocateCanvasId(Canvas3D c2) {
        Object object = mcThreadLock;
        synchronized (object) {
            this.createMasterControlThread();
            assert (this.mcThread != null);
            Renderer rdr = this.createRenderer(c2.graphicsConfiguration);
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 16;
            createMessage.type = 66;
            createMessage.universe = null;
            createMessage.view = null;
            createMessage.args[0] = c2;
            rdr.rendererStructure.addMessage(createMessage);
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                this.setWorkForRequestRenderer();
                this.pendingRequest = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendFreeCanvasId(Canvas3D c2) {
        Object object = mcThreadLock;
        synchronized (object) {
            this.createMasterControlThread();
            assert (this.mcThread != null);
            Renderer rdr = this.createRenderer(c2.graphicsConfiguration);
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 16;
            createMessage.type = 67;
            createMessage.universe = null;
            createMessage.view = null;
            createMessage.args[0] = c2;
            rdr.rendererStructure.addMessage(createMessage);
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                this.setWorkForRequestRenderer();
                this.pendingRequest = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork() {
        this.runMonitor(0, null, null, null, null);
        Object object = this.timeLock;
        synchronized (object) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (this.pendingRequest) {
                    this.handlePendingRequest();
                }
            }
        }
        if (!this.running) {
            return;
        }
        if (this.threadListsChanged) {
            this.updateWorkThreads();
        }
        object = this.timeLock;
        synchronized (object) {
            this.updateTimeValues();
        }
        View[] v = (View[])this.views.toArray(false);
        for (int i2 = this.views.size() - 1; i2 >= 0; --i2) {
            if (!v[i2].active) continue;
            v[i2].updateViewCache();
            if ((v[i2].viewCache.vcDirtyMask == 0 || v[i2].renderBin.orientedRAs.isEmpty()) && (v[i2].renderBin.cachedDirtyOrientedRAs == null || v[i2].renderBin.cachedDirtyOrientedRAs.isEmpty())) continue;
            v[i2].renderBin.updateOrientedRAs();
        }
        this.runMonitor(2, this.stateWorkThreads, this.renderWorkThreads, this.requestRenderWorkThreads, null);
        if (this.renderOnceList.size() > 0) {
            this.clearRenderOnceList();
        }
        this.manageMemory();
    }

    private void handlePendingRequest() {
        Integer type;
        int i2;
        boolean rendererRun = false;
        Object[] objs = this.requestObjList.toArray(false);
        Integer[] types = (Integer[])this.requestTypeList.toArray(false);
        int size = this.requestObjList.size();
        for (i2 = 0; i2 < size; ++i2) {
            type = types[i2];
            Object o2 = objs[i2];
            if (type == RESET_CANVAS) {
                Canvas3D cv = (Canvas3D)o2;
                if (cv.screen != null && cv.screen.renderer != null) {
                    this.rendererCleanupArgs[1] = o2;
                    this.rendererCleanupArgs[2] = RESETCANVAS_CLEANUP;
                    this.runMonitor(6, null, null, null, cv.screen.renderer);
                    this.rendererCleanupArgs[1] = null;
                }
                cv.reset();
                cv.view = null;
                cv.computeViewCache();
                continue;
            }
            if (type == ACTIVATE_VIEW) {
                this.viewActivate((View)o2);
                continue;
            }
            if (type == DEACTIVATE_VIEW) {
                this.viewDeactivate((View)o2);
                continue;
            }
            if (type == REEVALUATE_CANVAS) {
                this.evaluateAllCanvases();
                continue;
            }
            if (type == INPUTDEVICE_CHANGE) {
                this.inputDeviceThreads.clearMirror();
                this.threadListsChanged = true;
                continue;
            }
            if (type == START_VIEW) {
                this.startView((View)o2);
                continue;
            }
            if (type == STOP_VIEW) {
                View v = (View)o2;
                if (++v.stopViewCount > 4) {
                    v.stopViewCount = -1;
                    this.stopView(v);
                    continue;
                }
                this.tempViewList.add(v);
                continue;
            }
            if (type == UNREGISTER_VIEW) {
                this.unregisterView((View)o2);
                continue;
            }
            if (type == PHYSICAL_ENV_CHANGE) {
                this.evaluatePhysicalEnv((View)o2);
                continue;
            }
            if (type == EMPTY_UNIVERSE) {
                boolean foundView = false;
                VirtualUniverse univ = (VirtualUniverse)o2;
                View[] v = (View[])this.views.toArray(false);
                for (int j2 = this.views.size() - 1; j2 >= 0; --j2) {
                    if (v[j2].universe != univ) continue;
                    foundView = true;
                    break;
                }
                if (foundView) continue;
                this.destroyUniverseThreads(univ);
                this.threadListsChanged = true;
                continue;
            }
            if (type == START_RENDERER) {
                if (o2 instanceof Canvas3D) {
                    Canvas3D c3d = (Canvas3D)o2;
                    if (!c3d.isFatalError()) {
                        c3d.isRunningStatus = true;
                    }
                } else {
                    ((Renderer)o2).userStop = false;
                }
                this.threadListsChanged = true;
                continue;
            }
            if (type == STOP_RENDERER) {
                if (o2 instanceof Canvas3D) {
                    ((Canvas3D)o2).isRunningStatus = false;
                } else {
                    ((Renderer)o2).userStop = true;
                }
                this.threadListsChanged = true;
                continue;
            }
            if (type == RENDER_ONCE) {
                View v = (View)o2;
                this.startView(v);
                this.renderOnceList.add(v);
                this.sendRunMessage(v, 128);
                this.threadListsChanged = true;
                rendererRun = true;
                continue;
            }
            if (type == FREE_CONTEXT) {
                Canvas3D cv = (Canvas3D)((Object[])o2)[0];
                if (cv.screen != null && cv.screen.renderer != null) {
                    this.rendererCleanupArgs[1] = o2;
                    this.rendererCleanupArgs[2] = REMOVECTX_CLEANUP;
                    this.runMonitor(6, null, null, null, cv.screen.renderer);
                    this.rendererCleanupArgs[1] = null;
                }
                rendererRun = true;
                continue;
            }
            if (type == FREE_DRAWING_SURFACE) {
                Pipeline.getPipeline().freeDrawingSurfaceNative(o2);
                continue;
            }
            if (type == GETBESTCONFIG) {
                GraphicsConfiguration gc2 = ((GraphicsConfiguration[])((GraphicsConfigTemplate3D)o2).testCfg)[0];
                this.sendRenderMessage(gc2, o2, type);
                rendererRun = true;
                continue;
            }
            if (type == ISCONFIGSUPPORT) {
                GraphicsConfiguration gc3 = (GraphicsConfiguration)((GraphicsConfigTemplate3D)o2).testCfg;
                this.sendRenderMessage(gc3, o2, type);
                rendererRun = true;
                continue;
            }
            if (type == SET_GRAPHICSCONFIG_FEATURES || type == SET_QUERYPROPERTIES) {
                GraphicsConfiguration gc4 = ((Canvas3D)o2).graphicsConfiguration;
                this.sendRenderMessage(gc4, o2, type);
                rendererRun = true;
                continue;
            }
            if (type != SET_VIEW) continue;
            Canvas3D cv = (Canvas3D)o2;
            cv.view = cv.pendingView;
            cv.computeViewCache();
        }
        for (i2 = 0; i2 < size; ++i2) {
            View v;
            type = types[i2];
            if (type != FREE_MESSAGE) continue;
            if (objs[i2] instanceof VirtualUniverse) {
                VirtualUniverse u = (VirtualUniverse)objs[i2];
                if (this.regUniverseList.contains(u)) continue;
                this.emptyMessageList(u.behaviorStructure, null);
                this.emptyMessageList(u.geometryStructure, null);
                this.emptyMessageList(u.soundStructure, null);
                this.emptyMessageList(u.renderingEnvironmentStructure, null);
                continue;
            }
            if (!(objs[i2] instanceof View) || this.views.contains(v = (View)objs[i2])) continue;
            this.emptyMessageList(v.soundScheduler, v);
            this.emptyMessageList(v.renderBin, v);
            if (v.resetUnivCount != v.universeCount) continue;
            v.reset();
            v.universe = null;
            if (this.running) continue;
        }
        this.requestObjList.clear();
        this.requestTypeList.clear();
        size = this.tempViewList.size();
        if (size > 0) {
            if (this.running) {
                for (i2 = 0; i2 < size; ++i2) {
                    this.requestTypeList.add(STOP_VIEW);
                    this.requestObjList.add(this.tempViewList.get(i2));
                }
                this.setWork();
            } else {
                for (i2 = 0; i2 < size; ++i2) {
                    View v = (View)this.tempViewList.get(i2);
                    v.stopViewCount = -1;
                    v.isRunning = false;
                }
            }
            this.tempViewList.clear();
            this.pendingRequest = true;
        } else {
            this.pendingRequest = rendererRun || this.requestObjList.size() > 0;
        }
        size = this.freeMessageList.size();
        if (size > 0) {
            for (i2 = 0; i2 < size; ++i2) {
                this.requestTypeList.add(FREE_MESSAGE);
                this.requestObjList.add(this.freeMessageList.get(i2));
            }
            this.pendingRequest = true;
            this.freeMessageList.clear();
        }
        if (!this.running && this.renderOnceList.size() > 0) {
            this.clearRenderOnceList();
        }
        if (this.pendingRequest) {
            this.setWork();
        }
        if (rendererRun || this.requestRenderWorkToDo) {
            this.running = true;
        }
    }

    private void clearRenderOnceList() {
        for (int i2 = this.renderOnceList.size() - 1; i2 >= 0; --i2) {
            View v = (View)this.renderOnceList.get(i2);
            v.renderOnceFinish = true;
            this.stopView(v);
        }
        this.renderOnceList.clear();
        this.threadListsChanged = true;
    }

    synchronized void runMonitor(int action, UnorderList stateThreadList, UnorderList renderThreadList, UnorderList requestRenderThreadList, J3dThread nthread) {
        switch (action) {
            case 2: {
                View currentV;
                int i2;
                int currentStateThread = 0;
                int currentRenderThread = 0;
                int currentRequestRenderThread = 0;
                J3dThreadData[] renderThreads = (J3dThreadData[])renderThreadList.toArray(false);
                J3dThreadData[] stateThreads = (J3dThreadData[])stateThreadList.toArray(false);
                J3dThreadData[] requestRenderThreads = (J3dThreadData[])requestRenderThreadList.toArray(false);
                int renderThreadSize = renderThreadList.arraySize();
                int stateThreadSize = stateThreadList.arraySize();
                int requestRenderThreadSize = requestRenderThreadList.arraySize();
                boolean done = false;
                View[] allView = (View[])this.views.toArray(false);
                if (this.lockGeometry) {
                    for (i2 = this.views.arraySize() - 1; i2 >= 0; --i2) {
                        currentV = allView[i2];
                        currentV.renderBin.lockGeometry();
                    }
                }
                while (!done) {
                    J3dThreadData thread2;
                    while (!this.renderWaiting && currentRenderThread != renderThreadSize) {
                        View view;
                        thread2 = renderThreads[currentRenderThread++];
                        if (!thread2.needsRun) continue;
                        if ((thread2.threadOpts & 8) != 0) {
                            view = (View)((Object[])thread2.threadArgs)[2];
                            ++view.frameNumber;
                            view.startTime = J3dClock.currentTimeMillis();
                        }
                        ++this.renderPending;
                        if (this.cpuLimit == 1) {
                            thread2.thread.args = (Object[])thread2.threadArgs;
                            thread2.thread.doWork(this.currentTime);
                        } else {
                            ++this.threadPending;
                            thread2.thread.runMonitor(2, this.currentTime, (Object[])thread2.threadArgs);
                        }
                        if ((thread2.threadOpts & 0x10) != 0) {
                            view = (View)((Object[])thread2.threadArgs)[3];
                            this.timestampUpdateList.add(view);
                        }
                        if ((thread2.threadOpts & 0x20) != 0) {
                            for (i2 = 0; i2 < this.views.arraySize(); ++i2) {
                                currentV = allView[i2];
                                currentV.renderBin.releaseGeometry();
                            }
                        }
                        if (this.cpuLimit != 1 && (thread2.threadOpts & 1) != 0) {
                            this.renderWaiting = true;
                        }
                        if (this.cpuLimit == 1 || this.cpuLimit > this.threadPending) continue;
                        this.state = 4;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e2) {
                            System.err.println(e2);
                        }
                        this.state = 1;
                    }
                    while (!this.stateWaiting && currentStateThread != stateThreadSize) {
                        thread2 = stateThreads[currentStateThread++];
                        if (!thread2.needsRun) continue;
                        ++this.statePending;
                        if (this.cpuLimit == 1) {
                            thread2.thread.args = (Object[])thread2.threadArgs;
                            thread2.thread.doWork(this.currentTime);
                        } else {
                            ++this.threadPending;
                            thread2.thread.runMonitor(2, this.currentTime, (Object[])thread2.threadArgs);
                        }
                        if (this.cpuLimit != 1 && (thread2.threadOpts & 1) != 0) {
                            this.stateWaiting = true;
                        }
                        if (this.cpuLimit == 1 || this.cpuLimit > this.threadPending) continue;
                        if (currentRenderThread != renderThreadSize) break;
                        this.state = 4;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e3) {
                            System.err.println(e3);
                        }
                        this.state = 1;
                    }
                    if (!this.renderWaiting && currentRenderThread == renderThreadSize) {
                        currentRequestRenderThread = 0;
                        while (!this.renderWaiting && currentRequestRenderThread != requestRenderThreadSize) {
                            thread2 = requestRenderThreads[currentRequestRenderThread++];
                            ++this.renderPending;
                            if (this.cpuLimit == 1) {
                                thread2.thread.args = (Object[])thread2.threadArgs;
                                thread2.thread.doWork(this.currentTime);
                            } else {
                                ++this.threadPending;
                                thread2.thread.runMonitor(2, this.currentTime, (Object[])thread2.threadArgs);
                            }
                            if (this.cpuLimit != 1 && (thread2.threadOpts & 1) != 0) {
                                this.renderWaiting = true;
                            }
                            if (this.cpuLimit == 1 || this.cpuLimit > this.threadPending) continue;
                            this.state = 4;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e4) {
                                System.err.println(e4);
                            }
                            this.state = 1;
                        }
                    }
                    if (this.cpuLimit != 1 && (this.renderWaiting && currentStateThread == stateThreadSize || this.stateWaiting && currentRenderThread == renderThreadSize || this.renderWaiting && this.stateWaiting)) {
                        if (!this.requestRenderWorkToDo) {
                            this.state = 3;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e5) {
                                System.err.println(e5);
                            }
                            this.state = 1;
                        }
                        this.requestRenderWorkToDo = false;
                    }
                    if (currentStateThread != stateThreadSize || currentRenderThread != renderThreadSize || currentRequestRenderThread != requestRenderThreadSize || this.threadPending != 0) continue;
                    for (int k2 = this.timestampUpdateList.size() - 1; k2 >= 0; --k2) {
                        View v = this.timestampUpdateList.get(k2);
                        v.setFrameTimingValues();
                        v.universe.behaviorStructure.incElapsedFrames();
                    }
                    this.timestampUpdateList.clear();
                    this.updateMirrorObjects();
                    done = true;
                    if (!MasterControl.isStatsLoggable(Level.INFO)) continue;
                    this.logTimes();
                }
                break;
            }
            case 3: {
                if (this.state != 5) {
                    --this.threadPending;
                    assert (this.threadPending >= 0) : "threadPending = " + this.threadPending;
                    if (nthread.type == 16) {
                        View v = (View)nthread.args[3];
                        if (v != null) {
                            v.stopTime = J3dClock.currentTimeMillis();
                        }
                        if (--this.renderPending == 0) {
                            this.renderWaiting = false;
                        }
                        assert (this.renderPending >= 0) : "renderPending = " + this.renderPending;
                    } else {
                        if (--this.statePending == 0) {
                            this.stateWaiting = false;
                        }
                        assert (this.statePending >= 0) : "statePending = " + this.statePending;
                    }
                    if (this.state != 4 && this.state != 3) break;
                    this.notify();
                    break;
                }
                this.notify();
                this.state = 1;
                break;
            }
            case 0: {
                if (!this.workToDo) {
                    this.state = 0;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e6) {
                        System.err.println(e6);
                    }
                    this.state = 1;
                }
                this.workToDo = false;
                break;
            }
            case 1: {
                this.workToDo = true;
                if (this.state != 0) break;
                this.notify();
                break;
            }
            case 5: {
                this.requestRenderWorkToDo = true;
                this.workToDo = true;
                if (this.state != 4 && this.state != 3 && this.state != 0) break;
                this.notify();
                break;
            }
            case 6: {
                nthread.runMonitor(2, this.currentTime, this.rendererCleanupArgs);
                this.state = 5;
                while (this.state != 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e7) {
                        System.err.println(e7);
                    }
                }
                break;
            }
            default: {
                assert (false) : "missing case in switch statement";
                break;
            }
        }
    }

    private String dumpThreads(int threads) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("threads:");
        if ((threads & 1) != 0) {
            strBuf.append(" BEHAVIOR_SCHEDULER");
        }
        if ((threads & 2) != 0) {
            strBuf.append(" SOUND_SCHEDULER");
        }
        if ((threads & 4) != 0) {
            strBuf.append(" INPUT_DEVICE_SCHEDULER");
        }
        if ((threads & 0x10) != 0) {
            strBuf.append(" RENDER_THREAD");
        }
        if ((threads & 0x40) != 0) {
            strBuf.append(" UPDATE_GEOMETRY");
        }
        if ((threads & 0x80) != 0) {
            strBuf.append(" UPDATE_RENDER");
        }
        if ((threads & 0x100) != 0) {
            strBuf.append(" UPDATE_BEHAVIOR");
        }
        if ((threads & 0x200) != 0) {
            strBuf.append(" UPDATE_SOUND");
        }
        if ((threads & 0x400) != 0) {
            strBuf.append(" UPDATE_RENDERING_ATTRIBUTES");
        }
        if ((threads & 0x1000) != 0) {
            strBuf.append(" UPDATE_RENDERING_ENVIRONMENT");
        }
        if ((threads & 0x2000) != 0) {
            strBuf.append(" UPDATE_TRANSFORM");
        }
        return strBuf.toString();
    }

    private void dumpMessage(String str, J3dMessage m2) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(str).append(" ");
        if (m2.type >= 0 && m2.type < mtype.length) {
            strBuf.append(mtype[m2.type]);
        } else {
            strBuf.append("<UNKNOWN>");
        }
        strBuf.append("  ").append(this.dumpThreads(m2.threads));
        MasterControl.getCoreLogger().finest(strBuf.toString());
    }

    private void manageMemory() {
        if (++this.frameCount > this.frameCountCutoff) {
            FreeListManager.manageLists();
            this.frameCount = 0;
        }
    }

    static final void threadYield() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int getNumberOfProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    synchronized void recordTime(TimeType type, long deltaTime) {
        int idx;
        int n2 = idx = type.ordinal();
        this.statTimes[n2] = this.statTimes[n2] + deltaTime;
        int n3 = idx;
        this.statCounts[n3] = this.statCounts[n3] + 1;
        this.statSeen[idx] = true;
    }

    private synchronized void logTimes() {
        ++this.frameCycleNumber;
        if (++this.frameCycleTick >= 10) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("----------------------------------------------\n").append("    Frame Number = ").append(this.frameCycleNumber).append("\n");
            for (int i2 = 0; i2 < this.statTimes.length; ++i2) {
                if (!this.statSeen[i2]) continue;
                strBuf.append("    ");
                if (this.statCounts[i2] > 0) {
                    strBuf.append((Object)TimeType.values()[i2]).append(" [").append(this.statCounts[i2]).append("] = ").append((double)this.statTimes[i2] / 1000000.0 / (double)this.statCounts[i2]).append(" msec per call\n");
                    this.statTimes[i2] = 0L;
                    this.statCounts[i2] = 0;
                    continue;
                }
                assert (this.statTimes[i2] == 0L);
                strBuf.append((Object)TimeType.values()[i2]).append(" [0] = 0.0 msec\n");
            }
            MasterControl.getStatsLogger().info(strBuf.toString());
            this.frameCycleTick = 0;
        }
    }

    static {
        statsLoggerEnabled = false;
        coreLoggerEnabled = false;
        librariesLoaded = false;
        systemStartTime = 0L;
        REMOVEALLCTXS_CLEANUP = new Integer(1);
        REMOVECTX_CLEANUP = new Integer(2);
        REMOVENOTIFY_CLEANUP = new Integer(3);
        RESETCANVAS_CLEANUP = new Integer(4);
        FREECONTEXT_CLEANUP = new Integer(5);
        mcThreadLock = new Object();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ThreadGroup parent;
                Thread thread2 = Thread.currentThread();
                threadPriority = thread2.getPriority();
                rootThreadGroup = thread2.getThreadGroup();
                while ((parent = rootThreadGroup.getParent()) != null) {
                    rootThreadGroup = parent;
                }
                rootThreadGroup = new ThreadGroup(rootThreadGroup, "Java3D");
                return null;
            }
        });
        try {
            MasterControl.initLoggers();
        }
        catch (RuntimeException ex) {
            System.err.println(ex);
        }
        mtype = new String[]{"INSERT_NODES", "REMOVE_NODES", "RUN", "TRANSFORM_CHANGED", "UPDATE_VIEW", "STOP_THREAD", "COLORINGATTRIBUTES_CHANGED", "LINEATTRIBUTES_CHANGED", "POINTATTRIBUTES_CHANGED", "POLYGONATTRIBUTES_CHANGED", "RENDERINGATTRIBUTES_CHANGED", "TEXTUREATTRIBUTES_CHANGED", "TRANSPARENCYATTRIBUTES_CHANGED", "MATERIAL_CHANGED", "TEXCOORDGENERATION_CHANGED", "TEXTURE_CHANGED", "MORPH_CHANGED", "GEOMETRY_CHANGED", "APPEARANCE_CHANGED", "LIGHT_CHANGED", "BACKGROUND_CHANGED", "CLIP_CHANGED", "FOG_CHANGED", "BOUNDINGLEAF_CHANGED", "SHAPE3D_CHANGED", "TEXT3D_TRANSFORM_CHANGED", "TEXT3D_DATA_CHANGED", "SWITCH_CHANGED", "COND_MET", "BEHAVIOR_ENABLE", "BEHAVIOR_DISABLE", "INSERT_RENDERATOMS", "ORDERED_GROUP_INSERTED", "ORDERED_GROUP_REMOVED", "COLLISION_BOUND_CHANGED", "REGION_BOUND_CHANGED", "MODELCLIP_CHANGED", "BOUNDS_AUTO_COMPUTE_CHANGED", "SOUND_ATTRIB_CHANGED", "AURALATTRIBUTES_CHANGED", "SOUNDSCAPE_CHANGED", "ALTERNATEAPPEARANCE_CHANGED", "RENDER_OFFSCREEN", "RENDER_RETAINED", "RENDER_IMMEDIATE", "SOUND_STATE_CHANGED", "ORIENTEDSHAPE3D_CHANGED", "TEXTURE_UNIT_STATE_CHANGED", "UPDATE_VIEWPLATFORM", "BEHAVIOR_ACTIVATE", "GEOMETRYARRAY_CHANGED", "MEDIA_CONTAINER_CHANGED", "RESIZE_CANVAS", "TOGGLE_CANVAS", "IMAGE_COMPONENT_CHANGED", "SCHEDULING_INTERVAL_CHANGED", "VIEWSPECIFICGROUP_CHANGED", "VIEWSPECIFICGROUP_INIT", "VIEWSPECIFICGROUP_CLEAR", "ORDERED_GROUP_TABLE_CHANGED", "BEHAVIOR_REEVALUATE", "CREATE_OFFSCREENBUFFER", "DESTROY_CTX_AND_OFFSCREENBUFFER", "SHADER_ATTRIBUTE_CHANGED", "SHADER_ATTRIBUTE_SET_CHANGED", "SHADER_APPEARANCE_CHANGED", "ALLOCATE_CANVASID", "FREE_CANVASID"};
    }

    static enum TimeType {
        TOTAL_FRAME,
        RENDER,
        BEHAVIOR;

    }
}

