/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.FogRetained;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Color3f;

class LinearFogRetained
extends FogRetained {
    private double frontDistance = 0.1;
    private double backDistance = 1.0;
    private double frontDistanceInEc;
    private double backDistanceInEc;
    static final int FRONT_DISTANCE_CHANGED = 64;
    static final int BACK_DISTANCE_CHANGED = 128;

    LinearFogRetained() {
        this.nodeType = 3;
    }

    void initFrontDistance(double frontDistance) {
        this.frontDistance = frontDistance;
    }

    void setFrontDistance(double frontDistance) {
        this.frontDistance = frontDistance;
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.type = 22;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(64);
        createMessage.args[2] = new Double(frontDistance);
        VirtualUniverse.mc.processMessage(createMessage);
    }

    double getFrontDistance() {
        return this.frontDistance;
    }

    void initBackDistance(double backDistance) {
        this.backDistance = backDistance;
    }

    void setBackDistance(double backDistance) {
        this.backDistance = backDistance;
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.type = 22;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(128);
        createMessage.args[2] = new Double(backDistance);
        VirtualUniverse.mc.processMessage(createMessage);
    }

    double getBackDistance() {
        return this.backDistance;
    }

    @Override
    void update(Context ctx, double scale) {
        this.validateDistancesInEc(scale);
        Pipeline.getPipeline().updateLinearFog(ctx, this.color.x, this.color.y, this.color.z, this.frontDistanceInEc, this.backDistanceInEc);
    }

    @Override
    void setLive(SetLiveState s) {
        super.setLive(s);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4096;
        createMessage.universe = this.universe;
        createMessage.type = 22;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(16);
        ArrayList addScopeList = new ArrayList();
        for (int i2 = 0; i2 < this.scopes.size(); ++i2) {
            GroupRetained group = (GroupRetained)this.scopes.get(i2);
            this.tempKey.reset();
            group.addAllNodesForScopedFog(this.mirrorFog, addScopeList, this.tempKey);
        }
        Object[] scopeInfo = new Object[]{this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE, addScopeList};
        createMessage.args[2] = scopeInfo;
        Color3f clr = new Color3f(this.color);
        createMessage.args[3] = clr;
        Object[] obj = new Object[]{this.boundingLeaf, this.regionOfInfluence != null ? this.regionOfInfluence.clone() : null, this.inBackgroundGroup ? Boolean.TRUE : Boolean.FALSE, this.geometryBackground, new Double(this.frontDistance), new Double(this.backDistance)};
        createMessage.args[4] = obj;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    synchronized void updateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        if ((component & 0x40) != 0) {
            ((LinearFogRetained)this.mirrorFog).frontDistance = (Double)objs[2];
        }
        if ((component & 0x80) != 0) {
            ((LinearFogRetained)this.mirrorFog).backDistance = (Double)objs[2];
        }
        if ((component & 0x10) != 0) {
            ((LinearFogRetained)this.mirrorFog).frontDistance = (Double)((Object[])objs[4])[4];
            ((LinearFogRetained)this.mirrorFog).backDistance = (Double)((Object[])objs[4])[5];
        }
        ((LinearFogRetained)this.mirrorFog).setLocalToVworldScale(this.getLastLocalToVworld().getDistanceScale());
        super.updateMirrorObject(objs);
    }

    @Override
    protected void validateDistancesInEc(double vworldToCoexistenceScale) {
        double localToEcScale = this.getLocalToVworldScale() * vworldToCoexistenceScale;
        this.frontDistanceInEc = this.frontDistance * localToEcScale;
        this.backDistanceInEc = this.backDistance * localToEcScale;
    }
}

