/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.AmbientLightRetained;
import org.jogamp.java3d.BackgroundRetained;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.EnvironmentSet;
import org.jogamp.java3d.LightRetained;
import org.jogamp.java3d.ObjectUpdate;
import org.jogamp.java3d.OrderedCollection;
import org.jogamp.java3d.PointLightRetained;
import org.jogamp.java3d.RenderBin;
import org.jogamp.java3d.VirtualUniverse;

class LightBin
implements ObjectUpdate {
    int maxLights = -1;
    LightRetained[] lights = null;
    int[] lightsRef = null;
    int numEmptySlots = -1;
    RenderBin renderBin = null;
    LightBin next = null;
    LightBin prev = null;
    EnvironmentSet environmentSetList = null;
    ArrayList<EnvironmentSet> insertEnvSet = new ArrayList();
    int canvasDirty = 0;
    int lightDirtyMaskCache = 0;
    int lightDirtyMask = 0;
    ArrayList<PointLightRetained> pointLts = new ArrayList();
    int[] pointLtsSlotIndex;
    OrderedCollection orderedCollection = null;
    boolean onUpdateList = false;
    BackgroundRetained geometryBackground = null;

    LightBin(int maxLights, RenderBin rb, boolean isOpaque) {
        this.maxLights = maxLights;
        this.numEmptySlots = maxLights;
        this.lights = new LightRetained[maxLights];
        this.lightsRef = new int[maxLights];
        this.renderBin = rb;
    }

    void reset(boolean inOpaque) {
        this.prev = null;
        this.next = null;
        this.orderedCollection = null;
        this.environmentSetList = null;
        this.onUpdateList = false;
        this.geometryBackground = null;
    }

    void setOrderedInfo(OrderedCollection oc) {
        this.orderedCollection = oc;
    }

    boolean willEnvironmentSetFit(EnvironmentSet e2) {
        int numEsLights;
        int slotsNeeded = numEsLights = e2.lights.size();
        block0: for (int i2 = 0; i2 < numEsLights; ++i2) {
            LightRetained light = e2.lights.get(i2);
            if (light instanceof AmbientLightRetained) continue;
            for (int j2 = 0; j2 < this.maxLights; ++j2) {
                if (this.lights[j2] != light) continue;
                --slotsNeeded;
                continue block0;
            }
        }
        return slotsNeeded <= this.numEmptySlots;
    }

    void addEnvironmentSet(EnvironmentSet e2, RenderBin rb) {
        int numEsLights = e2.lights.size();
        block0: for (int i2 = 0; i2 < numEsLights; ++i2) {
            int j2;
            LightRetained light = e2.lights.get(i2);
            if (light instanceof AmbientLightRetained) continue;
            for (j2 = 0; j2 < this.maxLights; ++j2) {
                if (this.lights[j2] != light) continue;
                if (light.lightOn) {
                    e2.enableMask |= (long)(1 << j2);
                }
                int n2 = j2;
                this.lightsRef[n2] = this.lightsRef[n2] + 1;
                e2.ltPos[i2] = j2;
                break;
            }
            if (j2 != this.maxLights) continue;
            for (j2 = 0; j2 < this.maxLights; ++j2) {
                if (this.lights[j2] != null) continue;
                this.lights[j2] = light;
                this.lightsRef[j2] = 1;
                if (light instanceof PointLightRetained) {
                    this.pointLts.add((PointLightRetained)light);
                    int pointLtsSlotIndexLen = 0;
                    if (this.pointLtsSlotIndex != null) {
                        pointLtsSlotIndexLen = this.pointLtsSlotIndex.length;
                    }
                    if (pointLtsSlotIndexLen < this.pointLts.size()) {
                        int[] newIndexList = new int[pointLtsSlotIndexLen + 8];
                        for (int x = 0; x < pointLtsSlotIndexLen; ++x) {
                            newIndexList[x] = this.pointLtsSlotIndex[x];
                        }
                        this.pointLtsSlotIndex = newIndexList;
                    }
                    this.pointLtsSlotIndex[this.pointLts.size() - 1] = j2;
                }
                if (light.lightOn) {
                    e2.enableMask |= (long)(1 << j2);
                }
                e2.ltPos[i2] = j2;
                --this.numEmptySlots;
                continue block0;
            }
        }
        e2.lightBin = this;
        e2.enableMaskCache = e2.enableMask;
        this.insertEnvSet.add(e2);
        if (!this.onUpdateList) {
            rb.objUpdateList.add(this);
            this.onUpdateList = true;
        }
    }

    @Override
    public void updateObject() {
        int i2;
        if (this.insertEnvSet.size() > 0) {
            EnvironmentSet e2 = this.insertEnvSet.get(0);
            if (this.environmentSetList == null) {
                this.environmentSetList = e2;
            } else {
                e2.next = this.environmentSetList;
                this.environmentSetList.prev = e2;
                this.environmentSetList = e2;
            }
            for (i2 = 1; i2 < this.insertEnvSet.size(); ++i2) {
                e2 = this.insertEnvSet.get(i2);
                e2.next = this.environmentSetList;
                this.environmentSetList.prev = e2;
                this.environmentSetList = e2;
            }
        }
        this.insertEnvSet.clear();
        if (this.canvasDirty != 0) {
            Canvas3D[] canvases = this.renderBin.view.getCanvases();
            for (i2 = 0; i2 < canvases.length; ++i2) {
                canvases[i2].canvasDirty |= this.canvasDirty;
            }
            this.lightDirtyMask = this.lightDirtyMaskCache;
            this.canvasDirty = 0;
            this.lightDirtyMaskCache = 0;
        }
        this.onUpdateList = false;
    }

    void removeEnvironmentSet(EnvironmentSet e2) {
        e2.lightBin = null;
        if (this.insertEnvSet.contains(e2)) {
            this.insertEnvSet.remove(this.insertEnvSet.indexOf(e2));
        } else {
            int i2;
            int numEsLights = e2.lights.size();
            block0: for (i2 = 0; i2 < numEsLights; ++i2) {
                LightRetained light = e2.lights.get(i2);
                for (int j2 = 0; j2 < this.maxLights; ++j2) {
                    if (this.lights[j2] != light) continue;
                    int n2 = j2;
                    this.lightsRef[n2] = this.lightsRef[n2] - 1;
                    if (this.lightsRef[j2] != 0) continue block0;
                    if (light instanceof PointLightRetained) {
                        this.pointLts.remove(this.pointLts.indexOf(light));
                    }
                    this.lights[j2] = null;
                    this.lightDirtyMaskCache &= ~(1 << j2);
                    this.lightDirtyMask &= ~(1 << j2);
                    ++this.numEmptySlots;
                    continue block0;
                }
            }
            if (e2.prev == null) {
                this.environmentSetList = e2.next;
                if (e2.next != null) {
                    e2.next.prev = null;
                }
            } else {
                e2.prev.next = e2.next;
                if (e2.next != null) {
                    e2.next.prev = e2.prev;
                }
            }
            Canvas3D[] canvases = this.renderBin.view.getCanvases();
            for (i2 = 0; i2 < canvases.length; ++i2) {
                canvases[i2].environmentSet = null;
            }
        }
        e2.prev = null;
        e2.next = null;
        if (this.environmentSetList == null && this.insertEnvSet.size() == 0) {
            this.renderBin.removeLightBin(this);
            this.geometryBackground = null;
        }
    }

    void render(Canvas3D cv) {
        cv.setStateToUpdate(0, this);
        EnvironmentSet e2 = this.environmentSetList;
        while (e2 != null) {
            e2.render(cv);
            e2 = e2.next;
        }
    }

    void updateAttributes(Canvas3D cv) {
        int frameCount = VirtualUniverse.mc.frameCount;
        if (cv.lightBin != this) {
            double scale;
            if (this.geometryBackground == null) {
                scale = cv.canvasViewCache.getVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                scale = cv.canvasViewCache.getInfVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            for (int i2 = 0; i2 < this.maxLights; ++i2) {
                if (this.lights[i2] == null || cv.lights[i2] == this.lights[i2] && cv.frameCount[i2] == frameCount) continue;
                cv.lights[i2] = this.lights[i2];
                cv.frameCount[i2] = frameCount;
                this.lights[i2].update(cv.ctx, i2, scale);
            }
            cv.lightBin = this;
            cv.canvasDirty &= 0xFFFFFFBF;
            cv.enableMask = -1L;
        } else if ((cv.canvasDirty & 0x40) != 0) {
            double scale;
            if (this.geometryBackground == null) {
                scale = cv.canvasViewCache.getVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                scale = cv.canvasViewCache.getInfVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            int i3 = 0;
            int mask = this.lightDirtyMask;
            while (mask != 0) {
                if ((mask & 1) != 0) {
                    this.lights[i3].update(cv.ctx, i3, scale);
                    cv.lights[i3] = this.lights[i3];
                    cv.frameCount[i3] = frameCount;
                }
                mask >>= 1;
                ++i3;
            }
            cv.canvasDirty &= 0xFFFFFFBF;
        } else if (this.pointLts.size() > 0 && (cv.canvasDirty & 0x8000) != 0) {
            double scale;
            if (this.geometryBackground == null) {
                scale = cv.canvasViewCache.getVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                scale = cv.canvasViewCache.getInfVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            for (int i4 = 0; i4 < this.pointLts.size(); ++i4) {
                PointLightRetained lt = this.pointLts.get(i4);
                lt.update(cv.ctx, this.pointLtsSlotIndex[i4], scale);
                cv.lights[this.pointLtsSlotIndex[i4]] = lt;
                cv.frameCount[this.pointLtsSlotIndex[i4]] = frameCount;
            }
        }
    }
}

