/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.J3dThreadData;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.View;
import org.jogamp.java3d.VirtualUniverse;

abstract class J3dThread
extends Thread {
    static final int BEHAVIOR_SCHEDULER = 1;
    static final int SOUND_SCHEDULER = 2;
    static final int INPUT_DEVICE_SCHEDULER = 4;
    static final int RENDER_THREAD = 16;
    static final int UPDATE_GEOMETRY = 64;
    static final int UPDATE_RENDER = 128;
    static final int UPDATE_BEHAVIOR = 256;
    static final int UPDATE_SOUND = 512;
    static final int UPDATE_RENDERING_ATTRIBUTES = 1024;
    static final int UPDATE_RENDERING_ENVIRONMENT = 4096;
    static final int UPDATE_TRANSFORM = 8192;
    static final int WORK_THREAD = 1;
    static final int UPDATE_THREAD = 2;
    static final int WAIT = 0;
    static final int NOTIFY_AND_WAIT = 1;
    static final int NOTIFY = 2;
    static final int RUN = 2;
    static final int STOP = 3;
    boolean active = false;
    private volatile boolean running = true;
    private volatile boolean ready = false;
    private J3dThreadData[] data = null;
    private volatile boolean started = false;
    long referenceTime;
    long lastWaitTimestamp = 0L;
    int type;
    int classification = 1;
    Object[] args = null;
    volatile boolean userStop = false;
    private volatile boolean waiting = false;
    private static int numInstances = 0;
    private int instanceNum = -1;

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    abstract void doWork(long var1);

    J3dThread(ThreadGroup t) {
        super(t, "");
    }

    synchronized J3dThreadData getThreadData(View v, Canvas3D c2) {
        J3dThreadData threadData;
        if (this.type != 16) {
            if (this.data == null) {
                this.data = new J3dThreadData[1];
                this.data[0] = new J3dThreadData();
                this.data[0].thread = this;
                this.data[0].threadType = this.type;
                this.data[0].view = null;
                this.data[0].canvas = null;
            }
            threadData = this.data[0];
        } else if (this.data == null) {
            this.data = new J3dThreadData[1];
            this.data[0] = new J3dThreadData();
            this.data[0].thread = this;
            this.data[0].threadType = this.type;
            this.data[0].view = v;
            this.data[0].canvas = c2;
            this.data[0].threadArgs = new Object[4];
            threadData = this.data[0];
        } else {
            int i2;
            for (i2 = 0; i2 < this.data.length && (this.data[i2].view != v || this.data[i2].canvas != c2); ++i2) {
            }
            if (i2 == this.data.length) {
                int j2;
                J3dThreadData[] newData = new J3dThreadData[this.data.length + 1];
                for (j2 = 0; j2 < this.data.length; ++j2) {
                    newData[j2] = this.data[j2];
                }
                this.data = newData;
                this.data[j2] = new J3dThreadData();
                this.data[j2].thread = this;
                this.data[j2].threadType = this.type;
                this.data[j2].view = v;
                this.data[j2].canvas = c2;
                this.data[j2].threadArgs = new Object[4];
                threadData = this.data[j2];
            } else {
                threadData = this.data[i2];
                Object[] args = (Object[])threadData.threadArgs;
                args[0] = null;
                args[1] = null;
                args[2] = null;
                args[3] = null;
            }
        }
        return threadData;
    }

    void initialize() {
        this.start();
        while (!this.started) {
            MasterControl.threadYield();
        }
    }

    void finish() {
        while (!this.waiting) {
            MasterControl.threadYield();
        }
        this.runMonitor(3, 0L, null);
    }

    @Override
    public void run() {
        this.runMonitor(0, 0L, null);
        while (this.running) {
            this.doWork(this.referenceTime);
            this.runMonitor(1, 0L, null);
        }
        this.shutdown();
    }

    synchronized void runMonitor(int action, long referenceTime, Object[] args) {
        switch (action) {
            case 0: {
                this.started = true;
                while (!this.ready && this.running) {
                    this.waiting = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        System.err.println(e2);
                    }
                    this.waiting = false;
                }
                this.ready = false;
                break;
            }
            case 1: {
                VirtualUniverse.mc.runMonitor(3, null, null, null, this);
                while (!this.ready && this.running) {
                    this.waiting = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e3) {
                        System.err.println(e3);
                    }
                    this.waiting = false;
                }
                this.ready = false;
                break;
            }
            case 2: {
                this.referenceTime = referenceTime;
                this.args = args;
                this.ready = true;
                if (!this.waiting) break;
                this.notify();
                break;
            }
            case 3: {
                this.running = false;
                if (!this.waiting) break;
                this.notify();
            }
        }
    }

    void cleanupView() {
        this.data = null;
    }

    void shutdown() {
    }

    void cleanup() {
        this.active = false;
        this.running = true;
        this.ready = false;
        this.data = null;
        this.started = true;
        this.lastWaitTimestamp = 0L;
        this.classification = 1;
        this.args = null;
        this.userStop = false;
        this.referenceTime = 0L;
    }
}

