/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingPolytope;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.IndexedGeometryStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickCone;
import org.jogamp.java3d.PickCylinder;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

class IndexedLineStripArrayRetained
extends IndexedGeometryStripArrayRetained {
    IndexedLineStripArrayRetained() {
        this.geoType = 14;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Point3d[] pnts = new Point3d[2];
        double[] sdist = new double[1];
        double minDist = Double.MAX_VALUE;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i2 = 0;
        int count = 0;
        int[] vtxIndexArr = new int[2];
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (i2 < this.stripIndexCounts.length) {
                    vtxIndexArr[0] = this.indexCoord[count];
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 1; j2 < scount; ++j2) {
                        vtxIndexArr[1] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[1]);
                        if (this.intersectLineAndRay(pnts[0], pnts[1], pickRay.origin, pickRay.direction, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                Vector3d dir2 = new Vector3d(pickSegment.end.x - pickSegment.start.x, pickSegment.end.y - pickSegment.start.y, pickSegment.end.z - pickSegment.start.z);
                while (i2 < this.stripIndexCounts.length) {
                    vtxIndexArr[0] = this.indexCoord[count];
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 1; j2 < scount; ++j2) {
                        vtxIndexArr[1] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[1]);
                        if (this.intersectLineAndRay(pnts[0], pnts[1], pickSegment.start, dir2, sdist, iPnt) && sdist[0] <= 1.0) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 6: {
                BoundingBox bbox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (i2 < this.stripIndexCounts.length) {
                    vtxIndexArr[0] = this.indexCoord[count];
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 1; j2 < scount; ++j2) {
                        vtxIndexArr[1] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[1]);
                        if (this.intersectBoundingBox(pnts, bbox, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (i2 < this.stripIndexCounts.length) {
                    vtxIndexArr[0] = this.indexCoord[count];
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 1; j2 < scount; ++j2) {
                        vtxIndexArr[1] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[1]);
                        if (this.intersectBoundingSphere(pnts, bsphere, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (i2 < this.stripIndexCounts.length) {
                    vtxIndexArr[0] = this.indexCoord[count];
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 1; j2 < scount; ++j2) {
                        vtxIndexArr[1] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[1]);
                        if (this.intersectBoundingPolytope(pnts, bpolytope, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (i2 < this.stripIndexCounts.length) {
                    vtxIndexArr[0] = this.indexCoord[count];
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 1; j2 < scount; ++j2) {
                        vtxIndexArr[1] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[1]);
                        if (this.intersectCylinder(pnts, pickCylinder, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (i2 < this.stripIndexCounts.length) {
                    vtxIndexArr[0] = this.indexCoord[count];
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 1; j2 < scount; ++j2) {
                        vtxIndexArr[1] = this.indexCoord[count];
                        this.getVertexData(this.indexCoord[count++], pnts[1]);
                        if (this.intersectCone(pnts, pickCone, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[0].set(pnts[1]);
                        vtxIndexArr[0] = vtxIndexArr[1];
                    }
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (minDist < Double.MAX_VALUE) {
            iPnt.x = x;
            iPnt.y = y;
            iPnt.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        int i2 = 0;
        int count = 0;
        Point3d[] points = new Point3d[2];
        double[] dist = new double[1];
        points[0] = new Point3d();
        points[1] = new Point3d();
        switch (pnts.length) {
            case 3: 
            case 4: {
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], points[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 1; j2 < scount; ++j2) {
                        this.getVertexData(this.indexCoord[count++], points[1]);
                        if (this.intersectSegment(pnts, points[0], points[1], dist, null)) {
                            return true;
                        }
                        points[0].set(points[1]);
                    }
                }
                break;
            }
            case 2: {
                Vector3d dir2 = new Vector3d();
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], points[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j3 = 1; j3 < scount; ++j3) {
                        this.getVertexData(this.indexCoord[count++], points[1]);
                        dir2.x = points[1].x - points[0].x;
                        dir2.y = points[1].y - points[0].y;
                        dir2.z = points[1].z - points[0].z;
                        if (this.intersectLineAndRay(pnts[0], pnts[1], points[0], dir2, dist, null) && dist[0] <= 1.0) {
                            return true;
                        }
                        points[0].set(points[1]);
                    }
                }
                break;
            }
            case 1: {
                Vector3d dir3 = new Vector3d();
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], points[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j4 = 1; j4 < scount; ++j4) {
                        this.getVertexData(this.indexCoord[count++], points[1]);
                        dir3.x = points[1].x - points[0].x;
                        dir3.y = points[1].y - points[0].y;
                        dir3.z = points[1].z - points[0].z;
                        if (this.intersectPntAndRay(pnts[0], points[0], dir3, dist) && dist[0] <= 1.0) {
                            return true;
                        }
                        points[0].set(points[1]);
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        int i2 = 0;
        int count = 0;
        Point3d[] pnts = new Point3d[]{new Point3d(), new Point3d()};
        while (i2 < this.stripIndexCounts.length) {
            this.getVertexData(this.indexCoord[count++], pnts[0]);
            thisToOtherVworld.transform(pnts[0]);
            int scount = this.stripIndexCounts[i2++];
            for (int j2 = 1; j2 < scount; ++j2) {
                this.getVertexData(this.indexCoord[count++], pnts[1]);
                thisToOtherVworld.transform(pnts[1]);
                if (geom.intersect(pnts)) {
                    return true;
                }
                pnts[0].set(pnts[1]);
            }
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        int i2 = 0;
        int count = 0;
        Point3d[] pnts = new Point3d[]{new Point3d(), new Point3d()};
        switch (targetBound.getPickType()) {
            case 6: {
                BoundingBox box = (BoundingBox)targetBound;
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j2 = 1; j2 < scount; ++j2) {
                        this.getVertexData(this.indexCoord[count++], pnts[1]);
                        if (this.intersectBoundingBox(pnts, box, null, null)) {
                            return true;
                        }
                        pnts[0].set(pnts[1]);
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)targetBound;
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j3 = 1; j3 < scount; ++j3) {
                        this.getVertexData(this.indexCoord[count++], pnts[1]);
                        if (this.intersectBoundingSphere(pnts, bsphere, null, null)) {
                            return true;
                        }
                        pnts[0].set(pnts[1]);
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)targetBound;
                while (i2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[count++], pnts[0]);
                    int scount = this.stripIndexCounts[i2++];
                    for (int j4 = 1; j4 < scount; ++j4) {
                        this.getVertexData(this.indexCoord[count++], pnts[1]);
                        if (this.intersectBoundingPolytope(pnts, bpolytope, null, null)) {
                            return true;
                        }
                        pnts[0].set(pnts[1]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + targetBound);
            }
        }
        return false;
    }

    @Override
    int getClassType() {
        return 2;
    }
}

