/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingPolytope;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.IndexedGeometryArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickCone;
import org.jogamp.java3d.PickCylinder;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

class IndexedLineArrayRetained
extends IndexedGeometryArrayRetained {
    IndexedLineArrayRetained() {
        this.geoType = 11;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Point3d[] pnts = new Point3d[2];
        double[] sdist = new double[1];
        double minDist = Double.MAX_VALUE;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i2 = this.initialIndexIndex;
        int loopStopIndex = this.initialIndexIndex + this.validIndexCount;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        int[] vtxIndexArr = new int[2];
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (i2 < loopStopIndex) {
                    for (int k2 = 0; k2 < 2; ++k2) {
                        vtxIndexArr[k2] = this.indexCoord[i2];
                        this.getVertexData(this.indexCoord[i2++], pnts[k2]);
                    }
                    if (!this.intersectLineAndRay(pnts[0], pnts[1], pickRay.origin, pickRay.direction, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                Vector3d dir2 = new Vector3d(pickSegment.end.x - pickSegment.start.x, pickSegment.end.y - pickSegment.start.y, pickSegment.end.z - pickSegment.start.z);
                while (i2 < loopStopIndex) {
                    for (int k3 = 0; k3 < 2; ++k3) {
                        vtxIndexArr[k3] = this.indexCoord[i2];
                        this.getVertexData(this.indexCoord[i2++], pnts[k3]);
                    }
                    if (!this.intersectLineAndRay(pnts[0], pnts[1], pickSegment.start, dir2, sdist, iPnt) || !(sdist[0] <= 1.0)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 6: {
                BoundingBox bbox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (i2 < loopStopIndex) {
                    for (int k4 = 0; k4 < 2; ++k4) {
                        vtxIndexArr[k4] = this.indexCoord[i2];
                        this.getVertexData(this.indexCoord[i2++], pnts[k4]);
                    }
                    if (!this.intersectBoundingBox(pnts, bbox, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (i2 < loopStopIndex) {
                    for (int k5 = 0; k5 < 2; ++k5) {
                        vtxIndexArr[k5] = this.indexCoord[i2];
                        this.getVertexData(this.indexCoord[i2++], pnts[k5]);
                    }
                    if (!this.intersectBoundingSphere(pnts, bsphere, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (i2 < loopStopIndex) {
                    for (int k6 = 0; k6 < 2; ++k6) {
                        vtxIndexArr[k6] = this.indexCoord[i2];
                        this.getVertexData(this.indexCoord[i2++], pnts[k6]);
                    }
                    if (!this.intersectBoundingPolytope(pnts, bpolytope, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (i2 < loopStopIndex) {
                    for (int k7 = 0; k7 < 2; ++k7) {
                        vtxIndexArr[k7] = this.indexCoord[i2];
                        this.getVertexData(this.indexCoord[i2++], pnts[k7]);
                    }
                    if (!this.intersectCylinder(pnts, pickCylinder, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (i2 < loopStopIndex) {
                    for (int k8 = 0; k8 < 2; ++k8) {
                        vtxIndexArr[k8] = this.indexCoord[i2];
                        this.getVertexData(this.indexCoord[i2++], pnts[k8]);
                    }
                    if (!this.intersectCone(pnts, pickCone, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (minDist < Double.MAX_VALUE) {
            iPnt.x = x;
            iPnt.y = y;
            iPnt.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Point3d[] points = new Point3d[2];
        double[] dist = new double[1];
        int i2 = this.initialIndexIndex;
        int loopStopIndex = this.initialIndexIndex + this.validIndexCount;
        points[0] = new Point3d();
        points[1] = new Point3d();
        switch (pnts.length) {
            case 3: 
            case 4: {
                while (i2 < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i2++], points[0]);
                    this.getVertexData(this.indexCoord[i2++], points[1]);
                    if (!this.intersectSegment(pnts, points[0], points[1], dist, null)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                Vector3d dir2 = new Vector3d();
                while (i2 < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i2++], points[0]);
                    this.getVertexData(this.indexCoord[i2++], points[1]);
                    dir2.x = points[1].x - points[0].x;
                    dir2.y = points[1].y - points[0].y;
                    dir2.z = points[1].z - points[0].z;
                    if (!this.intersectLineAndRay(pnts[0], pnts[1], points[0], dir2, dist, null) || !(dist[0] <= 1.0)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                Vector3d dir3 = new Vector3d();
                while (i2 < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i2++], points[0]);
                    this.getVertexData(this.indexCoord[i2++], points[1]);
                    dir3.x = points[1].x - points[0].x;
                    dir3.y = points[1].y - points[0].y;
                    dir3.z = points[1].z - points[0].z;
                    if (!this.intersectPntAndRay(pnts[0], points[0], dir3, dist) || !(dist[0] <= 1.0)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        Point3d[] pnts = new Point3d[2];
        int i2 = this.initialIndexIndex;
        int loopStopIndex = this.initialIndexIndex + this.validIndexCount;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        while (i2 < loopStopIndex) {
            this.getVertexData(this.indexCoord[i2++], pnts[0]);
            this.getVertexData(this.indexCoord[i2++], pnts[1]);
            thisToOtherVworld.transform(pnts[0]);
            thisToOtherVworld.transform(pnts[1]);
            if (!geom.intersect(pnts)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        Point3d[] pnts = new Point3d[2];
        int i2 = this.initialIndexIndex;
        int loopStopIndex = this.initialIndexIndex + this.validIndexCount;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        switch (targetBound.getPickType()) {
            case 6: {
                BoundingBox box = (BoundingBox)targetBound;
                while (i2 < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i2++], pnts[0]);
                    this.getVertexData(this.indexCoord[i2++], pnts[1]);
                    if (!this.intersectBoundingBox(pnts, box, null, null)) continue;
                    return true;
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)targetBound;
                while (i2 < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i2++], pnts[0]);
                    this.getVertexData(this.indexCoord[i2++], pnts[1]);
                    if (!this.intersectBoundingSphere(pnts, bsphere, null, null)) continue;
                    return true;
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)targetBound;
                while (i2 < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i2++], pnts[0]);
                    this.getVertexData(this.indexCoord[i2++], pnts[1]);
                    if (!this.intersectBoundingPolytope(pnts, bpolytope, null, null)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + targetBound);
            }
        }
        return false;
    }

    @Override
    int getClassType() {
        return 2;
    }
}

