/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryStripArrayRetained;
import org.jogamp.java3d.IndexedGeometryArrayRetained;
import org.jogamp.java3d.IndexedLineStripArrayRetained;
import org.jogamp.java3d.IndexedTriangleFanArrayRetained;
import org.jogamp.java3d.IndexedTriangleStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.LineStripArrayRetained;
import org.jogamp.java3d.TriangleFanArrayRetained;
import org.jogamp.java3d.TriangleStripArrayRetained;

abstract class IndexedGeometryStripArrayRetained
extends IndexedGeometryArrayRetained {
    int[] stripIndexCounts;
    int[] compileStripICOffset;
    int[] compileIndexLength;

    IndexedGeometryStripArrayRetained() {
    }

    void setStripIndexCounts(int[] stripIndexCounts) {
        boolean isLive;
        int i2;
        int num = stripIndexCounts.length;
        int total = 0;
        for (i2 = 0; i2 < num; ++i2) {
            total += stripIndexCounts[i2];
            if (this instanceof IndexedLineStripArrayRetained) {
                if (stripIndexCounts[i2] >= 2) continue;
                throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArrayRetained1"));
            }
            if (this instanceof IndexedTriangleStripArrayRetained) {
                if (stripIndexCounts[i2] >= 3) continue;
                throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArrayRetained1"));
            }
            if (!(this instanceof IndexedTriangleFanArrayRetained) || stripIndexCounts[i2] >= 3) continue;
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArrayRetained1"));
        }
        if (this.initialIndexIndex + total > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryStripArrayRetained0"));
        }
        int newCoordMax = 0;
        int newColorIndex = 0;
        int newNormalIndex = 0;
        int[] newTexCoordIndex = null;
        int[] newVertexAttrIndex = null;
        newCoordMax = this.computeMaxIndex(this.initialIndexIndex, total, this.indexCoord);
        this.doErrorCheck(newCoordMax);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                newColorIndex = this.computeMaxIndex(this.initialIndexIndex, total, this.indexColor);
                this.doColorCheck(newColorIndex);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                newTexCoordIndex = new int[this.texCoordSetCount];
                for (i2 = 0; i2 < this.texCoordSetCount; ++i2) {
                    newTexCoordIndex[i2] = this.computeMaxIndex(this.initialIndexIndex, total, this.indexTexCoord[i2]);
                    this.doTexCoordCheck(newTexCoordIndex[i2], i2);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                newVertexAttrIndex = new int[this.vertexAttrCount];
                for (i2 = 0; i2 < this.vertexAttrCount; ++i2) {
                    newVertexAttrIndex[i2] = this.computeMaxIndex(this.initialIndexIndex, total, this.indexVertexAttr[i2]);
                    this.doTexCoordCheck(newVertexAttrIndex[i2], i2);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                newNormalIndex = this.computeMaxIndex(this.initialIndexIndex, total, this.indexNormal);
                this.doNormalCheck(newNormalIndex);
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.validIndexCount = total;
        this.stripIndexCounts = new int[num];
        for (i2 = 0; i2 < num; ++i2) {
            this.stripIndexCounts[i2] = stripIndexCounts[i2];
        }
        this.maxCoordIndex = newCoordMax;
        if ((this.vertexFormat & 0x200) == 0) {
            this.maxColorIndex = newColorIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (i2 = 0; i2 < this.texCoordSetCount; ++i2) {
                    this.maxTexCoordIndices[i2] = newTexCoordIndex[i2];
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i2 = 0; i2 < this.vertexAttrCount; ++i2) {
                    this.maxVertexAttrIndices[i2] = newVertexAttrIndex[i2];
                }
            }
            this.maxNormalIndex = newNormalIndex;
        } else {
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (i2 = 0; i2 < this.texCoordSetCount; ++i2) {
                    this.maxTexCoordIndices[i2] = this.maxCoordIndex;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i2 = 0; i2 < this.vertexAttrCount; ++i2) {
                    this.maxVertexAttrIndices[i2] = this.maxCoordIndex;
                }
            }
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(true);
        }
    }

    @Override
    GeometryArrayRetained cloneNonIndexedGeometry() {
        GeometryStripArrayRetained obj = null;
        switch (this.geoType) {
            case 14: {
                obj = new LineStripArrayRetained();
                break;
            }
            case 13: {
                obj = new TriangleFanArrayRetained();
                break;
            }
            case 12: {
                obj = new TriangleStripArrayRetained();
            }
        }
        obj.createGeometryArrayData(this.validIndexCount, this.vertexFormat & 0xFFFFF67F, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes);
        obj.unIndexify(this);
        obj.setStripVertexCounts(this.stripIndexCounts);
        obj.cloneSourceArray = this;
        obj.source = this.source;
        return obj;
    }

    int getNumStrips() {
        return this.stripIndexCounts.length;
    }

    void getStripIndexCounts(int[] stripIndexCounts) {
        for (int i2 = stripIndexCounts.length - 1; i2 >= 0; --i2) {
            stripIndexCounts[i2] = this.stripIndexCounts[i2];
        }
    }

    @Override
    void mergeGeometryArrays(ArrayList list) {
        int i2;
        int numMerge = list.size();
        int numCount = 0;
        for (i2 = 0; i2 < numMerge; ++i2) {
            IndexedGeometryStripArrayRetained geo = (IndexedGeometryStripArrayRetained)list.get(i2);
            numCount += geo.stripIndexCounts.length;
        }
        this.stripIndexCounts = new int[numCount];
        this.compileIndexLength = new int[numCount];
        this.compileStripICOffset = new int[numMerge];
        int curICOffset = 0;
        for (i2 = 0; i2 < numMerge; ++i2) {
            IndexedGeometryStripArrayRetained geo = (IndexedGeometryStripArrayRetained)list.get(i2);
            this.compileStripICOffset[i2] = curICOffset;
            this.compileIndexLength[i2] = geo.stripIndexCounts.length;
            System.arraycopy(geo.stripIndexCounts, 0, this.stripIndexCounts, curICOffset, geo.stripIndexCounts.length);
            curICOffset += geo.stripIndexCounts.length;
        }
        super.mergeGeometryArrays(list);
    }

    int getNumStrips(int id) {
        return this.compileIndexLength[id];
    }

    void getStripIndexCounts(int id, int[] stripIndexCounts) {
        int count = this.compileIndexLength[id];
        int coffset = this.compileStripICOffset[id];
        for (int i2 = 0; i2 < count; ++i2) {
            stripIndexCounts[i2] = this.stripIndexCounts[coffset + 1];
        }
    }
}

