/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.vecmath.Vector3d;

public class HiResCoord {
    int[] x;
    int[] y;
    int[] z;
    private double[] scales = new double[]{7.922816251426434E28, 1.8446744073709552E19, 4.294967296E9, 1.0, 2.3283064365386963E-10, 5.421010862427522E-20, 1.262177448353619E-29, 2.938735877055719E-39};

    public HiResCoord(int[] X, int[] Y, int[] Z2) {
        this.x = new int[8];
        this.y = new int[8];
        this.z = new int[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            this.x[i2] = X[i2];
            this.y[i2] = Y[i2];
            this.z[i2] = Z2[i2];
        }
    }

    public HiResCoord(HiResCoord hc) {
        this.x = new int[8];
        this.y = new int[8];
        this.z = new int[8];
        this.x[0] = hc.x[0];
        this.y[0] = hc.y[0];
        this.z[0] = hc.z[0];
        this.x[1] = hc.x[1];
        this.y[1] = hc.y[1];
        this.z[1] = hc.z[1];
        this.x[2] = hc.x[2];
        this.y[2] = hc.y[2];
        this.z[2] = hc.z[2];
        this.x[3] = hc.x[3];
        this.y[3] = hc.y[3];
        this.z[3] = hc.z[3];
        this.x[4] = hc.x[4];
        this.y[4] = hc.y[4];
        this.z[4] = hc.z[4];
        this.x[5] = hc.x[5];
        this.y[5] = hc.y[5];
        this.z[5] = hc.z[5];
        this.x[6] = hc.x[6];
        this.y[6] = hc.y[6];
        this.z[6] = hc.z[6];
        this.x[7] = hc.x[7];
        this.y[7] = hc.y[7];
        this.z[7] = hc.z[7];
    }

    public HiResCoord() {
        this.x = new int[8];
        this.y = new int[8];
        this.z = new int[8];
    }

    public void setHiResCoord(int[] X, int[] Y, int[] Z2) {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.x[i2] = X[i2];
            this.y[i2] = Y[i2];
            this.z[i2] = Z2[i2];
        }
    }

    public void setHiResCoord(HiResCoord hires) {
        this.x[0] = hires.x[0];
        this.y[0] = hires.y[0];
        this.z[0] = hires.z[0];
        this.x[1] = hires.x[1];
        this.y[1] = hires.y[1];
        this.z[1] = hires.z[1];
        this.x[2] = hires.x[2];
        this.y[2] = hires.y[2];
        this.z[2] = hires.z[2];
        this.x[3] = hires.x[3];
        this.y[3] = hires.y[3];
        this.z[3] = hires.z[3];
        this.x[4] = hires.x[4];
        this.y[4] = hires.y[4];
        this.z[4] = hires.z[4];
        this.x[5] = hires.x[5];
        this.y[5] = hires.y[5];
        this.z[5] = hires.z[5];
        this.x[6] = hires.x[6];
        this.y[6] = hires.y[6];
        this.z[6] = hires.z[6];
        this.x[7] = hires.x[7];
        this.y[7] = hires.y[7];
        this.z[7] = hires.z[7];
    }

    public void setHiResCoordX(int[] X) {
        this.x[0] = X[0];
        this.x[1] = X[1];
        this.x[2] = X[2];
        this.x[3] = X[3];
        this.x[4] = X[4];
        this.x[5] = X[5];
        this.x[6] = X[6];
        this.x[7] = X[7];
    }

    public void setHiResCoordY(int[] Y) {
        this.y[0] = Y[0];
        this.y[1] = Y[1];
        this.y[2] = Y[2];
        this.y[3] = Y[3];
        this.y[4] = Y[4];
        this.y[5] = Y[5];
        this.y[6] = Y[6];
        this.y[7] = Y[7];
    }

    public void setHiResCoordZ(int[] Z2) {
        this.z[0] = Z2[0];
        this.z[1] = Z2[1];
        this.z[2] = Z2[2];
        this.z[3] = Z2[3];
        this.z[4] = Z2[4];
        this.z[5] = Z2[5];
        this.z[6] = Z2[6];
        this.z[7] = Z2[7];
    }

    public void getHiResCoord(int[] X, int[] Y, int[] Z2) {
        X[0] = this.x[0];
        X[1] = this.x[1];
        X[2] = this.x[2];
        X[3] = this.x[3];
        X[4] = this.x[4];
        X[5] = this.x[5];
        X[6] = this.x[6];
        X[7] = this.x[7];
        Y[0] = this.y[0];
        Y[1] = this.y[1];
        Y[2] = this.y[2];
        Y[3] = this.y[3];
        Y[4] = this.y[4];
        Y[5] = this.y[5];
        Y[6] = this.y[6];
        Y[7] = this.y[7];
        Z2[0] = this.z[0];
        Z2[1] = this.z[1];
        Z2[2] = this.z[2];
        Z2[3] = this.z[3];
        Z2[4] = this.z[4];
        Z2[5] = this.z[5];
        Z2[6] = this.z[6];
        Z2[7] = this.z[7];
    }

    public void getHiResCoord(HiResCoord hc) {
        hc.x[0] = this.x[0];
        hc.x[1] = this.x[1];
        hc.x[2] = this.x[2];
        hc.x[3] = this.x[3];
        hc.x[4] = this.x[4];
        hc.x[5] = this.x[5];
        hc.x[6] = this.x[6];
        hc.x[7] = this.x[7];
        hc.y[0] = this.y[0];
        hc.y[1] = this.y[1];
        hc.y[2] = this.y[2];
        hc.y[3] = this.y[3];
        hc.y[4] = this.y[4];
        hc.y[5] = this.y[5];
        hc.y[6] = this.y[6];
        hc.y[7] = this.y[7];
        hc.z[0] = this.z[0];
        hc.z[1] = this.z[1];
        hc.z[2] = this.z[2];
        hc.z[3] = this.z[3];
        hc.z[4] = this.z[4];
        hc.z[5] = this.z[5];
        hc.z[6] = this.z[6];
        hc.z[7] = this.z[7];
    }

    public void getHiResCoordX(int[] X) {
        X[0] = this.x[0];
        X[1] = this.x[1];
        X[2] = this.x[2];
        X[3] = this.x[3];
        X[4] = this.x[4];
        X[5] = this.x[5];
        X[6] = this.x[6];
        X[7] = this.x[7];
    }

    public void getHiResCoordY(int[] Y) {
        Y[0] = this.y[0];
        Y[1] = this.y[1];
        Y[2] = this.y[2];
        Y[3] = this.y[3];
        Y[4] = this.y[4];
        Y[5] = this.y[5];
        Y[6] = this.y[6];
        Y[7] = this.y[7];
    }

    public void getHiResCoordZ(int[] Z2) {
        Z2[0] = this.z[0];
        Z2[1] = this.z[1];
        Z2[2] = this.z[2];
        Z2[3] = this.z[3];
        Z2[4] = this.z[4];
        Z2[5] = this.z[5];
        Z2[6] = this.z[6];
        Z2[7] = this.z[7];
    }

    public boolean equals(HiResCoord h1) {
        try {
            return this.x[0] == h1.x[0] && this.x[1] == h1.x[1] && this.x[2] == h1.x[2] && this.x[3] == h1.x[3] && this.x[4] == h1.x[4] && this.x[5] == h1.x[5] && this.x[6] == h1.x[6] && this.x[7] == h1.x[7] && this.y[0] == h1.y[0] && this.y[1] == h1.y[1] && this.y[2] == h1.y[2] && this.y[3] == h1.y[3] && this.y[4] == h1.y[4] && this.y[5] == h1.y[5] && this.y[6] == h1.y[6] && this.y[7] == h1.y[7] && this.z[0] == h1.z[0] && this.z[1] == h1.z[1] && this.z[2] == h1.z[2] && this.z[3] == h1.z[3] && this.z[4] == h1.z[4] && this.z[5] == h1.z[5] && this.z[6] == h1.z[6] && this.z[7] == h1.z[7];
        }
        catch (NullPointerException e2) {
            return false;
        }
    }

    public boolean equals(Object o1) {
        try {
            HiResCoord h1 = (HiResCoord)o1;
            return this.x[0] == h1.x[0] && this.x[1] == h1.x[1] && this.x[2] == h1.x[2] && this.x[3] == h1.x[3] && this.x[4] == h1.x[4] && this.x[5] == h1.x[5] && this.x[6] == h1.x[6] && this.x[7] == h1.x[7] && this.y[0] == h1.y[0] && this.y[1] == h1.y[1] && this.y[2] == h1.y[2] && this.y[3] == h1.y[3] && this.y[4] == h1.y[4] && this.y[5] == h1.y[5] && this.y[6] == h1.y[6] && this.y[7] == h1.y[7] && this.z[0] == h1.z[0] && this.z[1] == h1.z[1] && this.z[2] == h1.z[2] && this.z[3] == h1.z[3] && this.z[4] == h1.z[4] && this.z[5] == h1.z[5] && this.z[6] == h1.z[6] && this.z[7] == h1.z[7];
        }
        catch (NullPointerException e2) {
            return false;
        }
        catch (ClassCastException e1) {
            return false;
        }
    }

    public void add(HiResCoord h1, HiResCoord h2) {
        this.hiResAdd(this, h1, h2);
    }

    public void sub(HiResCoord h1, HiResCoord h2) {
        HiResCoord tmpHc = new HiResCoord();
        this.hiResNegate(tmpHc, h2);
        this.hiResAdd(this, h1, tmpHc);
    }

    public void negate(HiResCoord h1) {
        this.hiResNegate(this, h1);
    }

    public void negate() {
        this.hiResNegate(this, this);
    }

    public void scale(int scale, HiResCoord h1) {
        this.hiResScale(h1.x, this.x, scale);
        this.hiResScale(h1.y, this.y, scale);
        this.hiResScale(h1.z, this.z, scale);
    }

    public void scale(int scale) {
        this.hiResScale(this.x, this.x, scale);
        this.hiResScale(this.y, this.y, scale);
        this.hiResScale(this.z, this.z, scale);
    }

    public void difference(HiResCoord h1, Vector3d v) {
        this.hiResDiff(this, h1, v);
    }

    public double distance(HiResCoord h1) {
        Vector3d diff = new Vector3d();
        this.hiResDiff(this, h1, diff);
        return Math.sqrt(diff.x * diff.x + diff.y * diff.y + diff.z * diff.z);
    }

    private void hiResNegate(HiResCoord ho, HiResCoord hi) {
        this.negateCoord(ho.x, hi.x);
        this.negateCoord(ho.y, hi.y);
        this.negateCoord(ho.z, hi.z);
    }

    private void negateCoord(int[] cout, int[] cin) {
        int i2;
        for (i2 = 0; i2 < 8; ++i2) {
            cout[i2] = ~cin[i2];
        }
        for (i2 = 7; i2 >= 0; --i2) {
            if (cout[i2] != -1) {
                int n2 = i2;
                cout[n2] = cout[n2] + 1;
                break;
            }
            cout[i2] = 0;
        }
    }

    private void hiResAdd(HiResCoord ho, HiResCoord h1, HiResCoord h2) {
        long tmp2;
        long tmp1;
        int i2;
        long signMask = Integer.MAX_VALUE;
        long signBit = 1L;
        signBit <<= 31;
        long carryMask = Integer.MAX_VALUE;
        carryMask <<= 1;
        ++carryMask;
        long carry = 0L;
        for (i2 = 7; i2 > 0; --i2) {
            tmp1 = 0L;
            tmp1 = signMask & (long)h1.x[i2];
            if (h1.x[i2] < 0) {
                tmp1 |= signBit;
            }
            tmp2 = 0L;
            tmp2 = signMask & (long)h2.x[i2];
            if (h2.x[i2] < 0) {
                tmp2 |= signBit;
            }
            tmp2 = tmp2 + tmp1 + carry;
            carry = tmp2 >> 32;
            ho.x[i2] = (int)(tmp2 & carryMask);
        }
        ho.x[0] = h1.x[0] + h2.x[0] + (int)carry;
        carry = 0L;
        for (i2 = 7; i2 > 0; --i2) {
            tmp1 = 0L;
            tmp1 = signMask & (long)h1.y[i2];
            if (h1.y[i2] < 0) {
                tmp1 |= signBit;
            }
            tmp2 = 0L;
            tmp2 = signMask & (long)h2.y[i2];
            if (h2.y[i2] < 0) {
                tmp2 |= signBit;
            }
            tmp2 = tmp2 + tmp1 + carry;
            carry = tmp2 >> 32;
            ho.y[i2] = (int)(tmp2 & carryMask);
        }
        ho.y[0] = h1.y[0] + h2.y[0] + (int)carry;
        carry = 0L;
        for (i2 = 7; i2 > 0; --i2) {
            tmp1 = 0L;
            tmp1 = signMask & (long)h1.z[i2];
            if (h1.z[i2] < 0) {
                tmp1 |= signBit;
            }
            tmp2 = 0L;
            tmp2 = signMask & (long)h2.z[i2];
            if (h2.z[i2] < 0) {
                tmp2 |= signBit;
            }
            tmp2 = tmp2 + tmp1 + carry;
            carry = tmp2 >> 32;
            ho.z[i2] = (int)(tmp2 & carryMask);
        }
        ho.z[0] = h1.z[0] + h2.z[0] + (int)carry;
    }

    private void hiResScale(int[] tin, int[] tout, double scale) {
        int signMask = Integer.MAX_VALUE;
        long carryMask = Integer.MAX_VALUE;
        carryMask <<= 1;
        ++carryMask;
        long signBit = 1L;
        signBit <<= 31;
        long carry = 0L;
        for (int i2 = 7; i2 > 0; --i2) {
            long tmp = 0L;
            tmp = signMask & tin[i2];
            if (tin[i2] < 0) {
                tmp |= signBit;
            }
            tmp = (long)((double)tmp * scale + (double)carry);
            carry = tmp >> 32;
            tout[i2] = (int)(tmp & carryMask);
        }
        tout[0] = (int)((double)tin[0] * scale + (double)carry);
    }

    private void hiResDiff(HiResCoord h1, HiResCoord h2, Vector3d diff) {
        long value;
        int i2;
        int[] tempCoord;
        HiResCoord diffHi = new HiResCoord();
        int[] coordSpace = new int[8];
        int signMask = Integer.MAX_VALUE;
        long signBit = 1L;
        signBit <<= 31;
        this.hiResNegate(diffHi, h2);
        this.hiResAdd(diffHi, h1, diffHi);
        if (diffHi.x[0] < 0) {
            tempCoord = coordSpace;
            this.negateCoord(tempCoord, diffHi.x);
        } else {
            tempCoord = diffHi.x;
        }
        diff.x = 0.0;
        for (i2 = 7; i2 > 0; --i2) {
            value = tempCoord[i2] & signMask;
            if (tempCoord[i2] < 0) {
                value |= signBit;
            }
            diff.x += this.scales[i2] * (double)value;
        }
        diff.x += this.scales[0] * (double)tempCoord[0];
        if (diffHi.x[0] < 0) {
            diff.x = -diff.x;
        }
        if (diffHi.y[0] < 0) {
            tempCoord = coordSpace;
            this.negateCoord(tempCoord, diffHi.y);
        } else {
            tempCoord = diffHi.y;
        }
        diff.y = 0.0;
        for (i2 = 7; i2 > 0; --i2) {
            value = tempCoord[i2] & signMask;
            if (tempCoord[i2] < 0) {
                value |= signBit;
            }
            diff.y += this.scales[i2] * (double)value;
        }
        diff.y += this.scales[0] * (double)tempCoord[0];
        if (diffHi.y[0] < 0) {
            diff.y = -diff.y;
        }
        if (diffHi.z[0] < 0) {
            tempCoord = coordSpace;
            this.negateCoord(tempCoord, diffHi.z);
        } else {
            tempCoord = diffHi.z;
        }
        diff.z = 0.0;
        for (i2 = 7; i2 > 0; --i2) {
            value = tempCoord[i2] & signMask;
            if (tempCoord[i2] < 0) {
                value |= signBit;
            }
            diff.z += this.scales[i2] * (double)value;
        }
        diff.z += this.scales[0] * (double)tempCoord[0];
        if (diffHi.z[0] < 0) {
            diff.z = -diff.z;
        }
    }
}

