/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.IndexedGeometryStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.LineStripArrayRetained;
import org.jogamp.java3d.TriangleFanArrayRetained;
import org.jogamp.java3d.TriangleStripArrayRetained;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.TexCoord3f;

abstract class GeometryStripArrayRetained
extends GeometryArrayRetained {
    int[] stripVertexCounts;
    int[] stripStartVertexIndices;
    int[] stripStartOffsetIndices;
    int[] compileNumStrips;
    int[] compileStripCountOffset;

    GeometryStripArrayRetained() {
    }

    void setStripVertexCounts(int[] stripVertexCounts) {
        boolean isLive;
        int i2;
        boolean nullGeo = false;
        int num = stripVertexCounts.length;
        int total = 0;
        for (i2 = 0; i2 < num; ++i2) {
            total += stripVertexCounts[i2];
            if (this instanceof LineStripArrayRetained) {
                if (stripVertexCounts[i2] >= 2) continue;
                throw new IllegalArgumentException(J3dI18N.getString("LineStripArrayRetained1"));
            }
            if (this instanceof TriangleStripArrayRetained) {
                if (stripVertexCounts[i2] >= 3) continue;
                throw new IllegalArgumentException(J3dI18N.getString("TriangleStripArrayRetained1"));
            }
            if (!(this instanceof TriangleFanArrayRetained) || stripVertexCounts[i2] >= 3) continue;
            throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArrayRetained1"));
        }
        if (this.initialVertexIndex + total > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray3"));
        }
        if (this.initialCoordIndex + total > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray7"));
        }
        if (this.initialColorIndex + total > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray4"));
        }
        if (this.initialNormalIndex + total > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray5"));
        }
        if ((this.vertexFormat & 0x460) != 0 && (this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            for (i2 = 0; i2 < this.texCoordSetCount; ++i2) {
                if (this.initialTexCoordIndex[i2] + total <= this.vertexCount) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray6"));
            }
        }
        if ((this.vertexFormat & 0x1000) != 0 && (this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            for (i2 = 0; i2 < this.vertexAttrCount; ++i2) {
                if (this.initialVertexAttrIndex[i2] + total <= this.vertexCount) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray8"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x40;
        this.validVertexCount = total;
        this.stripVertexCounts = new int[num];
        this.stripStartVertexIndices = new int[num];
        this.stripStartOffsetIndices = new int[num];
        this.stripStartOffsetIndices[0] = 0;
        if ((this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            this.stripStartVertexIndices[0] = this.initialCoordIndex;
            nullGeo = (this.vertexType & 0xF) == 0;
        } else {
            this.stripStartVertexIndices[0] = this.initialVertexIndex;
            if ((this.vertexFormat & 0x100) != 0) {
                nullGeo = (this.vertexFormat & 0x800) != 0 ? this.interLeavedVertexData == null : this.interleavedFloatBufferImpl == null;
            }
        }
        for (i2 = 0; i2 < num - 1; ++i2) {
            this.stripVertexCounts[i2] = stripVertexCounts[i2];
            this.stripStartVertexIndices[i2 + 1] = this.stripStartVertexIndices[i2] + stripVertexCounts[i2];
            this.stripStartOffsetIndices[i2 + 1] = this.stripStartOffsetIndices[i2] + stripVertexCounts[i2];
        }
        this.stripVertexCounts[num - 1] = stripVertexCounts[num - 1];
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.processCoordsChanged(nullGeo);
            this.sendDataChangedMessage(true);
        }
    }

    void unIndexify(IndexedGeometryStripArrayRetained src) {
        if ((src.vertexFormat & 0x800) == 0) {
            this.unIndexifyJavaArray(src);
        } else {
            this.unIndexifyNIOBuffer(src);
        }
    }

    private void unIndexifyJavaArray(IndexedGeometryStripArrayRetained src) {
        int vOffset = 0;
        int tOffset = 0;
        int base = src.initialIndexIndex;
        int colorStride = 0;
        float[] vdata = null;
        if ((src.vertexFormat & 0x80) == 0 || (src.vertexFormat & 0x100) != 0) {
            if ((src.vertexFormat & 0x80) == 0) {
                vdata = src.vertexData;
                if ((src.vertexFormat & 4) != 0) {
                    colorStride = 4;
                }
            } else if ((src.vertexFormat & 0x100) != 0) {
                vdata = src.interLeavedVertexData;
                if ((src.vertexFormat & 8) != 0) {
                    colorStride = 4;
                } else if ((src.vertexFormat & 4) != 0) {
                    colorStride = 3;
                }
            }
            for (int i2 = 0; i2 < src.stripIndexCounts.length; ++i2) {
                for (int j2 = 0; j2 < src.stripIndexCounts[i2]; ++j2) {
                    int k2;
                    int index = j2 + base;
                    if ((this.vertexFormat & 2) != 0) {
                        System.arraycopy(vdata, src.indexNormal[index] * src.stride + src.normalOffset, this.vertexData, vOffset + this.normalOffset, 3);
                    }
                    if (colorStride == 4) {
                        System.arraycopy(vdata, src.indexColor[index] * src.stride + src.colorOffset, this.vertexData, vOffset + this.colorOffset, colorStride);
                    } else if (colorStride == 3) {
                        System.arraycopy(vdata, src.indexColor[index] * src.stride + src.colorOffset, this.vertexData, vOffset + this.colorOffset, colorStride);
                        this.vertexData[vOffset + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x460) != 0) {
                        for (k2 = 0; k2 < this.texCoordSetCount; ++k2) {
                            System.arraycopy(vdata, src.indexTexCoord[k2][index] * src.stride + src.textureOffset + src.texCoordSetMapOffset[k2], this.vertexData, vOffset + this.textureOffset + this.texCoordSetMapOffset[k2], this.texCoordStride);
                        }
                    }
                    if ((this.vertexFormat & 0x1000) != 0) {
                        for (k2 = 0; k2 < this.vertexAttrCount; ++k2) {
                            System.arraycopy(vdata, src.indexVertexAttr[k2][index] * src.stride + src.vertexAttrOffsets[k2], this.vertexData, vOffset + this.vertexAttrOffsets[k2], this.vertexAttrSizes[k2]);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        System.arraycopy(vdata, src.indexCoord[index] * src.stride + src.coordinateOffset, this.vertexData, vOffset + this.coordinateOffset, 3);
                    }
                    vOffset += this.stride;
                }
                base += src.stripIndexCounts[i2];
            }
        } else {
            int k3;
            int index;
            int j3;
            int i3;
            if ((this.vertexFormat & 2) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.normalOffset;
                switch (src.vertexType & 0xC00) {
                    case 1024: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = j3 + base;
                                System.arraycopy(src.floatRefNormals, src.indexNormal[index] * 3, this.vertexData, vOffset, 3);
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 2048: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexNormal[j3 + base];
                                this.vertexData[vOffset] = src.v3fRefNormals[index].x;
                                this.vertexData[vOffset + 1] = src.v3fRefNormals[index].y;
                                this.vertexData[vOffset + 2] = src.v3fRefNormals[index].z;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.colorOffset;
                int multiplier = 3;
                if ((src.vertexFormat & 8) != 0) {
                    multiplier = 4;
                }
                switch (src.vertexType & 0x3F0) {
                    case 16: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = j3 + base;
                                if ((src.vertexFormat & 8) != 0) {
                                    System.arraycopy(src.floatRefColors, src.indexColor[index] * multiplier, this.vertexData, vOffset, 4);
                                } else {
                                    System.arraycopy(src.floatRefColors, src.indexColor[index] * multiplier, this.vertexData, vOffset, 3);
                                    this.vertexData[vOffset + 3] = 1.0f;
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 32: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexColor[j3 + base] * multiplier;
                                this.vertexData[vOffset] = (float)(src.byteRefColors[index] & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 1] = (float)(src.byteRefColors[index + 1] & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 2] = (float)(src.byteRefColors[index + 2] & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 3] = (src.vertexFormat & 8) != 0 ? (float)(src.byteRefColors[index + 3] & 0xFF) * 0.003921569f : 1.0f;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 64: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexColor[j3 + base];
                                this.vertexData[vOffset] = src.c3fRefColors[index].x;
                                this.vertexData[vOffset + 1] = src.c3fRefColors[index].y;
                                this.vertexData[vOffset + 2] = src.c3fRefColors[index].z;
                                this.vertexData[vOffset + 3] = 1.0f;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 128: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexColor[j3 + base];
                                this.vertexData[vOffset] = src.c4fRefColors[index].x;
                                this.vertexData[vOffset + 1] = src.c4fRefColors[index].y;
                                this.vertexData[vOffset + 2] = src.c4fRefColors[index].z;
                                this.vertexData[vOffset + 3] = src.c4fRefColors[index].w;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 256: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexColor[j3 + base];
                                this.vertexData[vOffset] = (float)(src.c3bRefColors[index].x & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 1] = (float)(src.c3bRefColors[index].y & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 2] = (float)(src.c3bRefColors[index].z & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 3] = 1.0f;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 512: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexColor[j3 + base];
                                this.vertexData[vOffset] = (float)(src.c4bRefColors[index].x & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 1] = (float)(src.c4bRefColors[index].y & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 2] = (float)(src.c4bRefColors[index].z & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 3] = (float)(src.c4bRefColors[index].w & 0xFF) * 0.003921569f;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.textureOffset;
                switch (src.vertexType & 0x7000) {
                    case 4096: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = j3 + base;
                                tOffset = vOffset;
                                for (k3 = 0; k3 < this.texCoordSetCount; ++k3) {
                                    System.arraycopy(src.refTexCoords[k3], src.indexTexCoord[k3][index] * this.texCoordStride, this.vertexData, tOffset, this.texCoordStride);
                                    tOffset += this.texCoordStride;
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 8192: {
                        int srcOffset;
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = j3 + base;
                                tOffset = vOffset;
                                for (k3 = 0; k3 < this.texCoordSetCount; ++k3) {
                                    srcOffset = src.indexTexCoord[k3][index];
                                    this.vertexData[tOffset] = ((TexCoord2f[])src.refTexCoords[k3])[srcOffset].x;
                                    this.vertexData[tOffset + 1] = ((TexCoord2f[])src.refTexCoords[k3])[srcOffset].y;
                                    tOffset += this.texCoordStride;
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 16384: {
                        int srcOffset;
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = j3 + base;
                                tOffset = vOffset;
                                for (k3 = 0; k3 < this.texCoordSetCount; ++k3) {
                                    srcOffset = src.indexTexCoord[k3][index];
                                    this.vertexData[tOffset] = ((TexCoord3f[])src.refTexCoords[k3])[srcOffset].x;
                                    this.vertexData[tOffset + 1] = ((TexCoord3f[])src.refTexCoords[k3])[srcOffset].y;
                                    this.vertexData[tOffset + 2] = ((TexCoord3f[])src.refTexCoords[k3])[srcOffset].z;
                                    tOffset += this.texCoordStride;
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                base = src.initialIndexIndex;
                vOffset = 0;
                switch (src.vertexType & 0x8000) {
                    case 32768: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = j3 + base;
                                for (k3 = 0; k3 < this.vertexAttrCount; ++k3) {
                                    System.arraycopy(src.floatRefVertexAttrs[k3], src.indexVertexAttr[k3][index] * this.vertexAttrSizes[k3], this.vertexData, vOffset + this.vertexAttrOffsets[k3], this.vertexAttrSizes[k3]);
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                vOffset = this.coordinateOffset;
                base = src.initialIndexIndex;
                switch (src.vertexType & 0xF) {
                    case 1: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = j3 + base;
                                System.arraycopy(src.floatRefCoords, src.indexCoord[index] * 3, this.vertexData, vOffset, 3);
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 2: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexCoord[j3 + base] * 3;
                                this.vertexData[vOffset] = (float)src.doubleRefCoords[index];
                                this.vertexData[vOffset + 1] = (float)src.doubleRefCoords[index + 1];
                                this.vertexData[vOffset + 2] = (float)src.doubleRefCoords[index + 2];
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 4: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexCoord[j3 + base];
                                this.vertexData[vOffset] = src.p3fRefCoords[index].x;
                                this.vertexData[vOffset + 1] = src.p3fRefCoords[index].y;
                                this.vertexData[vOffset + 2] = src.p3fRefCoords[index].z;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 8: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexCoord[j3 + base];
                                this.vertexData[vOffset] = (float)src.p3dRefCoords[index].x;
                                this.vertexData[vOffset + 1] = (float)src.p3dRefCoords[index].y;
                                this.vertexData[vOffset + 2] = (float)src.p3dRefCoords[index].z;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                }
            }
        }
    }

    private void unIndexifyNIOBuffer(IndexedGeometryStripArrayRetained src) {
        int vOffset = 0;
        int tOffset = 0;
        int base = src.initialIndexIndex;
        int colorStride = 0;
        if ((src.vertexFormat & 0x100) != 0) {
            if ((src.vertexFormat & 8) != 0) {
                colorStride = 4;
            } else if ((src.vertexFormat & 4) != 0) {
                colorStride = 3;
            }
            for (int i2 = 0; i2 < src.stripIndexCounts.length; ++i2) {
                for (int j2 = 0; j2 < src.stripIndexCounts[i2]; ++j2) {
                    int index = j2 + base;
                    if ((this.vertexFormat & 2) != 0) {
                        src.interleavedFloatBufferImpl.position(src.indexNormal[index] * src.stride + src.normalOffset);
                        src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.normalOffset, 3);
                    }
                    if (colorStride == 4) {
                        src.interleavedFloatBufferImpl.position(src.indexColor[index] * src.stride + src.colorOffset);
                        src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.colorOffset, colorStride);
                    } else if (colorStride == 3) {
                        src.interleavedFloatBufferImpl.position(src.indexColor[index] * src.stride + src.colorOffset);
                        src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.colorOffset, colorStride);
                        this.vertexData[vOffset + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x460) != 0) {
                        for (int k2 = 0; k2 < this.texCoordSetCount; ++k2) {
                            src.interleavedFloatBufferImpl.position(src.indexTexCoord[k2][index] * src.stride + src.textureOffset + src.texCoordSetMapOffset[k2]);
                            src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.textureOffset + this.texCoordSetMapOffset[k2], this.texCoordStride);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        src.interleavedFloatBufferImpl.position(src.indexCoord[index] * src.stride + src.coordinateOffset);
                        src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.coordinateOffset, 3);
                    }
                    vOffset += this.stride;
                }
                base += src.stripIndexCounts[i2];
            }
        } else {
            int k3;
            int index;
            int j3;
            int i3;
            if ((this.vertexFormat & 2) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.normalOffset;
                if ((src.vertexType & 0xC00) != 0) {
                    for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                        for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                            index = j3 + base;
                            src.floatBufferRefNormals.position(src.indexNormal[index] * 3);
                            src.floatBufferRefNormals.get(this.vertexData, vOffset, 3);
                            vOffset += this.stride;
                        }
                        base += src.stripIndexCounts[i3];
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.colorOffset;
                int multiplier = 3;
                if ((src.vertexFormat & 8) != 0) {
                    multiplier = 4;
                }
                switch (src.vertexType & 0x3F0) {
                    case 16: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = j3 + base;
                                if ((src.vertexFormat & 8) != 0) {
                                    src.floatBufferRefColors.position(src.indexColor[index] * multiplier);
                                    src.floatBufferRefColors.get(this.vertexData, vOffset, 4);
                                } else {
                                    src.floatBufferRefColors.position(src.indexColor[index] * multiplier);
                                    src.floatBufferRefColors.get(this.vertexData, vOffset, 3);
                                    this.vertexData[vOffset + 3] = 1.0f;
                                }
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 32: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexColor[j3 + base] * multiplier;
                                this.vertexData[vOffset] = (float)(src.byteBufferRefColors.get(index) & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 1] = (float)(src.byteBufferRefColors.get(index + 1) & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 2] = (float)(src.byteBufferRefColors.get(index + 2) & 0xFF) * 0.003921569f;
                                this.vertexData[vOffset + 3] = (src.vertexFormat & 8) != 0 ? (float)(src.byteBufferRefColors.get(index + 3) & 0xFF) * 0.003921569f : 1.0f;
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                base = src.initialIndexIndex;
                vOffset = this.textureOffset;
                if ((src.vertexType & 0x7000) != 0) {
                    for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                        for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                            index = j3 + base;
                            tOffset = vOffset;
                            for (k3 = 0; k3 < this.texCoordSetCount; ++k3) {
                                FloatBuffer texBuffer = (FloatBuffer)src.refTexCoordsBuffer[k3].getROBuffer();
                                texBuffer.position(src.indexTexCoord[k3][index] * this.texCoordStride);
                                texBuffer.get(this.vertexData, tOffset, this.texCoordStride);
                                tOffset += this.texCoordStride;
                            }
                            vOffset += this.stride;
                        }
                        base += src.stripIndexCounts[i3];
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                base = src.initialIndexIndex;
                vOffset = 0;
                if ((src.vertexType & 0x8000) == 32768) {
                    for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                        for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                            index = j3 + base;
                            for (k3 = 0; k3 < this.vertexAttrCount; ++k3) {
                                int vaOffset = vOffset + this.vertexAttrOffsets[k3];
                                FloatBuffer vaBuffer = src.floatBufferRefVertexAttrs[k3];
                                vaBuffer.position(src.indexVertexAttr[k3][index] * this.vertexAttrSizes[k3]);
                                vaBuffer.get(this.vertexData, vaOffset, this.vertexAttrSizes[k3]);
                            }
                            vOffset += this.stride;
                        }
                        base += src.stripIndexCounts[i3];
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                vOffset = this.coordinateOffset;
                base = src.initialIndexIndex;
                switch (src.vertexType & 0xF) {
                    case 1: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = j3 + base;
                                src.floatBufferRefCoords.position(src.indexCoord[index] * 3);
                                src.floatBufferRefCoords.get(this.vertexData, vOffset, 3);
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                    case 2: {
                        for (i3 = 0; i3 < src.stripIndexCounts.length; ++i3) {
                            for (j3 = 0; j3 < src.stripIndexCounts[i3]; ++j3) {
                                index = src.indexCoord[j3 + base] * 3;
                                this.vertexData[vOffset] = (float)src.doubleBufferRefCoords.get(index);
                                this.vertexData[vOffset + 1] = (float)src.doubleBufferRefCoords.get(index + 1);
                                this.vertexData[vOffset + 2] = (float)src.doubleBufferRefCoords.get(index + 2);
                                vOffset += this.stride;
                            }
                            base += src.stripIndexCounts[i3];
                        }
                        break;
                    }
                }
            }
        }
    }

    int getNumStrips() {
        return this.stripVertexCounts.length;
    }

    void getStripVertexCounts(int[] stripVertexCounts) {
        for (int stripVertexCounts[i] : this.stripVertexCounts) {
        }
    }

    void getStripVertexCounts(int id, int[] counts) {
        int stripOffset = this.compileStripCountOffset[id];
        int stripLength = this.compileNumStrips[id];
        System.arraycopy(this.stripVertexCounts, stripOffset, counts, 0, stripLength);
    }

    int getNumStrips(int id) {
        return this.compileNumStrips[id];
    }

    @Override
    void mergeGeometryArrays(ArrayList list) {
        int numMerge = list.size();
        int numStrips = 0;
        for (int i2 = 0; i2 < numMerge; ++i2) {
            numStrips += ((GeometryStripArrayRetained)list.get((int)i2)).stripVertexCounts.length;
        }
        this.stripVertexCounts = new int[numStrips];
        this.stripStartVertexIndices = new int[numStrips];
        this.stripStartOffsetIndices = new int[numStrips];
        int curStripOffset = 0;
        int curStripIndexOffset = 0;
        this.compileNumStrips = new int[numMerge];
        this.compileStripCountOffset = new int[numMerge];
        for (int i3 = 0; i3 < numMerge; ++i3) {
            int stripLength;
            GeometryStripArrayRetained strip = (GeometryStripArrayRetained)list.get(i3);
            int[] curStripVertexCounts = strip.stripVertexCounts;
            int[] curStripStartIndices = strip.stripStartVertexIndices;
            int[] curStripOffsetIndices = strip.stripStartOffsetIndices;
            this.compileNumStrips[i3] = stripLength = curStripVertexCounts.length;
            this.compileStripCountOffset[i3] = curStripOffset;
            System.arraycopy(curStripVertexCounts, 0, this.stripVertexCounts, curStripOffset, stripLength);
            for (int j2 = 0; j2 < stripLength; ++j2) {
                this.stripStartVertexIndices[j2 + curStripOffset] = curStripStartIndices[j2] + curStripIndexOffset;
                this.stripStartOffsetIndices[j2 + curStripOffset] = curStripOffsetIndices[j2] + curStripIndexOffset;
            }
            curStripOffset += stripLength;
            curStripIndexOffset += strip.validVertexCount;
        }
        this.validVertexCount = curStripIndexOffset;
        super.mergeGeometryArrays(list);
    }
}

