/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.jogamp.java3d.Canvas3D;

class EventCatcher
implements ComponentListener,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
WindowListener {
    private Canvas3D canvas;
    private static final boolean DEBUG = false;
    private boolean stopped = false;
    private boolean focusEvents = false;
    private boolean keyEvents = false;
    private boolean mouseEvents = false;
    private boolean mouseMotionEvents = false;
    private boolean mouseWheelEvents = false;
    private boolean mouseListenerAdded = false;

    EventCatcher(Canvas3D c2) {
        this.canvas = c2;
    }

    void enableFocusEvents() {
        if (!this.focusEvents) {
            this.canvas.addFocusListener(this);
            this.focusEvents = true;
        }
    }

    void disableFocusEvents() {
        if (this.focusEvents) {
            this.canvas.removeFocusListener(this);
            this.focusEvents = false;
        }
    }

    void enableKeyEvents() {
        if (!this.keyEvents) {
            this.canvas.addKeyListener(this);
            this.keyEvents = true;
            if (!this.mouseListenerAdded) {
                this.canvas.addMouseListener(this);
                this.mouseListenerAdded = true;
            }
        }
    }

    void disableKeyEvents() {
        if (this.keyEvents) {
            this.canvas.removeKeyListener(this);
            this.keyEvents = false;
            if (!this.mouseEvents && this.mouseListenerAdded) {
                this.canvas.removeMouseListener(this);
                this.mouseListenerAdded = false;
            }
        }
    }

    void enableMouseEvents() {
        if (!this.mouseEvents) {
            this.mouseEvents = true;
            if (!this.mouseListenerAdded) {
                this.canvas.addMouseListener(this);
                this.mouseListenerAdded = true;
            }
        }
    }

    void disableMouseEvents() {
        if (this.mouseEvents) {
            this.mouseEvents = false;
            if (!this.keyEvents && this.mouseListenerAdded) {
                this.canvas.removeMouseListener(this);
                this.mouseListenerAdded = false;
            }
        }
    }

    void enableMouseMotionEvents() {
        if (!this.mouseMotionEvents) {
            this.canvas.addMouseMotionListener(this);
            this.mouseMotionEvents = true;
        }
    }

    void disableMouseMotionEvents() {
        if (this.mouseMotionEvents) {
            this.canvas.removeMouseMotionListener(this);
            this.mouseMotionEvents = false;
        }
    }

    void enableMouseWheelEvents() {
        if (!this.mouseWheelEvents) {
            this.canvas.addMouseWheelListener(this);
            this.mouseWheelEvents = true;
        }
    }

    void disableMouseWheelEvents() {
        if (this.mouseWheelEvents) {
            this.canvas.removeMouseWheelListener(this);
            this.mouseWheelEvents = false;
        }
    }

    @Override
    public void componentResized(ComponentEvent e2) {
        if (e2.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(e2);
            this.canvas.evaluateVisiblilty();
            this.canvas.redraw();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e2) {
        if (e2.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(e2);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e2) {
        if (e2.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(e2);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void componentShown(ComponentEvent e2) {
        if (e2.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(e2);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void keyTyped(KeyEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void keyPressed(KeyEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
        this.stopped = !this.stopped;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(e2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(e2);
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(e2);
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(e2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(e2);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void windowClosed(WindowEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void windowClosing(WindowEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void windowActivated(WindowEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void windowDeactivated(WindowEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
    }

    @Override
    public void windowDeiconified(WindowEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
        if (this.canvas.view != null) {
            this.canvas.view.sendEventToSoundScheduler(e2);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void windowIconified(WindowEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
        if (this.canvas.view != null) {
            this.canvas.view.sendEventToSoundScheduler(e2);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void windowOpened(WindowEvent e2) {
        this.canvas.sendEventToBehaviorScheduler(e2);
        this.canvas.evaluateVisiblilty();
    }

    void reset() {
        this.focusEvents = false;
        this.keyEvents = false;
        this.mouseEvents = false;
        this.mouseMotionEvents = false;
        this.mouseWheelEvents = false;
        this.mouseListenerAdded = false;
        this.stopped = false;
    }
}

