/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.DepthComponent;
import org.jogamp.java3d.DepthComponentIntRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;

public class DepthComponentInt
extends DepthComponent {
    DepthComponentInt() {
    }

    public DepthComponentInt(int width, int height) {
        ((DepthComponentIntRetained)this.retained).initialize(width, height);
    }

    public void setDepthData(int[] depthData) {
        this.checkForLiveOrCompiled();
        ((DepthComponentIntRetained)this.retained).setDepthData(depthData);
    }

    public void getDepthData(int[] depthData) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("DepthComponentInt0"));
        }
        ((DepthComponentIntRetained)this.retained).getDepthData(depthData);
    }

    @Override
    void createRetained() {
        this.retained = new DepthComponentIntRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        DepthComponentIntRetained rt = (DepthComponentIntRetained)this.retained;
        DepthComponentInt d2 = new DepthComponentInt(rt.width, rt.height);
        d2.duplicateNodeComponent(this);
        return d2;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        int len = this.getWidth() * this.getHeight();
        int[] d2 = new int[len];
        ((DepthComponentIntRetained)originalNodeComponent.retained).getDepthData(d2);
        ((DepthComponentIntRetained)this.retained).setDepthData(d2);
    }
}

