/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.DepthComponent;
import org.jogamp.java3d.DepthComponentFloatRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;

public class DepthComponentFloat
extends DepthComponent {
    DepthComponentFloat() {
    }

    public DepthComponentFloat(int width, int height) {
        ((DepthComponentFloatRetained)this.retained).initialize(width, height);
    }

    public void setDepthData(float[] depthData) {
        this.checkForLiveOrCompiled();
        ((DepthComponentFloatRetained)this.retained).setDepthData(depthData);
    }

    public void getDepthData(float[] depthData) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("DepthComponentFloat0"));
        }
        ((DepthComponentFloatRetained)this.retained).getDepthData(depthData);
    }

    @Override
    void createRetained() {
        this.retained = new DepthComponentFloatRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        DepthComponentFloatRetained rt = (DepthComponentFloatRetained)this.retained;
        DepthComponentFloat d2 = new DepthComponentFloat(rt.width, rt.height);
        d2.duplicateNodeComponent(this);
        return d2;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        int len = this.getWidth() * this.getHeight();
        float[] f2 = new float[len];
        ((DepthComponentFloatRetained)originalNodeComponent.retained).getDepthData(f2);
        ((DepthComponentFloatRetained)this.retained).setDepthData(f2);
    }
}

