/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.CompressedGeometryHeader;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.GeometryDecompressorRetained;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.RenderAtom;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;

@Deprecated
class CompressedGeometryRetained
extends GeometryRetained {
    private static final int HEADER_LENGTH = 48;
    private static final int HEADER_MAJOR_VERSION_OFFSET = 0;
    private static final int HEADER_MINOR_VERSION_OFFSET = 1;
    private static final int HEADER_MINOR_MINOR_VERSION_OFFSET = 2;
    private static final int HEADER_BUFFER_TYPE_OFFSET = 3;
    private static final int HEADER_BUFFER_DATA_OFFSET = 4;
    static final byte TYPE_POINT = 1;
    static final byte TYPE_LINE = 2;
    static final byte TYPE_TRIANGLE = 4;
    int majorVersionNumber;
    int minorVersionNumber;
    int minorMinorVersionNumber;
    int packedVersion;
    int bufferType;
    int bufferContents;
    int renderFlags;
    int offset;
    int size;
    byte[] compressedGeometry;
    private boolean byReference = false;
    private byte[] originalCompressedGeometry = null;
    private static boolean hardwareDecompression = false;
    private GeometryRetained pickGeometry = null;

    private boolean decompressByRef(Context ctx) {
        return false;
    }

    private boolean decompressHW(Context ctx, int majorVersion, int minorVersion) {
        return false;
    }

    private void execute(Context ctx, int version, int bufferType, int bufferContents, int renderFlags, int offset, int size, byte[] geometry) {
        assert (false) : "This method should never be called!";
    }

    @Override
    void execute(Canvas3D cv, RenderAtom ra, boolean isNonUniformScale, boolean updateAlpha, float alpha, int screen, boolean ignoreVertexColors) {
        this.execute(cv.ctx, this.packedVersion, this.bufferType, this.bufferContents, this.renderFlags, this.offset, this.size, this.compressedGeometry);
    }

    CompressedGeometryRetained() {
        this.geoType = 17;
        this.geoBounds.setUpper(1.0, 1.0, 1.0);
        this.geoBounds.setLower(-1.0, -1.0, -1.0);
    }

    @Override
    void computeBoundingBox() {
    }

    @Override
    void update() {
        this.isDirty = 0;
    }

    boolean isByReference() {
        return this.byReference;
    }

    private void createByCopy(byte[] geometry) {
        this.compressedGeometry = new byte[48 + this.size];
        this.compressedGeometry[0] = (byte)this.majorVersionNumber;
        this.compressedGeometry[1] = (byte)this.minorVersionNumber;
        this.compressedGeometry[2] = (byte)this.minorMinorVersionNumber;
        this.compressedGeometry[3] = (byte)this.bufferType;
        this.compressedGeometry[4] = (byte)this.bufferContents;
        System.arraycopy(geometry, this.offset, this.compressedGeometry, 48, this.size);
        this.offset = 48;
    }

    void createCompressedGeometry(CompressedGeometryHeader hdr, byte[] geometry, boolean byReference) {
        this.byReference = byReference;
        if (hdr.lowerBound != null) {
            this.geoBounds.setLower(hdr.lowerBound);
        }
        if (hdr.upperBound != null) {
            this.geoBounds.setUpper(hdr.upperBound);
        }
        this.geoBounds.getCenter(this.centroid);
        this.recompCentroid = false;
        this.majorVersionNumber = hdr.majorVersionNumber;
        this.minorVersionNumber = hdr.minorVersionNumber;
        this.minorMinorVersionNumber = hdr.minorMinorVersionNumber;
        this.packedVersion = hdr.majorVersionNumber << 24 | hdr.minorVersionNumber << 16 | hdr.minorMinorVersionNumber << 8;
        switch (hdr.bufferType) {
            case 0: {
                this.bufferType = 1;
                break;
            }
            case 1: {
                this.bufferType = 2;
                break;
            }
            case 2: {
                this.bufferType = 4;
            }
        }
        this.bufferContents = hdr.bufferDataPresent;
        this.renderFlags = 0;
        this.size = hdr.size;
        this.offset = hdr.start;
        if (byReference) {
            this.compressedGeometry = geometry;
            this.originalCompressedGeometry = geometry;
        } else {
            this.createByCopy(geometry);
            this.originalCompressedGeometry = null;
        }
    }

    GeometryRetained getGeometry(boolean forceDecompression, Canvas3D cv) {
        if (forceDecompression) {
            GeometryDecompressorRetained gdr = new GeometryDecompressorRetained();
            this.mirrorGeometry = gdr.decompress(this);
            gdr.getBoundingBox(this.geoBounds);
            this.pickGeometry = this.mirrorGeometry;
        } else {
            if (hardwareDecompression) {
                return this;
            }
            if (this.decompressHW(cv.ctx, this.majorVersionNumber, this.minorVersionNumber)) {
                hardwareDecompression = true;
                if (this.isByReference() && !this.decompressByRef(cv.ctx)) {
                    this.createByCopy(this.compressedGeometry);
                }
                return this;
            }
            GeometryDecompressorRetained gdr = new GeometryDecompressorRetained();
            this.mirrorGeometry = gdr.decompress(this);
            gdr.getBoundingBox(this.geoBounds);
            this.pickGeometry = this.mirrorGeometry;
        }
        return this.mirrorGeometry;
    }

    GeometryRetained getPickGeometry() {
        if (this.pickGeometry != null) {
            return this.pickGeometry;
        }
        GeometryDecompressorRetained gdr = new GeometryDecompressorRetained();
        gdr.setDecompressPositionsOnly(true);
        this.pickGeometry = gdr.decompress(this);
        gdr.getBoundingBox(this.geoBounds);
        return this.pickGeometry;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        GeometryRetained geomR = this.getPickGeometry();
        return geomR != null ? geomR.intersect(pickShape, pickInfo, flags, iPnt, geom, geomIndex) : false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        GeometryRetained geom = this.getPickGeometry();
        return geom != null ? geom.intersect(targetBound) : false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained g2) {
        GeometryRetained geom = this.getPickGeometry();
        return geom != null ? geom.intersect(thisToOtherVworld, g2) : false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        GeometryRetained geom = this.getPickGeometry();
        return geom != null ? geom.intersect(pnts) : false;
    }

    @Override
    int getVertexFormat() {
        int vertexFormat = 1;
        if ((this.bufferContents & 1) != 0) {
            vertexFormat |= 2;
        }
        if ((this.bufferContents & 2) != 0) {
            vertexFormat |= 4;
        }
        if ((this.bufferContents & 4) != 0) {
            vertexFormat |= 8;
        }
        return vertexFormat;
    }

    int getBufferType() {
        switch (this.bufferType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 2;
    }

    void copy(byte[] buff) {
        System.arraycopy(this.compressedGeometry, this.offset, buff, 0, this.size);
    }

    byte[] getReference() {
        return this.originalCompressedGeometry;
    }

    void duplicate(CompressedGeometryRetained cgr) {
        cgr.majorVersionNumber = this.majorVersionNumber;
        cgr.minorVersionNumber = this.minorVersionNumber;
        cgr.minorMinorVersionNumber = this.minorMinorVersionNumber;
        cgr.packedVersion = this.packedVersion;
        cgr.bufferType = this.bufferType;
        cgr.bufferContents = this.bufferContents;
        cgr.renderFlags = this.renderFlags;
        cgr.offset = this.offset;
        cgr.size = this.size;
        cgr.geoBounds.setLower(this.geoBounds.lower);
        cgr.geoBounds.setUpper(this.geoBounds.upper);
        cgr.pickGeometry = this.pickGeometry;
        cgr.byReference = this.byReference;
        if (this.byReference) {
            cgr.compressedGeometry = this.compressedGeometry;
            cgr.originalCompressedGeometry = this.originalCompressedGeometry;
        } else {
            cgr.compressedGeometry = new byte[this.compressedGeometry.length];
            System.arraycopy(this.compressedGeometry, 0, cgr.compressedGeometry, 0, this.compressedGeometry.length);
            cgr.originalCompressedGeometry = null;
        }
    }

    @Override
    int getClassType() {
        return 7;
    }
}

