/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Color3f;

class ColoringAttributesRetained
extends NodeComponentRetained {
    static final int COLOR_CHANGED = 1;
    static final int SHADE_MODEL_CHANGED = 2;
    Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
    int shadeModel = 3;

    ColoringAttributesRetained() {
    }

    final void initColor(Color3f color) {
        this.color.set(color);
    }

    final void setColor(Color3f color) {
        this.initColor(color);
        this.sendMessage(1, new Color3f(color));
    }

    final void initColor(float r, float g2, float b2) {
        this.color.set(r, g2, b2);
    }

    final void setColor(float r, float g2, float b2) {
        this.initColor(r, g2, b2);
        this.sendMessage(1, new Color3f(r, g2, b2));
    }

    final void getColor(Color3f color) {
        color.set(this.color);
    }

    final void initShadeModel(int shadeModel) {
        this.shadeModel = shadeModel;
    }

    final void setShadeModel(int shadeModel) {
        this.initShadeModel(shadeModel);
        this.sendMessage(2, new Integer(shadeModel));
    }

    final int getShadeModel() {
        return this.shadeModel;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                ColoringAttributesRetained mirrorCa = new ColoringAttributesRetained();
                mirrorCa.source = this.source;
                mirrorCa.set(this);
                this.mirror = mirrorCa;
            }
        } else {
            ((ColoringAttributesRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context ctx, float dRed, float dGreen, float dBlue, float alpha, boolean lEnable) {
        Pipeline.getPipeline().updateColoringAttributes(ctx, dRed, dBlue, dGreen, this.color.x, this.color.y, this.color.z, alpha, lEnable, this.shadeModel);
    }

    @Override
    synchronized void initMirrorObject() {
        ((ColoringAttributesRetained)this.mirror).set(this);
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        ColoringAttributesRetained mirrorCa = (ColoringAttributesRetained)this.mirror;
        if ((component & 1) != 0) {
            mirrorCa.color.set((Color3f)value);
        } else if ((component & 2) != 0) {
            mirrorCa.shadeModel = (Integer)value;
        }
    }

    boolean equivalent(ColoringAttributesRetained cr) {
        return cr != null && this.color.equals(cr.color) && this.shadeModel == cr.shadeModel;
    }

    @Override
    protected Object clone() {
        ColoringAttributesRetained cr = (ColoringAttributesRetained)super.clone();
        cr.color = new Color3f(this.color);
        return cr;
    }

    protected void set(ColoringAttributesRetained cr) {
        super.set(cr);
        this.color.set(cr.color);
        this.shadeModel = cr.shadeModel;
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 6;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i2 = 0; i2 < univList.size(); ++i2) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 6;
            createMessage.universe = univList.get(i2);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i2);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 1 || bit == 3) {
            this.setFrequencyChangeMask(bit, 1);
        }
    }
}

