/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.NnuId;
import org.jogamp.java3d.NnuIdManager;

class CachedTargets {
    static String[] typeString = new String[]{"GEO_TARGETS", "ENV_TARGETS", "BEH_TARGETS", "SND_TARGETS", "VPF_TARGETS", "BLN_TARGETS", "GRP_TARGETS"};
    static int[] updateTargetThreads = new int[]{8384, 4224, 256, 514, 898, 4992, 8256};
    NnuId[][] targetArr = new NnuId[7][];

    CachedTargets() {
    }

    int computeTargetThreads() {
        int targetThreads = 0;
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetArr[i2] == null) continue;
            targetThreads |= updateTargetThreads[i2];
        }
        return targetThreads;
    }

    void copy(CachedTargets ct) {
        for (int i2 = 0; i2 < 7; ++i2) {
            this.targetArr[i2] = ct.targetArr[i2];
        }
    }

    void replace(NnuId oldObj, NnuId newObj, int type) {
        NnuId[] newArr = new NnuId[this.targetArr[type].length];
        System.arraycopy(this.targetArr[type], 0, newArr, 0, this.targetArr[type].length);
        this.targetArr[type] = newArr;
        NnuIdManager.replace(oldObj, newObj, this.targetArr[type]);
    }

    void dump() {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetArr[i2] == null) continue;
            System.err.println("  " + typeString[i2]);
            for (int j2 = 0; j2 < this.targetArr[i2].length; ++j2) {
                System.err.println("  " + this.targetArr[i2][j2]);
            }
        }
    }
}

