/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.BehaviorStructure;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.BoundingLeafRetained;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.DistanceLOD;
import org.jogamp.java3d.IllegalSceneGraphException;
import org.jogamp.java3d.IllegalSharingException;
import org.jogamp.java3d.IndexedUnorderSet;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LeafRetained;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.View;
import org.jogamp.java3d.ViewPlatformRetained;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.java3d.WakeupCondition;

class BehaviorRetained
extends LeafRetained {
    static final int WAKEUP_ACTIVATE_INDEX = 0;
    static final int WAKEUP_DEACTIVATE_INDEX = 1;
    static final int WAKEUP_VP_ENTRY_INDEX = 2;
    static final int WAKEUP_VP_EXIT_INDEX = 3;
    static final int WAKEUP_TIME_INDEX = 4;
    static final int NUM_WAKEUPS = 5;
    static final int WAKEUP_ACTIVATE = 1;
    static final int WAKEUP_DEACTIVATE = 2;
    static final int WAKEUP_VP_ENTRY = 4;
    static final int WAKEUP_VP_EXIT = 8;
    static final int WAKEUP_TIME = 16;
    static final int NUM_SCHEDULING_INTERVALS = 10;
    static final int BEHAIVORS_IN_BS_LIST = 0;
    static final int SCHEDULE_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    Bounds schedulingRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    WakeupCondition wakeupCondition = null;
    WakeupCondition newWakeupCondition = null;
    ViewPlatformRetained vp = null;
    boolean active = false;
    boolean enable = true;
    int schedulingInterval = 5;
    boolean conditionSet = false;
    boolean inCallback = false;
    boolean inInitCallback = false;
    Bounds transformedRegion = null;
    int isDirty = 65535;
    int wakeupMask = 0;
    int[] wakeupArray = new int[5];
    Object[] targets = new Object[1];

    BehaviorRetained() {
        this.nodeType = 17;
        this.localBounds = new BoundingBox((Bounds)null);
        this.targets[0] = this;
        IndexedUnorderSet.init(this, 2);
    }

    Bounds getSchedulingBounds() {
        Bounds b2 = null;
        if (this.schedulingRegion != null) {
            b2 = (Bounds)this.schedulingRegion.clone();
            if (this.staticTransform != null) {
                Transform3D invTransform = this.staticTransform.getInvTransform();
                b2.transform(invTransform);
            }
        }
        return b2;
    }

    synchronized void setSchedulingBounds(Bounds region) {
        if (region != null) {
            this.schedulingRegion = (Bounds)region.clone();
            if (this.staticTransform != null) {
                this.schedulingRegion.transform(this.staticTransform.transform);
            }
        } else {
            this.schedulingRegion = null;
        }
        if (this.source != null && this.source.isLive()) {
            this.sendMessage(35);
        }
    }

    synchronized void setSchedulingBoundingLeaf(BoundingLeaf region) {
        if (this.source != null && this.source.isLive() && this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        this.boundingLeaf = region != null ? (BoundingLeafRetained)region.retained : null;
        if (this.source != null && this.source.isLive()) {
            if (this.boundingLeaf != null) {
                this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
            }
            this.sendMessage(35);
        }
    }

    void setEnable(boolean state) {
        if (this.enable != state) {
            this.enable = state;
            if (this.source != null && this.source.isLive()) {
                this.sendMessage(state ? 29 : 30);
            }
        }
    }

    boolean getEnable() {
        return this.enable;
    }

    void setSchedulingInterval(int schedulingInterval) {
        if (this.source != null && this.source.isLive() && !this.inCallback) {
            this.sendMessage(55, new Integer(schedulingInterval));
        } else {
            this.schedulingInterval = schedulingInterval;
        }
    }

    int getSchedulingInterval() {
        return this.schedulingInterval;
    }

    BoundingLeaf getSchedulingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    @Override
    synchronized void setLive(SetLiveState s) {
        super.doSetLive(s);
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("BehaviorRetained0"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("BehaviorRetained1"));
        }
        s.nodeList.add(this);
        s.behaviorNodes.add(this);
        s.notifyThreads |= 0x100;
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this, 2);
        }
        this.switchState = s.switchStates.get(0);
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this, 2);
            s.notifyThreads |= 0x2000;
        }
        super.markAsLive();
    }

    @Override
    synchronized void clearLive(SetLiveState s) {
        super.clearLive(s);
        s.nodeList.add(this);
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this, 2);
            s.notifyThreads |= 0x2000;
        }
        s.notifyThreads |= 0x100;
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this, 2);
        }
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeInitialize() {
        BehaviorRetained behaviorRetained = this;
        synchronized (behaviorRetained) {
            boolean inCallbackSaved = this.inCallback;
            boolean inInitCallbackSaved = this.inInitCallback;
            this.inCallback = true;
            this.inInitCallback = true;
            try {
                ((Behavior)this.source).initialize();
            }
            catch (RuntimeException e2) {
                System.err.println("Exception occurred during Behavior initialization:");
                e2.printStackTrace();
            }
            catch (Error e3) {
                System.err.println("Error occurred during Behavior initialization:");
                e3.printStackTrace();
            }
            this.inCallback = inCallbackSaved;
            this.inInitCallback = inInitCallbackSaved;
        }
    }

    void wakeupOn(WakeupCondition criteria) {
        if (criteria == null) {
            throw new NullPointerException(J3dI18N.getString("BehaviorRetained2"));
        }
        if (!this.inInitCallback) {
            this.conditionSet = true;
            this.wakeupCondition = criteria;
        } else {
            this.newWakeupCondition = criteria;
        }
    }

    void handleLastWakeupOn(WakeupCondition prevWakeupCond, BehaviorStructure bs) {
        if (bs == this.universe.behaviorStructure) {
            if (this.wakeupCondition == prevWakeupCond) {
                this.wakeupCondition.resetTree();
            } else {
                if (prevWakeupCond != null) {
                    prevWakeupCond.cleanTree(bs);
                }
                this.wakeupCondition.buildTree(null, 0, this);
            }
        }
    }

    WakeupCondition getWakeupCondition() {
        return this.wakeupCondition;
    }

    void postId(int postId) {
        if (this.source != null && this.source.isLive()) {
            this.universe.behaviorStructure.handleBehaviorPost((Behavior)this.source, postId);
        }
    }

    protected View getView() {
        return this.universe != null ? this.universe.getCurrentView() : null;
    }

    synchronized void updateTransformRegion(Bounds bound) {
        if (this.boundingLeaf == null) {
            this.updateTransformRegion();
        } else if (bound == null) {
            this.transformedRegion = null;
        } else {
            this.transformedRegion = (Bounds)bound.clone();
            this.transformedRegion.transform(this.boundingLeaf.mirrorBoundingLeaf.getCurrentLocalToVworld());
        }
    }

    synchronized void updateTransformRegion() {
        if (this.boundingLeaf == null || !this.boundingLeaf.mirrorBoundingLeaf.switchState.currentSwitchOn) {
            if (this.schedulingRegion == null) {
                this.transformedRegion = null;
            } else {
                if (this.transformedRegion != null) {
                    this.transformedRegion.set(this.schedulingRegion);
                } else {
                    this.transformedRegion = (Bounds)this.schedulingRegion.clone();
                }
                this.transformedRegion.transform(this.getCurrentLocalToVworld());
            }
        } else {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        }
    }

    void updateBoundingLeaf(long refTime) {
        this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
    }

    void addWakeupCondition() {
    }

    final void sendMessage(int mtype, Object arg) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 256;
        createMessage.type = mtype;
        createMessage.universe = this.universe;
        createMessage.args[0] = this.targets;
        createMessage.args[1] = this;
        createMessage.args[2] = arg;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    final void sendMessage(int mtype) {
        this.sendMessage(mtype, null);
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        if (this.schedulingRegion != null) {
            this.schedulingRegion.transform(xform.transform);
        }
        if (this.source instanceof DistanceLOD) {
            ((DistanceLOD)this.source).mergeTransform(xform);
        }
    }
}

