/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.vecmath.Point2f;

class AuralAttributesRetained
extends NodeComponentRetained {
    float attributeGain = 1.0f;
    float rolloff = 1.0f;
    static final float SPEED_OF_SOUND = 0.344f;
    float reflectionCoefficient = 0.0f;
    float reverbCoefficient = 1.0f;
    float reflectionDelay = 20.0f;
    float reverbDelay = 40.0f;
    Bounds reverbBounds = null;
    float decayTime = 1000.0f;
    float decayFilter = 5000.0f;
    float diffusion = 1.0f;
    float density = 1.0f;
    int reverbOrder = 0;
    static final int NO_FILTERING = -1;
    static final int LOW_PASS = 1;
    int filterType = -1;
    float[] distance = null;
    float[] frequencyCutoff = null;
    float frequencyScaleFactor = 1.0f;
    float velocityScaleFactor = 0.0f;
    boolean aaDirty = true;
    AuralAttributesRetained mirrorAa = null;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    AuralAttributesRetained() {
    }

    void debugPrint(String message) {
    }

    void setAttributeGain(float gain) {
        this.attributeGain = gain;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getAttributeGain() {
        return this.attributeGain;
    }

    void setRolloff(float rolloff) {
        this.rolloff = rolloff;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getRolloff() {
        return this.rolloff;
    }

    void setReflectionCoefficient(float reflectionCoefficient) {
        this.reflectionCoefficient = reflectionCoefficient;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReflectionCoefficient() {
        return this.reflectionCoefficient;
    }

    void setReflectionDelay(float reflectionDelay) {
        this.reflectionDelay = reflectionDelay;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReflectionDelay() {
        return this.reflectionDelay;
    }

    void setReverbCoefficient(float reverbCoefficient) {
        this.reverbCoefficient = reverbCoefficient;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReverbCoefficient() {
        return this.reverbCoefficient;
    }

    void setReverbDelay(float reverbDelay) {
        this.reverbDelay = reverbDelay;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getReverbDelay() {
        return this.reverbDelay;
    }

    void setDecayTime(float decayTime) {
        this.decayTime = decayTime;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDecayTime() {
        return this.decayTime;
    }

    void setDecayFilter(float decayFilter) {
        this.decayFilter = decayFilter;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDecayFilter() {
        return this.decayFilter;
    }

    void setDiffusion(float diffusion) {
        this.diffusion = diffusion;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDiffusion() {
        return this.diffusion;
    }

    void setDensity(float density) {
        this.density = density;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getDensity() {
        return this.density;
    }

    synchronized void setReverbBounds(Bounds reverbVolume) {
        this.reverbBounds = reverbVolume;
        this.aaDirty = true;
        this.notifyUsers();
    }

    Bounds getReverbBounds() {
        return this.reverbBounds;
    }

    void setReverbOrder(int reverbOrder) {
        this.reverbOrder = reverbOrder;
        this.aaDirty = true;
        this.notifyUsers();
    }

    int getReverbOrder() {
        return this.reverbOrder;
    }

    synchronized void setDistanceFilter(Point2f[] attenuation) {
        if (attenuation == null) {
            this.filterType = -1;
            return;
        }
        int attenuationLength = attenuation.length;
        if (attenuationLength == 0) {
            this.filterType = -1;
            return;
        }
        this.filterType = 1;
        if (this.distance == null || this.distance != null && this.distance.length != attenuationLength) {
            this.distance = new float[attenuationLength];
            this.frequencyCutoff = new float[attenuationLength];
        }
        for (int i2 = 0; i2 < attenuationLength; ++i2) {
            this.distance[i2] = attenuation[i2].x;
            this.frequencyCutoff[i2] = attenuation[i2].y;
        }
        this.aaDirty = true;
        this.notifyUsers();
    }

    synchronized void setDistanceFilter(float[] distance, float[] filter) {
        if (distance == null || filter == null) {
            this.filterType = -1;
            return;
        }
        int distanceLength = distance.length;
        int filterLength = filter.length;
        if (distanceLength == 0 || filterLength == 0) {
            this.filterType = -1;
            return;
        }
        if (this.distance == null || this.distance != null && this.distance.length != filterLength) {
            this.distance = new float[distanceLength];
            this.frequencyCutoff = new float[distanceLength];
        }
        this.filterType = 1;
        System.arraycopy(distance, 0, this.distance, 0, distanceLength);
        if (distanceLength <= filterLength) {
            System.arraycopy(filter, 0, this.frequencyCutoff, 0, distanceLength);
        } else {
            System.arraycopy(filter, 0, this.frequencyCutoff, 0, filterLength);
            for (int i2 = filterLength; i2 < distanceLength; ++i2) {
                this.frequencyCutoff[i2] = filter[filterLength - 1];
            }
        }
        this.aaDirty = true;
        this.notifyUsers();
    }

    int getDistanceFilterLength() {
        if (this.distance == null) {
            return 0;
        }
        return this.distance.length;
    }

    void getDistanceFilter(Point2f[] attenuation) {
        if (attenuation == null) {
            return;
        }
        if (this.distance == null || this.frequencyCutoff == null) {
            return;
        }
        int distanceLength = this.distance.length;
        if (distanceLength > attenuation.length) {
            distanceLength = attenuation.length;
        }
        for (int i2 = 0; i2 < distanceLength; ++i2) {
            attenuation[i2].x = this.distance[i2];
            if (this.filterType == -1) {
                attenuation[i2].y = -1.0f;
                continue;
            }
            if (this.filterType != 1) continue;
            attenuation[i2].y = this.frequencyCutoff[i2];
        }
    }

    void getDistanceFilter(float[] distance, float[] filter) {
        if (distance == null || filter == null) {
            return;
        }
        if (this.distance == null || this.frequencyCutoff == null) {
            return;
        }
        int distanceLength = this.distance.length;
        if (distance.length < distanceLength) {
            distanceLength = distance.length;
        }
        System.arraycopy(this.distance, 0, distance, 0, distanceLength);
        int filterLength = this.frequencyCutoff.length;
        if (filter.length < filterLength) {
            filterLength = filter.length;
        }
        if (this.filterType == -1) {
            for (int i2 = 0; i2 < filterLength; ++i2) {
                filter[i2] = -1.0f;
            }
        }
        if (this.filterType == 1) {
            System.arraycopy(this.frequencyCutoff, 0, filter, 0, filterLength);
        }
    }

    void setFrequencyScaleFactor(float frequencyScaleFactor) {
        this.frequencyScaleFactor = frequencyScaleFactor;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getFrequencyScaleFactor() {
        return this.frequencyScaleFactor;
    }

    void setVelocityScaleFactor(float velocityScaleFactor) {
        this.velocityScaleFactor = velocityScaleFactor;
        this.aaDirty = true;
        this.notifyUsers();
    }

    float getVelocityScaleFactor() {
        return this.velocityScaleFactor;
    }

    synchronized void reset(AuralAttributesRetained aa) {
        this.attributeGain = aa.attributeGain;
        this.rolloff = aa.rolloff;
        this.reflectionCoefficient = aa.reflectionCoefficient;
        this.reverbCoefficient = aa.reverbCoefficient;
        this.reflectionDelay = aa.reflectionDelay;
        this.reverbDelay = aa.reverbDelay;
        this.reverbBounds = aa.reverbBounds;
        this.reverbOrder = aa.reverbOrder;
        this.decayTime = aa.decayTime;
        this.decayFilter = aa.decayFilter;
        this.diffusion = aa.diffusion;
        this.density = aa.density;
        this.frequencyScaleFactor = aa.frequencyScaleFactor;
        this.velocityScaleFactor = aa.velocityScaleFactor;
        if (aa.distance != null) {
            this.distance = new float[aa.distance.length];
            System.arraycopy(aa.distance, 0, this.distance, 0, this.distance.length);
        }
        if (aa.frequencyCutoff != null) {
            this.frequencyCutoff = new float[aa.frequencyCutoff.length];
            System.arraycopy(aa.frequencyCutoff, 0, this.frequencyCutoff, 0, this.frequencyCutoff.length);
        }
        this.aaDirty = false;
        aa.aaDirty = false;
    }

    void update(AuralAttributesRetained aa) {
        this.reset(aa);
    }
}

