/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.AuralAttributesRetained;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.vecmath.Point2f;

public class AuralAttributes
extends NodeComponent {
    public static final int ALLOW_ATTRIBUTE_GAIN_READ = 0;
    public static final int ALLOW_ATTRIBUTE_GAIN_WRITE = 1;
    public static final int ALLOW_ROLLOFF_READ = 2;
    public static final int ALLOW_ROLLOFF_WRITE = 3;
    public static final int ALLOW_REFLECTION_COEFFICIENT_READ = 4;
    public static final int ALLOW_REFLECTION_COEFFICIENT_WRITE = 5;
    public static final int ALLOW_REFLECTION_DELAY_READ = 16;
    public static final int ALLOW_REFLECTION_DELAY_WRITE = 17;
    public static final int ALLOW_REVERB_COEFFICIENT_READ = 18;
    public static final int ALLOW_REVERB_COEFFICIENT_WRITE = 19;
    public static final int ALLOW_REVERB_DELAY_READ = 6;
    public static final int ALLOW_REVERB_DELAY_WRITE = 7;
    public static final int ALLOW_REVERB_ORDER_READ = 8;
    public static final int ALLOW_REVERB_ORDER_WRITE = 9;
    public static final int ALLOW_DECAY_TIME_READ = 20;
    public static final int ALLOW_DECAY_TIME_WRITE = 21;
    public static final int ALLOW_DECAY_FILTER_READ = 22;
    public static final int ALLOW_DECAY_FILTER_WRITE = 23;
    public static final int ALLOW_DIFFUSION_READ = 24;
    public static final int ALLOW_DIFFUSION_WRITE = 25;
    public static final int ALLOW_DENSITY_READ = 26;
    public static final int ALLOW_DENSITY_WRITE = 27;
    public static final int ALLOW_DISTANCE_FILTER_READ = 10;
    public static final int ALLOW_DISTANCE_FILTER_WRITE = 11;
    public static final int ALLOW_FREQUENCY_SCALE_FACTOR_READ = 12;
    public static final int ALLOW_FREQUENCY_SCALE_FACTOR_WRITE = 13;
    public static final int ALLOW_VELOCITY_SCALE_FACTOR_READ = 14;
    public static final int ALLOW_VELOCITY_SCALE_FACTOR_WRITE = 15;
    private static final int[] readCapabilities = new int[]{0, 22, 20, 26, 24, 10, 12, 4, 16, 18, 6, 8, 2, 14};

    public AuralAttributes() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public AuralAttributes(float gain, float rolloff, float reflectionCoefficient, float reverbDelay, int reverbOrder, Point2f[] distanceFilter, float frequencyScaleFactor, float velocityScaleFactor) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((AuralAttributesRetained)this.retained).setAttributeGain(gain);
        ((AuralAttributesRetained)this.retained).setRolloff(rolloff);
        ((AuralAttributesRetained)this.retained).setReflectionCoefficient(reflectionCoefficient);
        ((AuralAttributesRetained)this.retained).setReverbDelay(reverbDelay);
        ((AuralAttributesRetained)this.retained).setReverbOrder(reverbOrder);
        ((AuralAttributesRetained)this.retained).setDistanceFilter(distanceFilter);
        ((AuralAttributesRetained)this.retained).setFrequencyScaleFactor(frequencyScaleFactor);
        ((AuralAttributesRetained)this.retained).setVelocityScaleFactor(velocityScaleFactor);
    }

    public AuralAttributes(float gain, float rolloff, float reflectionCoefficient, float reverbDelay, int reverbOrder, float[] distance, float[] frequencyCutoff, float frequencyScaleFactor, float velocityScaleFactor) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((AuralAttributesRetained)this.retained).setAttributeGain(gain);
        ((AuralAttributesRetained)this.retained).setRolloff(rolloff);
        ((AuralAttributesRetained)this.retained).setReflectionCoefficient(reflectionCoefficient);
        ((AuralAttributesRetained)this.retained).setReverbDelay(reverbDelay);
        ((AuralAttributesRetained)this.retained).setReverbOrder(reverbOrder);
        ((AuralAttributesRetained)this.retained).setDistanceFilter(distance, frequencyCutoff);
        ((AuralAttributesRetained)this.retained).setFrequencyScaleFactor(frequencyScaleFactor);
        ((AuralAttributesRetained)this.retained).setVelocityScaleFactor(velocityScaleFactor);
    }

    public AuralAttributes(float gain, float rolloff, float reflectionCoefficient, float reflectionDelay, float reverbCoefficient, float reverbDelay, float decayTime, float decayFilter, float diffusion, float density, float[] distance, float[] frequencyCutoff, float frequencyScaleFactor, float velocityScaleFactor) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((AuralAttributesRetained)this.retained).setAttributeGain(gain);
        ((AuralAttributesRetained)this.retained).setRolloff(rolloff);
        ((AuralAttributesRetained)this.retained).setReflectionCoefficient(reflectionCoefficient);
        ((AuralAttributesRetained)this.retained).setReflectionDelay(reflectionDelay);
        ((AuralAttributesRetained)this.retained).setReverbCoefficient(reverbCoefficient);
        ((AuralAttributesRetained)this.retained).setReverbDelay(reverbDelay);
        ((AuralAttributesRetained)this.retained).setDecayTime(decayTime);
        ((AuralAttributesRetained)this.retained).setDecayFilter(decayFilter);
        ((AuralAttributesRetained)this.retained).setDiffusion(diffusion);
        ((AuralAttributesRetained)this.retained).setDensity(density);
        ((AuralAttributesRetained)this.retained).setDistanceFilter(distance, frequencyCutoff);
        ((AuralAttributesRetained)this.retained).setFrequencyScaleFactor(frequencyScaleFactor);
        ((AuralAttributesRetained)this.retained).setVelocityScaleFactor(velocityScaleFactor);
    }

    @Override
    void createRetained() {
        this.retained = new AuralAttributesRetained();
        this.retained.setSource(this);
    }

    public void setAttributeGain(float gain) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes0"));
        }
        ((AuralAttributesRetained)this.retained).setAttributeGain(gain);
    }

    public float getAttributeGain() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes1"));
        }
        return ((AuralAttributesRetained)this.retained).getAttributeGain();
    }

    public void setRolloff(float rolloff) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes2"));
        }
        ((AuralAttributesRetained)this.retained).setRolloff(rolloff);
    }

    public float getRolloff() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes3"));
        }
        return ((AuralAttributesRetained)this.retained).getRolloff();
    }

    public void setReflectionCoefficient(float coefficient) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes4"));
        }
        ((AuralAttributesRetained)this.retained).setReflectionCoefficient(coefficient);
    }

    public float getReflectionCoefficient() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes21"));
        }
        return ((AuralAttributesRetained)this.retained).getReflectionCoefficient();
    }

    public void setReflectionDelay(float reflectionDelay) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes22"));
        }
        ((AuralAttributesRetained)this.retained).setReflectionDelay(reflectionDelay);
    }

    public float getReflectionDelay() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes23"));
        }
        return ((AuralAttributesRetained)this.retained).getReflectionDelay();
    }

    public void setReverbCoefficient(float coefficient) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes24"));
        }
        ((AuralAttributesRetained)this.retained).setReverbCoefficient(coefficient);
    }

    public float getReverbCoefficient() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes25"));
        }
        return ((AuralAttributesRetained)this.retained).getReverbCoefficient();
    }

    public void setReverbDelay(float reverbDelay) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes5"));
        }
        ((AuralAttributesRetained)this.retained).setReverbDelay(reverbDelay);
    }

    public float getReverbDelay() {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes7"));
        }
        return ((AuralAttributesRetained)this.retained).getReverbDelay();
    }

    public void setDecayTime(float decayTime) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes28"));
        }
        ((AuralAttributesRetained)this.retained).setDecayTime(decayTime);
    }

    public float getDecayTime() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes29"));
        }
        return ((AuralAttributesRetained)this.retained).getDecayTime();
    }

    public void setDecayFilter(float frequencyCutoff) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes30"));
        }
        ((AuralAttributesRetained)this.retained).setDecayFilter(frequencyCutoff);
    }

    public float getDecayFilter() {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes31"));
        }
        return ((AuralAttributesRetained)this.retained).getDecayFilter();
    }

    public void setDiffusion(float ratio) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes32"));
        }
        ((AuralAttributesRetained)this.retained).setDiffusion(ratio);
    }

    public float getDiffusion() {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes33"));
        }
        return ((AuralAttributesRetained)this.retained).getDiffusion();
    }

    public void setDensity(float ratio) {
        if (this.isLiveOrCompiled() && !this.getCapability(27)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes34"));
        }
        ((AuralAttributesRetained)this.retained).setDensity(ratio);
    }

    public float getDensity() {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes35"));
        }
        return ((AuralAttributesRetained)this.retained).getDensity();
    }

    public void setReverbDelay(Bounds reverbVolume) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes5"));
        }
        ((AuralAttributesRetained)this.retained).setReverbBounds(reverbVolume);
    }

    public void setReverbBounds(Bounds reverbVolume) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes26"));
        }
        ((AuralAttributesRetained)this.retained).setReverbBounds(reverbVolume);
    }

    public Bounds getReverbBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes27"));
        }
        return ((AuralAttributesRetained)this.retained).getReverbBounds();
    }

    public void setReverbOrder(int reverbOrder) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes8"));
        }
        ((AuralAttributesRetained)this.retained).setReverbOrder(reverbOrder);
    }

    public int getReverbOrder() {
        if (!this.getCapability(8) && this.isLiveOrCompiled()) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes9"));
        }
        return ((AuralAttributesRetained)this.retained).getReverbOrder();
    }

    public void setDistanceFilter(Point2f[] attenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes10"));
        }
        ((AuralAttributesRetained)this.retained).setDistanceFilter(attenuation);
    }

    public void setDistanceFilter(float[] distance, float[] frequencyCutoff) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes10"));
        }
        ((AuralAttributesRetained)this.retained).setDistanceFilter(distance, frequencyCutoff);
    }

    public int getDistanceFilterLength() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes12"));
        }
        return ((AuralAttributesRetained)this.retained).getDistanceFilterLength();
    }

    public void getDistanceFilter(Point2f[] attenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes12"));
        }
        ((AuralAttributesRetained)this.retained).getDistanceFilter(attenuation);
    }

    public void getDistanceFilter(float[] distance, float[] frequencyCutoff) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes12"));
        }
        ((AuralAttributesRetained)this.retained).getDistanceFilter(distance, frequencyCutoff);
    }

    public void setFrequencyScaleFactor(float frequencyScaleFactor) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes15"));
        }
        ((AuralAttributesRetained)this.retained).setFrequencyScaleFactor(frequencyScaleFactor);
    }

    public float getFrequencyScaleFactor() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes17"));
        }
        return ((AuralAttributesRetained)this.retained).getFrequencyScaleFactor();
    }

    public void setVelocityScaleFactor(float velocityScaleFactor) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes19"));
        }
        ((AuralAttributesRetained)this.retained).setVelocityScaleFactor(velocityScaleFactor);
    }

    public float getVelocityScaleFactor() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AuralAttributes20"));
        }
        return ((AuralAttributesRetained)this.retained).getVelocityScaleFactor();
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        AuralAttributes a2 = new AuralAttributes();
        a2.duplicateNodeComponent(this, this.forceDuplicate);
        return a2;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        AuralAttributesRetained aural = (AuralAttributesRetained)originalNodeComponent.retained;
        AuralAttributesRetained rt = (AuralAttributesRetained)this.retained;
        rt.setAttributeGain(aural.getAttributeGain());
        rt.setRolloff(aural.getRolloff());
        rt.setReflectionCoefficient(aural.getReflectionCoefficient());
        rt.setReverbDelay(aural.getReverbDelay());
        rt.setReverbOrder(aural.getReverbOrder());
        rt.setReverbBounds(aural.getReverbBounds());
        rt.setFrequencyScaleFactor(aural.getFrequencyScaleFactor());
        rt.setVelocityScaleFactor(aural.getVelocityScaleFactor());
        int len = aural.getDistanceFilterLength();
        float[] distance = new float[len];
        float[] frequencyCutoff = new float[len];
        aural.getDistanceFilter(distance, frequencyCutoff);
        rt.setDistanceFilter(distance, frequencyCutoff);
    }
}

