/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.ColoringAttributesRetained;
import org.jogamp.java3d.CompileState;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.LineAttributesRetained;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.MaterialRetained;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.PointAttributes;
import org.jogamp.java3d.PointAttributesRetained;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.PolygonAttributesRetained;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.RenderingAttributesRetained;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.TexCoordGeneration;
import org.jogamp.java3d.TexCoordGenerationRetained;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TextureAttributesRetained;
import org.jogamp.java3d.TextureRetained;
import org.jogamp.java3d.TextureUnitState;
import org.jogamp.java3d.TextureUnitStateRetained;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.TransparencyAttributesRetained;
import org.jogamp.java3d.VirtualUniverse;

class AppearanceRetained
extends NodeComponentRetained {
    MaterialRetained material = null;
    TextureRetained texture = null;
    TexCoordGenerationRetained texCoordGeneration = null;
    TextureAttributesRetained textureAttributes = null;
    TextureUnitStateRetained[] texUnitState = null;
    ColoringAttributesRetained coloringAttributes = null;
    TransparencyAttributesRetained transparencyAttributes = null;
    RenderingAttributesRetained renderingAttributes = null;
    PolygonAttributesRetained polygonAttributes = null;
    LineAttributesRetained lineAttributes = null;
    PointAttributesRetained pointAttributes = null;
    Object liveStateLock = new Object();
    CompileState map = null;
    AppearanceRetained mapAppearance = null;
    static final int MATERIAL = 1;
    static final int TEXTURE = 2;
    static final int TEXCOORD_GEN = 4;
    static final int TEXTURE_ATTR = 8;
    static final int COLOR = 16;
    static final int TRANSPARENCY = 32;
    static final int RENDERING = 64;
    static final int POLYGON = 128;
    static final int LINE = 256;
    static final int POINT = 512;
    static final int TEXTURE_UNIT_STATE = 1024;
    static final int ALL_SOLE_USERS = 0;
    AppearanceRetained sgApp = null;

    AppearanceRetained() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaterial(Material material) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.material != null) {
                    this.material.clearLive(this.refCount);
                    this.material.removeMirrorUsers(this);
                }
                if (material != null) {
                    ((MaterialRetained)material.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((MaterialRetained)material.retained).copyMirrorUsers(this);
                }
                this.sendMessage(1, material != null ? ((MaterialRetained)material.retained).mirror : null, true);
            }
            this.material = material == null ? null : (MaterialRetained)material.retained;
        }
    }

    Material getMaterial() {
        return this.material == null ? null : (Material)this.material.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTexture(Texture texture) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.texture != null) {
                    this.texture.clearLive(this.refCount);
                    this.texture.removeMirrorUsers(this);
                }
                if (texture != null) {
                    ((TextureRetained)texture.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((TextureRetained)texture.retained).copyMirrorUsers(this);
                }
                this.sendMessage(2, texture != null ? ((TextureRetained)texture.retained).mirror : null, true);
            }
            this.texture = texture == null ? null : (TextureRetained)texture.retained;
        }
    }

    Texture getTexture() {
        return this.texture == null ? null : (Texture)this.texture.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTextureAttributes(TextureAttributes textureAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.textureAttributes != null) {
                    this.textureAttributes.clearLive(this.refCount);
                    this.textureAttributes.removeMirrorUsers(this);
                }
                if (textureAttributes != null) {
                    ((TextureAttributesRetained)textureAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((TextureAttributesRetained)textureAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(8, textureAttributes != null ? ((TextureAttributesRetained)textureAttributes.retained).mirror : null, true);
            }
            this.textureAttributes = textureAttributes == null ? null : (TextureAttributesRetained)textureAttributes.retained;
        }
    }

    TextureAttributes getTextureAttributes() {
        return this.textureAttributes == null ? null : (TextureAttributes)this.textureAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setColoringAttributes(ColoringAttributes coloringAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.coloringAttributes != null) {
                    this.coloringAttributes.clearLive(this.refCount);
                    this.coloringAttributes.removeMirrorUsers(this);
                }
                if (coloringAttributes != null) {
                    ((ColoringAttributesRetained)coloringAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((ColoringAttributesRetained)coloringAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(16, coloringAttributes != null ? ((ColoringAttributesRetained)coloringAttributes.retained).mirror : null, true);
            }
            this.coloringAttributes = coloringAttributes == null ? null : (ColoringAttributesRetained)coloringAttributes.retained;
        }
    }

    ColoringAttributes getColoringAttributes() {
        return this.coloringAttributes == null ? null : (ColoringAttributes)this.coloringAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransparencyAttributes(TransparencyAttributes transparencyAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.transparencyAttributes != null) {
                    this.transparencyAttributes.clearLive(this.refCount);
                    this.transparencyAttributes.removeMirrorUsers(this);
                }
                if (transparencyAttributes != null) {
                    ((TransparencyAttributesRetained)transparencyAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((TransparencyAttributesRetained)transparencyAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(32, transparencyAttributes != null ? ((TransparencyAttributesRetained)transparencyAttributes.retained).mirror : null, true);
            }
            this.transparencyAttributes = transparencyAttributes == null ? null : (TransparencyAttributesRetained)transparencyAttributes.retained;
        }
    }

    TransparencyAttributes getTransparencyAttributes() {
        return this.transparencyAttributes == null ? null : (TransparencyAttributes)this.transparencyAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRenderingAttributes(RenderingAttributes renderingAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.renderingAttributes != null) {
                    this.renderingAttributes.clearLive(this.refCount);
                    this.renderingAttributes.removeMirrorUsers(this);
                }
                if (renderingAttributes != null) {
                    ((RenderingAttributesRetained)renderingAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((RenderingAttributesRetained)renderingAttributes.retained).copyMirrorUsers(this);
                }
                NodeComponentRetained m2 = null;
                boolean v = true;
                if (renderingAttributes != null) {
                    m2 = ((RenderingAttributesRetained)renderingAttributes.retained).mirror;
                    v = ((RenderingAttributesRetained)renderingAttributes.retained).visible;
                }
                this.sendMessage(64, m2, v);
                this.sendRenderingAttributesChangedMessage(v);
            }
            this.renderingAttributes = renderingAttributes == null ? null : (RenderingAttributesRetained)renderingAttributes.retained;
        }
    }

    RenderingAttributes getRenderingAttributes() {
        if (this.renderingAttributes == null) {
            return null;
        }
        return (RenderingAttributes)this.renderingAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPolygonAttributes(PolygonAttributes polygonAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.polygonAttributes != null) {
                    this.polygonAttributes.clearLive(this.refCount);
                    this.polygonAttributes.removeMirrorUsers(this);
                }
                if (polygonAttributes != null) {
                    ((PolygonAttributesRetained)polygonAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((PolygonAttributesRetained)polygonAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(128, polygonAttributes != null ? ((PolygonAttributesRetained)polygonAttributes.retained).mirror : null, true);
            }
            this.polygonAttributes = polygonAttributes == null ? null : (PolygonAttributesRetained)polygonAttributes.retained;
        }
    }

    PolygonAttributes getPolygonAttributes() {
        return this.polygonAttributes == null ? null : (PolygonAttributes)this.polygonAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLineAttributes(LineAttributes lineAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.lineAttributes != null) {
                    this.lineAttributes.clearLive(this.refCount);
                    this.lineAttributes.removeMirrorUsers(this);
                }
                if (lineAttributes != null) {
                    ((LineAttributesRetained)lineAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((LineAttributesRetained)lineAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(256, lineAttributes != null ? ((LineAttributesRetained)lineAttributes.retained).mirror : null, true);
            }
            this.lineAttributes = lineAttributes == null ? null : (LineAttributesRetained)lineAttributes.retained;
        }
    }

    LineAttributes getLineAttributes() {
        return this.lineAttributes == null ? null : (LineAttributes)this.lineAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPointAttributes(PointAttributes pointAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.pointAttributes != null) {
                    this.pointAttributes.clearLive(this.refCount);
                    this.pointAttributes.removeMirrorUsers(this);
                }
                if (pointAttributes != null) {
                    ((PointAttributesRetained)pointAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((PointAttributesRetained)pointAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(512, pointAttributes != null ? ((PointAttributesRetained)pointAttributes.retained).mirror : null, true);
            }
            this.pointAttributes = pointAttributes == null ? null : (PointAttributesRetained)pointAttributes.retained;
        }
    }

    PointAttributes getPointAttributes() {
        return this.pointAttributes == null ? null : (PointAttributes)this.pointAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTexCoordGeneration(TexCoordGeneration texGen) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.texCoordGeneration != null) {
                    this.texCoordGeneration.clearLive(this.refCount);
                    this.texCoordGeneration.removeMirrorUsers(this);
                }
                if (texGen != null) {
                    ((TexCoordGenerationRetained)texGen.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((TexCoordGenerationRetained)texGen.retained).copyMirrorUsers(this);
                }
                this.sendMessage(4, texGen != null ? ((TexCoordGenerationRetained)texGen.retained).mirror : null, true);
            }
            this.texCoordGeneration = texGen == null ? null : (TexCoordGenerationRetained)texGen.retained;
        }
    }

    TexCoordGeneration getTexCoordGeneration() {
        return this.texCoordGeneration == null ? null : (TexCoordGeneration)this.texCoordGeneration.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTextureUnitState(TextureUnitState[] stateArray) {
        Object object = this.liveStateLock;
        synchronized (object) {
            int i2;
            if (this.source.isLive()) {
                if (this.texUnitState != null) {
                    for (i2 = 0; i2 < this.texUnitState.length; ++i2) {
                        if (this.texUnitState[i2] == null) continue;
                        this.texUnitState[i2].clearLive(this.refCount);
                        this.texUnitState[i2].removeMirrorUsers(this);
                    }
                }
                if (stateArray != null && stateArray.length > 0) {
                    TextureUnitStateRetained[] mirrorStateArray = new TextureUnitStateRetained[stateArray.length];
                    Object[] args = new Object[]{new Integer(-1), mirrorStateArray};
                    for (i2 = 0; i2 < stateArray.length; ++i2) {
                        TextureUnitState tu = stateArray[i2];
                        if (tu != null) {
                            ((TextureUnitStateRetained)tu.retained).setLive(this.inBackgroundGroup, this.refCount);
                            ((TextureUnitStateRetained)tu.retained).copyMirrorUsers(this);
                            mirrorStateArray[i2] = (TextureUnitStateRetained)((TextureUnitStateRetained)tu.retained).mirror;
                            continue;
                        }
                        mirrorStateArray[i2] = null;
                    }
                    this.sendMessage(1024, args, true);
                } else {
                    this.sendMessage(1024, null, true);
                }
            }
            if (stateArray == null) {
                this.texUnitState = null;
            } else {
                if (this.texUnitState == null || this.texUnitState.length != stateArray.length) {
                    this.texUnitState = new TextureUnitStateRetained[stateArray.length];
                }
                for (i2 = 0; i2 < stateArray.length; ++i2) {
                    this.texUnitState[i2] = stateArray[i2] != null ? (TextureUnitStateRetained)stateArray[i2].retained : null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTextureUnitState(int index, TextureUnitState state) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.texUnitState[index] != null) {
                    this.texUnitState[index].clearLive(this.refCount);
                    this.texUnitState[index].removeMirrorUsers(this);
                }
                Object[] args = new Object[2];
                args[0] = new Integer(index);
                if (state != null) {
                    ((TextureUnitStateRetained)state.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((TextureUnitStateRetained)state.retained).copyMirrorUsers(this);
                    args[1] = ((TextureUnitStateRetained)state.retained).mirror;
                    this.sendMessage(1024, args, true);
                } else {
                    args[1] = null;
                    this.sendMessage(1024, args, true);
                }
            }
            this.texUnitState[index] = state != null ? (TextureUnitStateRetained)state.retained : null;
        }
    }

    TextureUnitState[] getTextureUnitState() {
        if (this.texUnitState == null) {
            return null;
        }
        TextureUnitState[] tus = new TextureUnitState[this.texUnitState.length];
        for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
            tus[i2] = this.texUnitState[i2] != null ? (TextureUnitState)this.texUnitState[i2].source : null;
        }
        return tus;
    }

    TextureUnitState getTextureUnitState(int index) {
        if (this.texUnitState[index] != null) {
            return (TextureUnitState)this.texUnitState[index].source;
        }
        return null;
    }

    int getTextureUnitCount() {
        if (this.texUnitState == null) {
            return 0;
        }
        return this.texUnitState.length;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            this.mirror = new AppearanceRetained();
        }
        this.initMirrorObject();
    }

    @Override
    synchronized void initMirrorObject() {
        AppearanceRetained mirrorApp = (AppearanceRetained)this.mirror;
        mirrorApp.source = this.source;
        mirrorApp.sgApp = this;
        mirrorApp.changedFrequent = this.changedFrequent;
        mirrorApp.material = this.material != null ? (MaterialRetained)this.material.mirror : null;
        mirrorApp.texture = this.texture != null ? (TextureRetained)this.texture.mirror : null;
        mirrorApp.texCoordGeneration = this.texCoordGeneration != null ? (TexCoordGenerationRetained)this.texCoordGeneration.mirror : null;
        mirrorApp.textureAttributes = this.textureAttributes != null ? (TextureAttributesRetained)this.textureAttributes.mirror : null;
        if (this.texUnitState != null && this.texUnitState.length > 0) {
            mirrorApp.texUnitState = new TextureUnitStateRetained[this.texUnitState.length];
            for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
                if (this.texUnitState[i2] == null) continue;
                mirrorApp.texUnitState[i2] = (TextureUnitStateRetained)this.texUnitState[i2].mirror;
            }
        } else if (mirrorApp.texture != null || mirrorApp.textureAttributes != null || mirrorApp.texCoordGeneration != null) {
            mirrorApp.texUnitState = new TextureUnitStateRetained[1];
            mirrorApp.texUnitState[0] = new TextureUnitStateRetained();
            mirrorApp.texUnitState[0].set(mirrorApp.texture, mirrorApp.textureAttributes, mirrorApp.texCoordGeneration);
        }
        mirrorApp.coloringAttributes = this.coloringAttributes != null ? (ColoringAttributesRetained)this.coloringAttributes.mirror : null;
        mirrorApp.transparencyAttributes = this.transparencyAttributes != null ? (TransparencyAttributesRetained)this.transparencyAttributes.mirror : null;
        mirrorApp.renderingAttributes = this.renderingAttributes != null ? (RenderingAttributesRetained)this.renderingAttributes.mirror : null;
        mirrorApp.polygonAttributes = this.polygonAttributes != null ? (PolygonAttributesRetained)this.polygonAttributes.mirror : null;
        mirrorApp.lineAttributes = this.lineAttributes != null ? (LineAttributesRetained)this.lineAttributes.mirror : null;
        mirrorApp.pointAttributes = this.pointAttributes != null ? (PointAttributesRetained)this.pointAttributes.mirror : null;
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        AppearanceRetained mirrorApp = (AppearanceRetained)this.mirror;
        if ((component & 1) != 0) {
            mirrorApp.material = (MaterialRetained)value;
        } else if ((component & 2) != 0) {
            mirrorApp.texture = (TextureRetained)value;
            if (mirrorApp.texUnitState == null) {
                mirrorApp.texUnitState = new TextureUnitStateRetained[1];
                mirrorApp.texUnitState[0] = new TextureUnitStateRetained();
            }
            mirrorApp.texUnitState[0].texture = (TextureRetained)value;
        } else if ((component & 4) != 0) {
            if (mirrorApp.texUnitState == null) {
                mirrorApp.texUnitState = new TextureUnitStateRetained[1];
                mirrorApp.texUnitState[0] = new TextureUnitStateRetained();
            }
            mirrorApp.texUnitState[0].texGen = (TexCoordGenerationRetained)value;
        } else if ((component & 8) != 0) {
            if (mirrorApp.texUnitState == null) {
                mirrorApp.texUnitState = new TextureUnitStateRetained[1];
                mirrorApp.texUnitState[0] = new TextureUnitStateRetained();
            }
            mirrorApp.texUnitState[0].texAttrs = (TextureAttributesRetained)value;
        } else if ((component & 0x400) != 0) {
            Object[] args = (Object[])value;
            if (args == null) {
                mirrorApp.texUnitState = null;
            } else {
                int index = (Integer)args[0];
                if (index == -1) {
                    mirrorApp.texUnitState = (TextureUnitStateRetained[])args[1];
                } else {
                    mirrorApp.texUnitState[index] = (TextureUnitStateRetained)args[1];
                }
            }
        } else if ((component & 0x10) != 0) {
            mirrorApp.coloringAttributes = (ColoringAttributesRetained)value;
        } else if ((component & 0x20) != 0) {
            mirrorApp.transparencyAttributes = (TransparencyAttributesRetained)value;
        } else if ((component & 0x40) != 0) {
            mirrorApp.renderingAttributes = (RenderingAttributesRetained)value;
        } else if ((component & 0x80) != 0) {
            mirrorApp.polygonAttributes = (PolygonAttributesRetained)value;
        } else if ((component & 0x100) != 0) {
            mirrorApp.lineAttributes = (LineAttributesRetained)value;
        } else if ((component & 0x200) != 0) {
            mirrorApp.pointAttributes = (PointAttributesRetained)value;
        }
    }

    @Override
    void setLive(boolean backgroundGroup, int refCount) {
        this.doSetLive(backgroundGroup, refCount);
        this.markAsLive();
    }

    @Override
    void doSetLive(boolean backgroundGroup, int refCount) {
        if (this.material != null) {
            this.material.setLive(backgroundGroup, refCount);
        }
        if (this.texture != null) {
            this.texture.setLive(backgroundGroup, refCount);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.setLive(backgroundGroup, refCount);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.setLive(backgroundGroup, refCount);
        }
        if (this.texUnitState != null) {
            for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
                if (this.texUnitState[i2] == null) continue;
                this.texUnitState[i2].setLive(backgroundGroup, refCount);
            }
        }
        if (this.coloringAttributes != null) {
            this.coloringAttributes.setLive(backgroundGroup, refCount);
        }
        if (this.transparencyAttributes != null) {
            this.transparencyAttributes.setLive(backgroundGroup, refCount);
        }
        if (this.renderingAttributes != null) {
            this.renderingAttributes.setLive(backgroundGroup, refCount);
        }
        if (this.polygonAttributes != null) {
            this.polygonAttributes.setLive(backgroundGroup, refCount);
        }
        if (this.lineAttributes != null) {
            this.lineAttributes.setLive(backgroundGroup, refCount);
        }
        if (this.pointAttributes != null) {
            this.pointAttributes.setLive(backgroundGroup, refCount);
        }
        super.doSetLive(backgroundGroup, refCount);
    }

    @Override
    void clearLive(int refCount) {
        super.clearLive(refCount);
        if (this.texture != null) {
            this.texture.clearLive(refCount);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.clearLive(refCount);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.clearLive(refCount);
        }
        if (this.texUnitState != null) {
            for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
                if (this.texUnitState[i2] == null) continue;
                this.texUnitState[i2].clearLive(refCount);
            }
        }
        if (this.coloringAttributes != null) {
            this.coloringAttributes.clearLive(refCount);
        }
        if (this.transparencyAttributes != null) {
            this.transparencyAttributes.clearLive(refCount);
        }
        if (this.renderingAttributes != null) {
            this.renderingAttributes.clearLive(refCount);
        }
        if (this.polygonAttributes != null) {
            this.polygonAttributes.clearLive(refCount);
        }
        if (this.lineAttributes != null) {
            this.lineAttributes.clearLive(refCount);
        }
        if (this.pointAttributes != null) {
            this.pointAttributes.clearLive(refCount);
        }
        if (this.material != null) {
            this.material.clearLive(refCount);
        }
    }

    @Override
    boolean isStatic() {
        boolean flag;
        boolean bl = flag = !(!this.source.capabilityBitsEmpty() || this.texture != null && !this.texture.source.capabilityBitsEmpty() || this.texCoordGeneration != null && !this.texCoordGeneration.source.capabilityBitsEmpty() || this.textureAttributes != null && !this.textureAttributes.source.capabilityBitsEmpty() || this.coloringAttributes != null && !this.coloringAttributes.source.capabilityBitsEmpty() || this.transparencyAttributes != null && !this.transparencyAttributes.source.capabilityBitsEmpty() || this.renderingAttributes != null && !this.renderingAttributes.source.capabilityBitsEmpty() || this.polygonAttributes != null && !this.polygonAttributes.source.capabilityBitsEmpty() || this.lineAttributes != null && !this.lineAttributes.source.capabilityBitsEmpty() || this.pointAttributes != null && !this.pointAttributes.source.capabilityBitsEmpty() || this.material != null && !this.material.source.capabilityBitsEmpty());
        if (!flag) {
            return flag;
        }
        if (this.texUnitState != null) {
            for (int i2 = 0; i2 < this.texUnitState.length && flag; ++i2) {
                if (this.texUnitState[i2] == null) continue;
                flag = flag && this.texUnitState[i2].isStatic();
            }
        }
        return flag;
    }

    @Override
    void compile(CompileState compState) {
        this.setCompiled();
        if (this.texture != null) {
            this.texture.compile(compState);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.compile(compState);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.compile(compState);
        }
        if (this.texUnitState != null) {
            for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
                if (this.texUnitState[i2] == null) continue;
                this.texUnitState[i2].compile(compState);
            }
        }
        if (this.coloringAttributes != null) {
            this.coloringAttributes.compile(compState);
        }
        if (this.transparencyAttributes != null) {
            this.transparencyAttributes.compile(compState);
        }
        if (this.renderingAttributes != null) {
            this.renderingAttributes.compile(compState);
        }
        if (this.polygonAttributes != null) {
            this.polygonAttributes.compile(compState);
        }
        if (this.lineAttributes != null) {
            this.lineAttributes.compile(compState);
        }
        if (this.pointAttributes != null) {
            this.pointAttributes.compile(compState);
        }
        if (this.material != null) {
            this.material.compile(compState);
        }
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AppearanceRetained && this.equals((AppearanceRetained)obj);
    }

    boolean equals(AppearanceRetained app) {
        boolean flag;
        boolean bl = flag = app == this || app != null && (this.material == app.material || this.material != null && this.material.equivalent(app.material)) && (this.texture == app.texture || this.texture != null && this.texture.equals(app.texture)) && (this.renderingAttributes == app.renderingAttributes || this.renderingAttributes != null && this.renderingAttributes.equivalent(app.renderingAttributes)) && (this.polygonAttributes == app.polygonAttributes || this.polygonAttributes != null && this.polygonAttributes.equivalent(app.polygonAttributes)) && (this.texCoordGeneration == app.texCoordGeneration || this.texCoordGeneration != null && this.texCoordGeneration.equivalent(app.texCoordGeneration)) && (this.textureAttributes == app.textureAttributes || this.textureAttributes != null && this.textureAttributes.equivalent(app.textureAttributes)) && (this.coloringAttributes == app.coloringAttributes || this.coloringAttributes != null && this.coloringAttributes.equivalent(app.coloringAttributes)) && (this.transparencyAttributes == app.transparencyAttributes || this.transparencyAttributes != null && this.transparencyAttributes.equivalent(app.transparencyAttributes)) && (this.lineAttributes == app.lineAttributes || this.lineAttributes != null && this.lineAttributes.equivalent(app.lineAttributes)) && (this.pointAttributes == app.pointAttributes || this.pointAttributes != null && this.pointAttributes.equivalent(app.pointAttributes));
        if (!flag) {
            return flag;
        }
        if (this.texUnitState == app.texUnitState) {
            return flag;
        }
        if (this.texUnitState == null || app.texUnitState == null || this.texUnitState.length != app.texUnitState.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
            if (this.texUnitState[i2] == app.texUnitState[i2] || this.texUnitState[i2] != null && app.texUnitState[i2] != null && this.texUnitState[i2].equals(app.texUnitState[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    synchronized void addAMirrorUser(Shape3DRetained shape) {
        super.addAMirrorUser(shape);
        if (this.material != null) {
            this.material.addAMirrorUser(shape);
        }
        if (this.texture != null) {
            this.texture.addAMirrorUser(shape);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.addAMirrorUser(shape);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.addAMirrorUser(shape);
        }
        if (this.texUnitState != null) {
            for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
                if (this.texUnitState[i2] == null) continue;
                this.texUnitState[i2].addAMirrorUser(shape);
            }
        }
        if (this.coloringAttributes != null) {
            this.coloringAttributes.addAMirrorUser(shape);
        }
        if (this.transparencyAttributes != null) {
            this.transparencyAttributes.addAMirrorUser(shape);
        }
        if (this.renderingAttributes != null) {
            this.renderingAttributes.addAMirrorUser(shape);
        }
        if (this.polygonAttributes != null) {
            this.polygonAttributes.addAMirrorUser(shape);
        }
        if (this.lineAttributes != null) {
            this.lineAttributes.addAMirrorUser(shape);
        }
        if (this.pointAttributes != null) {
            this.pointAttributes.addAMirrorUser(shape);
        }
    }

    @Override
    synchronized void removeAMirrorUser(Shape3DRetained shape) {
        super.removeAMirrorUser(shape);
        if (this.material != null) {
            this.material.removeAMirrorUser(shape);
        }
        if (this.texture != null) {
            this.texture.removeAMirrorUser(shape);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.removeAMirrorUser(shape);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.removeAMirrorUser(shape);
        }
        if (this.texUnitState != null) {
            for (int i2 = 0; i2 < this.texUnitState.length; ++i2) {
                if (this.texUnitState[i2] == null) continue;
                this.texUnitState[i2].removeAMirrorUser(shape);
            }
        }
        if (this.coloringAttributes != null) {
            this.coloringAttributes.removeAMirrorUser(shape);
        }
        if (this.transparencyAttributes != null) {
            this.transparencyAttributes.removeAMirrorUser(shape);
        }
        if (this.renderingAttributes != null) {
            this.renderingAttributes.removeAMirrorUser(shape);
        }
        if (this.polygonAttributes != null) {
            this.polygonAttributes.removeAMirrorUser(shape);
        }
        if (this.lineAttributes != null) {
            this.lineAttributes.removeAMirrorUser(shape);
        }
        if (this.pointAttributes != null) {
            this.pointAttributes.removeAMirrorUser(shape);
        }
    }

    final void sendMessage(int attrMask, Object attr, boolean visible) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 18;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i2 = 0; i2 < univList.size(); ++i2) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 18;
            createMessage.universe = univList.get(i2);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i2);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            if (attrMask == 64) {
                createMessage.args[4] = attr != null ? (visible ? Boolean.TRUE : Boolean.FALSE) : Boolean.TRUE;
            }
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    final void sendRenderingAttributesChangedMessage(boolean visible) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        for (int i2 = 0; i2 < univList.size(); ++i2) {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 64;
            createMessage.type = 10;
            createMessage.universe = univList.get(i2);
            createMessage.args[0] = this;
            createMessage.args[1] = null;
            createMessage.args[2] = visible ? Boolean.TRUE : Boolean.FALSE;
            ArrayList<GeometryAtom> gL = gaList.get(i2);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    boolean isOpaque(int geoType) {
        if (TransparencyAttributesRetained.useAlpha(this.transparencyAttributes)) {
            return false;
        }
        switch (geoType) {
            case 3: 
            case 10: {
                if (this.pointAttributes == null || !this.pointAttributes.pointAntialiasing) break;
                return false;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                if (this.lineAttributes == null || !this.lineAttributes.lineAntialiasing) break;
                return false;
            }
            case 15: 
            case 17: {
                break;
            }
            default: {
                if (this.polygonAttributes == null) break;
                if (this.polygonAttributes.polygonMode == 0 && this.pointAttributes != null && this.pointAttributes.pointAntialiasing) {
                    return false;
                }
                if (this.polygonAttributes.polygonMode != 1 || this.lineAttributes == null || !this.lineAttributes.lineAntialiasing) break;
                return false;
            }
        }
        return true;
    }

    @Override
    void handleFrequencyChange(int bit) {
        int mask = 0;
        if (bit == 9) {
            mask = 16;
        } else if (bit == 11) {
            mask = 32;
        } else if (bit == 13) {
            mask = 64;
        } else if (bit == 15) {
            mask = 128;
        } else if (bit == 17) {
            mask = 256;
        } else if (bit == 19) {
            mask = 512;
        } else if (bit == 1) {
            mask = 1;
        } else if (bit == 3) {
            mask = 2;
        } else if (bit == 7) {
            mask = 8;
        } else if (bit == 5) {
            mask = 4;
        } else if (bit == 21) {
            mask = 1024;
        }
        if (mask != 0) {
            this.setFrequencyChangeMask(bit, mask);
        }
    }
}

