/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSingle;

public class PngChunkPLTE
extends PngChunkSingle {
    public static final String ID = "PLTE";
    private int nentries = 0;
    private int[] entries;

    public PngChunkPLTE(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    @Override
    public ChunkRaw createRawChunk() {
        int n2 = 3 * this.nentries;
        int[] nArray = new int[3];
        ChunkRaw chunkRaw = this.createEmptyChunk(n2, true);
        int n3 = 0;
        for (int i2 = 0; i2 < this.nentries; ++i2) {
            this.getEntryRgb(i2, nArray);
            chunkRaw.data[n3++] = (byte)nArray[0];
            chunkRaw.data[n3++] = (byte)nArray[1];
            chunkRaw.data[n3++] = (byte)nArray[2];
        }
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        this.setNentries(chunkRaw.len / 3);
        int n2 = 0;
        for (int i2 = 0; i2 < this.nentries; ++i2) {
            this.setEntry(i2, chunkRaw.data[n2++] & 0xFF, chunkRaw.data[n2++] & 0xFF, chunkRaw.data[n2++] & 0xFF);
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkPLTE pngChunkPLTE = (PngChunkPLTE)pngChunk;
        this.setNentries(pngChunkPLTE.getNentries());
        System.arraycopy(pngChunkPLTE.entries, 0, this.entries, 0, this.nentries);
    }

    public void setNentries(int n2) {
        this.nentries = n2;
        if (this.nentries < 1 || this.nentries > 256) {
            throw new PngjException("invalid pallette - nentries=" + this.nentries);
        }
        if (this.entries == null || this.entries.length != this.nentries) {
            this.entries = new int[this.nentries];
        }
    }

    public int getNentries() {
        return this.nentries;
    }

    public void setEntry(int n2, int n3, int n4, int n5) {
        this.entries[n2] = n3 << 16 | n4 << 8 | n5;
    }

    public int getEntry(int n2) {
        return this.entries[n2];
    }

    public void getEntryRgb(int n2, int[] nArray) {
        this.getEntryRgb(n2, nArray, 0);
    }

    public void getEntryRgb(int n2, int[] nArray, int n3) {
        int n4 = this.entries[n2];
        nArray[n3 + 0] = (n4 & 0xFF0000) >> 16;
        nArray[n3 + 1] = (n4 & 0xFF00) >> 8;
        nArray[n3 + 2] = n4 & 0xFF;
    }

    public int minBitDepth() {
        if (this.nentries <= 2) {
            return 1;
        }
        if (this.nentries <= 4) {
            return 2;
        }
        if (this.nentries <= 16) {
            return 4;
        }
        return 8;
    }
}

