/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import jogamp.opengl.util.pngj.FilterType;
import jogamp.opengl.util.pngj.FilterWriteStrategy;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngIDatChunkOutputStream;
import jogamp.opengl.util.pngj.PngReader;
import jogamp.opengl.util.pngj.PngjExceptionInternal;
import jogamp.opengl.util.pngj.PngjOutputException;
import jogamp.opengl.util.pngj.PngjUnsupportedException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunksListForWrite;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkIEND;
import jogamp.opengl.util.pngj.chunks.PngChunkIHDR;
import jogamp.opengl.util.pngj.chunks.PngChunkSkipped;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;
import jogamp.opengl.util.pngj.chunks.PngMetadata;

public class PngWriter {
    public final ImageInfo imgInfo;
    private final String filename;
    protected int rowNum = -1;
    private final ChunksListForWrite chunksList;
    private final PngMetadata metadata;
    protected int currentChunkGroup = -1;
    protected FilterWriteStrategy filterStrat;
    private int compLevel = 6;
    private boolean shouldCloseStream = true;
    private PngIDatChunkOutputStream datStream;
    private DeflaterOutputStream datStreamDeflated;
    private int deflaterStrategy = 1;
    private final int[] histox = new int[256];
    private int idatMaxSize = 0;
    private final OutputStream os;
    protected byte[] rowb = null;
    protected byte[] rowbfilter = null;
    protected byte[] rowbprev = null;
    private boolean unpackedMode = false;

    public PngWriter(OutputStream outputStream, ImageInfo imageInfo) {
        this(outputStream, imageInfo, "[NO FILENAME AVAILABLE]");
    }

    public PngWriter(OutputStream outputStream, ImageInfo imageInfo, String string) {
        this.filename = string == null ? "" : string;
        this.os = outputStream;
        this.imgInfo = imageInfo;
        this.rowb = new byte[imageInfo.bytesPerRow + 1];
        this.rowbprev = new byte[this.rowb.length];
        this.rowbfilter = new byte[this.rowb.length];
        this.chunksList = new ChunksListForWrite(imageInfo);
        this.metadata = new PngMetadata(this.chunksList);
        this.filterStrat = new FilterWriteStrategy(imageInfo, FilterType.FILTER_DEFAULT);
    }

    private void init() {
        this.datStream = new PngIDatChunkOutputStream(this.os, this.idatMaxSize);
        Deflater deflater = new Deflater(this.compLevel);
        deflater.setStrategy(this.deflaterStrategy);
        this.datStreamDeflated = new DeflaterOutputStream((OutputStream)this.datStream, deflater);
        this.writeSignatureAndIHDR();
        this.writeFirstChunks();
    }

    private void reportResultsForFilter(int n2, FilterType filterType, boolean bl) {
        Arrays.fill(this.histox, 0);
        int n3 = 0;
        for (int i2 = 1; i2 <= this.imgInfo.bytesPerRow; ++i2) {
            byte by = this.rowbfilter[i2];
            n3 = by < 0 ? (n3 -= by) : (n3 += by);
            int n4 = by & 0xFF;
            this.histox[n4] = this.histox[n4] + 1;
        }
        this.filterStrat.fillResultsForFilter(n2, filterType, n3, this.histox, bl);
    }

    private void writeEndChunk() {
        PngChunkIEND pngChunkIEND = new PngChunkIEND(this.imgInfo);
        pngChunkIEND.createRawChunk().writeChunk(this.os);
    }

    private void writeFirstChunks() {
        int n2 = 0;
        this.currentChunkGroup = 1;
        n2 = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 2;
        n2 = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        if (n2 > 0 && this.imgInfo.greyscale) {
            throw new PngjOutputException("cannot write palette for this format");
        }
        if (n2 == 0 && this.imgInfo.indexed) {
            throw new PngjOutputException("missing palette");
        }
        this.currentChunkGroup = 3;
        n2 = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 4;
    }

    private void writeLastChunks() {
        this.currentChunkGroup = 5;
        this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        List<PngChunk> list = this.chunksList.getQueuedChunks();
        if (!list.isEmpty()) {
            throw new PngjOutputException(list.size() + " chunks were not written! Eg: " + list.get(0).toString());
        }
        this.currentChunkGroup = 6;
    }

    private void writeSignatureAndIHDR() {
        this.currentChunkGroup = 0;
        PngHelperInternal.writeBytes(this.os, PngHelperInternal.getPngIdSignature());
        PngChunkIHDR pngChunkIHDR = new PngChunkIHDR(this.imgInfo);
        pngChunkIHDR.setCols(this.imgInfo.cols);
        pngChunkIHDR.setRows(this.imgInfo.rows);
        pngChunkIHDR.setBitspc(this.imgInfo.bitDepth);
        int n2 = 0;
        if (this.imgInfo.alpha) {
            n2 += 4;
        }
        if (this.imgInfo.indexed) {
            ++n2;
        }
        if (!this.imgInfo.greyscale) {
            n2 += 2;
        }
        pngChunkIHDR.setColormodel(n2);
        pngChunkIHDR.setCompmeth(0);
        pngChunkIHDR.setFilmeth(0);
        pngChunkIHDR.setInterlaced(0);
        pngChunkIHDR.createRawChunk().writeChunk(this.os);
    }

    protected void encodeRowFromByte(byte[] byArray) {
        if (byArray.length == this.imgInfo.samplesPerRowPacked) {
            int n2 = 1;
            if (this.imgInfo.bitDepth <= 8) {
                for (byte by : byArray) {
                    this.rowb[n2++] = by;
                }
            } else {
                byte[] byArray2 = byArray;
                int n3 = byArray2.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    byte by;
                    this.rowb[n2] = by = byArray2[i2];
                    n2 += 2;
                }
            }
        } else {
            if (byArray.length >= this.imgInfo.samplesPerRow && this.unpackedMode) {
                ImageLine.packInplaceByte(this.imgInfo, byArray, byArray, false);
            }
            if (this.imgInfo.bitDepth <= 8) {
                int n4 = 1;
                for (int i3 = 0; i3 < this.imgInfo.samplesPerRowPacked; ++i3) {
                    this.rowb[n4++] = byArray[i3];
                }
            } else {
                int n5 = 1;
                for (int i4 = 0; i4 < this.imgInfo.samplesPerRowPacked; ++i4) {
                    this.rowb[n5++] = byArray[i4];
                    this.rowb[n5++] = 0;
                }
            }
        }
    }

    protected void encodeRowFromInt(int[] nArray) {
        if (nArray.length == this.imgInfo.samplesPerRowPacked) {
            int n2 = 1;
            if (this.imgInfo.bitDepth <= 8) {
                for (int n3 : nArray) {
                    this.rowb[n2++] = (byte)n3;
                }
            } else {
                for (int n4 : nArray) {
                    this.rowb[n2++] = (byte)(n4 >> 8);
                    this.rowb[n2++] = (byte)n4;
                }
            }
        } else {
            if (nArray.length >= this.imgInfo.samplesPerRow && this.unpackedMode) {
                ImageLine.packInplaceInt(this.imgInfo, nArray, nArray, false);
            }
            if (this.imgInfo.bitDepth <= 8) {
                int n5 = 1;
                for (int i2 = 0; i2 < this.imgInfo.samplesPerRowPacked; ++i2) {
                    this.rowb[n5++] = (byte)nArray[i2];
                }
            } else {
                int n6 = 1;
                for (int i3 = 0; i3 < this.imgInfo.samplesPerRowPacked; ++i3) {
                    this.rowb[n6++] = (byte)(nArray[i3] >> 8);
                    this.rowb[n6++] = (byte)nArray[i3];
                }
            }
        }
    }

    private void filterRow(int n2) {
        if (this.filterStrat.shouldTestAll(n2)) {
            this.filterRowNone();
            this.reportResultsForFilter(n2, FilterType.FILTER_NONE, true);
            this.filterRowSub();
            this.reportResultsForFilter(n2, FilterType.FILTER_SUB, true);
            this.filterRowUp();
            this.reportResultsForFilter(n2, FilterType.FILTER_UP, true);
            this.filterRowAverage();
            this.reportResultsForFilter(n2, FilterType.FILTER_AVERAGE, true);
            this.filterRowPaeth();
            this.reportResultsForFilter(n2, FilterType.FILTER_PAETH, true);
        }
        FilterType filterType = this.filterStrat.gimmeFilterType(n2, true);
        this.rowbfilter[0] = (byte)filterType.val;
        switch (filterType) {
            case FILTER_NONE: {
                this.filterRowNone();
                break;
            }
            case FILTER_SUB: {
                this.filterRowSub();
                break;
            }
            case FILTER_UP: {
                this.filterRowUp();
                break;
            }
            case FILTER_AVERAGE: {
                this.filterRowAverage();
                break;
            }
            case FILTER_PAETH: {
                this.filterRowPaeth();
                break;
            }
            default: {
                throw new PngjUnsupportedException("Filter type " + (Object)((Object)filterType) + " not implemented");
            }
        }
        this.reportResultsForFilter(n2, filterType, false);
    }

    private void prepareEncodeRow(int n2) {
        if (this.datStream == null) {
            this.init();
        }
        ++this.rowNum;
        if (n2 >= 0 && this.rowNum != n2) {
            throw new PngjOutputException("rows must be written in order: expected:" + this.rowNum + " passed:" + n2);
        }
        byte[] byArray = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = byArray;
    }

    private void filterAndSend(int n2) {
        this.filterRow(n2);
        try {
            this.datStreamDeflated.write(this.rowbfilter, 0, this.imgInfo.bytesPerRow + 1);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    protected void filterRowAverage() {
        int n2 = this.imgInfo.bytesPerRow;
        int n3 = 1 - this.imgInfo.bytesPixel;
        int n4 = 1;
        while (n4 <= n2) {
            this.rowbfilter[n4] = (byte)(this.rowb[n4] - ((this.rowbprev[n4] & 0xFF) + (n3 > 0 ? this.rowb[n3] & 0xFF : 0)) / 2);
            ++n4;
            ++n3;
        }
    }

    protected void filterRowNone() {
        for (int i2 = 1; i2 <= this.imgInfo.bytesPerRow; ++i2) {
            this.rowbfilter[i2] = this.rowb[i2];
        }
    }

    protected void filterRowPaeth() {
        int n2 = this.imgInfo.bytesPerRow;
        int n3 = 1 - this.imgInfo.bytesPixel;
        int n4 = 1;
        while (n4 <= n2) {
            this.rowbfilter[n4] = (byte)PngHelperInternal.filterRowPaeth(this.rowb[n4], n3 > 0 ? this.rowb[n3] & 0xFF : 0, this.rowbprev[n4] & 0xFF, n3 > 0 ? this.rowbprev[n3] & 0xFF : 0);
            ++n4;
            ++n3;
        }
    }

    protected void filterRowSub() {
        int n2;
        for (n2 = 1; n2 <= this.imgInfo.bytesPixel; ++n2) {
            this.rowbfilter[n2] = this.rowb[n2];
        }
        int n3 = 1;
        n2 = this.imgInfo.bytesPixel + 1;
        while (n2 <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[n2] = (byte)PngHelperInternal.filterRowSub(this.rowb[n2], this.rowb[n3]);
            ++n2;
            ++n3;
        }
    }

    protected void filterRowUp() {
        for (int i2 = 1; i2 <= this.imgInfo.bytesPerRow; ++i2) {
            this.rowbfilter[i2] = (byte)PngHelperInternal.filterRowUp(this.rowb[i2], this.rowbprev[i2]);
        }
    }

    protected int sumRowbfilter() {
        int n2 = 0;
        for (int i2 = 1; i2 <= this.imgInfo.bytesPerRow; ++i2) {
            if (this.rowbfilter[i2] < 0) {
                n2 -= this.rowbfilter[i2];
                continue;
            }
            n2 += this.rowbfilter[i2];
        }
        return n2;
    }

    private void copyChunks(PngReader pngReader, int n2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.currentChunkGroup >= 4;
        if (bl && pngReader.getCurrentChunkGroup() < 6) {
            throw new PngjExceptionInternal("tried to copy last chunks but reader has not ended");
        }
        for (PngChunk pngChunk : pngReader.getChunksList().getChunks()) {
            int n3 = pngChunk.getChunkGroup();
            if (n3 < 4 && bl2) continue;
            boolean bl4 = false;
            if (pngChunk.crit) {
                if (pngChunk.id.equals("PLTE")) {
                    if (this.imgInfo.indexed && ChunkHelper.maskMatch(n2, 1)) {
                        bl4 = true;
                    }
                    if (!this.imgInfo.greyscale && ChunkHelper.maskMatch(n2, 8)) {
                        bl4 = true;
                    }
                }
            } else {
                boolean bl5 = pngChunk instanceof PngChunkTextVar;
                boolean bl6 = pngChunk.safe;
                if (ChunkHelper.maskMatch(n2, 8)) {
                    bl4 = true;
                }
                if (bl6 && ChunkHelper.maskMatch(n2, 4)) {
                    bl4 = true;
                }
                if (pngChunk.id.equals("tRNS") && ChunkHelper.maskMatch(n2, 64)) {
                    bl4 = true;
                }
                if (pngChunk.id.equals("pHYs") && ChunkHelper.maskMatch(n2, 16)) {
                    bl4 = true;
                }
                if (bl5 && ChunkHelper.maskMatch(n2, 32)) {
                    bl4 = true;
                }
                if (!(!ChunkHelper.maskMatch(n2, 256) || ChunkHelper.isUnknown(pngChunk) || bl5 || pngChunk.id.equals("hIST") || pngChunk.id.equals("tIME"))) {
                    bl4 = true;
                }
                if (pngChunk instanceof PngChunkSkipped) {
                    bl4 = false;
                }
            }
            if (!bl4) continue;
            this.chunksList.queue(PngChunk.cloneChunk(pngChunk, this.imgInfo));
        }
    }

    public void copyChunksFirst(PngReader pngReader, int n2) {
        this.copyChunks(pngReader, n2, false);
    }

    public void copyChunksLast(PngReader pngReader, int n2) {
        this.copyChunks(pngReader, n2, true);
    }

    public double computeCompressionRatio() {
        if (this.currentChunkGroup < 6) {
            throw new PngjOutputException("must be called after end()");
        }
        double d2 = this.datStream.getCountFlushed();
        double d3 = (this.imgInfo.bytesPerRow + 1) * this.imgInfo.rows;
        return d2 / d3;
    }

    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            this.datStreamDeflated.finish();
            this.datStream.flush();
            this.writeLastChunks();
            this.writeEndChunk();
            if (this.shouldCloseStream) {
                this.os.close();
            }
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public ChunksListForWrite getChunksList() {
        return this.chunksList;
    }

    public String getFilename() {
        return this.filename;
    }

    public PngMetadata getMetadata() {
        return this.metadata;
    }

    public void setCompLevel(int n2) {
        if (n2 < 0 || n2 > 9) {
            throw new PngjOutputException("Compression level invalid (" + n2 + ") Must be 0..9");
        }
        this.compLevel = n2;
    }

    public void setFilterType(FilterType filterType) {
        this.filterStrat = new FilterWriteStrategy(this.imgInfo, filterType);
    }

    public void setIdatMaxSize(int n2) {
        this.idatMaxSize = n2;
    }

    public void setShouldCloseStream(boolean bl) {
        this.shouldCloseStream = bl;
    }

    public void setDeflaterStrategy(int n2) {
        this.deflaterStrategy = n2;
    }

    public void writeRow(ImageLine imageLine) {
        this.writeRow(imageLine.scanline, imageLine.getRown());
    }

    public void writeRow(ImageLine imageLine, int n2) {
        this.unpackedMode = imageLine.samplesUnpacked;
        if (imageLine.sampleType == ImageLine.SampleType.INT) {
            this.writeRowInt(imageLine.scanline, n2);
        } else {
            this.writeRowByte(imageLine.scanlineb, n2);
        }
    }

    public void writeRow(int[] nArray) {
        this.writeRow(nArray, -1);
    }

    public void writeRow(int[] nArray, int n2) {
        this.writeRowInt(nArray, n2);
    }

    public void writeRowInt(int[] nArray, int n2) {
        this.prepareEncodeRow(n2);
        this.encodeRowFromInt(nArray);
        this.filterAndSend(n2);
    }

    public void writeRowByte(byte[] byArray, int n2) {
        this.prepareEncodeRow(n2);
        this.encodeRowFromByte(byArray);
        this.filterAndSend(n2);
    }

    public void writeRowsInt(int[][] nArray) {
        for (int i2 = 0; i2 < this.imgInfo.rows; ++i2) {
            this.writeRowInt(nArray[i2], i2);
        }
    }

    public void writeRowsByte(byte[][] byArray) {
        for (int i2 = 0; i2 < this.imgInfo.rows; ++i2) {
            this.writeRowByte(byArray[i2], i2);
        }
    }

    public boolean isUnpackedMode() {
        return this.unpackedMode;
    }

    public void setUseUnPackedMode(boolean bl) {
        this.unpackedMode = bl;
    }
}

