/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.glsl.fixedfunc;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.ValueConv;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.fixedfunc.GLLightingFunc;
import com.jogamp.opengl.fixedfunc.GLMatrixFunc;
import com.jogamp.opengl.fixedfunc.GLPointerFunc;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.fixedfunc.ShaderSelectionMode;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import jogamp.opengl.util.glsl.fixedfunc.FixedFuncPipeline;

public class FixedFuncHook
implements GLLightingFunc,
GLMatrixFunc,
GLPointerFunc {
    public static final int MAX_TEXTURE_UNITS = 8;
    protected final GLProfile gl2es1GLProfile;
    protected FixedFuncPipeline fixedFunction;
    protected PMVMatrix pmvMatrix;
    protected boolean ownsPMVMatrix;
    protected GL2ES2 gl;

    public FixedFuncHook(GL2ES2 gL2ES2, ShaderSelectionMode shaderSelectionMode, PMVMatrix pMVMatrix) {
        this.gl2es1GLProfile = GLProfile.createCustomGLProfile("GL2ES1", gL2ES2.getGLProfile().getImpl());
        this.gl = gL2ES2;
        if (null != pMVMatrix) {
            this.ownsPMVMatrix = false;
            this.pmvMatrix = pMVMatrix;
        } else {
            this.ownsPMVMatrix = true;
            this.pmvMatrix = new PMVMatrix();
        }
        this.fixedFunction = new FixedFuncPipeline(this.gl, shaderSelectionMode, this.pmvMatrix);
    }

    public FixedFuncHook(GL2ES2 gL2ES2, ShaderSelectionMode shaderSelectionMode, PMVMatrix pMVMatrix, Class<?> clazz, String string, String string2, String string3, String string4, String string5, String string6) {
        this.gl2es1GLProfile = GLProfile.createCustomGLProfile("GL2ES1", gL2ES2.getGLProfile().getImpl());
        this.gl = gL2ES2;
        if (null != pMVMatrix) {
            this.ownsPMVMatrix = false;
            this.pmvMatrix = pMVMatrix;
        } else {
            this.ownsPMVMatrix = true;
            this.pmvMatrix = new PMVMatrix();
        }
        this.fixedFunction = new FixedFuncPipeline(this.gl, shaderSelectionMode, this.pmvMatrix, clazz, string, string2, string3, string4, string5, string6);
    }

    public boolean verbose() {
        return this.fixedFunction.verbose();
    }

    public void setVerbose(boolean bl) {
        this.fixedFunction.setVerbose(bl);
    }

    public void destroy() {
        this.fixedFunction.destroy(this.gl);
        this.fixedFunction = null;
        this.pmvMatrix = null;
        this.gl = null;
    }

    public PMVMatrix getMatrix() {
        return this.pmvMatrix;
    }

    public final boolean isGL4core() {
        return false;
    }

    public final boolean isGL3core() {
        return false;
    }

    public final boolean isGLcore() {
        return false;
    }

    public final boolean isGLES2Compatible() {
        return false;
    }

    public final boolean isGLES3Compatible() {
        return false;
    }

    public final GLProfile getGLProfile() {
        return this.gl2es1GLProfile;
    }

    public void glDrawArrays(int n2, int n3, int n4) {
        this.fixedFunction.glDrawArrays(this.gl, n2, n3, n4);
    }

    public void glDrawElements(int n2, int n3, int n4, Buffer buffer) {
        this.fixedFunction.glDrawElements(this.gl, n2, n3, n4, buffer);
    }

    public void glDrawElements(int n2, int n3, int n4, long l2) {
        this.fixedFunction.glDrawElements(this.gl, n2, n3, n4, l2);
    }

    public void glActiveTexture(int n2) {
        this.fixedFunction.glActiveTexture(n2);
        this.gl.glActiveTexture(n2);
    }

    public void glEnable(int n2) {
        if (this.fixedFunction.glEnable(n2, true)) {
            this.gl.glEnable(n2);
        }
    }

    public void glDisable(int n2) {
        if (this.fixedFunction.glEnable(n2, false)) {
            this.gl.glDisable(n2);
        }
    }

    @Override
    public void glGetFloatv(int n2, FloatBuffer floatBuffer) {
        if (PMVMatrix.isMatrixGetName(n2)) {
            this.pmvMatrix.glGetFloatv(n2, floatBuffer);
            return;
        }
        this.gl.glGetFloatv(n2, floatBuffer);
    }

    @Override
    public void glGetFloatv(int n2, float[] fArray, int n3) {
        if (PMVMatrix.isMatrixGetName(n2)) {
            this.pmvMatrix.glGetFloatv(n2, fArray, n3);
            return;
        }
        this.gl.glGetFloatv(n2, fArray, n3);
    }

    @Override
    public void glGetIntegerv(int n2, IntBuffer intBuffer) {
        if (PMVMatrix.isMatrixGetName(n2)) {
            this.pmvMatrix.glGetIntegerv(n2, intBuffer);
            return;
        }
        this.gl.glGetIntegerv(n2, intBuffer);
    }

    @Override
    public void glGetIntegerv(int n2, int[] nArray, int n3) {
        if (PMVMatrix.isMatrixGetName(n2)) {
            this.pmvMatrix.glGetIntegerv(n2, nArray, n3);
            return;
        }
        this.gl.glGetIntegerv(n2, nArray, n3);
    }

    public void glTexEnvi(int n2, int n3, int n4) {
        this.fixedFunction.glTexEnvi(n2, n3, n4);
    }

    public void glGetTexEnviv(int n2, int n3, IntBuffer intBuffer) {
        this.fixedFunction.glGetTexEnviv(n2, n3, intBuffer);
    }

    public void glGetTexEnviv(int n2, int n3, int[] nArray, int n4) {
        this.fixedFunction.glGetTexEnviv(n2, n3, nArray, n4);
    }

    public void glBindTexture(int n2, int n3) {
        this.fixedFunction.glBindTexture(n2, n3);
        this.gl.glBindTexture(n2, n3);
    }

    public void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        switch (n4) {
            case 3: {
                n4 = 6408 == n8 ? 6408 : 6407;
                break;
            }
            case 4: {
                n4 = 6407 == n8 ? 6407 : 6408;
            }
        }
        this.fixedFunction.glTexImage2D(n2, n4, n8);
        this.gl.glTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9, buffer);
    }

    public void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        switch (n4) {
            case 3: {
                n4 = 6408 == n8 ? 6408 : 6407;
                break;
            }
            case 4: {
                n4 = 6407 == n8 ? 6407 : 6408;
            }
        }
        this.fixedFunction.glTexImage2D(n2, n4, n8);
        this.gl.glTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9, l2);
    }

    public void glPointSize(float f2) {
        this.fixedFunction.glPointSize(f2);
    }

    public void glPointParameterf(int n2, float f2) {
        this.fixedFunction.glPointParameterf(n2, f2);
    }

    public void glPointParameterfv(int n2, float[] fArray, int n3) {
        this.fixedFunction.glPointParameterfv(n2, fArray, n3);
    }

    public void glPointParameterfv(int n2, FloatBuffer floatBuffer) {
        this.fixedFunction.glPointParameterfv(n2, floatBuffer);
    }

    public int glGetMatrixMode() {
        return this.pmvMatrix.glGetMatrixMode();
    }

    @Override
    public void glMatrixMode(int n2) {
        this.pmvMatrix.glMatrixMode(n2);
    }

    @Override
    public void glLoadMatrixf(FloatBuffer floatBuffer) {
        this.pmvMatrix.glLoadMatrixf(floatBuffer);
    }

    @Override
    public void glLoadMatrixf(float[] fArray, int n2) {
        this.glLoadMatrixf(Buffers.newDirectFloatBuffer(fArray, n2));
    }

    @Override
    public void glPopMatrix() {
        this.pmvMatrix.glPopMatrix();
    }

    @Override
    public void glPushMatrix() {
        this.pmvMatrix.glPushMatrix();
    }

    @Override
    public void glLoadIdentity() {
        this.pmvMatrix.glLoadIdentity();
    }

    @Override
    public void glMultMatrixf(FloatBuffer floatBuffer) {
        this.pmvMatrix.glMultMatrixf(floatBuffer);
    }

    @Override
    public void glMultMatrixf(float[] fArray, int n2) {
        this.glMultMatrixf(Buffers.newDirectFloatBuffer(fArray, n2));
    }

    @Override
    public void glTranslatef(float f2, float f3, float f4) {
        this.pmvMatrix.glTranslatef(f2, f3, f4);
    }

    @Override
    public void glRotatef(float f2, float f3, float f4, float f5) {
        this.pmvMatrix.glRotatef(f2, f3, f4, f5);
    }

    @Override
    public void glScalef(float f2, float f3, float f4) {
        this.pmvMatrix.glScalef(f2, f3, f4);
    }

    public void glOrtho(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.glOrthof((float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7);
    }

    @Override
    public void glOrthof(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.pmvMatrix.glOrthof(f2, f3, f4, f5, f6, f7);
    }

    public void glFrustum(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.glFrustumf((float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7);
    }

    @Override
    public void glFrustumf(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.pmvMatrix.glFrustumf(f2, f3, f4, f5, f6, f7);
    }

    @Override
    public void glColor4f(float f2, float f3, float f4, float f5) {
        this.fixedFunction.glColor4f(this.gl, f2, f3, f4, f5);
    }

    public void glColor4ub(byte by, byte by2, byte by3, byte by4) {
        this.glColor4f(ValueConv.byte_to_float(by, false), ValueConv.byte_to_float(by2, false), ValueConv.byte_to_float(by3, false), ValueConv.byte_to_float(by4, false));
    }

    @Override
    public void glLightfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.fixedFunction.glLightfv(this.gl, n2, n3, floatBuffer);
    }

    @Override
    public void glLightfv(int n2, int n3, float[] fArray, int n4) {
        this.glLightfv(n2, n3, Buffers.newDirectFloatBuffer(fArray, n4));
    }

    @Override
    public void glMaterialfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.fixedFunction.glMaterialfv(this.gl, n2, n3, floatBuffer);
    }

    @Override
    public void glMaterialfv(int n2, int n3, float[] fArray, int n4) {
        this.glMaterialfv(n2, n3, Buffers.newDirectFloatBuffer(fArray, n4));
    }

    @Override
    public void glMaterialf(int n2, int n3, float f2) {
        this.glMaterialfv(n2, n3, Buffers.newDirectFloatBuffer(new float[]{f2}));
    }

    @Override
    public void glShadeModel(int n2) {
        this.fixedFunction.glShadeModel(this.gl, n2);
    }

    public void glAlphaFunc(int n2, float f2) {
        this.fixedFunction.glAlphaFunc(n2, f2);
    }

    public void glClientActiveTexture(int n2) {
        this.fixedFunction.glClientActiveTexture(n2);
    }

    @Override
    public void glEnableClientState(int n2) {
        this.fixedFunction.glEnableClientState(this.gl, n2);
    }

    @Override
    public void glDisableClientState(int n2) {
        this.fixedFunction.glDisableClientState(this.gl, n2);
    }

    @Override
    public void glVertexPointer(GLArrayData gLArrayData) {
        if (gLArrayData.isVBO()) {
            if (!this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not enabled: " + gLArrayData);
            }
        } else {
            if (this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not disabled: " + gLArrayData);
            }
            Buffers.rangeCheck(gLArrayData.getBuffer(), 1);
            if (!Buffers.isDirect(gLArrayData.getBuffer())) {
                throw new GLException("Argument \"pointer\" was not a direct buffer");
            }
        }
        this.fixedFunction.glVertexPointer(this.gl, gLArrayData);
    }

    @Override
    public void glVertexPointer(int n2, int n3, int n4, Buffer buffer) {
        this.glVertexPointer(GLArrayDataWrapper.createFixed(32884, n2, n3, GLBuffers.isGLTypeFixedPoint(n3), n4, buffer, 0, 0L, 0, 34962));
    }

    @Override
    public void glVertexPointer(int n2, int n3, int n4, long l2) {
        int n5 = this.gl.getBoundBuffer(34962);
        if (n5 == 0) {
            throw new GLException("no GL_ARRAY_BUFFER VBO bound");
        }
        this.glVertexPointer(GLArrayDataWrapper.createFixed(32884, n2, n3, GLBuffers.isGLTypeFixedPoint(n3), n4, null, n5, l2, 35044, 34962));
    }

    @Override
    public void glColorPointer(GLArrayData gLArrayData) {
        if (gLArrayData.isVBO()) {
            if (!this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not enabled: " + gLArrayData);
            }
        } else {
            if (this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not disabled: " + gLArrayData);
            }
            Buffers.rangeCheck(gLArrayData.getBuffer(), 1);
            if (!Buffers.isDirect(gLArrayData.getBuffer())) {
                throw new GLException("Argument \"pointer\" was not a direct buffer");
            }
        }
        this.fixedFunction.glColorPointer(this.gl, gLArrayData);
    }

    @Override
    public void glColorPointer(int n2, int n3, int n4, Buffer buffer) {
        this.glColorPointer(GLArrayDataWrapper.createFixed(32886, n2, n3, GLBuffers.isGLTypeFixedPoint(n3), n4, buffer, 0, 0L, 0, 34962));
    }

    @Override
    public void glColorPointer(int n2, int n3, int n4, long l2) {
        int n5 = this.gl.getBoundBuffer(34962);
        if (n5 == 0) {
            throw new GLException("no GL_ARRAY_BUFFER VBO bound");
        }
        this.glColorPointer(GLArrayDataWrapper.createFixed(32886, n2, n3, GLBuffers.isGLTypeFixedPoint(n3), n4, null, n5, l2, 35044, 34962));
    }

    @Override
    public void glNormalPointer(GLArrayData gLArrayData) {
        if (gLArrayData.getComponentCount() != 3) {
            throw new GLException("Only 3 components per normal allowed");
        }
        if (gLArrayData.isVBO()) {
            if (!this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not enabled: " + gLArrayData);
            }
        } else {
            if (this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not disabled: " + gLArrayData);
            }
            Buffers.rangeCheck(gLArrayData.getBuffer(), 1);
            if (!Buffers.isDirect(gLArrayData.getBuffer())) {
                throw new GLException("Argument \"pointer\" was not a direct buffer");
            }
        }
        this.fixedFunction.glNormalPointer(this.gl, gLArrayData);
    }

    @Override
    public void glNormalPointer(int n2, int n3, Buffer buffer) {
        this.glNormalPointer(GLArrayDataWrapper.createFixed(32885, 3, n2, GLBuffers.isGLTypeFixedPoint(n2), n3, buffer, 0, 0L, 0, 34962));
    }

    @Override
    public void glNormalPointer(int n2, int n3, long l2) {
        int n4 = this.gl.getBoundBuffer(34962);
        if (n4 == 0) {
            throw new GLException("no GL_ARRAY_BUFFER VBO bound");
        }
        this.glNormalPointer(GLArrayDataWrapper.createFixed(32885, 3, n2, GLBuffers.isGLTypeFixedPoint(n2), n3, null, n4, l2, 35044, 34962));
    }

    @Override
    public void glTexCoordPointer(GLArrayData gLArrayData) {
        if (gLArrayData.isVBO()) {
            if (!this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not enabled: " + gLArrayData);
            }
        } else {
            if (this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not disabled: " + gLArrayData);
            }
            Buffers.rangeCheck(gLArrayData.getBuffer(), 1);
            if (!Buffers.isDirect(gLArrayData.getBuffer())) {
                throw new GLException("Argument \"pointer\" was not a direct buffer");
            }
        }
        this.fixedFunction.glTexCoordPointer(this.gl, gLArrayData);
    }

    @Override
    public void glTexCoordPointer(int n2, int n3, int n4, Buffer buffer) {
        this.glTexCoordPointer(GLArrayDataWrapper.createFixed(32888, n2, n3, GLBuffers.isGLTypeFixedPoint(n3), n4, buffer, 0, 0L, 0, 34962));
    }

    @Override
    public void glTexCoordPointer(int n2, int n3, int n4, long l2) {
        int n5 = this.gl.getBoundBuffer(34962);
        if (n5 == 0) {
            throw new GLException("no GL_ARRAY_BUFFER VBO bound");
        }
        this.glTexCoordPointer(GLArrayDataWrapper.createFixed(32888, n2, n3, GLBuffers.isGLTypeFixedPoint(n3), n4, null, n5, l2, 35044, 34962));
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName() + " (");
        if (null != this.pmvMatrix) {
            stringBuilder.append(", matrixDirty: " + (0 != this.pmvMatrix.getModifiedBits(false)));
        }
        stringBuilder.append("\n\t, FixedFunction: " + this.fixedFunction);
        stringBuilder.append(this.gl);
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }
}

