/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.oculusvr.stereo.lense;

public class LensConfig {
    public static final int NumCoefficients = 11;
    private DistortionEquation eqn;
    float MetersPerTanAngleAtCenter;
    private final float[] K;
    private final float[] InvK;
    private float MaxR;
    private float MaxInvR;
    private final float[] ChromaticAberration = new float[4];

    public LensConfig() {
        this.K = new float[11];
        this.InvK = new float[11];
        this.SetToIdentity();
    }

    public LensConfig(DistortionEquation distortionEquation, float f2, float[] fArray) {
        this.K = new float[11];
        this.InvK = new float[11];
        this.SetToIdentity();
        this.eqn = distortionEquation;
        this.MetersPerTanAngleAtCenter = f2;
        System.arraycopy(fArray, 0, this.K, 0, fArray.length);
        this.ChromaticAberration[0] = -0.006f;
        this.ChromaticAberration[1] = 0.0f;
        this.ChromaticAberration[2] = 0.014f;
        this.ChromaticAberration[3] = 0.0f;
    }

    private void SetUpInverseApprox() {
        switch (this.eqn) {
            case RecipPoly4: {
                float[] fArray = new float[4];
                float[] fArray2 = new float[4];
                float[] fArray3 = new float[4];
                float[] fArray4 = new float[4];
                float f2 = this.MaxInvR;
                fArray[0] = 0.0f;
                fArray[1] = f2 * 0.4f;
                fArray[2] = f2 * 0.8f;
                fArray[3] = f2 * 1.5f;
                for (int i2 = 0; i2 < 4; ++i2) {
                    fArray2[i2] = fArray[i2] * fArray[i2];
                    fArray3[i2] = this.DistortionFnInverse(fArray[i2]);
                    fArray4[i2] = fArray[i2] / fArray3[i2];
                }
                fArray4[0] = 1.0f;
                LensConfig.FitCubicPolynomial(this.InvK, fArray2, fArray4);
                break;
            }
            case CatmullRom10: {
                for (int i3 = 1; i3 < 11; ++i3) {
                    float f3 = i3;
                    float f4 = f3 * this.MaxInvR * this.MaxInvR / 10.0f;
                    float f5 = (float)Math.sqrt(f4);
                    float f6 = this.DistortionFnInverse(f5);
                    this.InvK[i3] = f6 / f5;
                    this.InvK[0] = 1.0f;
                }
                break;
            }
            default: {
                throw new InternalError("unsupported EQ " + (Object)((Object)this.eqn));
            }
        }
    }

    private void SetToIdentity() {
        for (int i2 = 0; i2 < 11; ++i2) {
            this.K[i2] = 0.0f;
            this.InvK[i2] = 0.0f;
        }
        this.eqn = DistortionEquation.RecipPoly4;
        this.K[0] = 1.0f;
        this.InvK[0] = 1.0f;
        this.MaxR = 1.0f;
        this.MaxInvR = 1.0f;
        this.ChromaticAberration[0] = 0.0f;
        this.ChromaticAberration[1] = 0.0f;
        this.ChromaticAberration[2] = 0.0f;
        this.ChromaticAberration[3] = 0.0f;
        this.MetersPerTanAngleAtCenter = 0.05f;
    }

    public float DistortionFn(float f2) {
        return f2 * this.DistortionFnScaleRadiusSquared(f2 * f2);
    }

    public float DistortionFnInverseApprox(float f2) {
        float f3;
        float f4 = f2 * f2;
        switch (this.eqn) {
            case RecipPoly4: {
                f3 = 1.0f / (this.InvK[0] + f4 * (this.InvK[1] + f4 * (this.InvK[2] + f4 * this.InvK[3])));
                break;
            }
            case CatmullRom10: {
                float f5 = 10.0f * f4 / (this.MaxInvR * this.MaxInvR);
                f3 = LensConfig.EvalCatmullRom10Spline(this.InvK, f5);
                break;
            }
            default: {
                throw new InternalError("unsupported EQ " + (Object)((Object)this.eqn));
            }
        }
        return f2 * f3;
    }

    public float DistortionFnInverse(float f2) {
        float f3 = f2 * 0.25f;
        float f4 = f2 * 0.25f;
        float f5 = Math.abs(f2 - this.DistortionFn(f4));
        for (int i2 = 0; i2 < 20; ++i2) {
            float f6 = f4 + f3;
            float f7 = f4 - f3;
            float f8 = Math.abs(f2 - this.DistortionFn(f6));
            float f9 = Math.abs(f2 - this.DistortionFn(f7));
            if (f8 < f5) {
                f4 = f6;
                f5 = f8;
                continue;
            }
            if (f9 < f5) {
                f4 = f7;
                f5 = f9;
                continue;
            }
            f3 *= 0.5f;
        }
        return f4;
    }

    public float DistortionFnScaleRadiusSquared(float f2) {
        float f3;
        switch (this.eqn) {
            case RecipPoly4: {
                f3 = 1.0f / (this.K[0] + f2 * (this.K[1] + f2 * (this.K[2] + f2 * this.K[3])));
                break;
            }
            case CatmullRom10: {
                float f4 = 10.0f * f2 / (this.MaxR * this.MaxR);
                f3 = LensConfig.EvalCatmullRom10Spline(this.K, f4);
                break;
            }
            default: {
                throw new InternalError("unsupported EQ " + (Object)((Object)this.eqn));
            }
        }
        return f3;
    }

    public float[] DistortionFnScaleRadiusSquaredChroma(float f2) {
        float f3 = this.DistortionFnScaleRadiusSquared(f2);
        float[] fArray = new float[]{f3 * (1.0f + this.ChromaticAberration[0] + f2 * this.ChromaticAberration[1]), f3, f3 * (1.0f + this.ChromaticAberration[2] + f2 * this.ChromaticAberration[3])};
        return fArray;
    }

    private static boolean FitCubicPolynomial(float[] fArray, float[] fArray2, float[] fArray3) {
        float f2 = (fArray2[0] - fArray2[1]) * (fArray2[0] - fArray2[2]) * (fArray2[0] - fArray2[3]);
        float f3 = (fArray2[1] - fArray2[2]) * (fArray2[1] - fArray2[3]) * (fArray2[1] - fArray2[0]);
        float f4 = (fArray2[2] - fArray2[3]) * (fArray2[2] - fArray2[0]) * (fArray2[2] - fArray2[1]);
        float f5 = (fArray2[3] - fArray2[0]) * (fArray2[3] - fArray2[1]) * (fArray2[3] - fArray2[2]);
        if (f2 == 0.0f || f3 == 0.0f || f4 == 0.0f || f5 == 0.0f) {
            return false;
        }
        float f6 = fArray3[0] / f2;
        float f7 = fArray3[1] / f3;
        float f8 = fArray3[2] / f4;
        float f9 = fArray3[3] / f5;
        fArray[0] = -(f6 * fArray2[1] * fArray2[2] * fArray2[3] + f7 * fArray2[0] * fArray2[2] * fArray2[3] + f8 * fArray2[0] * fArray2[1] * fArray2[3] + f9 * fArray2[0] * fArray2[1] * fArray2[2]);
        fArray[1] = f6 * (fArray2[1] * fArray2[2] + fArray2[2] * fArray2[3] + fArray2[3] * fArray2[1]) + f7 * (fArray2[0] * fArray2[2] + fArray2[2] * fArray2[3] + fArray2[3] * fArray2[0]) + f8 * (fArray2[0] * fArray2[1] + fArray2[1] * fArray2[3] + fArray2[3] * fArray2[0]) + f9 * (fArray2[0] * fArray2[1] + fArray2[1] * fArray2[2] + fArray2[2] * fArray2[0]);
        fArray[2] = -(f6 * (fArray2[1] + fArray2[2] + fArray2[3]) + f7 * (fArray2[0] + fArray2[2] + fArray2[3]) + f8 * (fArray2[0] + fArray2[1] + fArray2[3]) + f9 * (fArray2[0] + fArray2[1] + fArray2[2]));
        fArray[3] = f6 + f7 + f8 + f9;
        return true;
    }

    private static float EvalCatmullRom10Spline(float[] fArray, float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7 = (float)Math.floor(f2);
        f7 = Math.max(0.0f, Math.min(10.0f, f7));
        float f8 = f2 - f7;
        int n2 = (int)f7;
        switch (n2) {
            case 0: {
                f6 = 1.0f;
                f5 = fArray[1] - fArray[0];
                f4 = fArray[1];
                f3 = 0.5f * (fArray[2] - fArray[0]);
                break;
            }
            default: {
                f6 = fArray[n2];
                f5 = 0.5f * (fArray[n2 + 1] - fArray[n2 - 1]);
                f4 = fArray[n2 + 1];
                f3 = 0.5f * (fArray[n2 + 2] - fArray[n2]);
                break;
            }
            case 9: {
                f6 = fArray[9];
                f5 = 0.5f * (fArray[10] - fArray[9]);
                f4 = fArray[10];
                f3 = fArray[10] - fArray[9];
                break;
            }
            case 10: {
                f6 = fArray[10];
                f5 = fArray[10] - fArray[9];
                f4 = f6 + f5;
                f3 = f5;
            }
        }
        float f9 = 1.0f - f8;
        float f10 = (f6 * (1.0f + 2.0f * f8) + f5 * f8) * f9 * f9 + (f4 * (1.0f + 2.0f * f9) - f3 * f9) * f8 * f8;
        return f10;
    }

    public static LensConfig[] GenerateLensConfigFromEyeRelief(float[] fArray, DistortionEquation distortionEquation) {
        LensConfig[] lensConfigArray = new LensConfig[2];
        DistortionDescriptor[] distortionDescriptorArray = LensConfig.CreateDistortionDescriptorsforOVRDK1_CupsABC();
        lensConfigArray[0] = LensConfig.GenerateLensConfigFromEyeRelief(fArray[0], distortionDescriptorArray, distortionEquation);
        lensConfigArray[1] = LensConfig.GenerateLensConfigFromEyeRelief(fArray[1], distortionDescriptorArray, distortionEquation);
        return lensConfigArray;
    }

    private static LensConfig GenerateLensConfigFromEyeRelief(float f2, DistortionDescriptor[] distortionDescriptorArray, DistortionEquation distortionEquation) {
        float f3;
        int n2 = distortionDescriptorArray.length;
        DistortionDescriptor distortionDescriptor = null;
        DistortionDescriptor distortionDescriptor2 = null;
        float f4 = 0.0f;
        if (f2 == 0.0f) {
            distortionDescriptor2 = distortionDescriptorArray[0];
            distortionDescriptor = distortionDescriptorArray[0];
            f4 = 0.0f;
        } else {
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                assert (distortionDescriptorArray[i2].eyeRelief < distortionDescriptorArray[i2 + 1].eyeRelief);
                if (!(distortionDescriptorArray[i2].eyeRelief <= f2) || !(distortionDescriptorArray[i2 + 1].eyeRelief > f2)) continue;
                distortionDescriptor2 = distortionDescriptorArray[i2];
                distortionDescriptor = distortionDescriptorArray[i2 + 1];
                f4 = (f2 - distortionDescriptor2.eyeRelief) / (distortionDescriptor.eyeRelief - distortionDescriptor2.eyeRelief);
            }
        }
        if (distortionDescriptor == null) {
            if (distortionDescriptorArray[0].eyeRelief > f2) {
                distortionDescriptor2 = distortionDescriptorArray[0];
                distortionDescriptor = distortionDescriptorArray[0];
            } else {
                assert (distortionDescriptorArray[n2 - 1].eyeRelief <= f2);
                distortionDescriptor2 = distortionDescriptorArray[n2 - 1];
                distortionDescriptor = distortionDescriptorArray[n2 - 1];
            }
            f4 = 0.0f;
        }
        float f5 = 1.0f - f4;
        distortionDescriptor2.config.MaxR = distortionDescriptor2.maxRadius;
        distortionDescriptor.config.MaxR = distortionDescriptor.maxRadius;
        LensConfig lensConfig = new LensConfig();
        lensConfig.MaxR = f3 = f5 * distortionDescriptor2.maxRadius + f4 * distortionDescriptor.maxRadius;
        switch (distortionEquation) {
            case RecipPoly4: {
                float f6;
                int n3;
                float[] fArray = new float[4];
                float[] fArray2 = new float[4];
                fArray[0] = 0.0f;
                fArray2[0] = 1.0f;
                for (n3 = 1; n3 < 4; ++n3) {
                    f6 = f5 * distortionDescriptor2.sampleRadius[n3 - 1] + f4 * distortionDescriptor.sampleRadius[n3 - 1];
                    float f7 = f6 * f6;
                    float f8 = distortionDescriptor2.config.DistortionFnScaleRadiusSquared(f7);
                    float f9 = distortionDescriptor.config.DistortionFnScaleRadiusSquared(f7);
                    fArray[n3] = f7;
                    fArray2[n3] = 1.0f / (f5 * f8 + f4 * f9);
                }
                lensConfig.eqn = DistortionEquation.RecipPoly4;
                n3 = LensConfig.FitCubicPolynomial(lensConfig.K, fArray, fArray2) ? 1 : 0;
                assert (n3 != 0);
                lensConfig.MaxInvR = f6 = lensConfig.DistortionFn(f3);
                lensConfig.SetUpInverseApprox();
                break;
            }
            case CatmullRom10: {
                float f10;
                float f11;
                float f12;
                int n4;
                lensConfig.MaxR = f3;
                lensConfig.K[0] = f5 * distortionDescriptor2.config.K[0] + f4 * distortionDescriptor.config.K[0];
                for (n4 = 1; n4 < 11; ++n4) {
                    float f13;
                    f12 = (float)n4 / 10.0f * f3 * f3;
                    f11 = distortionDescriptor2.config.DistortionFnScaleRadiusSquared(f12);
                    float f14 = distortionDescriptor.config.DistortionFnScaleRadiusSquared(f12);
                    lensConfig.K[n4] = f13 = f5 * f11 + f4 * f14;
                }
                lensConfig.eqn = DistortionEquation.CatmullRom10;
                for (n4 = 1; n4 < 11; ++n4) {
                    f12 = (float)n4 / 10.0f * f3 * f3;
                    f11 = lensConfig.DistortionFnScaleRadiusSquared(f12);
                    assert (Math.abs(f11 - lensConfig.K[n4]) < 1.0E-4f);
                }
                lensConfig.MaxInvR = f10 = lensConfig.DistortionFn(f3);
                lensConfig.SetUpInverseApprox();
                break;
            }
            default: {
                throw new InternalError("unsupported EQ " + (Object)((Object)distortionEquation));
            }
        }
        lensConfig.ChromaticAberration[0] = f5 * distortionDescriptor2.config.ChromaticAberration[0] + f4 * distortionDescriptor.config.ChromaticAberration[0];
        lensConfig.ChromaticAberration[1] = f5 * distortionDescriptor2.config.ChromaticAberration[1] + f4 * distortionDescriptor.config.ChromaticAberration[1];
        lensConfig.ChromaticAberration[2] = f5 * distortionDescriptor2.config.ChromaticAberration[2] + f4 * distortionDescriptor.config.ChromaticAberration[2];
        lensConfig.ChromaticAberration[3] = f5 * distortionDescriptor2.config.ChromaticAberration[3] + f4 * distortionDescriptor.config.ChromaticAberration[3];
        lensConfig.MetersPerTanAngleAtCenter = distortionDescriptor2.config.MetersPerTanAngleAtCenter * f5 + distortionDescriptor.config.MetersPerTanAngleAtCenter * f4;
        return lensConfig;
    }

    public static DistortionDescriptor[] CreateDistortionDescriptorsforOVRDK1_CupsABC() {
        return new DistortionDescriptor[]{new DistortionDescriptor(new LensConfig(DistortionEquation.CatmullRom10, 0.0425f, new float[]{1.0f, 1.06505f, 1.14725f, 1.2705f, 1.48f, 1.87f, 2.534f, 3.6f, 5.1f, 7.4f, 11.0f}), 0.007760465f, new float[]{0.22271715f, 0.51224947f, 0.7126949f}, (float)Math.sqrt(1.8f)), new DistortionDescriptor(new LensConfig(DistortionEquation.CatmullRom10, 0.0425f, new float[]{1.0f, 1.0324073f, 1.0716046f, 1.1199839f, 1.1808606f, 1.2590494f, 1.361915f, 1.5014338f, 1.6986004f, 1.9940577f, 2.4783146f}), 0.012760465f, new float[]{0.22271715f, 0.51224947f, 0.7126949f}, 1.0f), new DistortionDescriptor(new LensConfig(DistortionEquation.CatmullRom10, 0.0425f, new float[]{1.0102f, 1.0371f, 1.0831f, 1.1353f, 1.2f, 1.2851f, 1.3979f, 1.56f, 1.8f, 2.25f, 3.0f}), 0.017760465f, new float[]{0.22271715f, 0.51224947f, 0.7126949f}, 1.0f)};
    }

    public static enum DistortionEquation {
        RecipPoly4,
        CatmullRom10;

    }

    public static class DistortionDescriptor {
        final LensConfig config;
        final float eyeRelief;
        final float[] sampleRadius;
        final float maxRadius;

        public DistortionDescriptor(LensConfig lensConfig, float f2, float[] fArray, float f3) {
            this.config = lensConfig;
            this.eyeRelief = f2;
            this.sampleRadius = fArray;
            this.maxRadius = f3;
        }
    }
}

