/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.oculusvr.stereo.lense;

import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.util.stereo.generic.GenericStereoDeviceConfig;
import jogamp.opengl.oculusvr.stereo.lense.LensConfig;

public class DistortionSpec {
    private static final float[] quaterHalf = new float[]{0.25f, 0.5f};
    final LensConfig lens;
    final float[] pixelsPerTanAngleAtCenter;
    final float[] tanEyeAngleScale;
    final float[] lensCenter;

    public DistortionSpec(LensConfig lensConfig) {
        this.lens = lensConfig;
        this.pixelsPerTanAngleAtCenter = new float[2];
        this.tanEyeAngleScale = new float[2];
        this.lensCenter = new float[2];
    }

    public static DistortionSpec[] CalculateDistortionSpec(GenericStereoDeviceConfig genericStereoDeviceConfig, float[] fArray) {
        DistortionSpec[] distortionSpecArray = new DistortionSpec[2];
        LensConfig[] lensConfigArray = LensConfig.GenerateLensConfigFromEyeRelief(fArray, LensConfig.DistortionEquation.CatmullRom10);
        distortionSpecArray[0] = DistortionSpec.CalculateDistortionSpec(genericStereoDeviceConfig, 0, fArray[0], lensConfigArray[0]);
        distortionSpecArray[1] = DistortionSpec.CalculateDistortionSpec(genericStereoDeviceConfig, 1, fArray[1], lensConfigArray[1]);
        return distortionSpecArray;
    }

    private static DistortionSpec CalculateDistortionSpec(GenericStereoDeviceConfig genericStereoDeviceConfig, int n2, float f2, LensConfig lensConfig) {
        DistortionSpec distortionSpec = new DistortionSpec(lensConfig);
        DimensionImmutable dimensionImmutable = genericStereoDeviceConfig.surfaceSizeInPixels;
        float[] fArray = new float[]{(float)dimensionImmutable.getWidth() / genericStereoDeviceConfig.screenSizeInMeters[0], (float)dimensionImmutable.getHeight() / genericStereoDeviceConfig.screenSizeInMeters[1]};
        VectorUtil.scaleVec2(distortionSpec.pixelsPerTanAngleAtCenter, fArray, distortionSpec.lens.MetersPerTanAngleAtCenter);
        VectorUtil.scaleVec2(distortionSpec.tanEyeAngleScale, quaterHalf, VectorUtil.divVec2(new float[2], genericStereoDeviceConfig.screenSizeInMeters, distortionSpec.lens.MetersPerTanAngleAtCenter));
        float f3 = 0.5f * genericStereoDeviceConfig.screenSizeInMeters[0];
        float f4 = (genericStereoDeviceConfig.screenSizeInMeters[0] - genericStereoDeviceConfig.interpupillaryDistanceInMeters) * 0.5f;
        distortionSpec.lensCenter[0] = f4 / f3 * 2.0f - 1.0f;
        distortionSpec.lensCenter[1] = genericStereoDeviceConfig.pupilCenterFromScreenTopInMeters / genericStereoDeviceConfig.screenSizeInMeters[1] * 2.0f - 1.0f;
        if (1 == n2) {
            distortionSpec.lensCenter[0] = -distortionSpec.lensCenter[0];
        }
        return distortionSpec;
    }
}

