/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.DefaultGraphicsConfiguration;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLBuffers;
import java.lang.ref.WeakReference;
import java.util.List;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawable;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawableFactory;

public class MacOSXPbufferCGLDrawable
extends MacOSXCGLDrawable {
    protected GLBackendImpl impl;
    protected int pBufferTexTarget;
    protected int pBufferTexWidth;
    protected int pBufferTexHeight;

    public MacOSXPbufferCGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, false);
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.createPbuffer();
        } else {
            this.destroyPbuffer();
        }
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new MacOSXCGLContext(this, gLContext);
    }

    protected int getTextureTarget() {
        return this.pBufferTexTarget;
    }

    protected int getTextureWidth() {
        return this.pBufferTexWidth;
    }

    protected int getTextureHeight() {
        return this.pBufferTexHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyPbuffer() {
        MutableSurface mutableSurface = (MutableSurface)this.getNativeSurface();
        long l2 = mutableSurface.getSurfaceHandle();
        if (0L != l2) {
            List list = this.createdContexts;
            synchronized (list) {
                int n2 = 0;
                while (n2 < this.createdContexts.size()) {
                    WeakReference weakReference = (WeakReference)this.createdContexts.get(n2);
                    MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)weakReference.get();
                    if (macOSXCGLContext != null) {
                        macOSXCGLContext.detachPBuffer();
                        ++n2;
                        continue;
                    }
                    this.createdContexts.remove(n2);
                }
            }
            this.impl.destroy(l2);
            mutableSurface.setSurfaceHandle(0L);
        }
    }

    private void createPbuffer() {
        MutableSurface mutableSurface = (MutableSurface)this.getNativeSurface();
        DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)mutableSurface.getGraphicsConfiguration();
        MacOSXCGLDrawableFactory.SharedResource sharedResource = ((MacOSXCGLDrawableFactory)this.factory).getOrCreateSharedResourceImpl(defaultGraphicsConfiguration.getScreen().getDevice());
        if (DEBUG) {
            System.out.println(MacOSXPbufferCGLDrawable.getThreadName() + ": Pbuffer config: " + defaultGraphicsConfiguration);
            if (null != sharedResource) {
                System.out.println("Pbuffer NPOT Texure  avail: " + sharedResource.isNPOTTextureAvailable());
                System.out.println("Pbuffer RECT Texture avail: " + sharedResource.isRECTTextureAvailable());
            } else {
                System.out.println("Pbuffer no sr, no RECT/NPOT Texture avail");
            }
        }
        this.pBufferTexTarget = 3553;
        if (null != sharedResource && sharedResource.isNPOTTextureAvailable()) {
            this.pBufferTexWidth = this.getSurfaceWidth();
            this.pBufferTexHeight = this.getSurfaceHeight();
        } else {
            this.pBufferTexWidth = GLBuffers.getNextPowerOf2(this.getSurfaceWidth());
            this.pBufferTexHeight = GLBuffers.getNextPowerOf2(this.getSurfaceHeight());
        }
        long l2 = this.impl.create(this.pBufferTexTarget, 6408, this.getSurfaceWidth(), this.getSurfaceHeight());
        if (DEBUG) {
            System.err.println("MacOSXPbufferCGLDrawable tex: target " + MacOSXPbufferCGLDrawable.toHexString(this.pBufferTexTarget) + ", pbufferSize " + this.getSurfaceWidth() + "x" + this.getSurfaceHeight() + ", texSize " + this.pBufferTexWidth + "x" + this.pBufferTexHeight + ", internal-fmt " + MacOSXPbufferCGLDrawable.toHexString(6408L));
            System.err.println("MacOSXPbufferCGLDrawable pBuffer: " + MacOSXPbufferCGLDrawable.toHexString(l2));
        }
        if (l2 == 0L) {
            throw new GLException("pbuffer creation error: CGL.createPBuffer() failed");
        }
        mutableSurface.setSurfaceHandle(l2);
    }

    @Override
    public void setOpenGLMode(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        super.setOpenGLMode(gLBackendType);
        this.createPbuffer();
    }

    @Override
    protected void initOpenGLImpl(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        switch (gLBackendType) {
            case NSOPENGL: {
                this.impl = new NSOpenGLImpl();
                break;
            }
            case CGL: {
                this.impl = new CGLImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + (Object)((Object)gLBackendType));
            }
        }
    }

    static interface GLBackendImpl {
        public long create(int var1, int var2, int var3, int var4);

        public void destroy(long var1);
    }

    static class NSOpenGLImpl
    implements GLBackendImpl {
        NSOpenGLImpl() {
        }

        @Override
        public long create(int n2, int n3, int n4, int n5) {
            return CGL.createPBuffer(n2, n3, n4, n5);
        }

        @Override
        public void destroy(long l2) {
            CGL.destroyPBuffer(l2);
        }
    }

    static class CGLImpl
    implements GLBackendImpl {
        CGLImpl() {
        }

        @Override
        public long create(int n2, int n3, int n4, int n5) {
            PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(1);
            int n6 = CGL.CGLCreatePBuffer(n4, n5, n2, n3, 0, pointerBuffer);
            if (n6 != 0) {
                throw new GLException("Error creating CGL-based pbuffer: error code " + n6);
            }
            return pointerBuffer.get(0);
        }

        @Override
        public void destroy(long l2) {
            int n2 = CGL.CGLDestroyPBuffer(l2);
            if (n2 != 0) {
                throw new GLException("Error destroying CGL-based pbuffer: error code " + n2);
            }
        }
    }
}

