/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.tessellator;

import jogamp.opengl.glu.tessellator.GLUhalfEdge;
import jogamp.opengl.glu.tessellator.GLUvertex;

class Geom {
    static final double EPSILON = 1.0E-5;
    static final double ONE_MINUS_EPSILON = 0.99999;

    private Geom() {
    }

    static double EdgeEval(GLUvertex gLUvertex, GLUvertex gLUvertex2, GLUvertex gLUvertex3) {
        assert (Geom.VertLeq(gLUvertex, gLUvertex2) && Geom.VertLeq(gLUvertex2, gLUvertex3));
        double d2 = gLUvertex2.s - gLUvertex.s;
        double d3 = gLUvertex3.s - gLUvertex2.s;
        if (d2 + d3 > 0.0) {
            if (d2 < d3) {
                return gLUvertex2.t - gLUvertex.t + (gLUvertex.t - gLUvertex3.t) * (d2 / (d2 + d3));
            }
            return gLUvertex2.t - gLUvertex3.t + (gLUvertex3.t - gLUvertex.t) * (d3 / (d2 + d3));
        }
        return 0.0;
    }

    static double EdgeSign(GLUvertex gLUvertex, GLUvertex gLUvertex2, GLUvertex gLUvertex3) {
        assert (Geom.VertLeq(gLUvertex, gLUvertex2) && Geom.VertLeq(gLUvertex2, gLUvertex3));
        double d2 = gLUvertex2.s - gLUvertex.s;
        double d3 = gLUvertex3.s - gLUvertex2.s;
        if (d2 + d3 > 0.0) {
            return (gLUvertex2.t - gLUvertex3.t) * d2 + (gLUvertex2.t - gLUvertex.t) * d3;
        }
        return 0.0;
    }

    static double TransEval(GLUvertex gLUvertex, GLUvertex gLUvertex2, GLUvertex gLUvertex3) {
        assert (Geom.TransLeq(gLUvertex, gLUvertex2) && Geom.TransLeq(gLUvertex2, gLUvertex3));
        double d2 = gLUvertex2.t - gLUvertex.t;
        double d3 = gLUvertex3.t - gLUvertex2.t;
        if (d2 + d3 > 0.0) {
            if (d2 < d3) {
                return gLUvertex2.s - gLUvertex.s + (gLUvertex.s - gLUvertex3.s) * (d2 / (d2 + d3));
            }
            return gLUvertex2.s - gLUvertex3.s + (gLUvertex3.s - gLUvertex.s) * (d3 / (d2 + d3));
        }
        return 0.0;
    }

    static double TransSign(GLUvertex gLUvertex, GLUvertex gLUvertex2, GLUvertex gLUvertex3) {
        assert (Geom.TransLeq(gLUvertex, gLUvertex2) && Geom.TransLeq(gLUvertex2, gLUvertex3));
        double d2 = gLUvertex2.t - gLUvertex.t;
        double d3 = gLUvertex3.t - gLUvertex2.t;
        if (d2 + d3 > 0.0) {
            return (gLUvertex2.s - gLUvertex3.s) * d2 + (gLUvertex2.s - gLUvertex.s) * d3;
        }
        return 0.0;
    }

    static boolean VertCCW(GLUvertex gLUvertex, GLUvertex gLUvertex2, GLUvertex gLUvertex3) {
        return gLUvertex.s * (gLUvertex2.t - gLUvertex3.t) + gLUvertex2.s * (gLUvertex3.t - gLUvertex.t) + gLUvertex3.s * (gLUvertex.t - gLUvertex2.t) >= 0.0;
    }

    static double Interpolate(double d2, double d3, double d4, double d5) {
        d2 = d2 < 0.0 ? 0.0 : d2;
        double d6 = d4 = d4 < 0.0 ? 0.0 : d4;
        if (d2 <= d4) {
            if (d4 == 0.0) {
                return (d3 + d5) / 2.0;
            }
            return d3 + (d5 - d3) * (d2 / (d2 + d4));
        }
        return d5 + (d3 - d5) * (d4 / (d2 + d4));
    }

    static void EdgeIntersect(GLUvertex gLUvertex, GLUvertex gLUvertex2, GLUvertex gLUvertex3, GLUvertex gLUvertex4, GLUvertex gLUvertex5) {
        double d2;
        double d3;
        GLUvertex gLUvertex6;
        if (!Geom.VertLeq(gLUvertex, gLUvertex2)) {
            gLUvertex6 = gLUvertex;
            gLUvertex = gLUvertex2;
            gLUvertex2 = gLUvertex6;
        }
        if (!Geom.VertLeq(gLUvertex3, gLUvertex4)) {
            gLUvertex6 = gLUvertex3;
            gLUvertex3 = gLUvertex4;
            gLUvertex4 = gLUvertex6;
        }
        if (!Geom.VertLeq(gLUvertex, gLUvertex3)) {
            gLUvertex6 = gLUvertex;
            gLUvertex = gLUvertex3;
            gLUvertex3 = gLUvertex6;
            gLUvertex6 = gLUvertex2;
            gLUvertex2 = gLUvertex4;
            gLUvertex4 = gLUvertex6;
        }
        if (!Geom.VertLeq(gLUvertex3, gLUvertex2)) {
            gLUvertex5.s = (gLUvertex3.s + gLUvertex2.s) / 2.0;
        } else if (Geom.VertLeq(gLUvertex2, gLUvertex4)) {
            d3 = Geom.EdgeEval(gLUvertex, gLUvertex3, gLUvertex2);
            if (d3 + (d2 = Geom.EdgeEval(gLUvertex3, gLUvertex2, gLUvertex4)) < 0.0) {
                d3 = -d3;
                d2 = -d2;
            }
            gLUvertex5.s = Geom.Interpolate(d3, gLUvertex3.s, d2, gLUvertex2.s);
        } else {
            d3 = Geom.EdgeSign(gLUvertex, gLUvertex3, gLUvertex2);
            if (d3 + (d2 = -Geom.EdgeSign(gLUvertex, gLUvertex4, gLUvertex2)) < 0.0) {
                d3 = -d3;
                d2 = -d2;
            }
            gLUvertex5.s = Geom.Interpolate(d3, gLUvertex3.s, d2, gLUvertex4.s);
        }
        if (!Geom.TransLeq(gLUvertex, gLUvertex2)) {
            gLUvertex6 = gLUvertex;
            gLUvertex = gLUvertex2;
            gLUvertex2 = gLUvertex6;
        }
        if (!Geom.TransLeq(gLUvertex3, gLUvertex4)) {
            gLUvertex6 = gLUvertex3;
            gLUvertex3 = gLUvertex4;
            gLUvertex4 = gLUvertex6;
        }
        if (!Geom.TransLeq(gLUvertex, gLUvertex3)) {
            gLUvertex6 = gLUvertex3;
            gLUvertex3 = gLUvertex;
            gLUvertex = gLUvertex6;
            gLUvertex6 = gLUvertex4;
            gLUvertex4 = gLUvertex2;
            gLUvertex2 = gLUvertex6;
        }
        if (!Geom.TransLeq(gLUvertex3, gLUvertex2)) {
            gLUvertex5.t = (gLUvertex3.t + gLUvertex2.t) / 2.0;
        } else if (Geom.TransLeq(gLUvertex2, gLUvertex4)) {
            d3 = Geom.TransEval(gLUvertex, gLUvertex3, gLUvertex2);
            if (d3 + (d2 = Geom.TransEval(gLUvertex3, gLUvertex2, gLUvertex4)) < 0.0) {
                d3 = -d3;
                d2 = -d2;
            }
            gLUvertex5.t = Geom.Interpolate(d3, gLUvertex3.t, d2, gLUvertex2.t);
        } else {
            d3 = Geom.TransSign(gLUvertex, gLUvertex3, gLUvertex2);
            if (d3 + (d2 = -Geom.TransSign(gLUvertex, gLUvertex4, gLUvertex2)) < 0.0) {
                d3 = -d3;
                d2 = -d2;
            }
            gLUvertex5.t = Geom.Interpolate(d3, gLUvertex3.t, d2, gLUvertex4.t);
        }
    }

    static boolean VertEq(GLUvertex gLUvertex, GLUvertex gLUvertex2) {
        return gLUvertex.s == gLUvertex2.s && gLUvertex.t == gLUvertex2.t;
    }

    static boolean VertLeq(GLUvertex gLUvertex, GLUvertex gLUvertex2) {
        return gLUvertex.s < gLUvertex2.s || gLUvertex.s == gLUvertex2.s && gLUvertex.t <= gLUvertex2.t;
    }

    static boolean TransLeq(GLUvertex gLUvertex, GLUvertex gLUvertex2) {
        return gLUvertex.t < gLUvertex2.t || gLUvertex.t == gLUvertex2.t && gLUvertex.s <= gLUvertex2.s;
    }

    static boolean EdgeGoesLeft(GLUhalfEdge gLUhalfEdge) {
        return Geom.VertLeq(gLUhalfEdge.Sym.Org, gLUhalfEdge.Org);
    }

    static boolean EdgeGoesRight(GLUhalfEdge gLUhalfEdge) {
        return Geom.VertLeq(gLUhalfEdge.Org, gLUhalfEdge.Sym.Org);
    }

    static double VertL1dist(GLUvertex gLUvertex, GLUvertex gLUvertex2) {
        return Math.abs(gLUvertex.s - gLUvertex2.s) + Math.abs(gLUvertex.t - gLUvertex2.t);
    }

    static double EdgeCos(GLUvertex gLUvertex, GLUvertex gLUvertex2, GLUvertex gLUvertex3) {
        double d2 = gLUvertex2.s - gLUvertex.s;
        double d3 = gLUvertex2.t - gLUvertex.t;
        double d4 = gLUvertex3.s - gLUvertex.s;
        double d5 = gLUvertex3.t - gLUvertex.t;
        double d6 = d2 * d4 + d3 * d5;
        double d7 = Math.sqrt(d2 * d2 + d3 * d3) * Math.sqrt(d4 * d4 + d5 * d5);
        if (d7 > 0.0) {
            d6 /= d7;
        }
        return d6;
    }
}

