/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.mipmap;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.glu.mipmap.BuildMipmap;
import jogamp.opengl.glu.mipmap.Image;
import jogamp.opengl.glu.mipmap.PixelStorageModes;
import jogamp.opengl.glu.mipmap.ScaleInternal;

public class Mipmap {
    public static int computeLog(int n2) {
        int n3 = 0;
        if (n2 == 0) {
            return -1;
        }
        while (true) {
            if ((n2 & 1) >= 1) {
                if (n2 != 1) {
                    return -1;
                }
                return n3;
            }
            n2 >>= 1;
            ++n3;
        }
    }

    public static int nearestPower(int n2) {
        int n3 = 1;
        if (n2 == 0) {
            return -1;
        }
        while (n2 != 1) {
            if (n2 == 3) {
                return n3 * 4;
            }
            n2 >>= 1;
            n3 *= 2;
        }
        return n3;
    }

    public static short GLU_SWAP_2_BYTES(short s) {
        byte by = 0;
        by = (byte)(s >>> 8);
        s = (short)(s << 8);
        s = (short)(s | 0xFF & by);
        return s;
    }

    public static int GLU_SWAP_4_BYTES(int n2) {
        int n3 = n2 << 24;
        n3 |= 0xFF0000 & n2 << 8;
        n3 |= 0xFF00 & n2 >>> 8;
        return n3 |= 0xFF & n2 >>> 24;
    }

    public static float GLU_SWAP_4_BYTES(float f2) {
        int n2 = Float.floatToRawIntBits(f2);
        float f3 = Float.intBitsToFloat(n2);
        return f3;
    }

    public static int checkMipmapArgs(int n2, int n3, int n4) {
        if (!Mipmap.legalFormat(n3) || !Mipmap.legalType(n4)) {
            return 100900;
        }
        if (n3 == 6401) {
            return 100900;
        }
        if (!Mipmap.isLegalFormatForPackedPixelType(n3, n4)) {
            return 100904;
        }
        return 0;
    }

    public static boolean legalFormat(int n2) {
        switch (n2) {
            case 6400: 
            case 6401: 
            case 6402: 
            case 6403: 
            case 6404: 
            case 6405: 
            case 6406: 
            case 6407: 
            case 6408: 
            case 6409: 
            case 6410: 
            case 32992: 
            case 32993: {
                return true;
            }
        }
        return false;
    }

    public static boolean legalType(int n2) {
        switch (n2) {
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 5124: 
            case 5125: 
            case 5126: 
            case 6656: 
            case 32818: 
            case 32819: 
            case 32820: 
            case 32821: 
            case 33634: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: 
            case 33639: 
            case 33640: 
            case 36342: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTypePackedPixel(int n2) {
        assert (Mipmap.legalType(n2));
        return n2 == 32818 || n2 == 33634 || n2 == 33635 || n2 == 33636 || n2 == 32819 || n2 == 33637 || n2 == 32820 || n2 == 33638 || n2 == 32821 || n2 == 33639 || n2 == 36342 || n2 == 33640;
    }

    public static boolean isLegalFormatForPackedPixelType(int n2, int n3) {
        if (Mipmap.isTypePackedPixel(n3)) {
            return true;
        }
        if ((n3 == 32818 || n3 == 33634 || n3 == 33635 || n3 == 33636) & n2 != 6407) {
            return false;
        }
        return n3 != 32819 && n3 != 33637 && n3 != 32820 && n3 != 33638 && n3 != 32821 && n3 != 33639 && n3 != 36342 && n3 != 33640 || n2 == 6408 || n2 == 32993;
    }

    public static boolean isLegalLevels(int n2, int n3, int n4, int n5) {
        return n3 >= 0 && n3 >= n2 && n4 >= n3 && n5 >= n4;
    }

    public static void closestFit(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray, int[] nArray2) {
        if (gL.isGL2GL3() && gL.getContext().getGLVersionNumber().compareTo(GLContext.Version1_1) >= 0) {
            int n8 = Mipmap.nearestPower(n3);
            int n9 = Mipmap.nearestPower(n4);
            int[] nArray3 = new int[1];
            boolean bl = false;
            try {
                do {
                    int n10;
                    int n11;
                    int n12 = n3 > 1 ? n8 >> 1 : n8;
                    int n13 = n11 = n4 > 1 ? n9 >> 1 : n9;
                    assert (n12 > 0);
                    assert (n11 > 0);
                    if (n2 == 3553 || n2 == 32868) {
                        n10 = 32868;
                        gL.glTexImage2D(n10, 1, n5, n12, n11, 0, n6, n7, null);
                    } else if (n2 == 34069 || n2 == 34070 || n2 == 34071 || n2 == 34072 || n2 == 34073 || n2 == 34074) {
                        n10 = 34075;
                        gL.glTexImage2D(n10, 1, n5, n12, n11, 0, n6, n7, null);
                    } else {
                        assert (n2 == 3552 || n2 == 32867);
                        n10 = 32867;
                        gL.getGL2GL3().glTexImage1D(n10, 1, n5, n12, 0, n6, n7, null);
                    }
                    if (gL.isGL2GL3()) {
                        gL.getGL2GL3().glGetTexLevelParameteriv(n10, 1, 4096, nArray3, 0);
                    } else {
                        nArray3[0] = 0;
                    }
                    if (nArray3[0] != 0) continue;
                    if (n8 == 1 && n9 == 1) {
                        bl = true;
                        break;
                    }
                    n8 = n12;
                    n9 = n11;
                } while (nArray3[0] == 0);
            }
            catch (GLException gLException) {
                bl = true;
            }
            if (!bl) {
                nArray[0] = n8;
                nArray2[0] = n9;
                return;
            }
        }
        int[] nArray4 = new int[1];
        gL.glGetIntegerv(3379, nArray4, 0);
        nArray[0] = Mipmap.nearestPower(n3);
        if (nArray[0] > nArray4[0]) {
            nArray[0] = nArray4[0];
        }
        nArray2[0] = Mipmap.nearestPower(n4);
        if (nArray2[0] > nArray4[0]) {
            nArray2[0] = nArray4[0];
        }
    }

    public static void closestFit3D(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray, int[] nArray2, int[] nArray3) {
        int n9 = Mipmap.nearestPower(n3);
        int n10 = Mipmap.nearestPower(n4);
        int n11 = Mipmap.nearestPower(n5);
        int[] nArray4 = new int[1];
        do {
            int n12 = n9 > 1 ? n9 >> 1 : n9;
            int n13 = n10 > 1 ? n10 >> 1 : n10;
            int n14 = n11 > 1 ? n11 >> 1 : n11;
            int n15 = 0;
            assert (n12 > 0);
            assert (n13 > 0);
            assert (n14 > 0);
            if (n2 == 32879 || n2 == 32880) {
                n15 = 32880;
                gL.getGL2GL3().glTexImage3D(n15, 1, n6, n12, n13, n14, 0, n7, n8, null);
            }
            if (gL.isGL2GL3()) {
                gL.getGL2GL3().glGetTexLevelParameteriv(n15, 1, 4096, nArray4, 0);
            } else {
                nArray4[0] = 0;
            }
            if (nArray4[0] != 0) continue;
            if (n9 == 1 && n10 == 1 && n11 == 1) {
                nArray3[0] = 1;
                nArray2[0] = 1;
                nArray[0] = 1;
                return;
            }
            n9 = n12;
            n10 = n13;
            n11 = n14;
        } while (nArray4[0] == 0);
        nArray[0] = n9;
        nArray2[0] = n10;
        nArray3[0] = n11;
    }

    public static int elements_per_group(int n2, int n3) {
        if (n3 == 32818 || n3 == 33634 || n3 == 33635 || n3 == 33636 || n3 == 32819 || n3 == 33637 || n3 == 32820 || n3 == 33638 || n3 == 32821 || n3 == 33639 || n3 == 36342 || n3 == 33640) {
            return 1;
        }
        switch (n2) {
            case 6407: 
            case 32992: {
                return 3;
            }
            case 6410: {
                return 2;
            }
            case 6408: 
            case 32993: {
                return 4;
            }
        }
        return 1;
    }

    public static int bytes_per_element(int n2) {
        switch (n2) {
            case 5120: 
            case 5121: 
            case 6656: 
            case 32818: 
            case 33634: {
                return 1;
            }
            case 5122: 
            case 5123: 
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: {
                return 2;
            }
            case 5124: 
            case 5125: 
            case 5126: 
            case 32821: 
            case 33639: 
            case 33640: 
            case 36342: {
                return 4;
            }
        }
        return 4;
    }

    public static boolean is_index(int n2) {
        return n2 == 6400 || n2 == 6401;
    }

    public static int image_size(int n2, int n3, int n4, int n5) {
        assert (n2 > 0);
        assert (n3 > 0);
        int n6 = Mipmap.elements_per_group(n4, n5);
        int n7 = n5 == 6656 ? (n2 + 7) / 8 : Mipmap.bytes_per_element(n5) * n2;
        return n7 * n3 * n6;
    }

    public static int imageSize3D(int n2, int n3, int n4, int n5, int n6) {
        int n7 = Mipmap.elements_per_group(n5, n6);
        int n8 = Mipmap.bytes_per_element(n6) * n2;
        assert (n2 > 0 && n3 > 0 && n4 > 0);
        assert (n6 != 6656);
        return n8 * n3 * n4 * n7;
    }

    public static void retrieveStoreModes(GL gL, PixelStorageModes pixelStorageModes) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(3317, nArray, 0);
        pixelStorageModes.setUnpackAlignment(nArray[0]);
        gL.glGetIntegerv(3314, nArray, 0);
        pixelStorageModes.setUnpackRowLength(nArray[0]);
        gL.glGetIntegerv(3315, nArray, 0);
        pixelStorageModes.setUnpackSkipRows(nArray[0]);
        gL.glGetIntegerv(3316, nArray, 0);
        pixelStorageModes.setUnpackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3313, nArray, 0);
        pixelStorageModes.setUnpackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3312, nArray, 0);
        pixelStorageModes.setUnpackSwapBytes(nArray[0] == 1);
        gL.glGetIntegerv(3333, nArray, 0);
        pixelStorageModes.setPackAlignment(nArray[0]);
        gL.glGetIntegerv(3330, nArray, 0);
        pixelStorageModes.setPackRowLength(nArray[0]);
        gL.glGetIntegerv(3331, nArray, 0);
        pixelStorageModes.setPackSkipRows(nArray[0]);
        gL.glGetIntegerv(3332, nArray, 0);
        pixelStorageModes.setPackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3329, nArray, 0);
        pixelStorageModes.setPackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3328, nArray, 0);
        pixelStorageModes.setPackSwapBytes(nArray[0] == 1);
    }

    public static void retrieveStoreModes3D(GL gL, PixelStorageModes pixelStorageModes) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(3317, nArray, 0);
        pixelStorageModes.setUnpackAlignment(nArray[0]);
        gL.glGetIntegerv(3314, nArray, 0);
        pixelStorageModes.setUnpackRowLength(nArray[0]);
        gL.glGetIntegerv(3315, nArray, 0);
        pixelStorageModes.setUnpackSkipRows(nArray[0]);
        gL.glGetIntegerv(3316, nArray, 0);
        pixelStorageModes.setUnpackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3313, nArray, 0);
        pixelStorageModes.setUnpackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3312, nArray, 0);
        pixelStorageModes.setUnpackSwapBytes(nArray[0] == 1);
        gL.glGetIntegerv(32877, nArray, 0);
        pixelStorageModes.setUnpackSkipImages(nArray[0]);
        gL.glGetIntegerv(32878, nArray, 0);
        pixelStorageModes.setUnpackImageHeight(nArray[0]);
        gL.glGetIntegerv(3333, nArray, 0);
        pixelStorageModes.setPackAlignment(nArray[0]);
        gL.glGetIntegerv(3330, nArray, 0);
        pixelStorageModes.setPackRowLength(nArray[0]);
        gL.glGetIntegerv(3331, nArray, 0);
        pixelStorageModes.setPackSkipRows(nArray[0]);
        gL.glGetIntegerv(3332, nArray, 0);
        pixelStorageModes.setPackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3329, nArray, 0);
        pixelStorageModes.setPackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3328, nArray, 0);
        pixelStorageModes.setPackSwapBytes(nArray[0] == 1);
        gL.glGetIntegerv(32875, nArray, 0);
        pixelStorageModes.setPackSkipImages(nArray[0]);
        gL.glGetIntegerv(32876, nArray, 0);
        pixelStorageModes.setPackImageHeight(nArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluScaleImage(GL gL, int n2, int n3, int n4, int n5, ByteBuffer byteBuffer, int n6, int n7, int n8, ByteBuffer byteBuffer2) {
        int n9 = byteBuffer.position();
        int n10 = byteBuffer2.position();
        try {
            PixelStorageModes pixelStorageModes = new PixelStorageModes();
            if (n3 == 0 || n4 == 0 || n6 == 0 || n7 == 0) {
                int n11 = 0;
                return n11;
            }
            if (n3 < 0 || n4 < 0 || n6 < 0 || n7 < 0) {
                int n12 = 100901;
                return n12;
            }
            if (!(Mipmap.legalFormat(n2) && Mipmap.legalType(n5) && Mipmap.legalType(n8))) {
                int n13 = 100900;
                return n13;
            }
            if (!Mipmap.isLegalFormatForPackedPixelType(n2, n5)) {
                int n14 = 100904;
                return n14;
            }
            if (!Mipmap.isLegalFormatForPackedPixelType(n2, n8)) {
                int n15 = 100904;
                return n15;
            }
            ByteBuffer byteBuffer3 = Buffers.newDirectByteBuffer(Mipmap.image_size(n3, n4, n2, 5123));
            ByteBuffer byteBuffer4 = Buffers.newDirectByteBuffer(Mipmap.image_size(n6, n7, n2, 5123));
            if (byteBuffer3 == null || byteBuffer4 == null) {
                int n16 = 100902;
                return n16;
            }
            Mipmap.retrieveStoreModes(gL, pixelStorageModes);
            Image.fill_image(pixelStorageModes, n3, n4, n2, n5, Mipmap.is_index(n2), byteBuffer, byteBuffer3.asShortBuffer());
            int n17 = Mipmap.elements_per_group(n2, 0);
            ScaleInternal.scale_internal(n17, n3, n4, byteBuffer3.asShortBuffer(), n6, n7, byteBuffer4.asShortBuffer());
            Image.empty_image(pixelStorageModes, n6, n7, n2, n8, Mipmap.is_index(n2), byteBuffer4.asShortBuffer(), byteBuffer2);
            int n18 = 0;
            return n18;
        }
        finally {
            byteBuffer.position(n9);
            byteBuffer2.position(n10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild1DMipmapLevels(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        int n10 = byteBuffer.position();
        try {
            int n11 = Mipmap.checkMipmapArgs(n3, n5, n6);
            if (n11 != 0) {
                int n12 = n11;
                return n12;
            }
            if (n4 < 1) {
                int n13 = 100901;
                return n13;
            }
            int n14 = Mipmap.computeLog(n4);
            if (!Mipmap.isLegalLevels(n7, n8, n9, n14 += n7)) {
                int n15 = 100901;
                return n15;
            }
            int n16 = BuildMipmap.gluBuild1DMipmapLevelsCore(gL, n2, n3, n4, n4, n5, n6, n7, n8, n9, byteBuffer);
            return n16;
        }
        finally {
            byteBuffer.position(n10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild1DMipmaps(GL gL, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        int n7 = byteBuffer.position();
        try {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int n8 = Mipmap.checkMipmapArgs(n3, n5, n6);
            if (n8 != 0) {
                int n9 = n8;
                return n9;
            }
            if (n4 < 1) {
                int n10 = 100901;
                return n10;
            }
            Mipmap.closestFit(gL, n2, n4, 1, n3, n5, n6, nArray, nArray2);
            int n11 = Mipmap.computeLog(nArray[0]);
            int n12 = BuildMipmap.gluBuild1DMipmapLevelsCore(gL, n2, n3, n4, nArray[0], n5, n6, 0, 0, n11, byteBuffer);
            return n12;
        }
        finally {
            byteBuffer.position(n7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild2DMipmapLevels(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Object object) {
        Buffer buffer;
        Object[] objectArray;
        ByteBuffer byteBuffer;
        int n11 = Mipmap.checkMipmapArgs(n3, n6, n7);
        if (n11 != 0) {
            return n11;
        }
        if (n4 < 1 || n5 < 1) {
            return 100901;
        }
        int n12 = Mipmap.computeLog(n4);
        int n13 = Mipmap.computeLog(n5);
        if (n13 > n12) {
            n12 = n13;
        }
        if (!Mipmap.isLegalLevels(n8, n9, n10, n12 += n8)) {
            return 100901;
        }
        if (object instanceof ByteBuffer) {
            byteBuffer = (ByteBuffer)object;
        } else if (object instanceof byte[]) {
            objectArray = (byte[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length);
            byteBuffer.put((byte[])objectArray);
            byteBuffer.flip();
        } else if (object instanceof short[]) {
            objectArray = (short[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 2);
            buffer = byteBuffer.asShortBuffer();
            ((ShortBuffer)buffer).put((short[])objectArray);
        } else if (object instanceof int[]) {
            objectArray = (int[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 4);
            buffer = byteBuffer.asIntBuffer();
            ((IntBuffer)buffer).put((int[])objectArray);
        } else if (object instanceof float[]) {
            objectArray = (float[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 4);
            buffer = byteBuffer.asFloatBuffer();
            ((FloatBuffer)buffer).put((float[])objectArray);
        } else {
            throw new IllegalArgumentException("Unhandled data type: " + object.getClass().getName());
        }
        int n14 = byteBuffer.position();
        try {
            int n15 = BuildMipmap.gluBuild2DMipmapLevelsCore(gL, n2, n3, n4, n5, n4, n5, n6, n7, n8, n9, n10, byteBuffer);
            return n15;
        }
        finally {
            byteBuffer.position(n14);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild2DMipmaps(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        Buffer buffer;
        Object[] objectArray;
        ByteBuffer byteBuffer;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n8 = Mipmap.checkMipmapArgs(n3, n6, n7);
        if (n8 != 0) {
            return n8;
        }
        if (n4 < 1 || n5 < 1) {
            return 100901;
        }
        Mipmap.closestFit(gL, n2, n4, n5, n3, n6, n7, nArray, nArray2);
        int n9 = Mipmap.computeLog(nArray[0]);
        int n10 = Mipmap.computeLog(nArray2[0]);
        if (n10 > n9) {
            n9 = n10;
        }
        if (object instanceof ByteBuffer) {
            byteBuffer = (ByteBuffer)object;
        } else if (object instanceof byte[]) {
            objectArray = (byte[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length);
            byteBuffer.put((byte[])objectArray);
            byteBuffer.flip();
        } else if (object instanceof short[]) {
            objectArray = (short[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 2);
            buffer = byteBuffer.asShortBuffer();
            ((ShortBuffer)buffer).put((short[])objectArray);
        } else if (object instanceof int[]) {
            objectArray = (int[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 4);
            buffer = byteBuffer.asIntBuffer();
            ((IntBuffer)buffer).put((int[])objectArray);
        } else if (object instanceof float[]) {
            objectArray = (float[])object;
            byteBuffer = ByteBuffer.allocateDirect(objectArray.length * 4);
            buffer = byteBuffer.asFloatBuffer();
            ((FloatBuffer)buffer).put((float[])objectArray);
        } else {
            throw new IllegalArgumentException("Unhandled data type: " + object.getClass().getName());
        }
        int n11 = byteBuffer.position();
        try {
            int n12 = BuildMipmap.gluBuild2DMipmapLevelsCore(gL, n2, n3, n4, n5, nArray[0], nArray2[0], n6, n7, 0, 0, n9, byteBuffer);
            return n12;
        }
        finally {
            byteBuffer.position(n11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild3DMipmaps(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ByteBuffer byteBuffer) {
        int n9 = byteBuffer.position();
        try {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int n10 = Mipmap.checkMipmapArgs(n3, n7, n8);
            if (n10 != 0) {
                int n11 = n10;
                return n11;
            }
            if (n4 < 1 || n5 < 1 || n6 < 1) {
                int n12 = 100901;
                return n12;
            }
            if (n8 == 6656) {
                int n13 = 100900;
                return n13;
            }
            Mipmap.closestFit3D(gL, n2, n4, n5, n6, n3, n7, n8, nArray, nArray2, nArray3);
            int n14 = Mipmap.computeLog(nArray[0]);
            int n15 = Mipmap.computeLog(nArray2[0]);
            if (n15 > n14) {
                n14 = n15;
            }
            if ((n15 = Mipmap.computeLog(nArray3[0])) > n14) {
                n14 = n15;
            }
            int n16 = BuildMipmap.gluBuild3DMipmapLevelsCore(gL, n2, n3, n4, n5, n6, nArray[0], nArray2[0], nArray3[0], n7, n8, 0, 0, n14, byteBuffer);
            return n16;
        }
        finally {
            byteBuffer.position(n9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluBuild3DMipmapLevels(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ByteBuffer byteBuffer) {
        int n12 = byteBuffer.position();
        try {
            int n13 = Mipmap.checkMipmapArgs(n3, n7, n8);
            if (n13 != 0) {
                int n14 = n13;
                return n14;
            }
            if (n4 < 1 || n5 < 1 || n6 < 1) {
                int n15 = 100901;
                return n15;
            }
            if (n8 == 6656) {
                int n16 = 100900;
                return n16;
            }
            int n17 = Mipmap.computeLog(n4);
            int n18 = Mipmap.computeLog(n5);
            if (n18 > n17) {
                n17 = n18;
            }
            if ((n18 = Mipmap.computeLog(n6)) > n17) {
                n17 = n18;
            }
            if (!Mipmap.isLegalLevels(n9, n10, n11, n17 += n9)) {
                int n19 = 100901;
                return n19;
            }
            int n20 = BuildMipmap.gluBuild3DMipmapLevelsCore(gL, n2, n3, n4, n5, n6, n4, n5, n6, n7, n8, n9, n10, n11, byteBuffer);
            return n20;
        }
        finally {
            byteBuffer.position(n12);
        }
    }
}

