/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.GenericUpstreamSurfacelessHook;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.egl.EGL;
import java.nio.IntBuffer;
import jogamp.nativewindow.ProxySurfaceImpl;
import jogamp.nativewindow.WrappedSurface;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLUpstreamSurfaceHook;

public class EGLSurface
extends WrappedSurface {
    static boolean DEBUG = EGLDrawable.DEBUG || ProxySurface.DEBUG;

    public static EGLSurface get(NativeSurface nativeSurface) {
        if (nativeSurface instanceof EGLSurface) {
            return (EGLSurface)nativeSurface;
        }
        return new EGLSurface(nativeSurface);
    }

    private EGLSurface(NativeSurface nativeSurface) {
        super(nativeSurface.getGraphicsConfiguration(), 0L, new EGLUpstreamSurfaceHook(nativeSurface), false);
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLSurface.ctor().1: " + this);
            ProxySurfaceImpl.dumpHierarchy(System.err, this);
        }
    }

    public static EGLSurface createWrapped(EGLGraphicsConfiguration eGLGraphicsConfiguration, long l2, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        return new EGLSurface(eGLGraphicsConfiguration, l2, upstreamSurfaceHook, bl);
    }

    private EGLSurface(EGLGraphicsConfiguration eGLGraphicsConfiguration, long l2, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        super(eGLGraphicsConfiguration, 0L, new EGLUpstreamSurfaceHook(eGLGraphicsConfiguration, l2, upstreamSurfaceHook, bl), false);
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLSurface.ctor().2: " + this);
            ProxySurfaceImpl.dumpHierarchy(System.err, this);
        }
    }

    public static EGLSurface createSurfaceless(EGLGraphicsConfiguration eGLGraphicsConfiguration, GenericUpstreamSurfacelessHook genericUpstreamSurfacelessHook, boolean bl) {
        return new EGLSurface(eGLGraphicsConfiguration, genericUpstreamSurfacelessHook, bl);
    }

    private EGLSurface(EGLGraphicsConfiguration eGLGraphicsConfiguration, GenericUpstreamSurfacelessHook genericUpstreamSurfacelessHook, boolean bl) {
        super(eGLGraphicsConfiguration, 0L, genericUpstreamSurfacelessHook, bl);
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLSurface.ctor().3: " + this);
            ProxySurfaceImpl.dumpHierarchy(System.err, this);
        }
    }

    public static long eglCreateWindowSurface(long l2, long l3, long l4) {
        int n2 = EGLDisplayUtil.getEGLPlatformType(true);
        return EGL.eglCreateWindowSurface(l2, l3, l4, null);
    }

    public void setEGLSurfaceHandle() throws GLException {
        this.setSurfaceHandle(this.createEGLSurface());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long createEGLSurface() throws GLException {
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)this.getGraphicsConfiguration();
        NativeSurface nativeSurface = this.getUpstreamSurface();
        boolean bl = ((GLCapabilitiesImmutable)eGLGraphicsConfiguration.getChosenCapabilities()).isPBuffer();
        long l2 = this.createEGLSurface(bl, true, eGLGraphicsConfiguration, nativeSurface);
        if (DEBUG) {
            System.err.println(EGLSurface.getThreadName() + ": EGLSurface: EGL.eglCreateSurface.0: 0x" + Long.toHexString(l2));
            ProxySurfaceImpl.dumpHierarchy(System.err, this);
        }
        if (0L == l2) {
            int n2 = EGL.eglGetError();
            if (12299 != n2 || bl) throw new GLException("Creation of window surface w/ surface handle failed (1): " + eGLGraphicsConfiguration + ", " + this + ", error " + GLDrawableImpl.toHexString(n2));
            if (!EGLSurface.hasUniqueNativeWindowHandle(nativeSurface)) throw new GLException("Creation of window surface w/ surface handle failed (2): " + eGLGraphicsConfiguration + ", " + this + ", error " + GLDrawableImpl.toHexString(n2));
            l2 = this.createEGLSurface(bl, false, eGLGraphicsConfiguration, nativeSurface);
            if (DEBUG) {
                System.err.println(EGLSurface.getThreadName() + ": Info: Creation of window surface w/ surface handle failed: " + eGLGraphicsConfiguration + ", error " + GLDrawableImpl.toHexString(n2) + ", retry w/ windowHandle");
                System.err.println(EGLSurface.getThreadName() + ": EGLSurface: EGL.eglCreateSurface.1: 0x" + Long.toHexString(l2));
            }
            if (0L == l2) {
                throw new GLException("Creation of window surface w/ window handle failed: " + eGLGraphicsConfiguration + ", " + this + ", error " + GLDrawableImpl.toHexString(EGL.eglGetError()));
            }
        }
        if (!DEBUG) return l2;
        System.err.println(EGLSurface.getThreadName() + ": createEGLSurface handle " + GLDrawableImpl.toHexString(l2));
        return l2;
    }

    private long createEGLSurface(boolean bl, boolean bl2, EGLGraphicsConfiguration eGLGraphicsConfiguration, NativeSurface nativeSurface) {
        if (bl) {
            return EGLDrawableFactory.createPBufferSurfaceImpl(eGLGraphicsConfiguration, this.getSurfaceWidth(), this.getSurfaceHeight(), false);
        }
        long l2 = bl2 ? nativeSurface.getSurfaceHandle() : ((NativeWindow)nativeSurface).getWindowHandle();
        long l3 = EGLSurface.eglCreateWindowSurface(eGLGraphicsConfiguration.getScreen().getDevice().getHandle(), eGLGraphicsConfiguration.getNativeConfig(), l2);
        if (DEBUG) {
            int n2 = EGLDisplayUtil.getEGLPlatformType(true);
            System.err.println("EGLSurface.createEGLSurface.X: useNativeSurface " + bl2 + ", nativeWin " + EGLContext.toHexString(l2) + ") @ " + n2 + "/" + NativeWindowFactory.getNativeWindowType(true) + ": " + EGLContext.toHexString(l3) + ", " + (0L != l3 ? "OK" : "Failed") + " - with config " + eGLGraphicsConfiguration);
        }
        return l3;
    }

    private static boolean hasUniqueNativeWindowHandle(NativeSurface nativeSurface) {
        return nativeSurface instanceof NativeWindow && ((NativeWindow)nativeSurface).getWindowHandle() != nativeSurface.getSurfaceHandle();
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static boolean isValidEGLSurfaceHandle(long l2, long l3) {
        if (0L == l3) {
            return false;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        boolean bl = EGL.eglQuerySurface(l2, l3, 12328, intBuffer);
        if (!bl) {
            int n2 = EGL.eglGetError();
            if (DEBUG) {
                System.err.println(EGLSurface.getThreadName() + ": EGLSurface.isValidEGLSurfaceHandle eglQuerySuface failed: error " + GLDrawableImpl.toHexString(n2) + ", " + GLDrawableImpl.toHexString(l3));
            }
        }
        return bl;
    }
}

