/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.LongObjectHashMap;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.egl.EGL;
import java.nio.IntBuffer;
import jogamp.opengl.Debug;
import jogamp.opengl.GLVersionNumber;
import jogamp.opengl.egl.EGLContext;

public class EGLDisplayUtil {
    private static final boolean DEBUG = Debug.debug("EGLDisplayUtil");
    private static boolean useSingletonEGLDisplay = false;
    private static EGLDisplayRef singletonEGLDisplay = null;
    private static final LongObjectHashMap openEGLDisplays = new LongObjectHashMap();
    private static boolean eglGetPlatformDisplayProbed;
    private static boolean eglGetPlatformDisplayAvail;
    private static VersionNumber eglGetPlatformDisplayMinVersion;
    private static final IntBuffer _eglMajorVersion;
    private static final IntBuffer _eglMinorVersion;
    private static final EGLGraphicsDevice.EGLDisplayLifecycleCallback eglLifecycleCallback;

    public static int shutdown(boolean bl) {
        if (DEBUG || bl || openEGLDisplays.size() > 0) {
            System.err.println("EGLDisplayUtil.EGLDisplays: Shutdown (open: " + openEGLDisplays.size() + ")");
            if (DEBUG) {
                ExceptionUtils.dumpStack(System.err);
            }
            if (openEGLDisplays.size() > 0) {
                EGLDisplayUtil.dumpOpenDisplayConnections();
            }
        }
        return openEGLDisplays.size();
    }

    public static void dumpOpenDisplayConnections() {
        System.err.println("EGLDisplayUtil: Open EGL Display Connections: " + openEGLDisplays.size());
        int n2 = 0;
        for (LongObjectHashMap.Entry entry : openEGLDisplays) {
            EGLDisplayRef eGLDisplayRef = (EGLDisplayRef)entry.value;
            System.err.println("EGLDisplayUtil: Open[" + n2 + "]: 0x" + Long.toHexString(entry.key) + ": " + eGLDisplayRef);
            if (null != eGLDisplayRef.createdStack) {
                eGLDisplayRef.createdStack.printStackTrace();
            }
            ++n2;
        }
    }

    static synchronized void setSingletonEGLDisplayOnly(boolean bl) {
        useSingletonEGLDisplay = bl;
    }

    public static int getEGLPlatformType(boolean bl) {
        return EGLDisplayUtil.getEGLPlatformType(NativeWindowFactory.getNativeWindowType(bl));
    }

    public static int getEGLPlatformType(String string) {
        int n2;
        switch (string) {
            case ".x11": {
                n2 = 12757;
                break;
            }
            case ".android": {
                n2 = 12609;
                break;
            }
            case ".egl.gbm": {
                n2 = 12759;
                break;
            }
            case ".wayland": {
                n2 = 12760;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private static synchronized long eglGetDisplay(long l2) {
        if (useSingletonEGLDisplay && null != singletonEGLDisplay) {
            if (DEBUG) {
                System.err.println("EGLDisplayUtil.eglGetDisplay.s: eglDisplay(" + EGLContext.toHexString(l2) + "): " + EGLContext.toHexString(EGLDisplayUtil.singletonEGLDisplay.eglDisplay) + ", " + (0L != EGLDisplayUtil.singletonEGLDisplay.eglDisplay ? "OK" : "Failed") + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
            }
            return EGLDisplayUtil.singletonEGLDisplay.eglDisplay;
        }
        if (!eglGetPlatformDisplayProbed) {
            int n2;
            boolean bl = false;
            boolean bl2 = false;
            GLVersionNumber gLVersionNumber = GLVersionNumber.create(EGL.eglQueryString(0L, 12372));
            int n3 = EGL.eglGetError();
            boolean bl3 = eglGetPlatformDisplayAvail = 12288 == n3 && gLVersionNumber.isValid() && gLVersionNumber.compareTo(eglGetPlatformDisplayMinVersion) >= 0;
            if (!eglGetPlatformDisplayAvail) {
                String string = EGL.eglQueryString(0L, 12373);
                n2 = EGL.eglGetError();
                if (12288 == n2 && null != string && string.length() > 0 && string.indexOf("EGL_EXT_platform_base") >= 0) {
                    eglGetPlatformDisplayAvail = true;
                    bl2 = true;
                }
            } else {
                n2 = 12288;
            }
            eglGetPlatformDisplayProbed = true;
            if (DEBUG) {
                System.err.println("EGLDisplayUtil.eglGetDisplay.p: eglGetPlatformDisplay available: " + eglGetPlatformDisplayAvail + ", eglClientVersion '" + gLVersionNumber + "' via[Version " + bl3 + ", err 0x" + Integer.toHexString(n3) + " / Extension " + bl2 + ", err 0x" + Integer.toHexString(n2) + "]");
            }
        }
        int n4 = EGLDisplayUtil.getEGLPlatformType(true);
        long l3 = eglGetPlatformDisplayAvail && 0 != n4 ? EGL.eglGetPlatformDisplay(n4, l2, null) : EGL.eglGetDisplay(l2);
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglGetDisplay.X: eglDisplay(" + EGLContext.toHexString(l2) + ") @ " + n4 + "/" + NativeWindowFactory.getNativeWindowType(true) + ": " + EGLContext.toHexString(l3) + ", " + (0L != l3 ? "OK" : "Failed") + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
        }
        return l3;
    }

    private static synchronized boolean eglInitialize(long l2, int[] nArray, int[] nArray2) {
        if (0L == l2) {
            return false;
        }
        EGLDisplayRef eGLDisplayRef = EGLDisplayRef.getOrCreateOpened(l2, _eglMajorVersion, _eglMinorVersion);
        int n2 = _eglMajorVersion.get(0);
        int n3 = _eglMinorVersion.get(0);
        if (null != nArray && null != nArray2) {
            if (null != eGLDisplayRef) {
                nArray[0] = n2;
                nArray2[0] = n3;
            } else {
                nArray[0] = 0;
                nArray2[0] = 0;
            }
        }
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglInitialize(" + EGLContext.toHexString(l2) + " ...): " + eGLDisplayRef + " = " + (null != eGLDisplayRef) + ", eglVersion " + n2 + "." + n3 + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
        }
        return null != eGLDisplayRef;
    }

    private static synchronized int eglGetDisplayAndInitialize(long l2, long[] lArray, int[] nArray, int[] nArray2, int[] nArray3) {
        lArray[0] = 0L;
        long l3 = EGLDisplayUtil.eglGetDisplay(l2);
        if (0L == l3) {
            nArray[0] = EGL.eglGetError();
            return 12296;
        }
        if (!EGLDisplayUtil.eglInitialize(l3, nArray2, nArray3)) {
            nArray[0] = EGL.eglGetError();
            return 12289;
        }
        lArray[0] = l3;
        return 12288;
    }

    private static synchronized long eglGetDisplayAndInitialize(long[] lArray, int[] nArray, int[] nArray2) {
        long[] lArray2 = new long[1];
        int[] nArray3 = new int[1];
        int n2 = EGLDisplayUtil.eglGetDisplayAndInitialize(lArray[0], lArray2, nArray3, nArray, nArray2);
        if (12288 == n2) {
            return lArray2[0];
        }
        if (0L != lArray[0]) {
            if (DEBUG) {
                System.err.println("EGLDisplayUtil.eglGetAndInitDisplay failed with native " + EGLContext.toHexString(lArray[0]) + ", error " + EGLContext.toHexString(n2) + "/" + EGLContext.toHexString(nArray3[0]) + " - fallback!");
            }
            if (12288 == (n2 = EGLDisplayUtil.eglGetDisplayAndInitialize(0L, lArray2, nArray3, nArray, nArray2))) {
                lArray[0] = 0L;
                return lArray2[0];
            }
        }
        throw new GLException("Failed to created/initialize EGL display incl. fallback default: native " + EGLContext.toHexString(lArray[0]) + ", error " + EGLContext.toHexString(n2) + "/" + EGLContext.toHexString(nArray3[0]));
    }

    private static synchronized boolean eglTerminate(long l2) {
        if (0L == l2) {
            return false;
        }
        boolean[] blArray = new boolean[1];
        EGLDisplayRef eGLDisplayRef = EGLDisplayRef.closeOpened(l2, blArray);
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglTerminate.X(" + EGLContext.toHexString(l2) + " ...): " + eGLDisplayRef + " = " + blArray[0] + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
        }
        return blArray[0];
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(long l2, String string, int n2) {
        return new EGLGraphicsDevice(l2, 0L, string, n2, eglLifecycleCallback);
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        return new EGLGraphicsDevice(abstractGraphicsDevice, 0L, eglLifecycleCallback);
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(NativeSurface nativeSurface) {
        long l2 = ".windows" == NativeWindowFactory.getNativeWindowType(false) ? nativeSurface.getSurfaceHandle() : nativeSurface.getDisplayHandle();
        AbstractGraphicsDevice abstractGraphicsDevice = nativeSurface.getGraphicsConfiguration().getScreen().getDevice();
        return new EGLGraphicsDevice(l2, 0L, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID(), eglLifecycleCallback);
    }

    static {
        openEGLDisplays.setKeyNotFoundValue(null);
        eglGetPlatformDisplayProbed = false;
        eglGetPlatformDisplayAvail = false;
        eglGetPlatformDisplayMinVersion = new VersionNumber(1, 5, 0);
        _eglMajorVersion = Buffers.newDirectIntBuffer(1);
        _eglMinorVersion = Buffers.newDirectIntBuffer(1);
        eglLifecycleCallback = new EGLGraphicsDevice.EGLDisplayLifecycleCallback(){

            @Override
            public long eglGetAndInitDisplay(long[] lArray, int[] nArray, int[] nArray2) {
                return EGLDisplayUtil.eglGetDisplayAndInitialize(lArray, nArray, nArray2);
            }

            @Override
            public void eglTerminate(long l2) {
                EGLDisplayUtil.eglTerminate(l2);
            }
        };
    }

    private static class EGLDisplayRef {
        final long eglDisplay;
        final Throwable createdStack;
        int initRefCount;

        static EGLDisplayRef getOrCreateOpened(long l2, IntBuffer intBuffer, IntBuffer intBuffer2) {
            EGLDisplayRef eGLDisplayRef = (EGLDisplayRef)openEGLDisplays.get(l2);
            if (null == eGLDisplayRef) {
                boolean bl = EGL.eglInitialize(l2, intBuffer, intBuffer2);
                if (DEBUG) {
                    System.err.println("EGLDisplayUtil.EGL.eglInitialize 0x" + Long.toHexString(l2) + " -> " + bl);
                }
                if (bl) {
                    EGLDisplayRef eGLDisplayRef2 = new EGLDisplayRef(l2);
                    openEGLDisplays.put(l2, eGLDisplayRef2);
                    ++eGLDisplayRef2.initRefCount;
                    if (DEBUG) {
                        System.err.println("EGLDisplayUtil.EGL.eglInitialize " + eGLDisplayRef2);
                    }
                    if (null == singletonEGLDisplay) {
                        singletonEGLDisplay = eGLDisplayRef2;
                    }
                    return eGLDisplayRef2;
                }
                return null;
            }
            ++eGLDisplayRef.initRefCount;
            return eGLDisplayRef;
        }

        static EGLDisplayRef closeOpened(long l2, boolean[] blArray) {
            EGLDisplayRef eGLDisplayRef = (EGLDisplayRef)openEGLDisplays.get(l2);
            blArray[0] = true;
            if (null != eGLDisplayRef) {
                if (0 < eGLDisplayRef.initRefCount) {
                    --eGLDisplayRef.initRefCount;
                    if (0 == eGLDisplayRef.initRefCount) {
                        boolean bl = EGL.eglTerminate(l2);
                        if (DEBUG) {
                            System.err.println("EGLDisplayUtil.EGL.eglTerminate 0x" + Long.toHexString(l2) + " -> " + bl);
                            System.err.println("EGLDisplayUtil.EGL.eglTerminate " + eGLDisplayRef);
                        }
                        blArray[0] = bl;
                        if (eGLDisplayRef == singletonEGLDisplay) {
                            singletonEGLDisplay = null;
                        }
                    }
                }
                if (0 >= eGLDisplayRef.initRefCount) {
                    openEGLDisplays.remove(l2);
                }
            }
            return eGLDisplayRef;
        }

        private EGLDisplayRef(long l2) {
            this.eglDisplay = l2;
            this.initRefCount = 0;
            this.createdStack = DEBUG ? new Throwable() : null;
        }

        public String toString() {
            return "EGLDisplayRef[0x" + Long.toHexString(this.eglDisplay) + ": refCnt " + this.initRefCount + "]";
        }
    }
}

