/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.opengl.GLException;
import com.jogamp.opengl.fixedfunc.GLMatrixFunc;
import com.jogamp.opengl.math.FloatUtil;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class ProjectFloat {
    private final float[] mat4Tmp1 = new float[16];
    private final float[] mat4Tmp2 = new float[16];
    private final float[] mat4Tmp3 = new float[16];

    public static final int getRequiredFloatBufferSize() {
        return 16;
    }

    public void gluOrtho2D(GLMatrixFunc gLMatrixFunc, float f2, float f3, float f4, float f5) {
        gLMatrixFunc.glOrthof(f2, f3, f4, f5, -1.0f, 1.0f);
    }

    public void gluPerspective(GLMatrixFunc gLMatrixFunc, float f2, float f3, float f4, float f5) throws GLException {
        gLMatrixFunc.glMultMatrixf(FloatUtil.makePerspective(this.mat4Tmp1, 0, true, f2 * (float)Math.PI / 180.0f, f3, f4, f5), 0);
    }

    public void gluLookAt(GLMatrixFunc gLMatrixFunc, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.mat4Tmp2[0] = f2;
        this.mat4Tmp2[1] = f3;
        this.mat4Tmp2[2] = f4;
        this.mat4Tmp2[4] = f5;
        this.mat4Tmp2[5] = f6;
        this.mat4Tmp2[6] = f7;
        this.mat4Tmp2[8] = f8;
        this.mat4Tmp2[9] = f9;
        this.mat4Tmp2[10] = f10;
        gLMatrixFunc.glMultMatrixf(FloatUtil.makeLookAt(this.mat4Tmp1, 0, this.mat4Tmp2, 0, this.mat4Tmp2, 4, this.mat4Tmp2, 8, this.mat4Tmp3), 0);
    }

    public boolean gluProject(float f2, float f3, float f4, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, float[] fArray3, int n5) {
        return FloatUtil.mapObjToWinCoords(f2, f3, f4, fArray, n2, fArray2, n3, nArray, n4, fArray3, n5, this.mat4Tmp1, this.mat4Tmp2);
    }

    public boolean gluProject(float f2, float f3, float f4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int[] nArray, int n2, float[] fArray, int n3) {
        float[] fArray2 = this.mat4Tmp1;
        float[] fArray3 = this.mat4Tmp2;
        fArray2[0] = f2;
        fArray2[1] = f3;
        fArray2[2] = f4;
        fArray2[3] = 1.0f;
        FloatUtil.multMatrixVec(floatBuffer, fArray2, fArray3);
        FloatUtil.multMatrixVec(floatBuffer2, fArray3, fArray2);
        if (fArray2[3] == 0.0f) {
            return false;
        }
        fArray2[3] = 1.0f / fArray2[3] * 0.5f;
        fArray2[0] = fArray2[0] * fArray2[3] + 0.5f;
        fArray2[1] = fArray2[1] * fArray2[3] + 0.5f;
        fArray2[2] = fArray2[2] * fArray2[3] + 0.5f;
        fArray[0 + n3] = fArray2[0] * (float)nArray[2 + n2] + (float)nArray[0 + n2];
        fArray[1 + n3] = fArray2[1] * (float)nArray[3 + n2] + (float)nArray[1 + n2];
        fArray[2 + n3] = fArray2[2];
        return true;
    }

    public boolean gluProject(float f2, float f3, float f4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3) {
        float[] fArray = this.mat4Tmp1;
        float[] fArray2 = this.mat4Tmp2;
        fArray[0] = f2;
        fArray[1] = f3;
        fArray[2] = f4;
        fArray[3] = 1.0f;
        FloatUtil.multMatrixVec(floatBuffer, fArray, fArray2);
        FloatUtil.multMatrixVec(floatBuffer2, fArray2, fArray);
        if (fArray[3] == 0.0f) {
            return false;
        }
        fArray[3] = 1.0f / fArray[3] * 0.5f;
        fArray[0] = fArray[0] * fArray[3] + 0.5f;
        fArray[1] = fArray[1] * fArray[3] + 0.5f;
        fArray[2] = fArray[2] * fArray[3] + 0.5f;
        int n2 = intBuffer.position();
        int n3 = floatBuffer3.position();
        floatBuffer3.put(0 + n3, fArray[0] * (float)intBuffer.get(2 + n2) + (float)intBuffer.get(0 + n2));
        floatBuffer3.put(1 + n3, fArray[1] * (float)intBuffer.get(3 + n2) + (float)intBuffer.get(1 + n2));
        floatBuffer3.put(2 + n3, fArray[2]);
        return true;
    }

    public boolean gluUnProject(float f2, float f3, float f4, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, float[] fArray3, int n5) {
        return FloatUtil.mapWinToObjCoords(f2, f3, f4, fArray, n2, fArray2, n3, nArray, n4, fArray3, n5, this.mat4Tmp1, this.mat4Tmp2);
    }

    public boolean gluUnProject(float f2, float f3, float f4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int[] nArray, int n2, float[] fArray, int n3) {
        FloatUtil.multMatrix(floatBuffer2, floatBuffer, this.mat4Tmp1);
        if (null == FloatUtil.invertMatrix(this.mat4Tmp1, this.mat4Tmp1)) {
            return false;
        }
        this.mat4Tmp2[0] = f2;
        this.mat4Tmp2[1] = f3;
        this.mat4Tmp2[2] = f4;
        this.mat4Tmp2[3] = 1.0f;
        this.mat4Tmp2[0] = (this.mat4Tmp2[0] - (float)nArray[0 + n2]) / (float)nArray[2 + n2];
        this.mat4Tmp2[1] = (this.mat4Tmp2[1] - (float)nArray[1 + n2]) / (float)nArray[3 + n2];
        this.mat4Tmp2[0] = this.mat4Tmp2[0] * 2.0f - 1.0f;
        this.mat4Tmp2[1] = this.mat4Tmp2[1] * 2.0f - 1.0f;
        this.mat4Tmp2[2] = this.mat4Tmp2[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(this.mat4Tmp1, 0, this.mat4Tmp2, 0, this.mat4Tmp2, 4);
        if ((double)this.mat4Tmp2[7] == 0.0) {
            return false;
        }
        this.mat4Tmp2[7] = 1.0f / this.mat4Tmp2[7];
        fArray[0 + n3] = this.mat4Tmp2[4] * this.mat4Tmp2[7];
        fArray[1 + n3] = this.mat4Tmp2[5] * this.mat4Tmp2[7];
        fArray[2 + n3] = this.mat4Tmp2[6] * this.mat4Tmp2[7];
        return true;
    }

    public boolean gluUnProject(float f2, float f3, float f4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3) {
        int n2 = intBuffer.position();
        int n3 = floatBuffer3.position();
        FloatUtil.multMatrix(floatBuffer2, floatBuffer, this.mat4Tmp1);
        if (null == FloatUtil.invertMatrix(this.mat4Tmp1, this.mat4Tmp1)) {
            return false;
        }
        this.mat4Tmp2[0] = f2;
        this.mat4Tmp2[1] = f3;
        this.mat4Tmp2[2] = f4;
        this.mat4Tmp2[3] = 1.0f;
        this.mat4Tmp2[0] = (this.mat4Tmp2[0] - (float)intBuffer.get(0 + n2)) / (float)intBuffer.get(2 + n2);
        this.mat4Tmp2[1] = (this.mat4Tmp2[1] - (float)intBuffer.get(1 + n2)) / (float)intBuffer.get(3 + n2);
        this.mat4Tmp2[0] = this.mat4Tmp2[0] * 2.0f - 1.0f;
        this.mat4Tmp2[1] = this.mat4Tmp2[1] * 2.0f - 1.0f;
        this.mat4Tmp2[2] = this.mat4Tmp2[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(this.mat4Tmp1, 0, this.mat4Tmp2, 0, this.mat4Tmp2, 4);
        if ((double)this.mat4Tmp2[7] == 0.0) {
            return false;
        }
        this.mat4Tmp2[7] = 1.0f / this.mat4Tmp2[7];
        floatBuffer3.put(0 + n3, this.mat4Tmp2[4] * this.mat4Tmp2[7]);
        floatBuffer3.put(1 + n3, this.mat4Tmp2[5] * this.mat4Tmp2[7]);
        floatBuffer3.put(2 + n3, this.mat4Tmp2[6] * this.mat4Tmp2[7]);
        return true;
    }

    public boolean gluUnProject4(float f2, float f3, float f4, float f5, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, float f6, float f7, float[] fArray3, int n5) {
        return FloatUtil.mapWinToObjCoords(f2, f3, f4, f5, fArray, n2, fArray2, n3, nArray, n4, f6, f7, fArray3, n5, this.mat4Tmp1, this.mat4Tmp2);
    }

    public boolean gluUnProject4(float f2, float f3, float f4, float f5, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, float f6, float f7, FloatBuffer floatBuffer3) {
        FloatUtil.multMatrix(floatBuffer2, floatBuffer, this.mat4Tmp1);
        if (null == FloatUtil.invertMatrix(this.mat4Tmp1, this.mat4Tmp1)) {
            return false;
        }
        this.mat4Tmp2[0] = f2;
        this.mat4Tmp2[1] = f3;
        this.mat4Tmp2[2] = f4;
        this.mat4Tmp2[3] = f5;
        int n2 = intBuffer.position();
        this.mat4Tmp2[0] = (this.mat4Tmp2[0] - (float)intBuffer.get(0 + n2)) / (float)intBuffer.get(2 + n2);
        this.mat4Tmp2[1] = (this.mat4Tmp2[1] - (float)intBuffer.get(1 + n2)) / (float)intBuffer.get(3 + n2);
        this.mat4Tmp2[2] = (this.mat4Tmp2[2] - f6) / (f7 - f6);
        this.mat4Tmp2[0] = this.mat4Tmp2[0] * 2.0f - 1.0f;
        this.mat4Tmp2[1] = this.mat4Tmp2[1] * 2.0f - 1.0f;
        this.mat4Tmp2[2] = this.mat4Tmp2[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(this.mat4Tmp1, 0, this.mat4Tmp2, 0, this.mat4Tmp2, 4);
        if (this.mat4Tmp2[7] == 0.0f) {
            return false;
        }
        int n3 = floatBuffer3.position();
        floatBuffer3.put(0 + n3, this.mat4Tmp2[4]);
        floatBuffer3.put(1 + n3, this.mat4Tmp2[5]);
        floatBuffer3.put(2 + n3, this.mat4Tmp2[6]);
        floatBuffer3.put(3 + n3, this.mat4Tmp2[7]);
        return true;
    }

    public void gluPickMatrix(GLMatrixFunc gLMatrixFunc, float f2, float f3, float f4, float f5, IntBuffer intBuffer) {
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return;
        }
        int n2 = intBuffer.position();
        gLMatrixFunc.glTranslatef(((float)intBuffer.get(2 + n2) - 2.0f * (f2 - (float)intBuffer.get(0 + n2))) / f4, ((float)intBuffer.get(3 + n2) - 2.0f * (f3 - (float)intBuffer.get(1 + n2))) / f5, 0.0f);
        gLMatrixFunc.glScalef((float)intBuffer.get(2) / f4, (float)intBuffer.get(3) / f5, 1.0f);
    }

    public void gluPickMatrix(GLMatrixFunc gLMatrixFunc, float f2, float f3, float f4, float f5, int[] nArray, int n2) {
        if (null != FloatUtil.makePick(this.mat4Tmp1, 0, f2, f3, f4, f5, nArray, n2, this.mat4Tmp2)) {
            gLMatrixFunc.glMultMatrixf(this.mat4Tmp1, 0);
        }
    }
}

