/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import java.util.HashMap;
import java.util.StringTokenizer;
import jogamp.opengl.GLContextImpl;

final class ExtensionAvailabilityCache {
    protected static final boolean DEBUG = GLContextImpl.DEBUG;
    private boolean initialized = false;
    private String glExtensions = null;
    private int glExtensionCount = 0;
    private String glXExtensions = null;
    private int glXExtensionCount = 0;
    private final HashMap<String, String> availableExtensionCache = new HashMap(100);

    ExtensionAvailabilityCache() {
        this.flush();
    }

    final void flush() {
        this.initialized = false;
        this.glExtensions = null;
        this.glExtensionCount = 0;
        this.glXExtensions = null;
        this.glXExtensionCount = 0;
        this.availableExtensionCache.clear();
    }

    final void reset(GLContextImpl gLContextImpl) {
        this.flush();
        this.initAvailableExtensions(gLContextImpl);
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    final int getTotalExtensionCount() {
        this.validateInitialization();
        return this.availableExtensionCache.size();
    }

    final boolean isExtensionAvailable(String string) {
        this.validateInitialization();
        return null != this.availableExtensionCache.get(string);
    }

    final int getPlatformExtensionCount() {
        this.validateInitialization();
        return this.glXExtensionCount;
    }

    final String getPlatformExtensionsString() {
        this.validateInitialization();
        return this.glXExtensions;
    }

    final int getGLExtensionCount() {
        this.validateInitialization();
        return this.glExtensionCount;
    }

    final String getGLExtensionsString() {
        this.validateInitialization();
        if (DEBUG) {
            System.err.println("ExtensionAvailabilityCache: getGLExtensions() called");
        }
        return this.glExtensions;
    }

    private final void validateInitialization() {
        if (!this.isInitialized()) {
            throw new InternalError("ExtensionAvailabilityCache not initialized!");
        }
    }

    private final void initAvailableExtensions(GLContextImpl gLContextImpl) {
        Object object;
        int n2;
        GL gL = gLContextImpl.getGL();
        if (this.isInitialized()) {
            throw new InternalError("ExtensionAvailabilityCache already initialized!");
        }
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Pre-caching init " + gL + ", OpenGL " + gLContextImpl.getGLVersion());
        }
        boolean bl = false;
        if (gLContextImpl.isGL3() || gLContextImpl.isGLES3()) {
            if (!gLContextImpl.has_glGetStringiInt()) {
                if (DEBUG) {
                    System.err.println("GLContext: GL >= 3.1 usage, but no glGetStringi");
                }
            } else {
                bl = true;
            }
        }
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Pre-caching extension availability OpenGL " + gLContextImpl.getGLVersion() + ", use " + (bl ? "glGetStringi" : "glGetString"));
        }
        if (bl) {
            Object object2 = new int[]{0};
            gLContextImpl.glGetIntegervInt(33309, (int[])object2, 0);
            int n3 = object2[0];
            object2 = new StringBuilder();
            try {
                for (n2 = 0; n2 < n3; ++n2) {
                    object = gLContextImpl.glGetStringiInt(7939, n2);
                    if (null != this.availableExtensionCache.put((String)object, (String)object)) continue;
                    if (0 < n2) {
                        ((StringBuilder)object2).append(" ");
                    }
                    ((StringBuilder)object2).append((String)object);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                ExceptionUtils.dumpThrowable("glGetStringi native access", unsatisfiedLinkError);
            }
            if (0 == n3 || ((StringBuilder)object2).length() == 0) {
                bl = false;
            } else {
                this.glExtensions = ((StringBuilder)object2).toString();
                this.glExtensionCount = n3;
            }
        }
        if (!bl) {
            this.glExtensions = gLContextImpl.glGetStringInt(7939);
            if (null != this.glExtensions) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.glExtensions);
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken().trim();
                    if (null != this.availableExtensionCache.put(string, string)) continue;
                    ++n4;
                }
                this.glExtensionCount = n4;
            }
        }
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GL_EXTENSIONS: " + this.glExtensionCount + ", used " + (bl ? "glGetStringi" : "glGetString"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object object3 = new StringTokenizer(gLContextImpl.getPlatformExtensionsStringImpl().toString());
        n2 = 0;
        while (((StringTokenizer)object3).hasMoreTokens()) {
            object = ((StringTokenizer)object3).nextToken().trim();
            if (null != this.availableExtensionCache.put((String)object, (String)object)) continue;
            if (0 < n2) {
                stringBuilder.append(" ");
            }
            stringBuilder.append((String)object);
            ++n2;
        }
        this.glXExtensions = stringBuilder.toString();
        this.glXExtensionCount = n2;
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GLX_EXTENSIONS: " + this.glXExtensionCount);
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GL vendor: " + gLContextImpl.glGetStringInt(7936));
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: ALL EXTENSIONS: " + this.availableExtensionCache.size());
        }
        int n5 = gLContextImpl.getCtxOptions();
        object3 = gLContextImpl.getGLVersionNumber();
        int[] nArray = new int[]{((VersionNumber)object3).getMajor()};
        object = new int[]{((VersionNumber)object3).getMinor()};
        do {
            String string = (gLContextImpl.isGLES() ? "GL_ES_VERSION_" : "GL_VERSION_") + nArray[0] + "_" + (int)object[0];
            this.availableExtensionCache.put(string, string);
            if (!DEBUG) continue;
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Added " + string + " to known extensions");
        } while (GLContext.decrementGLVersion(n5, nArray, (int[])object));
        this.availableExtensionCache.put("<INTERNAL_DUMMY_PLACEHOLDER>", "<INTERNAL_DUMMY_PLACEHOLDER>");
        this.initialized = true;
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }
}

