/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.macosx;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.RunnableTask;
import com.jogamp.common.util.TaskBase;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.newt.util.EDTUtil;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.newt.Debug;

public class AppKitEDTUtil
implements EDTUtil {
    public static final boolean DEBUG = Debug.debug("EDT");
    private final Object edtLock = new Object();
    private ThreadGroup threadGroup;
    private final String name;
    private final Runnable dispatchMessages;
    private NEDT nedt = null;
    private int start_iter = 0;
    private static long pollPeriod = 10L;

    public AppKitEDTUtil(ThreadGroup threadGroup, String string, Runnable runnable) {
        this.threadGroup = threadGroup;
        this.name = Thread.currentThread().getName() + "-" + string + "-EDT-";
        this.dispatchMessages = runnable;
        this.nedt = new NEDT(this.threadGroup, this.name);
        this.nedt.setDaemon(true);
    }

    @Override
    public final long getPollPeriod() {
        return pollPeriod;
    }

    @Override
    public final void setPollPeriod(long l2) {
        pollPeriod = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws IllegalStateException {
        Object object = this.edtLock;
        synchronized (object) {
            if (this.nedt.isRunning()) {
                throw new IllegalStateException("EDT still running and not subject to stop. Curr " + Thread.currentThread().getName() + ", EDT " + this.nedt.getName() + ", isRunning " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop);
            }
            if (DEBUG) {
                System.err.println(Thread.currentThread() + ": AppKit-EDT reset - edt: " + this.nedt);
            }
            if (this.nedt.getState() != Thread.State.NEW) {
                if (null != this.threadGroup && this.threadGroup.isDestroyed()) {
                    this.threadGroup = Thread.currentThread().getThreadGroup();
                }
                this.nedt = new NEDT(this.threadGroup, this.name);
                this.nedt.setDaemon(true);
            }
            this.startImpl();
        }
        if (!this.nedt.isRunning()) {
            throw new RuntimeException("EDT could not be started: " + this.nedt);
        }
    }

    private final void startImpl() {
        if (this.nedt.isAlive()) {
            throw new RuntimeException("AppKit-EDT Thread.isAlive(): true, isRunning: " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop + ", edt: " + this.nedt);
        }
        ++this.start_iter;
        this.nedt.setName(this.name + this.start_iter);
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": AppKit-EDT START - edt: " + this.nedt);
        }
        this.nedt.start();
    }

    @Override
    public final boolean isCurrentThreadEDT() {
        return OSXUtil.IsMainThread();
    }

    @Override
    public final boolean isCurrentThreadNEDT() {
        return this.nedt == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadEDTorNEDT() {
        return OSXUtil.IsMainThread() || this.nedt == Thread.currentThread();
    }

    @Override
    public final boolean isRunning() {
        return this.nedt.isRunning();
    }

    @Override
    public final boolean invokeStop(boolean bl, Runnable runnable) {
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": AppKit-EDT.invokeStop wait " + bl);
            ExceptionUtils.dumpStack(System.err);
        }
        return this.invokeImpl(bl, runnable, true, false);
    }

    public final boolean invokeAndWaitError(Runnable runnable) {
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": AppKit-EDT.invokeAndWaitError");
            ExceptionUtils.dumpStack(System.err);
        }
        return this.invokeImpl(true, runnable, false, true);
    }

    @Override
    public final boolean invoke(boolean bl, Runnable runnable) {
        return this.invokeImpl(bl, runnable, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean invokeImpl(boolean bl, Runnable runnable, boolean bl2, boolean bl3) {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            TaskBase taskBase;
            Object object3 = this.edtLock;
            synchronized (object3) {
                if (this.nedt.shouldStop) {
                    System.err.println(Thread.currentThread() + ": Warning: AppKit-EDT about (1) to stop, won't enqueue new task: " + this.nedt);
                    if (DEBUG) {
                        ExceptionUtils.dumpStack(System.err);
                    }
                    return false;
                }
                if (this.isCurrentThreadEDT()) {
                    if (null != runnable) {
                        runnable.run();
                    }
                    bl = false;
                    taskBase = null;
                    if (bl2) {
                        this.nedt.shouldStop = true;
                    }
                } else {
                    if (!this.nedt.isRunning) {
                        if (null != runnable) {
                            if (bl2) {
                                System.err.println(Thread.currentThread() + ": Warning: AppKit-EDT is about (3) to stop and stopped already, dropping task - " + this.nedt);
                            } else {
                                System.err.println(Thread.currentThread() + ": Warning: AppKit-EDT is not running, dropping task. NEDT " + this.nedt);
                            }
                            if (DEBUG) {
                                ExceptionUtils.dumpStack(System.err);
                            }
                        }
                        return false;
                    }
                    if (bl2 && this.nedt.isRunning) {
                        if (DEBUG) {
                            System.err.println(Thread.currentThread() + ": AppKit-EDT signal STOP (on edt: " + this.isCurrentThreadEDT() + ") - " + this.nedt + ", isRunning " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop);
                        }
                        Object object4 = this.nedt.sync;
                        synchronized (object4) {
                            this.nedt.shouldStop = true;
                            this.nedt.sync.notifyAll();
                        }
                    }
                    if (null != runnable) {
                        taskBase = new RunnableTask(runnable, bl ? object : null, true, bl ? null : System.err);
                        OSXUtil.RunOnMainThread(false, false, taskBase);
                    } else {
                        bl = false;
                        taskBase = null;
                    }
                }
            }
            if (bl) {
                try {
                    while (taskBase.isInQueue()) {
                        object.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
                object3 = taskBase.getThrowable();
                if (null != object3) {
                    if (object3 instanceof NativeWindowException) {
                        throw (NativeWindowException)object3;
                    }
                    throw new RuntimeException((Throwable)object3);
                }
            }
            if (DEBUG && bl2) {
                System.err.println(Thread.currentThread() + ": AppKit-EDT signal STOP X edt: " + this.nedt);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilIdle() {
        NEDT nEDT;
        Object object = this.edtLock;
        synchronized (object) {
            nEDT = this.nedt;
        }
        if (!nEDT.isRunning || nEDT == Thread.currentThread() || OSXUtil.IsMainThread()) {
            return false;
        }
        OSXUtil.WaitUntilFinish();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilStopped() {
        Object object = this.edtLock;
        synchronized (object) {
            Thread thread2 = Thread.currentThread();
            boolean bl = OSXUtil.IsMainThread();
            if (this.nedt.isRunning && this.nedt != thread2 && !bl) {
                try {
                    while (this.nedt.isRunning) {
                        this.edtLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
                return true;
            }
            return false;
        }
    }

    class NEDT
    extends InterruptSource.Thread {
        volatile boolean shouldStop;
        volatile boolean isRunning;
        Object sync;

        public NEDT(ThreadGroup threadGroup, String string) {
            super(threadGroup, null, string);
            this.shouldStop = false;
            this.isRunning = false;
            this.sync = new Object();
        }

        public final boolean isRunning() {
            return this.isRunning && !this.shouldStop;
        }

        @Override
        public final void start() throws IllegalThreadStateException {
            this.isRunning = true;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object;
            if (DEBUG) {
                System.err.println(this.getName() + ": AppKit-EDT run() START " + this.getName());
            }
            RuntimeException runtimeException = null;
            try {
                do {
                    if (!this.shouldStop) {
                        AppKitEDTUtil.this.dispatchMessages.run();
                    }
                    object = this.sync;
                    synchronized (object) {
                        if (!this.shouldStop) {
                            try {
                                this.sync.wait(pollPeriod);
                            }
                            catch (InterruptedException interruptedException) {
                                throw new InterruptedRuntimeException(interruptedException);
                            }
                        }
                    }
                } while (!this.shouldStop);
            }
            catch (Throwable throwable) {
                this.shouldStop = true;
                if (throwable instanceof RuntimeException) {
                    runtimeException = (RuntimeException)throwable;
                }
                runtimeException = new RuntimeException("Within AppKit-EDT", throwable);
            }
            finally {
                if (DEBUG) {
                    System.err.println(this.getName() + ": AppKit-EDT run() END " + this.getName() + ", " + runtimeException);
                }
                object = AppKitEDTUtil.this.edtLock;
                synchronized (object) {
                    this.isRunning = false;
                    AppKitEDTUtil.this.edtLock.notifyAll();
                }
                if (DEBUG) {
                    System.err.println(this.getName() + ": AppKit-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
                }
                if (null != runtimeException) {
                    throw runtimeException;
                }
            }
        }
    }
}

