/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.ios;

import com.jogamp.common.util.Function;
import com.jogamp.common.util.FunctionTask;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.RunnableTask;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.Point;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.ToolkitProperties;

public class IOSUtil
implements ToolkitProperties {
    private static boolean isInit = false;
    private static final boolean DEBUG = Debug.debug("IOSUtil");
    private static final ThreadLocal<Boolean> tlsIsMainThread = new ThreadLocal();
    public static final int MAX_PIXELSCALE = 2;
    private static Runnable _nop = new Runnable(){

        @Override
        public void run() {
        }
    };

    public static synchronized void initSingleton() {
        if (!isInit) {
            if (DEBUG) {
                System.out.println("IOSUtil.initSingleton()");
            }
            if (!NWJNILibLoader.loadNativeWindow("ios")) {
                throw new NativeWindowException("NativeWindow IOS native library load error.");
            }
            if (!IOSUtil.initIDs0()) {
                throw new NativeWindowException("IOS: Could not initialized native stub");
            }
            isInit = true;
        }
    }

    public static void shutdown() {
    }

    public static boolean requiresToolkitLock() {
        return false;
    }

    public static final boolean hasThreadingIssues() {
        return false;
    }

    public static boolean isCALayer(long l2) {
        return 0L != l2 ? IOSUtil.isCALayer0(l2) : false;
    }

    public static boolean isCAEAGLLayer(long l2) {
        return 0L != l2 ? IOSUtil.isCAEAGLLayer0(l2) : false;
    }

    public static boolean isUIView(long l2) {
        return 0L != l2 ? IOSUtil.isUIView0(l2) : false;
    }

    public static boolean isUIWindow(long l2) {
        return 0L != l2 ? IOSUtil.isUIWindow0(l2) : false;
    }

    public static Point GetLocationOnScreen(long l2, int n2, int n3) {
        return (Point)IOSUtil.GetLocationOnScreen0(l2, n2, n3);
    }

    public static Insets GetInsets(long l2) {
        return (Insets)IOSUtil.GetInsets0(l2);
    }

    public static float GetScreenPixelScaleByScreenIdx(int n2) {
        if (0 <= n2) {
            return IOSUtil.GetScreenPixelScale1(n2);
        }
        return 1.0f;
    }

    public static float GetScreenPixelScale(long l2) {
        if (0L != l2) {
            return IOSUtil.GetScreenPixelScale2(l2);
        }
        return 1.0f;
    }

    public static long CreateUIWindow(final int n2, final int n3, final int n4, final int n5, final boolean bl) {
        final long[] lArray = new long[]{0L};
        IOSUtil.RunOnMainThread(true, false, new Runnable(){

            @Override
            public void run() {
                lArray[0] = IOSUtil.CreateUIWindow0(n2, n3, n4, n5, bl);
            }
        });
        return lArray[0];
    }

    public static void DestroyUIWindow(long l2) {
        IOSUtil.DestroyUIWindow0(l2);
    }

    public static long GetCALayer(long l2) {
        return 0L != l2 ? IOSUtil.GetCALayer0(l2) : 0L;
    }

    public static long GetCAEAGLLayer(long l2) {
        return 0L != l2 ? IOSUtil.GetCAEAGLLayer0(l2) : 0L;
    }

    public static long GetUIView(long l2, boolean bl) {
        return 0L != l2 ? IOSUtil.GetUIView0(l2, bl) : 0L;
    }

    public static long GetUIWindow(long l2) {
        return 0L != l2 ? IOSUtil.GetUIWindow0(l2) : 0L;
    }

    public static void SetUIViewPixelScale(long l2, float f2) {
        IOSUtil.SetUIViewPixelScale0(l2, f2);
    }

    public static float GetUIViewPixelScale(long l2) {
        return IOSUtil.GetUIViewPixelScale0(l2);
    }

    public static void SetCALayerPixelScale(long l2, long l3, float f2) {
        if (0L == l2 && 0L == l3) {
            return;
        }
        IOSUtil.SetCALayerPixelScale0(l2, l3, f2);
    }

    public static float GetCALayerPixelScale(long l2) {
        return IOSUtil.GetCALayerPixelScale0(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RunOnMainThread(boolean bl, boolean bl2, Runnable runnable) {
        if (IOSUtil.IsMainThread0()) {
            runnable.run();
        } else {
            Object object = new Object();
            RunnableTask runnableTask = new RunnableTask(runnable, bl ? object : null, true, bl ? null : System.err);
            Object object2 = object;
            synchronized (object2) {
                IOSUtil.RunOnMainThread0(bl2, runnableTask);
                if (bl) {
                    while (runnableTask.isInQueue()) {
                        try {
                            object.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new InterruptedRuntimeException(interruptedException);
                        }
                        Throwable throwable = runnableTask.getThrowable();
                        if (null == throwable) continue;
                        throw new RuntimeException(throwable);
                    }
                }
            }
        }
    }

    public static void RunLater(boolean bl, Runnable runnable, int n2) {
        IOSUtil.RunLater0(bl, false, new RunnableTask(runnable, null, true, System.err), n2);
    }

    public static void WaitUntilFinish() {
        IOSUtil.RunOnMainThread(true, true, _nop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, A> R RunOnMainThread(boolean bl, boolean bl2, Function<R, A> function, A ... AArray) {
        if (IOSUtil.IsMainThread0()) {
            return function.eval(AArray);
        }
        Object object = new Object();
        FunctionTask<R, A> functionTask = new FunctionTask<R, A>(function, bl ? object : null, true, bl ? null : System.err);
        Object object2 = object;
        synchronized (object2) {
            functionTask.setArgs(AArray);
            IOSUtil.RunOnMainThread0(bl2, functionTask);
            if (bl) {
                while (functionTask.isInQueue()) {
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedRuntimeException(interruptedException);
                    }
                    Throwable throwable = functionTask.getThrowable();
                    if (null == throwable) continue;
                    throw new RuntimeException(throwable);
                }
            }
        }
        return functionTask.getResult();
    }

    public static boolean IsMainThread() {
        Boolean bl = tlsIsMainThread.get();
        if (null == bl) {
            bl = new Boolean(IOSUtil.IsMainThread0());
            tlsIsMainThread.set(bl);
        }
        return bl;
    }

    public static int GetScreenRefreshRate(int n2) {
        return IOSUtil.GetScreenRefreshRate0(n2);
    }

    public static void CreateGLViewDemoA() {
        IOSUtil.CreateGLViewDemoA0();
    }

    private static native boolean initIDs0();

    private static native boolean isCALayer0(long var0);

    private static native boolean isCAEAGLLayer0(long var0);

    private static native boolean isUIView0(long var0);

    private static native boolean isUIWindow0(long var0);

    private static native Object GetLocationOnScreen0(long var0, int var2, int var3);

    private static native Object GetInsets0(long var0);

    private static native float GetScreenPixelScale1(int var0);

    private static native float GetScreenPixelScale2(long var0);

    private static native long CreateUIWindow0(int var0, int var1, int var2, int var3, boolean var4);

    private static native void DestroyUIWindow0(long var0);

    private static native long GetCALayer0(long var0);

    private static native long GetCAEAGLLayer0(long var0);

    private static native long GetUIView0(long var0, boolean var2);

    private static native long GetUIWindow0(long var0);

    private static native void SetUIViewPixelScale0(long var0, float var2);

    private static native float GetUIViewPixelScale0(long var0);

    private static native void SetCALayerPixelScale0(long var0, long var2, float var4);

    private static native float GetCALayerPixelScale0(long var0);

    private static native void RunOnMainThread0(boolean var0, Runnable var1);

    private static native void RunLater0(boolean var0, boolean var1, Runnable var2, int var3);

    private static native void KickUIApp0();

    private static native boolean IsMainThread0();

    private static native int GetScreenRefreshRate0(int var0);

    private static native void CreateGLViewDemoA0();
}

