/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class drmModeModeInfo {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] drmModeModeInfo_size = new int[]{68, 68, 68, 68, 68, 68, 68, 68, 68, 68};
    private static final int[] clock_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] hdisplay_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] hsync_start_offset = new int[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final int[] hsync_end_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] htotal_offset = new int[]{10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    private static final int[] hskew_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] vdisplay_offset = new int[]{14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
    private static final int[] vsync_start_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] vsync_end_offset = new int[]{18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
    private static final int[] vtotal_offset = new int[]{20, 20, 20, 20, 20, 20, 20, 20, 20, 20};
    private static final int[] vscan_offset = new int[]{22, 22, 22, 22, 22, 22, 22, 22, 22, 22};
    private static final int[] vrefresh_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 24, 24, 24};
    private static final int[] flags_offset = new int[]{28, 28, 28, 28, 28, 28, 28, 28, 28, 28};
    private static final int[] type_offset = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private static final int[] name_offset = new int[]{36, 36, 36, 36, 36, 36, 36, 36, 36, 36};
    private static final int[] name_size = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32};

    public static int size() {
        return drmModeModeInfo_size[mdIdx];
    }

    public static drmModeModeInfo create() {
        return drmModeModeInfo.create(Buffers.newDirectByteBuffer(drmModeModeInfo.size()));
    }

    public static drmModeModeInfo create(ByteBuffer byteBuffer) {
        return new drmModeModeInfo(byteBuffer);
    }

    drmModeModeInfo(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[drmModeModeInfo.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public drmModeModeInfo setClock(int n2) {
        this.accessor.setIntAt(clock_offset[mdIdx], n2);
        return this;
    }

    public int getClock() {
        return this.accessor.getIntAt(clock_offset[mdIdx]);
    }

    public drmModeModeInfo setHdisplay(short s) {
        this.accessor.setShortAt(hdisplay_offset[mdIdx], s);
        return this;
    }

    public short getHdisplay() {
        return this.accessor.getShortAt(hdisplay_offset[mdIdx]);
    }

    public drmModeModeInfo setHsync_start(short s) {
        this.accessor.setShortAt(hsync_start_offset[mdIdx], s);
        return this;
    }

    public short getHsync_start() {
        return this.accessor.getShortAt(hsync_start_offset[mdIdx]);
    }

    public drmModeModeInfo setHsync_end(short s) {
        this.accessor.setShortAt(hsync_end_offset[mdIdx], s);
        return this;
    }

    public short getHsync_end() {
        return this.accessor.getShortAt(hsync_end_offset[mdIdx]);
    }

    public drmModeModeInfo setHtotal(short s) {
        this.accessor.setShortAt(htotal_offset[mdIdx], s);
        return this;
    }

    public short getHtotal() {
        return this.accessor.getShortAt(htotal_offset[mdIdx]);
    }

    public drmModeModeInfo setHskew(short s) {
        this.accessor.setShortAt(hskew_offset[mdIdx], s);
        return this;
    }

    public short getHskew() {
        return this.accessor.getShortAt(hskew_offset[mdIdx]);
    }

    public drmModeModeInfo setVdisplay(short s) {
        this.accessor.setShortAt(vdisplay_offset[mdIdx], s);
        return this;
    }

    public short getVdisplay() {
        return this.accessor.getShortAt(vdisplay_offset[mdIdx]);
    }

    public drmModeModeInfo setVsync_start(short s) {
        this.accessor.setShortAt(vsync_start_offset[mdIdx], s);
        return this;
    }

    public short getVsync_start() {
        return this.accessor.getShortAt(vsync_start_offset[mdIdx]);
    }

    public drmModeModeInfo setVsync_end(short s) {
        this.accessor.setShortAt(vsync_end_offset[mdIdx], s);
        return this;
    }

    public short getVsync_end() {
        return this.accessor.getShortAt(vsync_end_offset[mdIdx]);
    }

    public drmModeModeInfo setVtotal(short s) {
        this.accessor.setShortAt(vtotal_offset[mdIdx], s);
        return this;
    }

    public short getVtotal() {
        return this.accessor.getShortAt(vtotal_offset[mdIdx]);
    }

    public drmModeModeInfo setVscan(short s) {
        this.accessor.setShortAt(vscan_offset[mdIdx], s);
        return this;
    }

    public short getVscan() {
        return this.accessor.getShortAt(vscan_offset[mdIdx]);
    }

    public drmModeModeInfo setVrefresh(int n2) {
        this.accessor.setIntAt(vrefresh_offset[mdIdx], n2);
        return this;
    }

    public int getVrefresh() {
        return this.accessor.getIntAt(vrefresh_offset[mdIdx]);
    }

    public drmModeModeInfo setFlags(int n2) {
        this.accessor.setIntAt(flags_offset[mdIdx], n2);
        return this;
    }

    public int getFlags() {
        return this.accessor.getIntAt(flags_offset[mdIdx]);
    }

    public drmModeModeInfo setType(int n2) {
        this.accessor.setIntAt(type_offset[mdIdx], n2);
        return this;
    }

    public int getType() {
        return this.accessor.getIntAt(type_offset[mdIdx]);
    }

    public static final int getNameArrayLength() {
        return 32;
    }

    public drmModeModeInfo setName(int n2, byte[] byArray) {
        if (n2 + byArray.length > 32) {
            throw new IndexOutOfBoundsException("offset " + n2 + " + val.length " + byArray.length + " > array-length " + 32);
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (32 > name_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal 32 > size " + name_size[mdIdx] + ", elemSize " + 1 + " * " + 32);
        }
        int n3 = name_offset[mdIdx];
        int n4 = n3 + 32;
        if (n4 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n4 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n3 + ", elemSize " + 1 + " * " + 32);
        }
        this.accessor.setBytesAt(n3 += 1 * n2, byArray);
        return this;
    }

    public ByteBuffer getName() {
        return this.accessor.slice(name_offset[mdIdx], 32);
    }

    public String getNameAsString() {
        int n2 = name_offset[mdIdx];
        ByteBuffer byteBuffer = this.getBuffer();
        byte[] byArray = new byte[32];
        int n3 = -1;
        while (++n3 < 32) {
            byArray[n3] = byteBuffer.get(n2 + n3);
            if (0 != byArray[n3]) continue;
        }
        return new String(byArray, 0, n3);
    }
}

