/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.nativewindow.NativeWindowException;
import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import jogamp.nativewindow.drm.DRMLib;
import jogamp.nativewindow.drm.DRMUtil;
import jogamp.nativewindow.drm.drmModeConnector;
import jogamp.nativewindow.drm.drmModeEncoder;
import jogamp.nativewindow.drm.drmModeModeInfo;
import jogamp.nativewindow.drm.drmModeRes;

public class DrmMode {
    public final int drmFd;
    public final int count;
    private final drmModeConnector[] connectors;
    private final drmModeModeInfo[] modes;
    private final drmModeEncoder[] encoder;
    private final int[] crtc_ids;
    private final int[] crtc_indices;
    private volatile boolean valid;

    private DrmMode(int n2, int n3) {
        this.drmFd = n2;
        this.count = n3;
        this.connectors = new drmModeConnector[n3];
        this.modes = new drmModeModeInfo[n3];
        this.encoder = new drmModeEncoder[n3];
        this.crtc_ids = new int[n3];
        this.crtc_indices = new int[n3];
        this.valid = false;
    }

    public void print(PrintStream printStream) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.print(printStream, i2);
        }
    }

    public void print(PrintStream printStream, int n2) {
        drmModeConnector drmModeConnector2 = this.connectors[n2];
        printStream.printf("Connector[%d]: id[con 0x%x, enc 0x%x], type %d[id 0x%x], connection %d, dim %dx%x mm, modes %d, encoders %d\n", n2, drmModeConnector2.getConnector_id(), drmModeConnector2.getEncoder_id(), drmModeConnector2.getConnector_type(), drmModeConnector2.getConnector_type_id(), drmModeConnector2.getConnection(), drmModeConnector2.getMmWidth(), drmModeConnector2.getMmHeight(), drmModeConnector2.getCount_modes(), drmModeConnector2.getCount_encoders());
        drmModeModeInfo drmModeModeInfo2 = this.modes[n2];
        System.err.printf("Connector[%d].Mode: clock %d, %dx%d @ %d Hz, type %d, name <%s>\n", n2, drmModeModeInfo2.getClock(), drmModeModeInfo2.getHdisplay(), drmModeModeInfo2.getVdisplay(), drmModeModeInfo2.getVrefresh(), drmModeModeInfo2.getType(), drmModeModeInfo2.getNameAsString());
        drmModeEncoder drmModeEncoder2 = this.encoder[n2];
        System.err.printf("Connector[%d].Encoder: id 0x%x, type %d, crtc_id 0x%x, possible[crtcs %d, clones %d]\n", n2, drmModeEncoder2.getEncoder_id(), drmModeEncoder2.getEncoder_type(), drmModeEncoder2.getCrtc_id(), drmModeEncoder2.getPossible_crtcs(), drmModeEncoder2.getPossible_clones());
    }

    public static DrmMode create(int n2, boolean bl) {
        drmModeRes drmModeRes2 = DRMLib.drmModeGetResources(n2);
        if (null == drmModeRes2) {
            throw new NativeWindowException("drmModeGetResources failed");
        }
        DrmMode drmMode = null;
        try {
            int n3;
            int n4;
            int n5;
            ArrayList<drmModeConnector> arrayList = new ArrayList<drmModeConnector>();
            drmModeModeInfo[] drmModeModeInfoArray = drmModeRes2.getConnectors();
            if (DRMUtil.DEBUG) {
                for (int i2 = 0; i2 < drmModeModeInfoArray.limit(); ++i2) {
                    drmModeConnector drmModeConnector2 = DRMLib.drmModeGetConnector(n2, drmModeModeInfoArray.get(i2));
                    n5 = 1 == drmModeConnector2.getConnection() ? 1 : 0;
                    System.err.printf("Connector %d/%d chosen %b,: id[con 0x%x, enc 0x%x], type %d[id 0x%x], connection %d, dim %dx%x mm, modes %d, encoders %d\n", i2, drmModeModeInfoArray.limit(), n5 != 0, drmModeConnector2.getConnector_id(), drmModeConnector2.getEncoder_id(), drmModeConnector2.getConnector_type(), drmModeConnector2.getConnector_type_id(), drmModeConnector2.getConnection(), drmModeConnector2.getMmWidth(), drmModeConnector2.getMmHeight(), drmModeConnector2.getCount_modes(), drmModeConnector2.getCount_encoders());
                    DRMLib.drmModeFreeConnector(drmModeConnector2);
                }
            }
            Object object = null;
            for (n4 = 0; n4 < drmModeModeInfoArray.limit(); ++n4) {
                object = DRMLib.drmModeGetConnector(n2, drmModeModeInfoArray.get(n4));
                if (1 == ((drmModeConnector)object).getConnection()) {
                    arrayList.add((drmModeConnector)object);
                    continue;
                }
                DRMLib.drmModeFreeConnector((drmModeConnector)object);
                object = null;
            }
            drmMode = new DrmMode(n2, arrayList.size());
            arrayList.toArray(drmMode.connectors);
            for (int i3 = 0; i3 < drmMode.count; ++i3) {
                drmModeModeInfoArray = drmMode.connectors[i3].getModes(0, new drmModeModeInfo[drmMode.connectors[i3].getCount_modes()]);
                object = null;
                n4 = 0;
                n5 = 0;
                for (int i4 = 0; i4 < drmModeModeInfoArray.length; ++i4) {
                    drmModeModeInfo drmModeModeInfo2 = drmModeModeInfoArray[i4];
                    int n6 = drmModeModeInfo2.getHdisplay() * drmModeModeInfo2.getVdisplay();
                    if (bl && drmModeModeInfo2.getType() == 8) {
                        object = drmModeModeInfo2;
                        n4 = Integer.MAX_VALUE;
                        n5 = i4;
                    } else if (n6 > n4) {
                        object = drmModeModeInfo2;
                        n4 = n6;
                        n5 = i4;
                    }
                    if (!DRMUtil.DEBUG) continue;
                    System.err.printf("Connector[%d].Mode %d/%d (max-chosen %d): clock %d, %dx%d @ %d Hz, type %d, name <%s>\n", i3, i4, drmModeModeInfoArray.length, n5, drmModeModeInfo2.getClock(), drmModeModeInfo2.getHdisplay(), drmModeModeInfo2.getVdisplay(), drmModeModeInfo2.getVrefresh(), drmModeModeInfo2.getType(), drmModeModeInfo2.getNameAsString());
                }
                if (null == object) {
                    throw new NativeWindowException("could not find mode");
                }
                drmMode.modes[i3] = object;
            }
            IntBuffer intBuffer = drmModeRes2.getEncoders();
            for (n3 = 0; n3 < drmMode.count; ++n3) {
                if (DRMUtil.DEBUG) {
                    for (int i5 = 0; i5 < intBuffer.limit(); ++i5) {
                        drmModeEncoder drmModeEncoder2 = DRMLib.drmModeGetEncoder(n2, intBuffer.get(i5));
                        n5 = drmModeEncoder2.getEncoder_id() == drmMode.connectors[n3].getEncoder_id() ? 1 : 0;
                        System.err.printf("Connector[%d].Encoder %d/%d chosen %b: id 0x%x, type %d, crtc_id 0x%x, possible[crtcs %d, clones %d]\n", n3, i5, intBuffer.limit(), n5 != 0, drmModeEncoder2.getEncoder_id(), drmModeEncoder2.getEncoder_type(), drmModeEncoder2.getCrtc_id(), drmModeEncoder2.getPossible_crtcs(), drmModeEncoder2.getPossible_clones());
                        DRMLib.drmModeFreeEncoder(drmModeEncoder2);
                    }
                }
                object = null;
                for (n4 = 0; n4 < intBuffer.limit() && ((drmModeEncoder)(object = DRMLib.drmModeGetEncoder(n2, intBuffer.get(n4)))).getEncoder_id() != drmMode.connectors[n3].getEncoder_id(); ++n4) {
                    DRMLib.drmModeFreeEncoder((drmModeEncoder)object);
                    object = null;
                }
                if (null == object) {
                    throw new NativeWindowException("could not find encoder");
                }
                drmMode.encoder[n3] = object;
            }
            intBuffer = drmModeRes2.getCrtcs();
            for (n3 = 0; n3 < drmMode.count; ++n3) {
                int n7 = -1;
                for (n4 = 0; n4 < intBuffer.limit(); ++n4) {
                    if (intBuffer.get(n4) != drmMode.encoder[n3].getCrtc_id()) continue;
                    n7 = n4;
                    break;
                }
                if (0 > n7) {
                    throw new NativeWindowException("could not find crtc index");
                }
                drmMode.crtc_ids[n3] = intBuffer.get(n7);
                drmMode.crtc_indices[n3] = n7;
            }
        }
        catch (Throwable throwable) {
            if (null != drmMode) {
                drmMode.destroy();
                drmMode = null;
            }
            throw throwable;
        }
        finally {
            DRMLib.drmModeFreeResources(drmModeRes2);
        }
        drmMode.valid = true;
        return drmMode;
    }

    public final boolean isValid() {
        return this.valid;
    }

    private final void checkValid() {
        if (!this.valid) {
            throw new IllegalStateException("Instance is invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (this.valid) {
            DrmMode drmMode = this;
            synchronized (drmMode) {
                if (this.valid) {
                    this.valid = false;
                    for (int i2 = 0; i2 < this.count; ++i2) {
                        if (null != this.encoder[i2]) {
                            DRMLib.drmModeFreeEncoder(this.encoder[i2]);
                        }
                        if (null == this.connectors[i2]) continue;
                        DRMLib.drmModeFreeConnector(this.connectors[i2]);
                    }
                }
            }
        }
    }

    public final drmModeConnector[] getConnectors() throws IllegalStateException {
        this.checkValid();
        return this.connectors;
    }

    public final drmModeModeInfo[] getModes() throws IllegalStateException {
        this.checkValid();
        return this.modes;
    }

    public final drmModeEncoder[] getEncoder() throws IllegalStateException {
        this.checkValid();
        return this.encoder;
    }

    public final int[] getCrtcIDs() throws IllegalStateException {
        this.checkValid();
        return this.crtc_ids;
    }

    public final int[] getCrtcIndices() throws IllegalStateException {
        this.checkValid();
        return this.crtc_indices;
    }
}

