/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

import com.jogamp.common.util.SecurityUtil;
import java.security.PrivilegedAction;
import java.util.Map;

public class SurfaceScaleUtils {
    private static final float EPSILON = 1.1920929E-7f;

    private static boolean isZero(float f2) {
        return Math.abs(f2) < 1.1920929E-7f;
    }

    public static int scale(int n2, float f2) {
        return (int)((float)n2 * f2 + 0.5f);
    }

    public static int scaleInv(int n2, float f2) {
        return (int)((float)n2 / f2 + 0.5f);
    }

    public static int[] scale(int[] nArray, int n2, int n3, float[] fArray) {
        nArray[0] = (int)((float)n2 * fArray[0] + 0.5f);
        nArray[1] = (int)((float)n3 * fArray[1] + 0.5f);
        return nArray;
    }

    public static int[] scaleInv(int[] nArray, int n2, int n3, float[] fArray) {
        nArray[0] = (int)((float)n2 / fArray[0] + 0.5f);
        nArray[1] = (int)((float)n3 / fArray[1] + 0.5f);
        return nArray;
    }

    public static int[] scale(int[] nArray, int[] nArray2, float[] fArray) {
        nArray[0] = (int)((float)nArray2[0] * fArray[0] + 0.5f);
        nArray[1] = (int)((float)nArray2[1] * fArray[1] + 0.5f);
        return nArray;
    }

    public static int[] scaleInv(int[] nArray, int[] nArray2, float[] fArray) {
        nArray[0] = (int)((float)nArray2[0] / fArray[0] + 0.5f);
        nArray[1] = (int)((float)nArray2[1] / fArray[1] + 0.5f);
        return nArray;
    }

    public static float clampPixelScale(float f2, float f3, float f4) {
        if (SurfaceScaleUtils.isZero(f2 - 1.0f)) {
            return 1.0f;
        }
        if (SurfaceScaleUtils.isZero(f2 - 0.0f) || f2 > f4 || SurfaceScaleUtils.isZero(f2 - f4)) {
            return f4;
        }
        if (f2 < f3 || SurfaceScaleUtils.isZero(f2 - f3)) {
            return f3;
        }
        return f2;
    }

    public static float[] clampPixelScale(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        fArray[0] = SurfaceScaleUtils.clampPixelScale(fArray2[0], fArray3[0], fArray4[0]);
        fArray[1] = SurfaceScaleUtils.clampPixelScale(fArray2[1], fArray3[1], fArray4[1]);
        return fArray;
    }

    public static boolean setNewPixelScale(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, String string) {
        boolean bl;
        float f2 = SurfaceScaleUtils.clampPixelScale(fArray3[0], fArray4[0], fArray5[0]);
        float f3 = SurfaceScaleUtils.clampPixelScale(fArray3[1], fArray4[1], fArray5[1]);
        boolean bl2 = bl = f2 != fArray2[0] || f3 != fArray2[1];
        if (null != string) {
            System.err.println(string + ".setNewPixelScale: pre[" + fArray2[0] + ", " + fArray2[1] + "], req[" + fArray3[0] + ", " + fArray3[1] + "], min[" + fArray4[0] + ", " + fArray4[1] + "], max[" + fArray5[0] + ", " + fArray5[1] + "] -> result[" + f2 + ", " + f3 + "], changed " + bl);
        }
        fArray[0] = f2;
        fArray[1] = f3;
        return bl;
    }

    public static String toString(Map<String, float[]> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        for (String string : map.keySet()) {
            stringBuilder.append("'").append(string).append("'").append(" = ( ");
            float[] fArray = map.get(string);
            if (null != fArray && 2 == fArray.length) {
                stringBuilder.append(fArray[0]).append(" / ").append(fArray[1]);
            }
            stringBuilder.append(" ), ");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public static int getPixelScaleEnv(String[] stringArray, float[] fArray, Map<String, float[]> map) {
        Map<String, String> map2 = SecurityUtil.doPrivileged(new PrivilegedAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() {
                return System.getenv();
            }
        });
        float f2 = -1.0f;
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        for (int i2 = 0; i2 < stringArray.length && !bl; ++i2) {
            block11: {
                String string = stringArray[i2];
                String string2 = map2.get(string);
                if (null == string2 || string2.isEmpty()) continue;
                try {
                    float f3 = Float.valueOf(string2).floatValue();
                    if (0 <= n2) break block11;
                    f2 = f3;
                    n2 = i2;
                }
                catch (NumberFormatException numberFormatException) {
                    if (0 <= n3) continue;
                    String[] stringArray2 = string2.split(";");
                    if (null == stringArray2) break block11;
                    for (String string3 : stringArray2) {
                        if (null == string3 || string3.isEmpty()) continue;
                        String[] stringArray3 = string3.split("=");
                        if (null == stringArray3 || 2 != stringArray3.length) {
                            map.clear();
                            break;
                        }
                        if (null == stringArray3[0] || stringArray3[0].isEmpty()) {
                            map.clear();
                            break;
                        }
                        if (null == stringArray3[1] || stringArray3[1].isEmpty()) {
                            map.clear();
                            break;
                        }
                        try {
                            float f4 = Float.valueOf(stringArray3[1]).floatValue();
                            map.put(stringArray3[0], new float[]{f4, f4});
                            n3 = i2;
                        }
                        catch (NumberFormatException numberFormatException2) {
                            map.clear();
                            break;
                        }
                    }
                }
            }
            bl = 0 <= n3 && 0 <= n2;
        }
        if (0 <= n2) {
            fArray[0] = f2;
            fArray[1] = f2;
            return n2;
        }
        if (0 <= n3) {
            return n3;
        }
        return -1;
    }
}

