/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.geom.plane;

import com.jogamp.graph.geom.SVertex;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.NoSuchElementException;
import jogamp.graph.geom.plane.AffineTransform;
import jogamp.graph.geom.plane.Crossing;
import jogamp.graph.geom.plane.IllegalPathStateException;
import jogamp.graph.geom.plane.PathIterator;

public final class Path2D
implements Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    static final String invalidWindingRuleValue = "Invalid winding rule value";
    static final String iteratorOutOfBounds = "Iterator out of bounds";
    private static final int BUFFER_SIZE = 10;
    private static final int BUFFER_CAPACITY = 10;
    byte[] types;
    float[] points;
    int typeSize;
    int pointSize;
    int rule;
    static int[] pointShift = new int[]{2, 2, 4, 6, 0};

    public Path2D() {
        this(1, 10);
    }

    public Path2D(int n2) {
        this(n2, 10);
    }

    public Path2D(int n2, int n3) {
        this.setWindingRule(n2);
        this.types = new byte[n3];
        this.points = new float[n3 * 2];
    }

    public Path2D(Path2D path2D) {
        this(1, 10);
        PathIterator pathIterator = path2D.iterator(null);
        this.setWindingRule(pathIterator.getWindingRule());
        this.append(pathIterator, false);
    }

    public void setWindingRule(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new NoSuchElementException(invalidWindingRuleValue);
        }
        this.rule = n2;
    }

    public int getWindingRule() {
        return this.rule;
    }

    void checkBuf(int n2, boolean bl) {
        Object[] objectArray;
        if (bl && this.typeSize == 0) {
            throw new IllegalPathStateException("First segment should be SEG_MOVETO type");
        }
        if (this.typeSize == this.types.length) {
            objectArray = new byte[this.typeSize + 10];
            System.arraycopy(this.types, 0, objectArray, 0, this.typeSize);
            this.types = objectArray;
        }
        if (this.pointSize + n2 > this.points.length) {
            objectArray = new float[this.pointSize + Math.max(20, n2)];
            System.arraycopy(this.points, 0, objectArray, 0, this.pointSize);
            this.points = objectArray;
        }
    }

    public void moveTo(float f2, float f3) {
        if (this.typeSize > 0 && this.types[this.typeSize - 1] == 0) {
            this.points[this.pointSize - 2] = f2;
            this.points[this.pointSize - 1] = f3;
        } else {
            this.checkBuf(2, false);
            this.types[this.typeSize++] = 0;
            this.points[this.pointSize++] = f2;
            this.points[this.pointSize++] = f3;
        }
    }

    public void lineTo(float f2, float f3) {
        this.checkBuf(2, true);
        this.types[this.typeSize++] = 1;
        this.points[this.pointSize++] = f2;
        this.points[this.pointSize++] = f3;
    }

    public void quadTo(float f2, float f3, float f4, float f5) {
        this.checkBuf(4, true);
        this.types[this.typeSize++] = 2;
        this.points[this.pointSize++] = f2;
        this.points[this.pointSize++] = f3;
        this.points[this.pointSize++] = f4;
        this.points[this.pointSize++] = f5;
    }

    public void curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.checkBuf(6, true);
        this.types[this.typeSize++] = 3;
        this.points[this.pointSize++] = f2;
        this.points[this.pointSize++] = f3;
        this.points[this.pointSize++] = f4;
        this.points[this.pointSize++] = f5;
        this.points[this.pointSize++] = f6;
        this.points[this.pointSize++] = f7;
    }

    public final int size() {
        return this.typeSize;
    }

    public final boolean isClosed() {
        return this.typeSize > 0 && this.types[this.typeSize - 1] == 4;
    }

    public void closePath() {
        if (!this.isClosed()) {
            this.checkBuf(0, true);
            this.types[this.typeSize++] = 4;
        }
    }

    public String toString() {
        return "[size " + this.size() + ", closed " + this.isClosed() + "]";
    }

    public void append(Path2D path2D, boolean bl) {
        PathIterator pathIterator = path2D.iterator(null);
        this.append(pathIterator, bl);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    if (!bl || this.typeSize == 0) {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    if (this.types[this.typeSize - 1] != 4 && this.points[this.pointSize - 2] == fArray[0] && this.points[this.pointSize - 1] == fArray[1]) break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled Segment Type: " + n2);
                }
            }
            pathIterator.next();
            bl = false;
        }
    }

    public SVertex getCurrentPoint() {
        if (this.typeSize == 0) {
            return null;
        }
        int n2 = this.pointSize - 2;
        if (this.types[this.typeSize - 1] == 4) {
            byte by;
            for (int i2 = this.typeSize - 2; i2 > 0 && (by = this.types[i2]) != 0; --i2) {
                n2 -= pointShift[by];
            }
        }
        return new SVertex(this.points[n2], this.points[n2 + 1], 0.0f, true);
    }

    public void reset() {
        this.typeSize = 0;
        this.pointSize = 0;
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transform(this.points, 0, this.points, 0, this.pointSize / 2);
    }

    public Path2D createTransformedShape(AffineTransform affineTransform) {
        Path2D path2D = (Path2D)this.clone();
        if (affineTransform != null) {
            path2D.transform(affineTransform);
        }
        return path2D;
    }

    public final synchronized AABBox getBounds2D() {
        float f2;
        float f3;
        float f4;
        float f5;
        if (this.pointSize == 0) {
            f5 = 0.0f;
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 0.0f;
        } else {
            int n2 = this.pointSize - 1;
            f3 = f5 = this.points[n2--];
            f2 = f4 = this.points[n2--];
            while (n2 > 0) {
                float f6 = this.points[n2--];
                int n3 = n2--;
                float f7 = this.points[n3];
                if (f7 < f2) {
                    f2 = f7;
                } else if (f7 > f4) {
                    f4 = f7;
                }
                if (f6 < f3) {
                    f3 = f6;
                    continue;
                }
                if (!(f6 > f5)) continue;
                f5 = f6;
            }
        }
        return new AABBox(f2, f3, 0.0f, f4, f5, 0.0f);
    }

    boolean isInside(int n2) {
        if (this.rule == 1) {
            return Crossing.isInsideNonZero(n2);
        }
        return Crossing.isInsideEvenOdd(n2);
    }

    public boolean contains(float f2, float f3) {
        return this.isInside(Crossing.crossShape(this, f2, f3));
    }

    public boolean contains(float f2, float f3, float f4, float f5) {
        int n2 = Crossing.intersectShape(this, f2, f3, f4, f5);
        return n2 != 255 && this.isInside(n2);
    }

    public boolean intersects(float f2, float f3, float f4, float f5) {
        int n2 = Crossing.intersectShape(this, f2, f3, f4, f5);
        return n2 == 255 || this.isInside(n2);
    }

    public boolean contains(Vertex vertex) {
        return this.contains(vertex.getX(), vertex.getY());
    }

    public boolean contains(AABBox aABBox) {
        return this.contains(aABBox.getMinX(), aABBox.getMinY(), aABBox.getWidth(), aABBox.getHeight());
    }

    public boolean intersects(AABBox aABBox) {
        return this.intersects(aABBox.getMinX(), aABBox.getMinY(), aABBox.getWidth(), aABBox.getHeight());
    }

    public PathIterator iterator() {
        return new Iterator(this);
    }

    public PathIterator iterator(AffineTransform affineTransform) {
        return new Iterator(this, affineTransform);
    }

    public Object clone() {
        try {
            Path2D path2D = (Path2D)super.clone();
            path2D.types = (byte[])this.types.clone();
            path2D.points = (float[])this.points.clone();
            return path2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static class Iterator
    implements PathIterator {
        int typeIndex;
        int pointIndex;
        Path2D p;
        AffineTransform t;

        Iterator(Path2D path2D) {
            this(path2D, null);
        }

        Iterator(Path2D path2D, AffineTransform affineTransform) {
            this.p = path2D;
            this.t = affineTransform;
        }

        @Override
        public int getWindingRule() {
            return this.p.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.typeIndex >= this.p.typeSize;
        }

        @Override
        public void next() {
            ++this.typeIndex;
        }

        @Override
        public int currentSegment(float[] fArray) {
            if (this.isDone()) {
                throw new NoSuchElementException(Path2D.iteratorOutOfBounds);
            }
            byte by = this.p.types[this.typeIndex];
            int n2 = pointShift[by];
            System.arraycopy(this.p.points, this.pointIndex, fArray, 0, n2);
            if (this.t != null) {
                this.t.transform(fArray, 0, fArray, 0, n2 / 2);
            }
            this.pointIndex += n2;
            return by;
        }
    }
}

