/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class VdmxTable
implements Table {
    private final DirectoryEntry _de;
    private final int _version;
    private final int _numRecs;
    private final int _numRatios;
    private final Ratio[] _ratRange;
    private final int[] _offset;
    private final Group[] _groups;

    protected VdmxTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        int n2;
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._version = dataInput.readUnsignedShort();
        this._numRecs = dataInput.readUnsignedShort();
        this._numRatios = dataInput.readUnsignedShort();
        this._ratRange = new Ratio[this._numRatios];
        for (n2 = 0; n2 < this._numRatios; ++n2) {
            this._ratRange[n2] = new Ratio(dataInput);
        }
        this._offset = new int[this._numRatios];
        for (n2 = 0; n2 < this._numRatios; ++n2) {
            this._offset[n2] = dataInput.readUnsignedShort();
        }
        this._groups = new Group[this._numRecs];
        for (n2 = 0; n2 < this._numRecs; ++n2) {
            this._groups[n2] = new Group(dataInput);
        }
    }

    @Override
    public int getType() {
        return 1447316824;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'VDMX' Table - Precomputed Vertical Device Metrics\n").append("--------------------------------------------------\n").append("  Version:                 ").append(this._version).append("\n").append("  Number of Hgt Records:   ").append(this._numRecs).append("\n").append("  Number of Ratio Records: ").append(this._numRatios).append("\n");
        for (n2 = 0; n2 < this._numRatios; ++n2) {
            stringBuilder.append("\n    Ratio Record #").append(n2 + 1).append("\n").append("\tCharSetId     ").append(this._ratRange[n2].getBCharSet()).append("\n").append("\txRatio        ").append(this._ratRange[n2].getXRatio()).append("\n").append("\tyStartRatio   ").append(this._ratRange[n2].getYStartRatio()).append("\n").append("\tyEndRatio     ").append(this._ratRange[n2].getYEndRatio()).append("\n").append("\tRecord Offset ").append(this._offset[n2]).append("\n");
        }
        stringBuilder.append("\n   VDMX Height Record Groups\n").append("   -------------------------\n");
        for (n2 = 0; n2 < this._numRecs; ++n2) {
            Group group = this._groups[n2];
            stringBuilder.append("   ").append(n2 + 1).append(".   Number of Hgt Records  ").append(group.getRecs()).append("\n").append("        Starting Y Pel Height  ").append(group.getStartSZ()).append("\n").append("        Ending Y Pel Height    ").append(group.getEndSZ()).append("\n");
            for (int i2 = 0; i2 < group.getRecs(); ++i2) {
                stringBuilder.append("\n            ").append(i2 + 1).append(". Pel Height= ").append(group.getEntry()[i2].getYPelHeight()).append("\n").append("               yMax=       ").append(group.getEntry()[i2].getYMax()).append("\n").append("               yMin=       ").append(group.getEntry()[i2].getYMin()).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }

    static class Ratio {
        private final byte _bCharSet;
        private final byte _xRatio;
        private final byte _yStartRatio;
        private final byte _yEndRatio;

        protected Ratio(DataInput dataInput) throws IOException {
            this._bCharSet = dataInput.readByte();
            this._xRatio = dataInput.readByte();
            this._yStartRatio = dataInput.readByte();
            this._yEndRatio = dataInput.readByte();
        }

        public byte getBCharSet() {
            return this._bCharSet;
        }

        public byte getXRatio() {
            return this._xRatio;
        }

        public byte getYStartRatio() {
            return this._yStartRatio;
        }

        public byte getYEndRatio() {
            return this._yEndRatio;
        }
    }

    static class Group {
        private final int _recs;
        private final int _startsz;
        private final int _endsz;
        private final VTableRecord[] _entry;

        protected Group(DataInput dataInput) throws IOException {
            this._recs = dataInput.readUnsignedShort();
            this._startsz = dataInput.readUnsignedByte();
            this._endsz = dataInput.readUnsignedByte();
            this._entry = new VTableRecord[this._recs];
            for (int i2 = 0; i2 < this._recs; ++i2) {
                this._entry[i2] = new VTableRecord(dataInput);
            }
        }

        public int getRecs() {
            return this._recs;
        }

        public int getStartSZ() {
            return this._startsz;
        }

        public int getEndSZ() {
            return this._endsz;
        }

        public VTableRecord[] getEntry() {
            return this._entry;
        }
    }

    static class VTableRecord {
        private final int _yPelHeight;
        private final short _yMax;
        private final short _yMin;

        protected VTableRecord(DataInput dataInput) throws IOException {
            this._yPelHeight = dataInput.readUnsignedShort();
            this._yMax = dataInput.readShort();
            this._yMin = dataInput.readShort();
        }

        public int getYPelHeight() {
            return this._yPelHeight;
        }

        public short getYMax() {
            return this._yMax;
        }

        public short getYMin() {
            return this._yMin;
        }
    }
}

