/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Feature;
import jogamp.graph.font.typecast.ot.table.Lookup;
import jogamp.graph.font.typecast.ot.table.LookupSubtableFactory;

public class LookupList {
    private final int _lookupCount;
    private final int[] _lookupOffsets;
    private final Lookup[] _lookups;

    public LookupList(DataInputStream dataInputStream, int n2, LookupSubtableFactory lookupSubtableFactory) throws IOException {
        int n3;
        dataInputStream.reset();
        dataInputStream.skipBytes(n2);
        this._lookupCount = dataInputStream.readUnsignedShort();
        this._lookupOffsets = new int[this._lookupCount];
        this._lookups = new Lookup[this._lookupCount];
        for (n3 = 0; n3 < this._lookupCount; ++n3) {
            this._lookupOffsets[n3] = dataInputStream.readUnsignedShort();
        }
        for (n3 = 0; n3 < this._lookupCount; ++n3) {
            this._lookups[n3] = new Lookup(lookupSubtableFactory, dataInputStream, n2 + this._lookupOffsets[n3]);
        }
    }

    public int getLookupCount() {
        return this._lookupCount;
    }

    public int getLookupOffset(int n2) {
        return this._lookupOffsets[n2];
    }

    public Lookup getLookup(int n2) {
        return this._lookups[n2];
    }

    public Lookup getLookup(Feature feature, int n2) {
        if (feature.getLookupCount() > n2) {
            int n3 = feature.getLookupListIndex(n2);
            return this._lookups[n3];
        }
        return null;
    }
}

