/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.HheaTable;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;

public class HmtxTable
implements Table {
    private final DirectoryEntry _de;
    private int[] _hMetrics = null;
    private short[] _leftSideBearing = null;

    protected HmtxTable(DirectoryEntry directoryEntry, DataInput dataInput, HheaTable hheaTable, MaxpTable maxpTable) throws IOException {
        int n2;
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._hMetrics = new int[hheaTable.getNumberOfHMetrics()];
        for (n2 = 0; n2 < hheaTable.getNumberOfHMetrics(); ++n2) {
            this._hMetrics[n2] = dataInput.readUnsignedByte() << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
        }
        n2 = maxpTable.getNumGlyphs() - hheaTable.getNumberOfHMetrics();
        this._leftSideBearing = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this._leftSideBearing[i2] = dataInput.readShort();
        }
    }

    public int getAdvanceWidth(int n2) {
        if (this._hMetrics == null) {
            return 0;
        }
        if (n2 < this._hMetrics.length) {
            return this._hMetrics[n2] >> 16;
        }
        return this._hMetrics[this._hMetrics.length - 1] >> 16;
    }

    public short getLeftSideBearing(int n2) {
        if (this._hMetrics == null) {
            return 0;
        }
        if (n2 < this._hMetrics.length) {
            return (short)(this._hMetrics[n2] & 0xFFFF);
        }
        return this._leftSideBearing[n2 - this._hMetrics.length];
    }

    @Override
    public int getType() {
        return 1752003704;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'hmtx' Table - Horizontal Metrics\n---------------------------------\n");
        stringBuilder.append("Size = ").append(this._de.getLength()).append(" bytes, ").append(this._hMetrics.length).append(" entries\n");
        for (n2 = 0; n2 < this._hMetrics.length; ++n2) {
            stringBuilder.append("        ").append(n2).append(". advWid: ").append(this.getAdvanceWidth(n2)).append(", LSdBear: ").append(this.getLeftSideBearing(n2)).append("\n");
        }
        for (n2 = 0; n2 < this._leftSideBearing.length; ++n2) {
            stringBuilder.append("        LSdBear ").append(n2 + this._hMetrics.length).append(": ").append(this._leftSideBearing[n2]).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

