/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Disassembler;
import jogamp.graph.font.typecast.ot.table.GlyfDescript;
import jogamp.graph.font.typecast.ot.table.GlyfTable;

public class GlyfSimpleDescript
extends GlyfDescript {
    private final int[] _endPtsOfContours;
    private final byte[] _flags;
    private final short[] _xCoordinates;
    private final short[] _yCoordinates;
    private final int _count;

    public GlyfSimpleDescript(GlyfTable glyfTable, int n2, short n3, DataInput dataInput) throws IOException {
        super(glyfTable, n2, (short)n3, dataInput);
        int n4;
        this._endPtsOfContours = new int[n3];
        for (n4 = 0; n4 < n3; ++n4) {
            this._endPtsOfContours[n4] = dataInput.readShort();
        }
        this._count = this._endPtsOfContours[n3 - 1] + 1;
        this._flags = new byte[this._count];
        this._xCoordinates = new short[this._count];
        this._yCoordinates = new short[this._count];
        n4 = dataInput.readShort();
        this.readInstructions(dataInput, n4);
        this.readFlags(this._count, dataInput);
        this.readCoords(this._count, dataInput);
    }

    @Override
    public int getEndPtOfContours(int n2) {
        return this._endPtsOfContours[n2];
    }

    @Override
    public byte getFlags(int n2) {
        return this._flags[n2];
    }

    @Override
    public short getXCoordinate(int n2) {
        return this._xCoordinates[n2];
    }

    @Override
    public short getYCoordinate(int n2) {
        return this._yCoordinates[n2];
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int getPointCount() {
        return this._count;
    }

    @Override
    public int getContourCount() {
        return this.getNumberOfContours();
    }

    private void readCoords(int n2, DataInput dataInput) throws IOException {
        int n3;
        short s = 0;
        short s2 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            if ((this._flags[n3] & 0x10) != 0) {
                if ((this._flags[n3] & 2) != 0) {
                    s = (short)(s + (short)dataInput.readUnsignedByte());
                }
            } else {
                s = (this._flags[n3] & 2) != 0 ? (short)(s + (short)(-((short)dataInput.readUnsignedByte()))) : (short)(s + dataInput.readShort());
            }
            this._xCoordinates[n3] = s;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if ((this._flags[n3] & 0x20) != 0) {
                if ((this._flags[n3] & 4) != 0) {
                    s2 = (short)(s2 + (short)dataInput.readUnsignedByte());
                }
            } else {
                s2 = (this._flags[n3] & 4) != 0 ? (short)(s2 + (short)(-((short)dataInput.readUnsignedByte()))) : (short)(s2 + dataInput.readShort());
            }
            this._yCoordinates[n3] = s2;
        }
    }

    private void readFlags(int n2, DataInput dataInput) throws IOException {
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                this._flags[i2] = dataInput.readByte();
                if ((this._flags[i2] & 8) == 0) continue;
                int n3 = dataInput.readByte();
                for (int i3 = 1; i3 <= n3; ++i3) {
                    this._flags[i2 + i3] = this._flags[i2];
                }
                i2 += n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("error: array index out of bounds");
        }
    }

    @Override
    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("\n\n        EndPoints\n        ---------");
        for (n2 = 0; n2 < this._endPtsOfContours.length; ++n2) {
            stringBuilder.append("\n          ").append(n2).append(": ").append(this._endPtsOfContours[n2]);
        }
        stringBuilder.append("\n\n          Length of Instructions: ");
        stringBuilder.append(this.getInstructions().length).append("\n");
        stringBuilder.append(Disassembler.disassemble(this.getInstructions(), 8));
        stringBuilder.append("\n        Flags\n        -----");
        for (n2 = 0; n2 < this._flags.length; ++n2) {
            stringBuilder.append("\n          ").append(n2).append(":  ");
            if ((this._flags[n2] & 0x20) != 0) {
                stringBuilder.append("YDual ");
            } else {
                stringBuilder.append("      ");
            }
            if ((this._flags[n2] & 0x10) != 0) {
                stringBuilder.append("XDual ");
            } else {
                stringBuilder.append("      ");
            }
            if ((this._flags[n2] & 8) != 0) {
                stringBuilder.append("Repeat ");
            } else {
                stringBuilder.append("       ");
            }
            if ((this._flags[n2] & 4) != 0) {
                stringBuilder.append("Y-Short ");
            } else {
                stringBuilder.append("        ");
            }
            if ((this._flags[n2] & 2) != 0) {
                stringBuilder.append("X-Short ");
            } else {
                stringBuilder.append("        ");
            }
            if ((this._flags[n2] & 1) != 0) {
                stringBuilder.append("On");
                continue;
            }
            stringBuilder.append("  ");
        }
        stringBuilder.append("\n\n        Coordinates\n        -----------");
        n2 = 0;
        short s = 0;
        for (int i2 = 0; i2 < this._xCoordinates.length; ++i2) {
            stringBuilder.append("\n          ").append(i2).append(": Rel (").append(this._xCoordinates[i2] - n2).append(", ").append(this._yCoordinates[i2] - s).append(")  ->  Abs (").append(this._xCoordinates[i2]).append(", ").append(this._yCoordinates[i2]).append(")");
            n2 = this._xCoordinates[i2];
            s = this._yCoordinates[i2];
        }
        return stringBuilder.toString();
    }
}

