/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import jogamp.graph.font.typecast.ot.table.GlyfCompositeComp;
import jogamp.graph.font.typecast.ot.table.GlyfDescript;
import jogamp.graph.font.typecast.ot.table.GlyfTable;

public class GlyfCompositeDescript
extends GlyfDescript {
    private final ArrayList<GlyfCompositeComp> _components = new ArrayList();

    public GlyfCompositeDescript(GlyfTable glyfTable, int n2, DataInput dataInput) throws IOException {
        super(glyfTable, n2, (short)-1, dataInput);
        GlyfCompositeComp glyfCompositeComp;
        int n3 = 0;
        int n4 = 0;
        do {
            glyfCompositeComp = new GlyfCompositeComp(n3, n4, dataInput);
            this._components.add(glyfCompositeComp);
            GlyfDescript glyfDescript = glyfTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfDescript == null) continue;
            n3 += glyfDescript.getPointCount();
            n4 += glyfDescript.getContourCount();
        } while ((glyfCompositeComp.getFlags() & 0x20) != 0);
        if ((glyfCompositeComp.getFlags() & 0x100) != 0) {
            this.readInstructions(dataInput, dataInput.readShort());
        }
    }

    @Override
    public int getEndPtOfContours(int n2) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeCompEndPt(n2);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            return glyfDescript.getEndPtOfContours(n2 - glyfCompositeComp.getFirstContour()) + glyfCompositeComp.getFirstIndex();
        }
        return 0;
    }

    @Override
    public byte getFlags(int n2) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n2);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            return glyfDescript.getFlags(n2 - glyfCompositeComp.getFirstIndex());
        }
        return 0;
    }

    @Override
    public short getXCoordinate(int n2) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n2);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            int n3 = n2 - glyfCompositeComp.getFirstIndex();
            short s = glyfDescript.getXCoordinate(n3);
            short s2 = glyfDescript.getYCoordinate(n3);
            short s3 = (short)glyfCompositeComp.scaleX(s, s2);
            s3 = (short)(s3 + glyfCompositeComp.getXTranslate());
            return s3;
        }
        return 0;
    }

    @Override
    public short getYCoordinate(int n2) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n2);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            int n3 = n2 - glyfCompositeComp.getFirstIndex();
            short s = glyfDescript.getXCoordinate(n3);
            short s2 = glyfDescript.getYCoordinate(n3);
            short s3 = (short)glyfCompositeComp.scaleY(s, s2);
            s3 = (short)(s3 + glyfCompositeComp.getYTranslate());
            return s3;
        }
        return 0;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public int getPointCount() {
        GlyfCompositeComp glyfCompositeComp = this._components.get(this._components.size() - 1);
        GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
        if (glyfDescript != null) {
            return glyfCompositeComp.getFirstIndex() + glyfDescript.getPointCount();
        }
        return 0;
    }

    @Override
    public int getContourCount() {
        GlyfCompositeComp glyfCompositeComp = this._components.get(this._components.size() - 1);
        GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
        return glyfCompositeComp.getFirstContour() + (null != glyfDescript ? glyfDescript.getContourCount() : 0);
    }

    public int getComponentIndex(int n2) {
        return this._components.get(n2).getFirstIndex();
    }

    public int getComponentCount() {
        return this._components.size();
    }

    public GlyfCompositeComp getComponent(int n2) {
        return this._components.get(n2);
    }

    protected GlyfCompositeComp getCompositeComp(int n2) {
        for (int i2 = 0; i2 < this._components.size(); ++i2) {
            GlyfCompositeComp glyfCompositeComp = this._components.get(i2);
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstIndex() > n2 || n2 >= glyfCompositeComp.getFirstIndex() + glyfDescript.getPointCount()) continue;
            return glyfCompositeComp;
        }
        return null;
    }

    protected GlyfCompositeComp getCompositeCompEndPt(int n2) {
        for (int i2 = 0; i2 < this._components.size(); ++i2) {
            GlyfCompositeComp glyfCompositeComp = this._components.get(i2);
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstContour() > n2 || n2 >= glyfCompositeComp.getFirstContour() + glyfDescript.getContourCount()) continue;
            return glyfCompositeComp;
        }
        return null;
    }
}

