/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Feature;
import jogamp.graph.font.typecast.ot.table.FeatureRecord;
import jogamp.graph.font.typecast.ot.table.LangSys;

public class FeatureList {
    private final int _featureCount;
    private final FeatureRecord[] _featureRecords;
    private final Feature[] _features;

    public FeatureList(DataInputStream dataInputStream, int n2) throws IOException {
        int n3;
        dataInputStream.reset();
        dataInputStream.skipBytes(n2);
        this._featureCount = dataInputStream.readUnsignedShort();
        this._featureRecords = new FeatureRecord[this._featureCount];
        this._features = new Feature[this._featureCount];
        for (n3 = 0; n3 < this._featureCount; ++n3) {
            this._featureRecords[n3] = new FeatureRecord(dataInputStream);
        }
        for (n3 = 0; n3 < this._featureCount; ++n3) {
            dataInputStream.reset();
            dataInputStream.skipBytes(n2 + this._featureRecords[n3].getOffset());
            this._features[n3] = new Feature(dataInputStream);
        }
    }

    public int getFeatureCount() {
        return this._featureCount;
    }

    public FeatureRecord getFeatureRecord(int n2) {
        return this._featureRecords[n2];
    }

    public Feature getFeature(int n2) {
        return this._features[n2];
    }

    public Feature findFeature(LangSys langSys, String string) {
        if (string.length() != 4) {
            return null;
        }
        int n2 = string.charAt(0) << 24 | string.charAt(1) << 16 | string.charAt(2) << 8 | string.charAt(3);
        for (int i2 = 0; i2 < this._featureCount; ++i2) {
            if (this._featureRecords[i2].getTag() != n2 || !langSys.isFeatureIndexed(i2)) continue;
            return this._features[i2];
        }
        return null;
    }
}

