/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import jogamp.graph.font.typecast.ot.table.CffTable;
import jogamp.graph.font.typecast.ot.table.Charstring;

public class CharstringType2
extends Charstring {
    private static final String[] _oneByteOperators = new String[]{"-Reserved-", "hstem", "-Reserved-", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "-Reserved-", "callsubr", "return", "escape", "-Reserved-", "endchar", "-Reserved-", "-Reserved-", "-Reserved-", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "shortint", "callgsubr", "vhcurveto", "hvcurveto"};
    private static final String[] _twoByteOperators = new String[]{"-Reserved- (dotsection)", "-Reserved-", "-Reserved-", "and", "or", "not", "-Reserved-", "-Reserved-", "-Reserved-", "abs", "add", "sub", "div", "-Reserved-", "neg", "eq", "-Reserved-", "-Reserved-", "drop", "-Reserved-", "put", "get", "ifelse", "random", "mul", "-Reserved-", "sqrt", "dup", "exch", "index", "roll", "-Reserved-", "-Reserved-", "-Reserved-", "hflex", "flex", "hflex1", "flex1", "-Reserved-"};
    private final int _index;
    private final String _name;
    private final int[] _data;
    private final int _offset;
    private final int _length;
    private final CffTable.Index _localSubrIndex;
    private final CffTable.Index _globalSubrIndex;
    private int _ip;

    protected CharstringType2(int n2, String string, int[] nArray, int n3, int n4, CffTable.Index index, CffTable.Index index2) {
        this._index = n2;
        this._name = string;
        this._data = nArray;
        this._offset = n3;
        this._length = n4;
        this._localSubrIndex = index;
        this._globalSubrIndex = index2;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public String getName() {
        return this._name;
    }

    private void disassemble(StringBuilder stringBuilder) {
        String string;
        Number number = null;
        while (this.isOperandAtIndex()) {
            number = this.nextOperand();
            stringBuilder.append(number).append(" ");
        }
        int n2 = this.nextByte();
        if (n2 == 12) {
            n2 = this.nextByte();
            if (n2 > 38) {
                n2 = 38;
            }
            string = _twoByteOperators[n2];
        } else {
            string = _oneByteOperators[n2];
        }
        stringBuilder.append(string);
    }

    public void resetIP() {
        this._ip = this._offset;
    }

    public boolean isOperandAtIndex() {
        int n2 = this._data[this._ip];
        return 32 <= n2 && n2 <= 255 || n2 == 28;
    }

    public Number nextOperand() {
        int n2 = this._data[this._ip];
        if (32 <= n2 && n2 <= 246) {
            ++this._ip;
            return n2 - 139;
        }
        if (247 <= n2 && n2 <= 250) {
            int n3 = this._data[this._ip + 1];
            this._ip += 2;
            return (n2 - 247) * 256 + n3 + 108;
        }
        if (251 <= n2 && n2 <= 254) {
            int n4 = this._data[this._ip + 1];
            this._ip += 2;
            return -(n2 - 251) * 256 - n4 - 108;
        }
        if (n2 == 28) {
            int n5 = this._data[this._ip + 1];
            int n6 = this._data[this._ip + 2];
            this._ip += 3;
            return n5 << 8 | n6;
        }
        if (n2 == 255) {
            byte by = (byte)this._data[this._ip + 1];
            int n7 = this._data[this._ip + 2];
            int n8 = this._data[this._ip + 3];
            int n9 = this._data[this._ip + 4];
            this._ip += 5;
            return Float.valueOf((float)(by << 8 | n7) + (float)(n8 << 8 | n9) / 65536.0f);
        }
        return null;
    }

    public int nextByte() {
        return this._data[this._ip++];
    }

    public boolean moreBytes() {
        return this._ip < this._offset + this._length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.resetIP();
        while (this.moreBytes()) {
            this.disassemble(stringBuilder);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

