/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.graph.font.Font;
import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.font.typecast.TypecastFont;
import jogamp.graph.font.typecast.ot.table.HeadTable;
import jogamp.graph.font.typecast.ot.table.HheaTable;

class TypecastHMetrics
implements Font.Metrics {
    private final TypecastFont fontImpl;
    private final HeadTable headTable;
    private final float unitsPerEM_Inv;
    private final AABBox bbox;
    private final HheaTable hheaTable;

    public TypecastHMetrics(TypecastFont typecastFont) {
        this.fontImpl = typecastFont;
        this.headTable = this.fontImpl.font.getHeadTable();
        this.hheaTable = this.fontImpl.font.getHheaTable();
        this.unitsPerEM_Inv = 1.0f / (float)this.headTable.getUnitsPerEm();
        int n2 = this.headTable.getXMax() - this.headTable.getXMin();
        int n3 = this.headTable.getYMax() - this.headTable.getYMin();
        float f2 = this.headTable.getXMin();
        float f3 = -(this.headTable.getYMin() + n3);
        float f4 = f2 + (float)n2;
        float f5 = f3 + (float)n3;
        this.bbox = new AABBox(f2, f3, 0.0f, f4, f5, 0.0f);
    }

    @Override
    public final float getAscent(float f2) {
        return this.getScale(f2) * (float)(-this.hheaTable.getAscender());
    }

    @Override
    public final float getDescent(float f2) {
        return this.getScale(f2) * (float)(-this.hheaTable.getDescender());
    }

    @Override
    public final float getLineGap(float f2) {
        return this.getScale(f2) * (float)(-this.hheaTable.getLineGap());
    }

    @Override
    public final float getMaxExtend(float f2) {
        return this.getScale(f2) * (float)this.hheaTable.getXMaxExtent();
    }

    @Override
    public final float getScale(float f2) {
        return f2 * this.unitsPerEM_Inv;
    }

    @Override
    public final AABBox getBBox(AABBox aABBox, float f2, float[] fArray) {
        return aABBox.setSize(this.bbox.getLow(), this.bbox.getHigh()).scale(this.getScale(f2), fArray);
    }
}

