/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;

public class Shdr {
    StructAccessor accessor;
    private final int mdIdx;
    private final MachineDataInfo md;
    private static final int[] Shdr_size = new int[]{40, 40, 40, 40, 40, 40, 64, 64};
    private static final int[] sh_name_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] sh_type_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] sh_flags_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] sh_addr_offset = new int[]{12, 12, 12, 12, 12, 12, 16, 16};
    private static final int[] sh_offset_offset = new int[]{16, 16, 16, 16, 16, 16, 24, 24};
    private static final int[] sh_size_offset = new int[]{20, 20, 20, 20, 20, 20, 32, 32};
    private static final int[] sh_link_offset = new int[]{24, 24, 24, 24, 24, 24, 40, 40};
    private static final int[] sh_info_offset = new int[]{28, 28, 28, 28, 28, 28, 44, 44};
    private static final int[] sh_addralign_offset = new int[]{32, 32, 32, 32, 32, 32, 48, 48};
    private static final int[] sh_entsize_offset = new int[]{36, 36, 36, 36, 36, 36, 56, 56};

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public Shdr setSh_name(int n2) {
        this.accessor.setIntAt(sh_name_offset[this.mdIdx], n2);
        return this;
    }

    public int getSh_name() {
        return this.accessor.getIntAt(sh_name_offset[this.mdIdx]);
    }

    public Shdr setSh_type(int n2) {
        this.accessor.setIntAt(sh_type_offset[this.mdIdx], n2);
        return this;
    }

    public int getSh_type() {
        return this.accessor.getIntAt(sh_type_offset[this.mdIdx]);
    }

    public Shdr setSh_flags(long l2) {
        this.accessor.setLongAt(sh_flags_offset[this.mdIdx], l2, this.md.longSizeInBytes());
        return this;
    }

    public long getSh_flags() {
        return this.accessor.getLongAt(sh_flags_offset[this.mdIdx], this.md.longSizeInBytes());
    }

    public Shdr setSh_addr(long l2) {
        this.accessor.setLongAt(sh_addr_offset[this.mdIdx], l2, this.md.longSizeInBytes());
        return this;
    }

    public long getSh_addr() {
        return this.accessor.getLongAt(sh_addr_offset[this.mdIdx], this.md.longSizeInBytes());
    }

    public Shdr setSh_offset(long l2) {
        this.accessor.setLongAt(sh_offset_offset[this.mdIdx], l2, this.md.longSizeInBytes());
        return this;
    }

    public long getSh_offset() {
        return this.accessor.getLongAt(sh_offset_offset[this.mdIdx], this.md.longSizeInBytes());
    }

    public Shdr setSh_size(long l2) {
        this.accessor.setLongAt(sh_size_offset[this.mdIdx], l2, this.md.longSizeInBytes());
        return this;
    }

    public long getSh_size() {
        return this.accessor.getLongAt(sh_size_offset[this.mdIdx], this.md.longSizeInBytes());
    }

    public Shdr setSh_link(int n2) {
        this.accessor.setIntAt(sh_link_offset[this.mdIdx], n2);
        return this;
    }

    public int getSh_link() {
        return this.accessor.getIntAt(sh_link_offset[this.mdIdx]);
    }

    public Shdr setSh_info(int n2) {
        this.accessor.setIntAt(sh_info_offset[this.mdIdx], n2);
        return this;
    }

    public int getSh_info() {
        return this.accessor.getIntAt(sh_info_offset[this.mdIdx]);
    }

    public Shdr setSh_addralign(long l2) {
        this.accessor.setLongAt(sh_addralign_offset[this.mdIdx], l2, this.md.longSizeInBytes());
        return this;
    }

    public long getSh_addralign() {
        return this.accessor.getLongAt(sh_addralign_offset[this.mdIdx], this.md.longSizeInBytes());
    }

    public Shdr setSh_entsize(long l2) {
        this.accessor.setLongAt(sh_entsize_offset[this.mdIdx], l2, this.md.longSizeInBytes());
        return this;
    }

    public long getSh_entsize() {
        return this.accessor.getLongAt(sh_entsize_offset[this.mdIdx], this.md.longSizeInBytes());
    }

    public static int size(int n2) {
        return Shdr_size[n2];
    }

    public static Shdr create(int n2) {
        return Shdr.create(n2, Buffers.newDirectByteBuffer(Shdr.size(n2)));
    }

    public static Shdr create(int n2, ByteBuffer byteBuffer) {
        return new Shdr(n2, byteBuffer);
    }

    Shdr(int n2, ByteBuffer byteBuffer) {
        this.mdIdx = n2;
        this.md = MachineDataInfo.StaticConfig.values()[n2].md;
        this.accessor = new StructAccessor(byteBuffer);
    }
}

